#include "BL2101_otp.h"


/****************************************************************************************************************************************** 
* : OTP_Write()
* ˵:	OTP
*     : uint32_t addr   дĵַ	ֶ   
*			uint32_t data   д
*     : 0  ̳ɹ   1 ʧ
* ע: 
******************************************************************************************************************************************/
uint8_t OTP_Write(uint32_t addr,uint32_t data)
{
	while((OTP->PROGEN & OTP_PROGEN_INIT_MASK) != 0);   //ȴOTPʼ
	
	OTP->PROGDATA = data;                               //ҪддݼĴ
	
	OTP->ADDR = (addr>>2);                              //ҪдĵַдOTPַĴ
	
	OTP->PROGEN |= OTP_PROGEN_EN_MASK;                  //ʹ
	
	while((OTP->PROGEN & OTP_PROGEN_ST_MASK) != 0);     //ȴ̽

	if((OTP->PROGEN & OTP_PROGEN_FAIL_MASK) != 0)       //жϱǷʧ
	{
		OTP->PROGEN |= OTP_PROGEN_FAIL_MASK;            //ʧܱ־
		return 1;
	}
	
	return 0;   // Finished without Errors
}


/****************************************************************************************************************************************** 
* : OTP_Read_1()
* ˵:	OTPȡ
*     : uint32_t addr   ȡݵĵַ   ֶ  			
*     : uint32_t  ȡ
* ע: 
******************************************************************************************************************************************/
uint32_t OTP_Read_1(uint32_t addr)
{
	while((OTP->PROGEN & OTP_PROGEN_INIT_MASK) != 0);    //ȴOTPʼ
		           
	OTP->ADDR = addr>>2;                                 //ҪȡĵַдOTPַĴ
	
	OTP->RDEN |= OTP_RDEN_EN_MASK;                       //ʹ
	
	while((OTP->RDEN & OTP_RDEN_EN_MASK) != 0);          //ȴ      
	
	return OTP->RDATA;                                   //ȡõַ
}


/****************************************************************************************************************************************** 
* : OTP_Read_2()
* ˵:	OTPȡ
*     : uint32_t addr   ȡݵĵַ   ֶ    			
*     : uint32_t  ȡ
* ע: 
******************************************************************************************************************************************/
uint32_t OTP_Read_2(uint32_t addr)
{
	addr = (addr>>2)<<2;                                       //ֶַ
	return *((volatile unsigned int *)(OTP_DATA_ADDR + addr));    //ȡõַ
}


/****************************************************************************************************************************************** 
* : OTP_Lock()
* ˵:	OTP
*     : 			
*     : 
* ע: 
******************************************************************************************************************************************/
void OTP_Lock(void)
{
	OTP->PROGEN |= LOCK_CMD << OTP_PROGEN_LOCK_POS;
}


/****************************************************************************************************************************************** 
* : OTP_UnLock()
* ˵:	OTP̽
*     : 			
*     : 
* ע: 
******************************************************************************************************************************************/
void OTP_UnLock(void)
{
	OTP->PROG_UNLOCK = UNLOCK_CMD << OTP_PROG_UNLOCK_POS;
}

