//------------------------------------------------------------------------------------
// HS6206.c
//------------------------------------------------------------------------------------
// Copyright 2014, HunterSun Electronics Co., Ltd.
// Yufeng. Yao
// 2014-01-16
//
// Program Description:
//
//
//
#include "uti.h"
#include "HS6220_RF.h"
#include "BL210x_gpio.h"
#include "BL210x_exti.h"

/* OM6220 ģSPI(3,4)ӿڳʼ
  ѾûӲCEĿƽˣ
  IRQŸҪ
*/

void HS6220_SPI_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct;            
	
	GPIO_InitStruct.Pin = HS6220_CSN_PIN;           
	GPIO_InitStruct.Mode = MODE_PP_OUT;           
	GPIO_Init(HS6220_CSN_PORT,&GPIO_InitStruct);   
	
	GPIO_InitStruct.Pin = HS6220_SCK_PIN;           
	GPIO_InitStruct.Mode = MODE_PP_OUT;           
	GPIO_Init(HS6220_SCK_PORT,&GPIO_InitStruct);   
		
//	GPIO_InitStruct.Pin = HS6220_MOSI_PIN;           
//	GPIO_InitStruct.Mode = MODE_PP_OUT;           
//	GPIO_Init(HS6220_MOSI_PORT,&GPIO_InitStruct);   

//	GPIO_InitStruct.Pin = HS6220_MISO_PIN;           	
//	GPIO_InitStruct.Mode = MODE_PP_OUT;           	
//	GPIO_Init(HS6220_MISO_PORT,&GPIO_InitStruct);    
	
	GPIO_InitStruct.Pin = HS6220_SDIO_PIN;           	
	GPIO_InitStruct.Mode = MODE_PP_OUT;           	
	GPIO_Init(HS6220_SDIO_PORT,&GPIO_InitStruct);   

	GPIO_InitStruct.Pin = HS6220_IRQ_PIN;            	
	GPIO_InitStruct.Mode = MODE_PU_IN;           	
	GPIO_Init(HS6220_IRQ_PORT,&GPIO_InitStruct);  
	
	HS6220_SDIO_HIGH;
	HS6220_CSN_HIGH;	
	HS6220_SCK_LOW;
}

// 3SPIд
void SPI_3wire_sendByte(unsigned char TxData)
{
	unsigned char i;
	unsigned char data_output_bit;
	GPIO_InitTypeDef GPIO_InitStruct;  
	
	GPIO_InitStruct.Pin = HS6220_SDIO_PIN;           	
	GPIO_InitStruct.Mode = MODE_PP_OUT;           	
	GPIO_Init(HS6220_SDIO_PORT,&GPIO_InitStruct); //DIOΪ
	
	for(i = 0; i < 8; i ++) 
	{
		data_output_bit = TxData & 0x80 ? 1 : 0;
		HS6220_SCK_LOW;
		if(data_output_bit){
			HS6220_SDIO_HIGH;
		}
		else{
			HS6220_SDIO_LOW;
		}

		HS6220_SCK_HIGH;
//		NOP_DELAY();
		TxData = TxData << 1;
	}

	HS6220_SDIO_LOW;
	HS6220_SCK_LOW;
//	NOP_DELAY();NOP_DELAY();NOP_DELAY();
}

// 3SPI
unsigned char SPI_3wire_readByte(void)
{
	unsigned char bit_ctr;
	unsigned char byte = 0;
	unsigned char temp = 0;
	
	GPIO_InitTypeDef GPIO_InitStruct;  
	
	GPIO_InitStruct.Pin = HS6220_SDIO_PIN;           	
	GPIO_InitStruct.Mode = MODE_FLOATING_IN;           	
	GPIO_Init(HS6220_SDIO_PORT,&GPIO_InitStruct); // DIOΪ
	__NOP;
	__NOP;
	
	for(bit_ctr = 0; bit_ctr < 8; bit_ctr ++) // output 8-bit
	{
		byte = byte << 1;
		HS6220_SCK_HIGH;   
		temp = GPIO_GetBit(HS6220_SDIO_PORT,HS6220_SDIO_PIN);
		byte |= temp;          
		HS6220_SCK_LOW;               
	}

	return (byte); // return read byte
}

// װĶɵõSPIд
void SPI_SendByte(unsigned char data)
{
#if (HS6220_SPI_NWIRE == SPI_3_WIRE)
	// 3SPIд
	SPI_3wire_sendByte(data);
#else
	// 4SPIд
	spi_4wire_wrd(data);
#endif
}

// װĶɵõSPI
unsigned char SPI_ReadByte(void)
{
#if (HS6220_SPI_NWIRE == SPI_3_WIRE)
	// 3SPI
	return SPI_3wire_readByte();
#else
	// 4SPI
	return spi_4wire_wrd(0);
#endif
}

// OM6220дһĴһֵ
void HS6220_write_byte(unsigned char addr,unsigned char D)
{
	HS6220_CSN_LOW;
	SPI_SendByte(HS6220_W_REGISTER | addr);
	SPI_SendByte(D);
	HS6220_CSN_HIGH;
}

// OM6220дһĴֵ
void HS6220_wr_buffer(unsigned char addr,const unsigned char* buf,unsigned char len)
{
	HS6220_CSN_LOW;
	SPI_SendByte(HS6220_W_REGISTER | addr);
	while(len--)
	{
		SPI_SendByte(*buf ++);
	}
	HS6220_CSN_HIGH;
}

// OM6220һĴһֵ
unsigned char HS6220_read_byte(unsigned char addr)
{
	unsigned char rxdata;
	
	HS6220_CSN_LOW;
	SPI_SendByte(HS6220_R_REGISTER | addr);
	rxdata = SPI_ReadByte();
	HS6220_CSN_HIGH;
	
	return(rxdata);
}

// OM6220һĴֵ
void HS6220_read_buffer(unsigned char addr, unsigned char* buf, unsigned char len)
{
	HS6220_CSN_LOW;
	SPI_SendByte(HS6220_R_REGISTER | addr);
	
	while(len --)
	{
		*buf ++ = SPI_ReadByte();
	}
	HS6220_CSN_HIGH;
}

// OM6220ֱӷ
void HS6220_Operation(unsigned char opt)
{	
	HS6220_CSN_LOW;
	SPI_SendByte(opt);
	HS6220_CSN_HIGH;
}


/* OM6220 ʼ
һģ飬ֻãʼݻе
ĵڶ֮ЩֵΪĬֵʼݾͻٺܶ
*/
void HS6220_Init(void)
{
	unsigned char temp[5];
	HS6220_SPI_Init();
	
	HS6220_write_byte(HS6220_BANK0_FEATURE, SOFT_RST); // soft_reset

#if (HS6220_SPI_NWIRE == SPI_4_WIRE) 
	// Ĭ3SPIģҪʹ4SPIϵ֮Ҫһ
	HS6220_write_byte(HS6220_BANK0_DYNPD, 0x08);
#else
	HS6220_write_byte(HS6220_BANK0_DYNPD, 0x00);
#endif

	HS6220_CE_Low();	
	HS6220_write_byte(HS6220_BANK0_CONFIG, 0x8b); // power up
	Delay1ms(3); // wait 3 ms
	HS6220_write_byte(HS6220_BANK0_PMU_CTL, 0xac); // HS6220_PWRDWN = 00
	Delay1ms(2);
    
	HS6220_write_byte(HS6220_BANK0_FEATURE, 0x10); // VCO_AMP_TX_MUX = b'0, A2 don't need config this bit

	HS6220_Bank_Switch(HS6220_Bank1);

	HS6220_write_byte(HS6220_BANK1_TEST_PKDET, 0x20); // pll_vdiv2_sel = 01, A2 don't need config this bit
    
	temp[2] = 0x05;
	temp[1] = 0xa0;
	temp[0] = 0x01;
	HS6220_wr_buffer(HS6220_BANK1_FAGC_CTRL_1, temp, 3);
    
	temp[1] = 0xb2;
	temp[0] = 0xcf;  
	HS6220_wr_buffer(HS6220_BANK1_AGC_CTRL, temp, 2);
	
	HS6220_Bank_Switch(HS6220_Bank0);

	HS6220_CE_High();
	Delay10us(10);
	HS6220_CE_Low(); // һҪע⣬У׼ʱCEǵ͵

	while((HS6220_read_byte(HS6220_BANK0_RF_SETUP) & 0x20) == 0x00);   //wait cal done
	HS6220_write_byte(HS6220_BANK0_RF_SETUP, 0x40);  // cal_en = 0

	HS6220_Bank_Switch(HS6220_Bank1);	

	temp[2] = 0x75;  //bp_dac =1 bp_rc = 1
	temp[1] = 0x98;  // bp_vco_amp = 1 bp_vco_ldo=1
	temp[0] = 0x20;
	HS6220_wr_buffer(HS6220_BANK1_CAL_CTL, temp, 3);

	HS6220_Bank_Switch(HS6220_Bank0);	

	temp[0] = 0x46;
	temp[1] = 0x0b;
	temp[2] = 0xaf;
	temp[3] = 0x43;
	temp[4] = 0x98;	
	HS6220_wr_buffer(HS6220_BANK0_RX_ADDR_P0, temp, 5); // set address

	temp[0]=0x46;
	temp[1]=0x0b;
	temp[2]=0xaf;
	temp[3]=0x43;
	temp[4]=0x98;
	HS6220_wr_buffer(HS6220_BANK0_TX_ADDR, temp, 5);   //set address


	HS6220_write_byte(HS6220_BANK0_FEATURE, 0x10); 
	HS6220_write_byte(HS6220_BANK0_EN_AA, 0x00);
	HS6220_write_byte(HS6220_BANK0_CONFIG, 0xfa);
	HS6220_write_byte(HS6220_BANK0_RX_PW_P0, rx_lenth);
	HS6220_write_byte(HS6220_BANK0_RF_CH, 45);
	HS6220_write_byte(HS6220_BANK0_EN_RXADDR, 0x03); // scramble_en = 0	
	HS6220_write_byte(HS6220_BANK0_RF_SETUP, 0x47);
	HS6220_write_byte(HS6220_BANK0_DYNPD, 0x07);
	
	HS6220_Clear_All_Irq();
	HS6220_Flush_Tx();	
	HS6220_CE_High();
			
}

/*OM6220 дĴ
 cmd = code; 
 D = data
 */
void HS6220_wr_cmd(unsigned char cmd,unsigned char D)
{
	HS6220_CSN_LOW;
	SPI_SendByte(cmd);
	SPI_SendByte(D);
	HS6220_CSN_HIGH;
}

// лOM6220 BANK
void HS6220_Bank_Switch(HS6220_Bank_TypeDef bank)
{
	unsigned char sta;
	
	sta = HS6220_read_byte(HS6220_BANK0_STATUS);
	
	if(bank != HS6220_Bank0)
	{
		if(!(sta & HS6220_Bank1))
		{
			HS6220_wr_cmd(HS6220_ACTIVATE, HS6220_ACTIVATE_DATA);
		}
	}
	else
	{
		if(sta & HS6220_Bank1)
		{
			HS6220_wr_cmd(HS6220_ACTIVATE, HS6220_ACTIVATE_DATA);
		}
	}
}

// OM6220 л
void HS6220_Change_Rate(HS6220_Rate_TypeDef rate)
{
	unsigned char tmp;
	
	tmp = HS6220_read_byte(HS6220_BANK0_RF_SETUP);

	if(rate == Rate_1M)
	{
		tmp &= 0xf7;
		HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
	}
	else if(rate == Rate_2M)
	{
		tmp |= 0x08;
		HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
	}
}

// OM6220 лŵ
void HS6220_Change_CH(unsigned char chn)
{
	if(chn < 0x80)
		HS6220_write_byte(HS6220_BANK0_RF_CH, chn);
}

// OM6220 л
void HS6220_Change_Pwr(HS6220_Pwr_TypeDef pwr)
{
	unsigned char tmp;

	tmp = HS6220_read_byte(HS6220_BANK0_RF_SETUP);
	tmp &= ~0x47;

	switch (pwr)
	{
		case Pwr_8db:
			tmp |= 0x47;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case Pwr_5db:
			tmp |= 0x40;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case Pwr_4db:
			tmp |= 0x07;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case Pwr_0db:
			tmp |= 0x03;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case Pwr_n6db:
			tmp |= 0x01;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;
	
		default: // ĬϾó0db
			tmp |= 0x03;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;
	}
}

// OM6220 лַ
void HS6220_Change_Addr(unsigned char *buf, unsigned char len)
{
	if(len <= 6)
	HS6220_wr_buffer(HS6220_BANK0_RX_ADDR_P0, buf, len); // set address
}


/*OM6220 ݰ
bufȡݴŵĵط
returnȡ֮󣬷صǶȡݰ
*/
unsigned char HS6220_ReceivePack(unsigned char *buf)
{
	unsigned char sta;
	unsigned char fifo_sta;
	unsigned char len;

	sta = HS6220_read_byte(HS6220_BANK0_STATUS);

	if(HS6220_STATUS_RX_DR & sta)
	{
		do
		{
			len = HS6220_read_byte(HS6220_R_RX_PL_WID);
			
			if(len <= HS6220_FIFO_MAX_PACK_SIZE)
			{
				HS6220_read_buffer(HS6220_R_RX_PAYLOAD, buf, len);
			}
			else
			{
				HS6220_Flush_Rx();
			}
			
			fifo_sta = HS6220_read_byte(HS6220_BANK0_FIFO_STATUS);
		}while(!(fifo_sta & HS6220_FIFO_STA_RX_EMPTY));/*not empty continue read out*/ 
		
		HS6220_write_byte(HS6220_BANK0_STATUS, sta);/*clear irq*/
		HS6220_Clear_All_Irq();
		HS6220_Flush_Tx();
		HS6220_Flush_Rx();		
		return len;
	}

	if(sta & (HS6220_STATUS_RX_DR | HS6220_STATUS_TX_DS | HS6220_STATUS_MAX_RT))
	{
		HS6220_write_byte(HS6220_BANK0_STATUS, sta);/*clear irq*/
	}
	
	return 0;
}


/* OM6220ݰ
  buf:Ҫ͵ݰָ 
  len:ݰĳȣ132ֽ 
  cmd: ݰHS6220_W_TX_PAYLOADHS6220_W_TX_PAYLOAD_NOACK
*/
void HS6220_SendPack(unsigned char cmd, unsigned char* buf, unsigned char len)
{
	unsigned char sta;
	
	sta = HS6220_read_byte(HS6220_BANK0_STATUS);
	if(!(sta & HS6220_STATUS_TX_FULL))
	{
		HS6220_wr_buffer(cmd, buf, len);
	}
}

// OM6220 лRFģʽ
void HS6220_ModeSwitch(HS6220_ModeTypeDef mod)
{
	unsigned char tmp;
	
	tmp = HS6220_read_byte(HS6220_BANK0_CONFIG);
	if(mod != HS6220_PRX_Mode)
	{
		tmp &= 0xFE;
	}
	else
	{
		tmp |= 0x01;
	}
	HS6220_write_byte(HS6220_BANK0_CONFIG, tmp);

	if(mod == HS6220_Carrier_Mode)
	{
		tmp = 0Xc7;//0x80 | HS6220_read_byte(HS6220_BANK0_RF_SETUP);
		HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		/* ע⣺λΪزʹλزģʽ֮CEҪߣزŻ
		   ҪлƵ㣬ʵȣͲҪȥڲRFῴزźŵ*/
	}
}

// OM6220 жϱ־
void HS6220_Clear_All_Irq(void)
{
	HS6220_write_byte(HS6220_BANK0_STATUS, 0x70);
}

// OM6220 TX FIFO
void HS6220_Flush_Tx(void)
{
	HS6220_Operation(HS6220_FLUSH_TX);
}

// OM6220 RX FIFO
void HS6220_Flush_Rx(void)
{
	HS6220_Operation(HS6220_FLUSH_RX);
}

// OM6220 CE
void HS6220_CE_High(void)
{
	HS6220_Operation(HS6220_CMD_CE_HIGH);;
}

// OM6220 CE
void HS6220_CE_Low(void)
{
	HS6220_Operation(HS6220_CMD_CE_LOW);
}

// ȡMO6220յݰȵĺ
unsigned char HS6220_read_payload_length(void)
{
	return HS6220_read_byte(HS6220_R_RX_PL_WID);
}

