//------------------------------------------------------------------------------------
// HS6206.h
//------------------------------------------------------------------------------------
// Copyright 2014, HunterSun Electronics Co., Ltd.
// Yufeng. Yao
// 2014-01-16
//
// Program Description: HS6200 command, register and 
//
//
//

#define MCU_GF90F0320
//#define split_rf
//#ifdef  HS6206_RF 
#ifndef __HS6206_RF_REG_H__
#define __HS6206_RF_REG_H__



#ifdef MCU_GF90F0320
#ifdef split_rf
// 
// SPI_CSN  -- P0.6
// SPI_MISO -- P2.2
// SPI_MOSI -- P2.3
// SPI_SCK  -- P2.4
// RF_CE    -- P2.7
// RF_IRQ   -- P1.0
//
#define SPI_CSN_PORT  P0
#define SPI_MISO_PORT P2
#define SPI_MOSI_PORT P2
#define SPI_SCK_PORT  P2
#define RF_CE_PORT    P2
#define RF_IRQ_PORT   P1

#define SPI_CSN_BIT   BIT6
#define SPI_MISO_BIT  BIT2
#define SPI_MOSI_BIT  BIT3
#define SPI_SCK_BIT   BIT4
#define RF_CE_BIT     BIT7
#define RF_IRQ_BIT    BIT0
#else
// ϷоƬ
// SPI_CSN  -- P2.0
// SPI_MISO -- P0.7
// SPI_MOSI -- P1.0
// SPI_SCK  -- P1.1
// RF_CE    -- P0.5
// RF_IRQ   -- P0.6
//
#define SPI_CSN_PORT  P2
#define SPI_MISO_PORT P0
#define SPI_MOSI_PORT P1
#define SPI_SCK_PORT  P1
#define RF_CE_PORT    P0
#define RF_IRQ_PORT   P0

#define SPI_CSN_BIT   BIT0
#define SPI_MISO_BIT  BIT7
#define SPI_MOSI_BIT  BIT0
#define SPI_SCK_BIT   BIT1
#define RF_CE_BIT     BIT5
#define RF_IRQ_BIT    BIT6
#endif

#define RF_SPI_CE_HIGH   RF_CE_PORT |= RF_CE_BIT
#define RF_SPI_CE_LOW    RF_CE_PORT &= ~RF_CE_BIT
#define HS6200_CSN_HIGH  SPI_CSN_PORT |= SPI_CSN_BIT  
#define HS6200_CSN_LOW   SPI_CSN_PORT &= ~SPI_CSN_BIT  
#define RF_SCK_HIGH      SPI_SCK_PORT |= SPI_SCK_BIT
#define RF_SCK_LOW       SPI_SCK_PORT &= ~SPI_SCK_BIT
#define RF_MOSI_HIGH     SPI_MOSI_PORT |= SPI_MOSI_BIT
#define RF_MOSI_LOW      SPI_MOSI_PORT &= ~SPI_MOSI_BIT
#define RF_MISO_HIGH     SPI_MISO_PORT & SPI_MISO_BIT

#define RF_IRQ_LOW       RF_IRQ_PORT &= ~RF_IRQ_BIT

#endif

#ifdef MCU_HS6206
//----- following define is related with HS6206 MCU -------------------------------------------
#define RF_CLK_EN             BIT2                 /*RF clock*/
#define RFSPI_CSN             BIT1                 /*Enable RF command. 0: enabled*/
#define RFSPI_CE              BIT0                 /*Enable RF transceiver. 1: enabled*/

//----------------SPIRCON--------------
#define RFSPI_MASK_RX_FIFO_FULL_INT   BIT3          /*Disable interrupt when RX FIFO is full.*/    
#define RFSPI_MASK_RX_DATA_RDY_INT    BIT2          /*Disable interrupt when data is available in RX FIFO*/
#define RFSPI_MASK_TX_FIFO_EMPTY_INT  BIT1          /*Disable interrupt when TX FIFO is empty.*/
#define RFSPI_MASK_TX_FIFO_RDY_INT    BIT0          /*Disable interrupt when a location is available in TX FIFO*/

//----------------SPIRSTAT-----------------
#define RFSPI_RX_FIFO_FULL           BIT3           /*RX FIFO full.*/ 
#define RFSPI_RX_DATA_RDY            BIT2           /*Data available in RX FIFO*/
#define RFSPI_TX_FIFO_EMPTY          BIT1           /*TX FIFO empty.*/
#define RFSPI_TX_FIFO_RDY            BIT0           /*Location available in TX FIFO*/

#define RF_SPI_CE_HIGH   RFCON |=RFSPI_CE
#define RF_SPI_CE_LOW    RFCON &=~RFSPI_CE
#define RF_DELAY_10us    delay_us(10)
#define RF_SPI_CE_HIGH_LOW  do{RF_SPI_CE_HIGH;RF_DELAY_10us;RF_SPI_CE_LOW;}while(0)

#define HS6200_CSN_HIGH  RFCON |= RFSPI_CSN  
#define HS6200_CSN_LOW   RFCON &=~RFSPI_CSN  
#endif


//----------------- RF command ---------------------
#define HS6200_RD_REG					0x00 // Define read command to register
#define HS6200_WR_REG					0x20 // Define write command to register
#define HS6200_R_RX_PAYLOAD				0x61 // Define RX payload register address
#define HS6200_W_TX_PAYLOAD				0xA0 // Define TX payload register address
#define HS6200_FLUSH_TX					0xE1 // Define flush TX register command
#define HS6200_FLUSH_RX					0xE2 // Define flush RX register command
#define HS6200_REUSE_TX_PL				0xE3 // Define reuse TX payload register command
#define HS6200_ACTIVATE					0x50 // Define ACTIVATE features register command   
#define HS6200_R_RX_PL_WID				0x60 // Define read RX payload width register command
#define HS6200_W_ACK_PAYLOAD			0xA8 // Define write ACK payload register command
#define HS6200_W_TX_PAYLOAD_NOACK		0xB0 // Define disable TX ACK for one time register command
#define HS6200_NOP						0xFF // Define No Operation, might be used to read status register
#define HS6200_READ_STATUS				0xFF
#define HS6200_ACTIVATE_DATA			0x53


//------------ HS6200 Bank0 Register Addr -------------------------- 
#define HS6200_BANK0_CONFIG				0x00 // 'Config' register address
#define HS6200_BANK0_EN_AA				0x01 // 'Enable Auto Acknowledgment' register address
#define HS6200_BANK0_EN_RXADDR			0x02 // 'Enabled RX addresses' register address
#define HS6200_BANK0_SETUP_AW			0x03 // 'Setup address width' register address
#define HS6200_BANK0_SETUP_RETR			0x04 // 'Setup Auto. Retrans' register address
#define HS6200_BANK0_RF_CH				0x05 // 'RF channel' register address
#define HS6200_BANK0_RF_SETUP			0x06 // 'RF setup' register address
#define HS6200_BANK0_STATUS				0x07 // 'Status' register address
#define HS6200_BANK0_OBSERVE_TX			0x08 // 'Observe TX' register address
#define HS6200_BANK0_RPD				0x09 // 'Received Power Detector' register address
#define HS6200_BANK0_RX_ADDR_P0			0x0A // 'RX address pipe0' register address
#define HS6200_BANK0_RX_ADDR_P1			0x0B // 'RX address pipe1' register address
#define HS6200_BANK0_RX_ADDR_P2			0x0C // 'RX address pipe2' register address
#define HS6200_BANK0_RX_ADDR_P3			0x0D // 'RX address pipe3' register address
#define HS6200_BANK0_RX_ADDR_P4			0x0E // 'RX address pipe4' register address
#define HS6200_BANK0_RX_ADDR_P5			0x0F // 'RX address pipe5' register address
#define HS6200_BANK0_TX_ADDR			0x10 // 'TX address' register address
#define HS6200_BANK0_RX_PW_P0			0x11 // 'RX payload width, pipe0' register address
#define HS6200_BANK0_RX_PW_P1			0x12 // 'RX payload width, pipe1' register address
#define HS6200_BANK0_RX_PW_P2			0x13 // 'RX payload width, pipe2' register address
#define HS6200_BANK0_RX_PW_P3			0x14 // 'RX payload width, pipe3' register address
#define HS6200_BANK0_RX_PW_P4			0x15 // 'RX payload width, pipe4' register address
#define HS6200_BANK0_RX_PW_P5			0x16 // 'RX payload width, pipe5' register address
#define HS6200_BANK0_FIFO_STATUS		0x17 // 'FIFO Status Register' register address
#define HS6200_BANK0_DYNPD				0x1C // 'Enable dynamic payload length' register address
#define HS6200_BANK0_FEATURE			0x1D // 'Feature' register address
#define HS6200_BANK0_SETUP_VALUE		0x1E
#define HS6200_BANK0_PRE_GURD			0x1F

//------------ HS6200 Bank1 Register Addr -------------------------- 
#define HS6200_BANK1_LINE				0x00
#define HS6200_BANK1_PLL_CTL0			0x01
#define HS6200_BANK1_PLL_CTL1			0x02
#define HS6200_BANK1_CAL_CTL			0x03
#define HS6200_BANK1_A_CNT_REG			0x04
#define HS6200_BANK1_B_CNT_REG			0x05				
#define HS6200_BANK1_STATUS				0x07				
#define HS6200_BANK1_STATE				0x08				
#define HS6200_BANK1_CHAN				0x09				
#define HS6200_BANK1_IF_FREQ			0x0A				
#define HS6200_BANK1_AFC_COR			0x0B				
#define HS6200_BANK1_FDEV				0x0C				
#define HS6200_BANK1_DAC_RANGE			0x0D				
#define HS6200_BANK1_DAC_IN				0x0E				
#define HS6200_BANK1_CTUNING			0x0F				
#define HS6200_BANK1_FTUNING			0x10				
#define HS6200_BANK1_RX_CTRL			0x11				
#define HS6200_BANK1_FAGC_CTRL			0x12				
#define HS6200_BANK1_FAGC_CTRL_1		0x13				
#define HS6200_BANK1_DAC_CAL_LOW		0x17				
#define HS6200_BANK1_DAC_CAL_HI			0x18				
#define HS6200_BANK1_DOC_DACI			0x1A				
#define HS6200_BANK1_DOC_DACQ			0x1B				
#define HS6200_BANK1_AGC_CTRL			0x1C				
#define HS6200_BANK1_AGC_GAIN			0x1D				
#define HS6200_BANK1_RF_IVGEN			0x1E				
#define HS6200_BANK1_TEST_PKDET			0x1F	


//----------------------defines--------------------------
//bank
#define HS6200_BANK1					0x80
#define HS6200_BANK0					0x00

/*register bit Mask define*/
/*R 0x17:*/
#define HS6200_FIFO_STA_TX_REUSE		0x40
#define HS6200_FIFO_STA_TX_FULL			0x20
#define HS6200_FIFO_STA_TX_EMPTY		0x10
#define HS6200_FIFO_STA_RX_FULL			0x02
#define HS6200_FIFO_STA_RX_EMPTY		0x01
/*R 0x07*/
#define HS6200_STATUS_RX_DR				0x40
#define HS6200_STATUS_TX_DS				0x20
#define HS6200_STATUS_MAX_RT			0x10
#define HS6200_STATUS_TX_FULL			0x01

/*pramr define*/
#define HS6200_FIFO_MAX_PACK_SIZE		0x20


//typedef enum {
//	Rf_PRX_Mode = 0,
//	Rf_PTX_Mode,
//	Rf_Carrier_Mode
//}HS6200_ModeTypeDef,RF_ModeTypeDef;

#include "portable.h"

#define  HS6200_ModeTypeDef RF_ModeTypeDef

//typedef RF_ModeTypeDef    HS6200_ModeTypeDef;

typedef enum {
	HS6200_Bank0 = 0,
	HS6200_Bank1
}HS6200_Bank_TypeDef;

//exteranal function definition
void HS6200_CE_Low(void);
void HS6200_CE_High(void);
void HS6200_RF_CE_High_Pulse(void);
void HS6200_Flush_Rx(void);
void HS6200_Flush_Tx(void);
void HS6200_Clear_All_Irq(void);
unsigned char HS6200_Read_Status(void);
void HS6200_write_byte(unsigned char addr,unsigned char D);
unsigned char HS6200_read_byte(unsigned char addr);
void HS6200_read_buffer(unsigned char addr,unsigned char* buf,unsigned char len);
void HS6200_wr_buffer(unsigned char addr,unsigned char* buf,unsigned char len);
unsigned char HS6200_Operation(unsigned char opt);
void HS6200_Change_CH(unsigned char ch_index);
void HS6200_configure_Reg(unsigned char *Dbuf);
void HS6200_bank_Switch(HS6200_Bank_TypeDef bank);
void HS6200_ModeSwitch(HS6200_ModeTypeDef mod);
void HS6200_write_byte(unsigned char addr,unsigned char D);
void HS6200_ChangeAddr_Reg(unsigned char* AddrBuf,unsigned char len);
void HS6200_ChangeTxAddr_Reg(unsigned char* AddrBuf,unsigned char len);
void HS6200_Write_Ack_Payload(unsigned char PipeNum, unsigned char *pBuf, unsigned char bytes);
void HS6200_SendPack(unsigned char cmd, unsigned char* buf, unsigned char len);
unsigned int HS6200_RecivePack(unsigned char* buf);
//void HS6200_RF_SOFT_Rst(void);
void HS6200_Init(void);



#endif  /*__HS6206_RF_REG_H__*/

//#endif  /*HS6206_RF*/

/*-------------------------------------------End Of File---------------------------------------------*/









