/**
 ****************************************************************************************
 * @file msg.c
 * @brief 
 * Copyright (C) Radioway 2012-2015
 * $Rev$
 *
 ****************************************************************************************
 */
#include "msg.h"
#include "os_string.h"

MSGQUEUE msgqueue;

void InitMsgqueue(void)
{
	os_memset((char*)&msgqueue, 0X00, sizeof(MSGQUEUE)/sizeof(char));
}

void PushMsg(PMSG pmsg)
{
	if (0X00 == msgqueue.msg[msgqueue.cWr].msgId)
	{
		msgqueue.msg[msgqueue.cWr].msgId = pmsg->msgId;
		msgqueue.msg[msgqueue.cWr].param = pmsg->param;
		msgqueue.cWr++;

		if (msgqueue.cWr >= MSG_MAX_NUM)
		{
			  msgqueue.cWr = 0;
		}
	}
}

void GetMsg(PMSG pmsg)
{
	pmsg->msgId = msgqueue.msg[msgqueue.cRd].msgId;
	pmsg->param = msgqueue.msg[msgqueue.cRd].param;
	
	if (pmsg->msgId)
	{
		msgqueue.msg[msgqueue.cRd].msgId = 0;
		msgqueue.msg[msgqueue.cRd].param = 0;
		msgqueue.cRd++;

		if (msgqueue.cRd >= MSG_MAX_NUM)
		{
			msgqueue.cRd = 0;
		}
	}
}

//Ϣ.
void ClrMsg(void)
{
	unsigned char i;
	unsigned char pmsg;
	
	for(i = 0; i < MSG_MAX_NUM;i++){
		pmsg = msgqueue.msg[i].msgId;
		if(pmsg){
			msgqueue.msg[i].msgId = 0;
			msgqueue.msg[i].param = 0;
		}
	}
	msgqueue.cWr = 0;
	msgqueue.cRd = 0;
}

