#ifndef __BL2102_PWMBASE_H__
#define __BL2102_PWMBASE_H__

#include "BL210x.h"


typedef enum
{ 
	PWMBASE_CH0 =  0x01,  
	PWMBASE_CH1 =  0x02, 
	PWMBASE_CH2 =  0x04, 
} PWMBASE_Channel_TypeDef;


typedef struct {
	uint8_t ClkDiv;		         //1---256Ƶ
	uint32_t Period;		     //,16λ
	FunctionalState  OvfIE;		 //жʹ	
} PWMBASE_CommonInitTypeDef;


typedef struct {
	PWMBASE_Channel_TypeDef Channel;
	uint32_t Comp;               //ת
	FunctionalState  CompIE;     //תжʹ
	FunctionalState  Inv;        //źŵƽת
	FunctionalState  OutEn;      //ʹ
} PWMBASE_ChannelInitTypeDef;


//  PWMBASE
#define IS_PWMBASE_ALL(PWMBASE)  ((PWMBASE) == PWMBASE0)

//  PWMBASEͨ
#define IS_PWMBASE_CHANNEL(PWMBASE_CHANNEL)  ((PWMBASE_CHANNEL) == PWMBASE_CH0 || (PWMBASE_CHANNEL) == PWMBASE_CH1 || (PWMBASE_CHANNEL) == PWMBASE_CH2)

//  PWMBASEԤƵϵ  
#define IS_PWMBASE_CLKDIV(PWMBASE_CLKDIV)    ((PWMBASE_CLKDIV) <= 255)

//  PWMBASE
#define IS_PWMBASE_PERIOD(PWMBASE_PERIOD)    (((PWMBASE_PERIOD) > 0) && ((PWMBASE_PERIOD) < 65536))

//  PWMBASEת
#define IS_PWMBASE_COMP(PWMBASE_COMP)        (((PWM_COMP) < 65536))

//  PWMBASEźŷת
#define IS_PWMBASE_INV(PWMBASE_INV)          (((PWMBASE_INV) == ENABLE) || ((PWMBASE_INV) == DISABLE))

//  PWMBASEźʹ
#define IS_PWMBASE_OUTEN(PWMBASE_OUTEN)      (((PWMBASE_OUTEN) == ENABLE) || ((PWMBASE_OUTEN) == DISABLE))

//  PWMBASEж
#define IS_PWMBASE_IE_OVF(PWMBASE_IE_OVF)    (((PWMBASE_IE_OVF) == ENABLE) || ((PWMBASE_IE_OVF) == DISABLE))

//  PWMBASEתж
#define IS_PWMBASE_IE_COMP(PWMBASE_IE_COMP)  (((PWMBASE_IE_COMP) == ENABLE) || ((PWMBASE_IE_COMP) == DISABLE))


void PWMBASE_Common_Init(PWMBASE_TypeDef * PWMBASEx, PWMBASE_CommonInitTypeDef * PWMBASE_CommonInitStruct);       //PWMBASEʼ

void PWMBASE_Channel_Init(PWMBASE_TypeDef * PWMBASEx, PWMBASE_ChannelInitTypeDef * PWMBASE_ChannelInitStruct);    //PWMBASEͨʼ

void PWMBASE_Start(PWMBASE_TypeDef * PWMBASEx);                                             //PWMBASEʼPWM

void PWMBASE_Stop(PWMBASE_TypeDef * PWMBASEx);                                              //رPWMBASEֹͣPWM

void PWMBASE_SetClkDiv(PWMBASE_TypeDef * PWMBASEx,uint8_t Clk_Div);                         //ԤƵϵ   ʵʷƵΪֵ1

void PWMBASE_SetOutInv(PWMBASE_TypeDef * PWMBASEx,uint8_t CHx,FunctionalState  OutInv);     //PWMBASEźŷת

void PWMBASE_SetOutEn(PWMBASE_TypeDef * PWMBASEx,uint8_t CHx,FunctionalState  OutEn);       //PWMBASEʹ

void PWMBASE_SetPeriod(PWMBASE_TypeDef * PWMBASEx, uint32_t Period);                        //

uint32_t PWMBASE_GetPeriod(PWMBASE_TypeDef * PWMBASEx);                                     //ȡ

void PWMBASE_SetComp(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx,uint32_t Comp);                //÷ת

uint32_t PWMBASE_GetComp(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx);                          //ȡõķת

void PWMBASE_IntCompEn(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx);                            //PWMBASEתжʹ

void PWMBASE_IntCompDis(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx);                           //PWMBASEתжϽ

void PWMBASE_IntCompClr(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx);                           //PWMBASEתжϱ־

uint8_t PWMBASE_IntCompState(PWMBASE_TypeDef * PWMBASEx, uint8_t CHx);                      //PWMBASEתж״̬  

void PWMBASE_IntOvfEn(PWMBASE_TypeDef * PWMBASEx);                                          //PWMBASEжʹ

void PWMBASE_IntOvfDis(PWMBASE_TypeDef * PWMBASEx);                                         //PWMBASEжϽ

void PWMBASE_IntOvfClr(PWMBASE_TypeDef * PWMBASEx);                                         //PWMBASEжϱ־

uint8_t PWMBASE_IntOvfState(PWMBASE_TypeDef * PWMBASEx);                                    //PWMBASEж״̬



#endif //__BL2102_PWMBASE_H__
