#include "BL210x_gpio.h"

/****************************************************************************************************************************************** 
* : GPIO_Init()
* ˵:	ųʼŷ©   ѹ
*     : GPIO_TypeDef * GPIOx	   
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void GPIO_Init(GPIO_TypeDef * GPIOx, GPIO_InitTypeDef* GPIO_InitStruct)
{
	switch((uint32_t)GPIOx)
	{
		case ((uint32_t)GPIOA):
		    
			SYS->CLKEN |= 0x01 << SYS_CLKEN_GPIOA_POS;                         //GPIOAʱ

#ifdef IC_BL2101		
			PORT->PORTA_SEL &= ~(0x03 << ((GPIO_InitStruct->Pin)*2));          //˿ΪGPIO
#endif
		
#ifdef IC_BL2102
			if(GPIO_InitStruct->Pin <= GPIO_PIN7)
			{
				PORT->PORTA_SEL0 &= ~(0x0F << ((GPIO_InitStruct->Pin)*4));       //˿ΪGPIO
			}
			else if(GPIO_InitStruct->Pin <= GPIO_PIN15)
			{
				PORT->PORTA_SEL1 &= ~(0x0F << ((GPIO_InitStruct->Pin - GPIO_PIN8)*4)); 
			}
#endif
		
			PORT->PORTA_INEN |=  (0x01 << (GPIO_InitStruct->Pin));                //ʹ
		
			if(GPIO_InitStruct->Mode == MODE_FLOATING_IN)                      //
			{
				PORT->PORTA_PU_IN  &= ~(0x01 << GPIO_InitStruct->Pin);
				PORT->PORTA_PD_IN  &= ~(0x01 << GPIO_InitStruct->Pin);
				PORT->PORTA_OD_OUT &= ~(0x01 << GPIO_InitStruct->Pin);
				
				GPIOA->DIR &= ~(1 << GPIO_InitStruct->Pin);                    //Ϊ
			}				
			else if(GPIO_InitStruct->Mode == MODE_PU_IN)	                   //          
			{
				PORT->PORTA_PU_IN  |=  (0x01 << GPIO_InitStruct->Pin);
				PORT->PORTA_PD_IN  &= ~(0x01 << GPIO_InitStruct->Pin);
				PORT->PORTA_OD_OUT &= ~(0x01 << GPIO_InitStruct->Pin);
				
				GPIOA->DIR &= ~(1 << GPIO_InitStruct->Pin);                    //Ϊ
			}
			else if(GPIO_InitStruct->Mode == MODE_PD_IN)	                   //   
			{
				PORT->PORTA_PU_IN  &= ~(0x01 << GPIO_InitStruct->Pin);
				PORT->PORTA_PD_IN  |=  (0x01 << GPIO_InitStruct->Pin);
				PORT->PORTA_OD_OUT &= ~(0x01 << GPIO_InitStruct->Pin);
				
				GPIOA->DIR &= ~(1 << GPIO_InitStruct->Pin);	                   //Ϊ
			}
			else if(GPIO_InitStruct->Mode == MODE_PP_OUT)                      //
			{
				PORT->PORTA_PU_IN  &= ~(0x01 << GPIO_InitStruct->Pin);
				PORT->PORTA_PD_IN  &= ~(0x01 << GPIO_InitStruct->Pin);
				PORT->PORTA_OD_OUT &= ~(0x01 << GPIO_InitStruct->Pin);
				
				GPIOA->DIR |= (1 << GPIO_InitStruct->Pin);		               //Ϊ
			}	
			else if(GPIO_InitStruct->Mode == MODE_OD_OUT)                      //©       
			{
				PORT->PORTA_PU_IN  &= ~(0x01 << GPIO_InitStruct->Pin);
				PORT->PORTA_PD_IN  &= ~(0x01 << GPIO_InitStruct->Pin);
				PORT->PORTA_OD_OUT |=  (0x01 << GPIO_InitStruct->Pin);
				
				GPIOA->DIR |= (1 << GPIO_InitStruct->Pin);                     //Ϊ
			}	 
			
			if(GPIO_InitStruct->WakeUp_En == WAKEUP_ENABLE)                    //ѹʹ
			{
				PORT->PORTA_WAKEUP |=  (0x01 << GPIO_InitStruct->Pin);
			}
			else
			{
				PORT->PORTA_WAKEUP &= ~(0x01 << GPIO_InitStruct->Pin);
			}
	
		break;

#ifdef IC_BL2101			
		case ((uint32_t)GPIOB):
			
			SYS->CLKEN |= 0x01 << SYS_CLKEN_GPIOB_POS;                         //GPIOBʱ
		
			PORT->PORTB_SEL &= ~(0x03 << ((GPIO_InitStruct->Pin)*2));          //˿ΪGPIO
			PORT->PORTB_INEN |=  (1 << (GPIO_InitStruct->Pin));                //ʹ
		
			if(GPIO_InitStruct->Mode == MODE_FLOATING_IN)                      //
			{
				PORT->PORTB_PU_IN  &= ~(1 << GPIO_InitStruct->Pin);
				PORT->PORTB_PD_IN  &= ~(1 << GPIO_InitStruct->Pin);
				PORT->PORTB_OD_OUT &= ~(1 << GPIO_InitStruct->Pin);
				
				GPIOB->DIR &= ~(1 << GPIO_InitStruct->Pin);                    //Ϊ
			}				
			else if(GPIO_InitStruct->Mode == MODE_PU_IN)	                   //  
			{
				PORT->PORTB_PU_IN  |=  (1 << GPIO_InitStruct->Pin);
				PORT->PORTB_PD_IN  &= ~(1 << GPIO_InitStruct->Pin);
				PORT->PORTB_OD_OUT &= ~(1 << GPIO_InitStruct->Pin);
				
				GPIOB->DIR &= ~(1 << GPIO_InitStruct->Pin);                    //Ϊ
			}
			else if(GPIO_InitStruct->Mode == MODE_PD_IN)	                   // 
			{
				PORT->PORTB_PU_IN  &= ~(1 << GPIO_InitStruct->Pin);
				PORT->PORTB_PD_IN  |=  (1 << GPIO_InitStruct->Pin);
				PORT->PORTB_OD_OUT &= ~(1 << GPIO_InitStruct->Pin);
				
				GPIOB->DIR &= ~(1 << GPIO_InitStruct->Pin);                    //Ϊ
			}
			else if(GPIO_InitStruct->Mode == MODE_PP_OUT)                      //
			{
				PORT->PORTB_PU_IN  &= ~(1 << GPIO_InitStruct->Pin);
				PORT->PORTB_PD_IN  &= ~(1 << GPIO_InitStruct->Pin);
				PORT->PORTB_OD_OUT &= ~(1 << GPIO_InitStruct->Pin);
				
				GPIOB->DIR |= (1 << GPIO_InitStruct->Pin);	                   //Ϊ
			}	
			else if(GPIO_InitStruct->Mode == MODE_OD_OUT)                      //©  
			{
				PORT->PORTB_PU_IN  &= ~(1 << GPIO_InitStruct->Pin);
				PORT->PORTB_PD_IN  &= ~(1 << GPIO_InitStruct->Pin);
				PORT->PORTB_OD_OUT |=  (1 << GPIO_InitStruct->Pin);
				
				GPIOB->DIR |= (1 << GPIO_InitStruct->Pin);                     //Ϊ
			}	
			
			if(GPIO_InitStruct->WakeUp_En == WAKEUP_ENABLE)                    //ѹʹ
			{
				PORT->PORTB_WAKEUP |=  (1 << GPIO_InitStruct->Pin);
			}
			else
			{
				PORT->PORTB_WAKEUP &= ~(1 << GPIO_InitStruct->Pin);
			}
			
		break;
#endif

		default:
		break;
	}		
}

/****************************************************************************************************************************************** 
* : GPIO_SetBit()
* ˵:	ָŵƽø
*     : GPIO_TypeDef * GPIOx	    ָGPIO˿ڣЧֵGPIOAGPIOB
*			uint32_t GPIO_Pin		    ָGPIOţЧֵPIN0PIN1PIN2... ... PIN14PIN15
*     : 
* ע: 
******************************************************************************************************************************************/
void GPIO_SetBit(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin)
{
	GPIOx->DATA |= (0x01 << GPIO_Pin);
}

/****************************************************************************************************************************************** 
* :	GPIO_ClrBit()
* ˵:	ָŵƽõ
*     : GPIO_TypeDef * GPIOx	    ָGPIO˿ڣЧֵGPIOAGPIOB
*			uint32_t GPIO_Pin		    ָGPIOţЧֵPIN0PIN1PIN2... ... PIN14PIN15
*     : 
* ע: 
******************************************************************************************************************************************/
void GPIO_ClrBit(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin)
{
	GPIOx->DATA &= ~(0x01 << GPIO_Pin);
}

/****************************************************************************************************************************************** 
* : GPIO_InvBit()
* ˵:	ָŵƽת
*     : GPIO_TypeDef * GPIOx	    ָGPIO˿ڣЧֵGPIOAGPIOB
*			uint32_t n		       ָGPIOţЧֵPIN0PIN1PIN2... ... PIN14PIN15
*     : 
* ע: 
******************************************************************************************************************************************/
void GPIO_InvBit(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin)
{
	GPIOx->DATA ^= (0x01 << GPIO_Pin);
}

/****************************************************************************************************************************************** 
* :	GPIO_GetBit()
* ˵:	ȡָŵĵƽ״̬
*     : GPIO_TypeDef * GPIOx	    ָGPIO˿ڣЧֵGPIOAGPIOB
*			uint32_t n		       ָGPIOţЧֵPIN0PIN1PIN2... ... PIN14PIN15
*     : ָŵĵƽ״̬	0 ͵ƽ	1 ߵƽ
* ע: 
******************************************************************************************************************************************/
uint32_t GPIO_GetBit(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin)
{	
	return ((GPIOx->DATA >> GPIO_Pin) & 0x01);
}
