#ifndef __BL210x_ADC_H__
#define __BL210x_ADC_H__

#include "BL210x.h"

#define ADC_CH0		0x01
#define ADC_CH1		0x02
#define ADC_CH2		0x04
#define ADC_CH3		0x08
#define ADC_CH4		0x10
#define ADC_CH5		0x20
#define ADC_CH6		0x40
#define ADC_CH7		0x80
#define ADC_CH8		0x100


typedef enum
{ 
	CLK_DIV_1 =  0x00,       //ADCʱϵͳʱ1Ƶ
	CLK_DIV_2 =  0x01,       //ADCʱϵͳʱ2Ƶ
    CLK_DIV_4 =  0x02,       //ADCʱϵͳʱ4Ƶ
	CLK_DIV_8 =  0x03        //ADCʱϵͳʱ8Ƶ
} ADC_Clk_Div_TypeDef;

typedef enum
{ 
	SAMP_AVG_1 =  0x00,       //1βȡƽ
	SAMP_AVG_2 =  0x01,       //2βȡƽ
    SAMP_AVG_4 =  0x02,       //4βȡƽ
	SAMP_AVG_8 =  0x03        //8βȡƽ
} ADC_SampAvg_TypeDef;


typedef enum
{
	SAMP_MODE_SINGLE    =  0x00,   //ADCβ
	SAMP_MODE_CONTINUE  =  0x01    //ADC
} ADC_Samp_Mode_TypeDef;


typedef enum
{ 
	MODE_FIFO =  0x00,       //ADCݴ洢ΪFIFOģʽ
	MODE_CHAN =  0x01        //ADCݴ洢Ϊͨģʽ
} ADC_Mode_TypeDef;


typedef enum
{
	SAMP_CLK_EXT =  0x00,    //ADCⲿʱӷʽ
	SAMP_CLK_IN  =  0x01     //ADCڲʱӷʽ
} ADC_Samp_Clk_TypeDef;


typedef enum
{
	EXTSAMP_CLKWIN_1   =  0x00,   //ⲿʱӷʽ1*CLK
	EXTSAMP_CLKWIN_2   =  0x01,   //ⲿʱӷʽ2*CLK
	EXTSAMP_CLKWIN_4   =  0x02,   //ⲿʱӷʽ4*CLK
	EXTSAMP_CLKWIN_8   =  0x03,   //ⲿʱӷʽ8*CLK
	EXTSAMP_CLKWIN_16  =  0x04,   //ⲿʱӷʽ16*CLK
	EXTSAMP_CLKWIN_32  =  0x05,   //ⲿʱӷʽ32*CLK
	EXTSAMP_CLKWIN_64  =  0x06,   //ⲿʱӷʽ64*CLK
	EXTSAMP_CLKWIN_128 =  0x07    //ⲿʱӷʽ128*CLK
} ExtSamp_ClkWin_TypeDef;

typedef enum
{
	INSAMP_CLKWIN_1  =  0x00,   //ڲʱӷʽ1*CLK
	INSAMP_CLKWIN_3  =  0x01,   //ڲʱӷʽ3*CLK
	INSAMP_CLKWIN_5  =  0x02,   //ڲʱӷʽ5*CLK
	INSAMP_CLKWIN_7  =  0x03,   //ڲʱӷʽ7*CLK
	INSAMP_CLKWIN_9  =  0x04,   //ڲʱӷʽ9*CLK
	INSAMP_CLKWIN_11 =  0x05,   //ڲʱӷʽ11*CLK
	INSAMP_CLKWIN_13 =  0x06,   //ڲʱӷʽ13*CLK
	INSAMP_CLKWIN_15 =  0x07    //ڲʱӷʽ15*CLK
} InSamp_ClkWin_TypeDef;


typedef enum
{
	VREF_EXT =  0x00,        //ADCⲿοʱ
	VREF_IN  =  0x01         //ADCڲοʱ
} ADC_Vref_TypeDef;


typedef enum
{
	TRIG_CPU  =  0x00,        //ADCѡCPU
	TRIG_EXT  =  0x01         //ADCѡⲿźŴ
} ADC_Trig_TypeDef;


#define ADC_EXTTRIG_NOSIGNAL       0x00
#define ADC_EXTTRIG_PWMPLUS_TRIG0  0x01
#define ADC_EXTTRIG_PWMPLUS_TRIG1  0x02
#define ADC_EXTTRIG_PWMPLUS_TRIG2  0x04
#define ADC_EXTTRIG_PWMPLUS_TRIG3  0x08
#define ADC_EXTTRIG_TIMPLUS_LOW    0x10
#define ADC_EXTTRIG_TIMPLUS_HIGH   0x20


//ADCʱӷƵϵ
#define IS_ADC_CLKDIV(ADC_CLKDIV)  (((ADC_CLKDIV) >= CLK_DIV_1) && ((ADC_CLKDIV) <= CLK_DIV_8))

//ADCͨ
#define IS_ADC_CH(ADC_CH)  (((ADC_CH) == ADC_CH0) || ((ADC_CH) == ADC_CH1) ||  \
                            ((ADC_CH) == ADC_CH2) || ((ADC_CH) == ADC_CH3) ||  \
							((ADC_CH) == ADC_CH4) || ((ADC_CH) == ADC_CH5) ||  \
							((ADC_CH) == ADC_CH6) || ((ADC_CH) == ADC_CH7) ||  \
                             (ADC_CH) == ADC_CH8) )

//ADCȡƽ
#define IS_ADC_SAMP_AVG(ADC_SAMP_AVG)  (((ADC_SAMP_AVG) >= SAMP_AVG_1) && ((ADC_SAMP_AVG) <= SAMP_AVG_8))

//ADCģʽ
#define IS_ADC_SAMP_MODE(ADC_SAMP_MODE)  (((ADC_SAMP_MODE) == SAMP_MODE_SINGLE) || ((ADC_SAMP_MODE) == SAMP_MODE_CONTINUE))

//ADCģʽ
#define IS_ADC_MODE(ADC_MODE)  (((ADC_MODE) == MODE_FIFO) || ((ADC_MODE) == MODE_CHAN))

//ADCʱ
#define IS_ADC_SAMP_CLOCK(ADC_SAMP_CLOCK)   (ADC_SAMP_CLOCK == SAMP_CLK_EXT || ADC_SAMP_CLOCK == SAMP_CLK_IN)

//ADCⲿʱӴ
#define IS_ADC_EXTSAMP_CLKWIN(ADC_EXTSAMP_CLKWIN)  (ADC_EXTSAMP_CLKWIN >= EXTSAMP_CLKWIN_1 || ADC_EXTSAMP_CLKWIN <= EXTSAMP_CLKWIN_128)

//ADCڲʱӴ
#define IS_ADC_INSAMP_CLKWIN(ADC_INSAMP_CLKWIN)  (ADC_INSAMP_CLKWIN >= INSAMP_CLKWIN_1 || ADC_INSAMP_CLKWIN <= INSAMP_CLKWIN_15)

//ADCοԴѡ
#define IS_ADC_VREF(ADC_VREF)  (ADC_VREF == VREF_EXT || ADC_VREF == VREF_IN)

//ADCVDDʹܳ
#define IS_ADC_VDDOPEN(ADC_VDDOPEN)     (((ADC_VDDOPEN) == ENABLE) || ((ADC_VDDOPEN) == DISABLE))

//ADCoffsetʹ
#define IS_ADC_OFFSET_EN(ADC_OFFSET_EN) (((ADC_OFFSET_EN) == ENABLE) || ((ADC_OFFSET_EN) == DISABLE))

//ADCkdʹ
#define IS_ADC_KD_EN(ADC_KD_EN) (((ADC_KD_EN) == ENABLE) || ((ADC_KD_EN) == DISABLE))

//ADCתжʹ
#define IS_ADC_EOC_IEN(ADC_EOC_IEN) (((ADC_EOC_IEN) == ENABLE) || ((ADC_EOC_IEN) == DISABLE))

//ADCFIFOжʹ
#define IS_ADC_FIFO_OVF_IEN(ADC_FIFO_OVF_IEN) (((ADC_FIFO_OVF_IEN) == ENABLE) || ((ADC_FIFO_OVF_IEN) == DISABLE))

//ADCFIFOжʹ
#define IS_ADC_FIFO_HALFFULL_IEN(ADC_FIFO_HALFFULL_IEN) (((ADC_FIFO_HALFFULL_IEN) == ENABLE) || ((ADC_FIFO_HALFFULL_IEN) == DISABLE))

//ADCFIFOжʹ
#define IS_ADC_FIFO_FULL_IEN(ADC_FIFO_FULL_IEN) (((ADC_FIFO_FULL_IEN) == ENABLE) || ((ADC_FIFO_FULL_IEN) == DISABLE))




typedef struct {
	ADC_Clk_Div_TypeDef Clk_Div;		   //ADCתʱӷƵȡֵ1 2 4 8
	
	uint16_t Channels;		               //ADCתͨѡУADC_CH0ADC_CH1... ... ADC_CH8ϣλ㣩
	
	ADC_SampAvg_TypeDef    SampAvg;	       //ȡƽADCתADCһͨתΣǵƽֵΪͨת
	
	ADC_Samp_Mode_TypeDef  Samp_Mode;	   //ģʽ£1 תģʽһֱתֱSTARTλ
							               //                  0 תģʽתɺSTARTλԶֹͣת

	ADC_Mode_TypeDef Mode;                 //ݴ洢ΪFIFOģʽͨģʽ   0: FIFO  1:ͨ
	
	ADC_Samp_Clk_TypeDef   SampClk;        //ADCʱѡ  1:ڲʱ   0:ⲿʱ
	
	ExtSamp_ClkWin_TypeDef ExtSamp_ClkWin; //ⲿ
	
	InSamp_ClkWin_TypeDef  InSamp_ClkWin;  //ڲ
	
	FunctionalState Adcvdd_Open;           //ADC VDDʹܳ   0:ֻͨ8Чʱ,ADC VDDʹܲŴ  1:ADC VDDʹܳ
	
	ADC_Vref_TypeDef Vref;                 //ADCοԴѡ  0:ⲿο  1:ڲο
	
	ADC_Trig_TypeDef Trig;                 //ADCԴѡ  0  CPU   1  ⲿź
	
	uint8_t  ExtTrig_Sel;                  //ⲿźŴԴѡ
	
	FunctionalState Offset_En;             //offsetʹ   0:ʹ  1:ʹ
	
	FunctionalState Kd_En;                 //kdʹ       0:ʹ  1:ʹ
	
	uint8_t Eoc_IEn;		               //EOCжʹܣÿͨãЧֵΪADC_CH0ADC_CH1... ... ADC_CH8ϣλ㣩
	
	FunctionalState Ovf_IEn;		       //FIFO жʹ
	
	FunctionalState HalfFull_IEn;	       //FIFOжʹ
	
	FunctionalState Full_IEn;		       //FIFO  жʹ
} ADC_InitStructure;



void ADC_Init(ADC_InitStructure * initStruct);      //ADCģתʼ
void ADC_Open(void);                                //ADC
void ADC_Close(void);                               //ADCر
void ADC_Start(void);                               //ADCת
void ADC_Stop(void);                                //ADCֹͣת
void ADC_SoftReset(void);                           //ADCλ
uint16_t ADC_Read(uint32_t chn);                    //ָͨȡת
void ADC_Read_FIFO(uint16_t * buffer,uint8_t num);  //FIFOĴжȡת
uint8_t ADC_IsEOC(uint32_t chn);                    //ָͨǷת
void ADC_IntEOCEn(uint32_t chn);                    //תжʹ
void ADC_IntEOCDis(uint32_t chn);                   //תжϽֹ
uint8_t ADC_IntEOCStat(uint32_t chn);               //תж״̬
void ADC_IntEOCClr(uint32_t chn);                   //תжϱ־
uint8_t ADC_FIFO_Level(void);                       //ȡFIFOˮλ
uint8_t ADC_FULLStat(void);                         //FIFO״̬
uint8_t ADC_HALFFULLStat(void);                     //FIFO״̬
uint8_t ADC_EMPTYStat(void);                        //FIFO״̬
uint8_t ADC_OVFStat(void);                          //FIFO״̬
void ADC_IntFULLEn(void);                           //FIFOжʹ
void ADC_IntFULLDis(void);                          //FIFOжϽֹ
uint8_t ADC_IntFULLStat(void);                      //FIFOж״̬
void ADC_IntFULLClr(void);                          //FIFOж״̬
void ADC_IntHALFFULLEn(void);                       //FIFOжʹ
void ADC_IntHALFFULLDis(void);                      //FIFOжϽֹ
uint8_t ADC_IntHALFFULLStat(void);                  //FIFOж״̬
void ADC_IntHALFFULLClr(void);                      //FIFOж״̬
void ADC_IntOVFEn(void);                            //FIFOжʹ
void ADC_IntOVFDis(void);                           //FIFOжϽֹ
uint8_t ADC_IntOVFStat(void);                       //FIFOж״̬
void ADC_IntOVFClr(void);                           //FIFOж״̬


#endif //__BL210x_ADC_H__
