#include "BL2102_pwmplus.h"

/****************************************************************************************************************************************** 
* :	PWMPLUS_CommonInit()
* ˵:	PWMPLUSʼ
*     : PWMPLUS_TypeDef * PWMPLUSx                  ָҪõPWMPLUSЧֵPWMPLUS0
*			PWMPLUS_InitTypeDef * PWMPLUS_ChannelInitStruct	PWMPLUS趨ֵĽṹ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_CommonInit(PWMPLUS_TypeDef * PWMPLUSx, PWMPLUS_CommonInitTypeDef * PWMPLUS_CommonInitStruct)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_CLKSRC(PWMPLUS_CommonInitStruct->Clk_Src));                 //ĲClkSrcǷϷ   
	
//	assert_param(IS_PWMPLUS_CLKDIV(PWMPLUS_CommonInitStruct->ClkDiv));                 //ĲClkDivǷϷ   
	
//	assert_param(IS_PWMPLUS_MODE(PWMPLUS_CommonInitStruct->Mode));                     //ĲModeǷϷ  
	
//	assert_param(IS_PWMPLUS_DIR(PWMPLUS_CommonInitStruct->Dir));                       //ĲDirǷϷ  
	
//	assert_param(IS_PWMPLUS_RELOAD_CNT(PWMPLUS_CommonInitStruct->Reload_Cnt));         //ĲReload_CntǷϷ  
	
//	assert_param(IS_PWMPLUS_PERIOD(PWMPLUS_CommonInitStruct->Period));                 //ĲPeriodǷϷ  
	
//	assert_param(IS_PWMPLUS_BRAKE_FILTER(PWMPLUS_CommonInitStruct->Brake_Filter));     //ĲBrake_FilterǷϷ  
	
//	assert_param(IS_PWMPLUS_BRAKE_LEVEL(PWMPLUS_CommonInitStruct->Brake_InputLevel));  //ĲBrake_InputLevelǷϷ  
	
//	assert_param(IS_PWMPLUS_TRIG_COMP(PWMPLUS_CommonInitStruct->Trig_Comp));           //ĲTrig_CompǷϷ  
	
//	assert_param(IS_PWMPLUS_TRIG_SEL(PWMPLUS_CommonInitStruct->Trig_Sel));             //ĲTrig_SelǷϷ  
	
//	assert_param(IS_PWMPLUS_RELOAD_IE(PWMPLUS_CommonInitStruct->Reload_IE));           //ĲReload_IEǷϷ  
	
//	assert_param(IS_PWMPLUS_BRAKE0_IE(PWMPLUS_CommonInitStruct->Brake0_IE));           //ĲBrake0_IEǷϷ  
	
//	assert_param(IS_PWMPLUS_BRAKE1_IE(PWMPLUS_CommonInitStruct->Brake1_IE));           //ĲBrake1_IEǷϷ  
	
//	assert_param(IS_PWMPLUS_UP_OVF_IE(PWMPLUS_CommonInitStruct->Up_OvfIE));            //ĲUp_OvfIEǷϷ  
	
//	assert_param(IS_PWMPLUS_UP_TRIGCOMP_IE(PWMPLUS_CommonInitStruct->Up_TrigCompIE));            //ĲUp_TrigCompIEǷϷ 
	
//	assert_param(IS_PWMPLUS_DOWN_OVF_IE(PWMPLUS_CommonInitStruct->Down_OvfIE));                  //ĲDown_OvfIEǷϷ 
	
//	assert_param(IS_PWMPLUS_DOWN_TRIGCOMP_IE(PWMPLUS_CommonInitStruct->Down_TrigCompIE));        //ĲDown_TrigCompIEǷϷ 
	

	switch((uint32_t)PWMPLUSx)
	{
		case((uint32_t)PWMPLUS0):
		
			SYS->CLKEN |= 0x01 << SYS_CLKEN_PWMPLUS0_POS;           //PWMPLUS0ʱ
		
		break;
	}

	PWMPLUS_Stop(PWMPLUSx);                                         //رPWMBASEֹͣPWM  
	
	temp = PWMPLUSx->CLK;
	
	temp &= ~(0x07 << PWMPLUS_CLK_SRC_POS);                //ʱѡ
	temp |= ((PWMPLUS_CommonInitStruct->Clk_Src) << PWMPLUS_CLK_SRC_POS);
	
	temp &= ~((0xFFFF << PWMPLUS_CLK_PREDIV_POS));         //ʱӷƵ   ʵʷƵΪֵ1
	temp |= ((PWMPLUS_CommonInitStruct->ClkDiv) << PWMPLUS_CLK_PREDIV_POS);
	
	PWMPLUSx->CLK = temp;
	
	temp = PWMPLUSx->CTR;
	
	temp &= ~(0x03 << PWMPLUS_CTR_OPM_POS);                //ģʽ
	temp |= (PWMPLUS_CommonInitStruct->Mode << PWMPLUS_CTR_OPM_POS);	
	
	temp &= ~(0x01 << PWMPLUS_CTR_DIR_POS);                //
	temp |= (PWMPLUS_CommonInitStruct->Dir << PWMPLUS_CTR_DIR_POS);	
	
	temp &= ~(0xFF << PWMPLUS_CTR_RELOAD_POS);             //Զװش   ʵװشΪֵ1
	temp |= (PWMPLUS_CommonInitStruct->Reload_Cnt << PWMPLUS_CTR_RELOAD_POS);
	
	PWMPLUSx->CTR = temp;
	
	if(PWMPLUS_CommonInitStruct->Period == 0)
	{
		PWMPLUS_CommonInitStruct->Period = 0xFFFF;
	}
	
	PWMPLUSx->PERIOD = PWMPLUS_CommonInitStruct->Period;           //PWMPLUS
	
	temp = PWMPLUSx->BRK_CTR;
	
	temp &= ~(0x03 << PWMPLUS_BRK_CTR_FILTER_POS);    //ɲ˲
	temp |= (PWMPLUS_CommonInitStruct->Brake_Filter << PWMPLUS_BRK_CTR_FILTER_POS);
	
	temp &= ~(0x03 << PWMPLUS_BRK_CTR_INLEV_POS);     //ɲЧƽ
	temp |= (PWMPLUS_CommonInitStruct->Brake_InputLevel << PWMPLUS_BRK_CTR_INLEV_POS);
	
	PWMPLUSx->BRK_CTR = temp;
	
	if(PWMPLUS_CommonInitStruct->Period < PWMPLUS_CommonInitStruct->Trig_Comp)
	{
		PWMPLUS_CommonInitStruct->Trig_Comp = 0;
	}
	
	PWMPLUSx->TRIG_COMP = PWMPLUS_CommonInitStruct->Trig_Comp;     //ڲ

	temp = PWMPLUSx->TRIG_SEL;
	
	temp &= ~(0x01 << PWMPLUS_TRIG_CTR_SEL0_POS);    //Trig0źŹѡ
	temp |= (PWMPLUS_CommonInitStruct->Trig0_Sel << PWMPLUS_TRIG_CTR_SEL0_POS);
	
	temp &= ~(0x01 << PWMPLUS_TRIG_CTR_SEL1_POS);    //Trig1źŹѡ
	temp |= (PWMPLUS_CommonInitStruct->Trig1_Sel << PWMPLUS_TRIG_CTR_SEL1_POS);
	
	temp &= ~(0x01 << PWMPLUS_TRIG_CTR_SEL2_POS);    //Trig2źŹѡ
	temp |= (PWMPLUS_CommonInitStruct->Trig2_Sel << PWMPLUS_TRIG_CTR_SEL2_POS);
	
	temp &= ~(0x01 << PWMPLUS_TRIG_CTR_SEL3_POS);    //Trig3źŹѡ
	temp |= (PWMPLUS_CommonInitStruct->Trig3_Sel << PWMPLUS_TRIG_CTR_SEL3_POS);
	
	PWMPLUSx->TRIG_SEL = temp;
	
	temp = PWMPLUSx->IE;
	
	temp &= ~(0x01 << PWMPLUS_IE_RELOAD_POS);              //Զװж
	temp |= (PWMPLUS_CommonInitStruct->Reload_IE << PWMPLUS_IE_RELOAD_POS);
	
	temp &= ~(0x01 << PWMPLUS_IE_BRK0_POS);                //BRAKE0ж
	temp |= (PWMPLUS_CommonInitStruct->Brake0_IE << PWMPLUS_IE_BRK0_POS);
	
	temp &= ~(0x01 << PWMPLUS_IE_BRK1_POS);                //BRAKE1ж
	temp |= (PWMPLUS_CommonInitStruct->Brake1_IE << PWMPLUS_IE_BRK1_POS);
	
	temp &= ~(0x01 << PWMPLUS_IE_UP_OVF_POS);              //ϼж
	temp |= (PWMPLUS_CommonInitStruct->Up_OvfIE << PWMPLUS_IE_UP_OVF_POS);
	
	temp &= ~(0x01 << PWMPLUS_IE_UP_TRIG_POS);             //ϼﴥж
	temp |= (PWMPLUS_CommonInitStruct->Up_TrigCompIE << PWMPLUS_IE_UP_TRIG_POS);
	
	temp &= ~(0x01 << PWMPLUS_IE_DOWN_OVF_POS);            //¼ж
	temp |= (PWMPLUS_CommonInitStruct->Down_OvfIE << PWMPLUS_IE_DOWN_OVF_POS);
	
	temp &= ~(0x01 << PWMPLUS_IE_DOWN_TRIG_POS);           //¼ﴥж
	temp |= (PWMPLUS_CommonInitStruct->Down_TrigCompIE << PWMPLUS_IE_DOWN_TRIG_POS);
	
	PWMPLUSx->IE = temp;
	
	switch((uint32_t)PWMPLUSx)
	{
		case((uint32_t)PWMPLUS0):
		
			if(PWMPLUSx->IE != 0)
			{
				NVIC_EnableIRQ(PWMPLUS0_IRQn);
			}
		
		break;
	}
	
	PWMPLUSx->IF = 0xFFFFF;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_ChannelInit()
* ˵:	PWMPLUSͨʼ
*     : PWMPLUS_TypeDef * PWMPLUSx                  ָҪõPWMPLUSЧֵPWMPLUS0
*			PWMPLUS_InitTypeDef * PWMPLUS_ChannelInitStruct	PWMPLUS趨ֵĽṹ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_ChannelInit(PWMPLUS_TypeDef * PWMPLUSx, PWMPLUS_ChannelInitTypeDef * PWMPLUS_ChannelInitStruct)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(PWMPLUS_CommonInitStruct->Channel));    //ĲChannelǷϷ  
	
//	assert_param(IS_PWMPLUS_COMP(PWMPLUS_CommonInitStruct->Comp));               //ĲCompǷϷ  
	
//	assert_param(IS_PWMPLUS_DEADZONE(PWMPLUS_CommonInitStruct->DeadZone));       //ĲDeadZoneǷϷ  
	
//	assert_param(IS_PWMPLUS_OUTEN(PWMPLUS_CommonInitStruct->CHxOutEn));          //ĲCHxOutEnǷϷ  
	
//	assert_param(IS_PWMPLUS_OUTEN(PWMPLUS_CommonInitStruct->CHxNOutEn));         //ĲCHxNOutEnǷϷ  
	
//	assert_param(IS_PWMPLUS_OUTINV(PWMPLUS_CommonInitStruct->CHxInv));           //ĲCHxInvǷϷ  
	
//	assert_param(IS_PWMPLUS_OUTINV(PWMPLUS_CommonInitStruct->CHxNInv));          //ĲCHxNInvǷϷ  
	
//	assert_param(IS_PWMPLUS_START_LEVEL(PWMPLUS_CommonInitStruct->StartLevel));  //ĲStartLevelǷϷ  
	
//	assert_param(IS_PWMPLUS_IDLE_LEVEL(PWMPLUS_CommonInitStruct->CHxIdleLevel));       //ĲCHxIdleLevelǷϷ  
	
//	assert_param(IS_PWMPLUS_IDLE_LEVEL(PWMPLUS_CommonInitStruct->CHxNIdleLevel));      //ĲCHxNIdleLevelǷϷ  
	
//	assert_param(IS_PWMPLUS_BRAKEEN(PWMPLUS_CommonInitStruct->Brake_Enable));          //ĲBrake_EnableǷϷ  
	
//	assert_param(IS_PWMPLUS_BRAKE_OUTLEVEL(PWMPLUS_CommonInitStruct->Brake_CHxOutLevel));         //ĲBrake_CHxOutLevelǷϷ  
	
//	assert_param(IS_PWMPLUS_BRAKE_OUTLEVEL(PWMPLUS_CommonInitStruct->Brake_CHxNOutLevel));        //ĲBrake_CHxNOutLevelǷϷ  
	
//	assert_param(IS_PWMPLUS_MASK_EN(PWMPLUS_CommonInitStruct->Mask_CHx_Enable));                  //ĲMask_CHx_EnableǷϷ  
	
//	assert_param(IS_PWMPLUS_MASK_EN(PWMPLUS_CommonInitStruct->Mask_CHxN_Enable));                 //ĲMask_CHxN_EnableǷϷ  
	
//	assert_param(IS_PWMPLUS_MASK_LEVEL(PWMPLUS_CommonInitStruct->Mask_CHx_Level));                //ĲMask_CHx_LevelǷϷ  
	
//	assert_param(IS_PWMPLUS_MASK_LEVEL(PWMPLUS_CommonInitStruct->Mask_CHxN_Level));               //ĲMask_CHxN_LevelǷϷ  
	
//	assert_param(IS_PWMPLUS_UP_COMP_IE(PWMPLUS_CommonInitStruct->Up_CompIE));                     //ĲUp_CompIEǷϷ  
	
//	assert_param(IS_PWMPLUS_DOWN_COMP_IE(PWMPLUS_CommonInitStruct->Down_CompIE));                 //ĲDown_CompIEǷϷ  
	
	
	PWMPLUS_Stop(PWMPLUSx);                                                                       //رPWMBASEֹͣPWM  
	
	if(PWMPLUS_ChannelInitStruct->Comp > PWMPLUS_GetPeriod(PWMPLUSx))
	{
		PWMPLUS_ChannelInitStruct->Comp = 0;
	}

	if(PWMPLUS_ChannelInitStruct->DeadZone > PWMPLUS_ChannelInitStruct->Comp)
	{
		PWMPLUS_ChannelInitStruct->DeadZone = PWMPLUS_ChannelInitStruct->Comp;
		
		if(PWMPLUS_ChannelInitStruct->DeadZone > 1023)
		{
			PWMPLUS_ChannelInitStruct->DeadZone = 1023;
		}
	}
	
	
	if((PWMPLUS_ChannelInitStruct->Channel & PWMPLUS_CH0) == PWMPLUS_CH0)
	{
		if(PWMPLUS_ChannelInitStruct->CHxOutEn == ENABLE)    
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH0_OUTEN_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0_OUTEN_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxNOutEn == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH0N_OUTEN_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0N_OUTEN_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH0_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0_INV_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxNInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH0N_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0N_INV_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->StartLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH0_START_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0_START_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxIdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH0_IDLE_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0_IDLE_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxNIdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH0N_IDLE_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0N_IDLE_POS);
		}
		
		temp = PWMPLUSx->BRK_CTR;
		
		temp &= ~(0x03 << PWMPLUS_BRK_CTR_CH0EN_POS);        //ɲʹ
		temp |= (PWMPLUS_ChannelInitStruct->Brake_Enable << PWMPLUS_BRK_CTR_CH0EN_POS);
		
		temp &= ~(0x01 << PWMPLUS_BRK_CTR_CH0_POL_POS);      //ɲƽ
		temp |= (PWMPLUS_ChannelInitStruct->Brake_CHxOutLevel << PWMPLUS_BRK_CTR_CH0_POL_POS);
		
		temp &= ~(0x01 << PWMPLUS_BRK_CTR_CH0N_POL_POS);     //ɲƽ
		temp |= (PWMPLUS_ChannelInitStruct->Brake_CHxNOutLevel << PWMPLUS_BRK_CTR_CH0N_POL_POS);
		
		PWMPLUSx->BRK_CTR = temp;
		
		
		temp = PWMPLUSx->MSK_EN;
		
		temp &= ~(0x01 << PWMPLUS_MSK_EN_CH0_POS);      //ͨxǷʹ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHx_Enable << PWMPLUS_MSK_EN_CH0_POS);
		
		temp &= ~(0x01 << PWMPLUS_MSK_EN_CH0N_POS);     //ͨxNǷʹ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHxN_Enable << PWMPLUS_MSK_EN_CH0N_POS);
		
		PWMPLUSx->MSK_EN = temp;
		
		temp = PWMPLUSx->MSK_LEVEL;
		
		temp &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH0_POS);      //ͨxƽѡ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHx_Level << PWMPLUS_MSK_LEVEL_CH0_POS);
		
		temp &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH0N_POS);     //ͨxNƽѡ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHxN_Level << PWMPLUS_MSK_LEVEL_CH0N_POS);
		
		PWMPLUSx->MSK_LEVEL = temp;
		PWMPLUSx->CH0_COMP = PWMPLUS_ChannelInitStruct->Comp;                  //÷ת
		
		PWMPLUSx->CH0_DEADZONE = PWMPLUS_ChannelInitStruct->DeadZone;          //ʱ
		
		temp = PWMPLUSx->IE;
		
		temp &= ~(0x01 << PWMPLUS_IE_CH0_UP_COMP_POS);            //ϼ﷭תж
		temp |= (PWMPLUS_ChannelInitStruct->Up_CompIE << PWMPLUS_IE_CH0_UP_COMP_POS);
		
		temp &= ~(0x01 << PWMPLUS_IE_CH0_DOWN_COMP_POS);          //¼﷭תж
		temp |= (PWMPLUS_ChannelInitStruct->Down_CompIE << PWMPLUS_IE_CH0_DOWN_COMP_POS);
		
		PWMPLUSx->IE = temp;
	}
	
	if((PWMPLUS_ChannelInitStruct->Channel & PWMPLUS_CH1) == PWMPLUS_CH1)
	{
		if(PWMPLUS_ChannelInitStruct->CHxOutEn == ENABLE)    
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH1_OUTEN_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1_OUTEN_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxNOutEn == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH1N_OUTEN_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1N_OUTEN_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH1_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1_INV_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxNInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH1N_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1N_INV_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->StartLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH1_START_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1_START_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxIdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH1_IDLE_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1_IDLE_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxNIdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH1N_IDLE_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1N_IDLE_POS);
		}
		
		temp = PWMPLUSx->BRK_CTR;
		
		temp &= ~(0x07 << PWMPLUS_BRK_CTR_CH1EN_POS);     //ɲʹ
		temp |= (PWMPLUS_ChannelInitStruct->Brake_Enable << PWMPLUS_BRK_CTR_CH1EN_POS);
		
		temp &= ~(0x01 << PWMPLUS_BRK_CTR_CH1_POL_POS);     //ɲƽ
		temp |= (PWMPLUS_ChannelInitStruct->Brake_CHxOutLevel << PWMPLUS_BRK_CTR_CH1_POL_POS);
		
		temp &= ~(0x01 << PWMPLUS_BRK_CTR_CH1N_POL_POS);     //ɲƽ
		temp |= (PWMPLUS_ChannelInitStruct->Brake_CHxNOutLevel << PWMPLUS_BRK_CTR_CH1N_POL_POS);
		
		PWMPLUSx->BRK_CTR = temp;
		
		temp = PWMPLUSx->MSK_EN;
		
		temp &= ~(0x01 << PWMPLUS_MSK_EN_CH1_POS);            //ͨxǷʹ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHx_Enable << PWMPLUS_MSK_EN_CH1_POS);
		
		temp &= ~(0x01 << PWMPLUS_MSK_EN_CH1N_POS);           //ͨxNǷʹ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHxN_Enable << PWMPLUS_MSK_EN_CH1N_POS);
		
		PWMPLUSx->MSK_EN = temp;
		
		temp = PWMPLUSx->MSK_LEVEL;
		
		temp &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH1_POS);      //ͨxƽѡ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHx_Level << PWMPLUS_MSK_LEVEL_CH1_POS);
		
		temp &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH1N_POS);     //ͨxNƽѡ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHxN_Level << PWMPLUS_MSK_LEVEL_CH1N_POS);
		
		PWMPLUSx->MSK_LEVEL = temp;
		
		PWMPLUSx->CH1_COMP = PWMPLUS_ChannelInitStruct->Comp;              //÷ת
		
		PWMPLUSx->CH1_DEADZONE = PWMPLUS_ChannelInitStruct->DeadZone;      //ʱ
		
		temp = PWMPLUSx->IE;
		
		temp &= ~(0x01 << PWMPLUS_IE_CH1_UP_COMP_POS);            //ϼ﷭תж
		temp |= (PWMPLUS_ChannelInitStruct->Up_CompIE << PWMPLUS_IE_CH1_UP_COMP_POS);
		
		temp &= ~(0x01 << PWMPLUS_IE_CH1_DOWN_COMP_POS);          //¼﷭תж
		temp |= (PWMPLUS_ChannelInitStruct->Down_CompIE << PWMPLUS_IE_CH1_DOWN_COMP_POS);
		
		PWMPLUSx->IE = temp;
	}
	
	if((PWMPLUS_ChannelInitStruct->Channel & PWMPLUS_CH2) == PWMPLUS_CH2)
	{
		if(PWMPLUS_ChannelInitStruct->CHxOutEn == ENABLE)    
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH2_OUTEN_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2_OUTEN_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxNOutEn == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH2N_OUTEN_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2N_OUTEN_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH2_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2_INV_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxNInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH2N_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2N_INV_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->StartLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH2_START_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2_START_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxIdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH2_IDLE_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2_IDLE_POS);
		}
		
		if(PWMPLUS_ChannelInitStruct->CHxNIdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH2N_IDLE_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2N_IDLE_POS);
		}
		
		temp = PWMPLUSx->BRK_CTR;
		
		temp &= ~(0x07 << PWMPLUS_BRK_CTR_CH2EN_POS);     //ɲʹ
		temp |= (PWMPLUS_ChannelInitStruct->Brake_Enable << PWMPLUS_BRK_CTR_CH2EN_POS);
		
		temp &= ~(0x01 << PWMPLUS_BRK_CTR_CH2_POL_POS);     //ɲƽ
		temp |= (PWMPLUS_ChannelInitStruct->Brake_CHxOutLevel << PWMPLUS_BRK_CTR_CH2_POL_POS);
		
		temp &= ~(0x01 << PWMPLUS_BRK_CTR_CH2N_POL_POS);    //ɲƽ
		temp |= (PWMPLUS_ChannelInitStruct->Brake_CHxNOutLevel << PWMPLUS_BRK_CTR_CH2N_POL_POS);
		
		PWMPLUSx->BRK_CTR = temp;
		
		temp = PWMPLUSx->MSK_EN;
		
		temp &= ~(0x01 << PWMPLUS_MSK_EN_CH2_POS);      //ͨxǷʹ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHx_Enable << PWMPLUS_MSK_EN_CH2_POS);
		
		temp &= ~(0x01 << PWMPLUS_MSK_EN_CH2N_POS);     //ͨxNǷʹ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHxN_Enable << PWMPLUS_MSK_EN_CH2N_POS);
		
		PWMPLUSx->MSK_EN = temp;
		
		temp = PWMPLUSx->MSK_LEVEL;
		
		temp &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH2_POS);      //ͨxƽѡ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHx_Level << PWMPLUS_MSK_LEVEL_CH2_POS);
		
		temp &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH2N_POS);     //ͨxNƽѡ
		temp |= (PWMPLUS_ChannelInitStruct->Mask_CHxN_Level << PWMPLUS_MSK_LEVEL_CH2N_POS);
		
		PWMPLUSx->MSK_LEVEL = temp;
		
		PWMPLUSx->CH2_COMP = PWMPLUS_ChannelInitStruct->Comp;                  //÷ת
		
		PWMPLUSx->CH2_DEADZONE = PWMPLUS_ChannelInitStruct->DeadZone;          //ʱ
		
		temp = PWMPLUSx->IE;
		
		temp &= ~(0x01 << PWMPLUS_IE_CH2_UP_COMP_POS);            //ϼ﷭תж
		temp |= (PWMPLUS_ChannelInitStruct->Up_CompIE << PWMPLUS_IE_CH2_UP_COMP_POS);
		
		temp &= ~(0x01 << PWMPLUS_IE_CH2_DOWN_COMP_POS);          //¼﷭תж
		temp |= (PWMPLUS_ChannelInitStruct->Down_CompIE << PWMPLUS_IE_CH2_DOWN_COMP_POS);
		
		PWMPLUSx->IE = temp;
	}
	
	switch((uint32_t)PWMPLUSx)
	{
		case((uint32_t)PWMPLUS0):
		
			if(PWMPLUSx->IE != 0)
			{
				NVIC_EnableIRQ(PWMPLUS0_IRQn);
			}
		
		break;
	}
	
	PWMPLUSx->IF = 0xFFFFF;
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_Start()
* ˵:	PWMPLUSʼPWM
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_Start(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                                      //ĲPWMPLUSxǷϷ   
	
	PWMPLUSx->CTR |= 0x01 << PWMPLUS_CTR_EN_POS; 
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_Stop()
* ˵:	رPWMPLUSֹͣPWM
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_Stop(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                                      //ĲPWMPLUSxǷϷ   
	
	PWMPLUSx->CTR &= ~(0x01 << PWMPLUS_CTR_EN_POS);  
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetClk_Src()
* ˵:	PWMPLUSʱѡ   
*     : PWMPLUS_Clk_Src_TypeDef Clk_Src  
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetClk_Src(PWMPLUS_TypeDef * PWMPLUSx,PWMPLUS_Clk_Src_TypeDef Clk_Src)
{
		uint32_t temp = 0;
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                      //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CLKSRC(Clk_Src));                    //ĲClk_SrcǷϷ   
	
	temp = PWMPLUSx->CLK;
	PWMPLUSx->CLK &= ~(0x07 << PWMPLUS_CLK_SRC_POS);             //PWMPLUSʱѡ   
	PWMPLUSx->CLK |= ((Clk_Src) << PWMPLUS_CLK_SRC_POS);
	
	PWMPLUSx->CLK = temp;
}




/****************************************************************************************************************************************** 
* :	PWMPLUS_SetClkDiv()
* ˵:	ԤƵϵ   ʵʷƵΪֵ1
*     : uint8_t Clk_Div   
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetClkDiv(PWMPLUS_TypeDef * PWMPLUSx,uint8_t ClkDiv)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_CLKDIV(ClkDiv));                                     //ĲClkDivǷϷ   
	
	temp = PWMPLUSx->CLK;
	
	temp &= ~((0xFFFF << PWMPLUS_CLK_PREDIV_POS));             
	temp |= ((ClkDiv) << PWMPLUS_CLK_PREDIV_POS);            //ʱӷƵ   ʵʷƵΪֵ1
	
	PWMPLUSx->CLK = temp;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetMode()
* ˵:	ùģʽ
*     : PWMPLUS_Mode_TypeDef Mode 
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetMode(PWMPLUS_TypeDef * PWMPLUSx,PWMPLUS_Mode_TypeDef Mode)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_MODE(Mode));                 //ĲModeǷϷ  
	
	temp = PWMPLUSx->CTR;
	
	temp &= ~(0x03 << PWMPLUS_CTR_OPM_POS);
	temp |= (Mode << PWMPLUS_CTR_OPM_POS);	
	
	PWMPLUSx->CTR = temp;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetDir()
* ˵:	ü
*     : PWMPLUS_Dir_TypeDef Dir
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetDir(PWMPLUS_TypeDef * PWMPLUSx,PWMPLUS_Dir_TypeDef Dir)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_DIR(Dir));                   //ĲDirǷϷ  
	
	temp = PWMPLUSx->CTR;
	
	temp &= ~(0x01 << PWMPLUS_CTR_DIR_POS);
	temp |= (Dir << PWMPLUS_CTR_DIR_POS);	
	
	PWMPLUSx->CTR = temp;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetReload_Cnt()
* ˵:	Զװش   ʵװشΪֵ1
*     : uint8_t Reload_Cnt
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetReload_Cnt(PWMPLUS_TypeDef * PWMPLUSx,uint8_t Reload_Cnt)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_RELOAD_CNT(Reload_Cnt));                //ĲReload_CntǷϷ  
	
	temp = PWMPLUSx->CTR;
	
	temp &= ~(0xFF << PWMPLUS_CTR_RELOAD_POS);
	temp |= (Reload_Cnt << PWMPLUS_CTR_RELOAD_POS);	                //Զװش   ʵװشΪֵ1
	
	PWMPLUSx->CTR = temp;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetBrake_Filter()
* ˵:	ɲ˲
*     : PWMPLUS_BrakeFilter_TypeDef Brake_Filter
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetBrake_Filter(PWMPLUS_TypeDef * PWMPLUSx,PWMPLUS_BrakeFilter_TypeDef Brake_Filter)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_BRAKE_FILTER(Brake_Filter));                 //ĲBrake_FilterǷϷ  
	
	temp = PWMPLUSx->BRK_CTR;
	
	temp &= ~(0x03 << PWMPLUS_BRK_CTR_FILTER_POS);                       //ɲ˲
	temp |= (Brake_Filter << PWMPLUS_BRK_CTR_FILTER_POS);
	
	PWMPLUSx->BRK_CTR = temp;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetBrake_InputLevel()
* ˵:	ɲЧƽѡ 
*     : PWMPLUS_BrakeLevel_TypeDef Brake_InputLevel
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetBrake_InputLevel(PWMPLUS_TypeDef * PWMPLUSx,PWMPLUS_BrakeLevel_TypeDef Brake_InputLevel)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_BRAKE_LEVEL(Brake_InputLevel));              //ĲBrake_InputLevelǷϷ  
	
	temp = PWMPLUSx->BRK_CTR;
	
	temp &= ~(0x03 << PWMPLUS_BRK_CTR_INLEV_POS);           //ɲЧƽѡ 
	temp |= (Brake_InputLevel << PWMPLUS_BRK_CTR_INLEV_POS);
	
	PWMPLUSx->BRK_CTR = temp;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetBrake_Enable()
* ˵:	ɲʹ
*     : PWMPLUS_TypeDef * PWMPLUSx          ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         ͨѡ  Զͨв   PWMPLUS_CH0 | PWMPLUS_CH1
*		    PWMPLUS_BrakeLevel_TypeDef Brake_InputLevel		    
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetBrake_Enable(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,PWMPLUS_BrakeEnable_TypeDef Brake_Enable)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
//	assert_param(IS_PWMPLUS_BRAKE_ENABLE(Brake_Enable));                 //ĲBrake_EnableǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		temp = PWMPLUSx->BRK_CTR;
		
		temp &= ~(0x03 << PWMPLUS_BRK_CTR_CH0EN_POS);          
		temp |= (Brake_Enable << PWMPLUS_BRK_CTR_CH0EN_POS);
		
		PWMPLUSx->BRK_CTR = temp;
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		temp = PWMPLUSx->BRK_CTR;
		
		temp &= ~(0x03 << PWMPLUS_BRK_CTR_CH1EN_POS);          
		temp |= (Brake_Enable << PWMPLUS_BRK_CTR_CH1EN_POS);
		
		PWMPLUSx->BRK_CTR = temp;
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		temp = PWMPLUSx->BRK_CTR;
		
		temp &= ~(0x03 << PWMPLUS_BRK_CTR_CH2EN_POS);          
		temp |= (Brake_Enable << PWMPLUS_BRK_CTR_CH2EN_POS);
		
		PWMPLUSx->BRK_CTR = temp;
	}	
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetBrake_OutLevel()
* ˵:	ɲʱͨƽ
*     : PWMPLUS_TypeDef * PWMPLUSx          ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         ͨѡ  Զͨв   PWMPLUS_CH0 | PWMPLUS_CH1
*		    PWMPLUS_Level_TypeDef Brake_OutLevel		    
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetBrake_OutLevel(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,PWMPLUS_Level_TypeDef Brake_OutLevel)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CHANNEL_ALL(CHx));                           //ĲCHxǷϷ  
	
//	assert_param(IS_PWMPLUS_BRAKE_OUTLEVEL(Brake_OutLevel));             //ĲBrake_OutLevelǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		if(Brake_OutLevel == LEVEL_LOW)
		{
			PWMPLUSx->BRK_CTR &= ~(0x01 << PWMPLUS_BRK_CTR_CH0_POL_POS); 
		}
		else if(Brake_OutLevel == LEVEL_HIGH)
		{
			PWMPLUSx->BRK_CTR |= (0x01 << PWMPLUS_BRK_CTR_CH0_POL_POS);
		}        
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		if(Brake_OutLevel == LEVEL_LOW)
		{
			PWMPLUSx->BRK_CTR &= ~(0x01 << PWMPLUS_BRK_CTR_CH1_POL_POS); 
		}
		else if(Brake_OutLevel == LEVEL_HIGH)
		{
			PWMPLUSx->BRK_CTR |= (0x01 << PWMPLUS_BRK_CTR_CH1_POL_POS);
		}   
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		if(Brake_OutLevel == LEVEL_LOW)
		{
			PWMPLUSx->BRK_CTR &= ~(0x01 << PWMPLUS_BRK_CTR_CH2_POL_POS); 
		}
		else if(Brake_OutLevel == LEVEL_HIGH)
		{
			PWMPLUSx->BRK_CTR |= (0x01 << PWMPLUS_BRK_CTR_CH2_POL_POS);
		}   
	}	
	
	if((CHx & PWMPLUS_CH0N) == PWMPLUS_CH0N) 
	{
		if(Brake_OutLevel == LEVEL_LOW)
		{
			PWMPLUSx->BRK_CTR &= ~(0x01 << PWMPLUS_BRK_CTR_CH0N_POL_POS); 
		}
		else if(Brake_OutLevel == LEVEL_HIGH)
		{
			PWMPLUSx->BRK_CTR |= (0x01 << PWMPLUS_BRK_CTR_CH0N_POL_POS);
		}   
	}
	
	if((CHx & PWMPLUS_CH1N) == PWMPLUS_CH1N) 
	{
		if(Brake_OutLevel == LEVEL_LOW)
		{
			PWMPLUSx->BRK_CTR &= ~(0x01 << PWMPLUS_BRK_CTR_CH1N_POL_POS); 
		}
		else if(Brake_OutLevel == LEVEL_HIGH)
		{
			PWMPLUSx->BRK_CTR |= (0x01 << PWMPLUS_BRK_CTR_CH1N_POL_POS);
		}   
	}
	
	if((CHx & PWMPLUS_CH2N) == PWMPLUS_CH2N) 
	{
		if(Brake_OutLevel == LEVEL_LOW)
		{
			PWMPLUSx->BRK_CTR &= ~(0x01 << PWMPLUS_BRK_CTR_CH2N_POL_POS); 
		}
		else if(Brake_OutLevel == LEVEL_HIGH)
		{
			PWMPLUSx->BRK_CTR |= (0x01 << PWMPLUS_BRK_CTR_CH2N_POL_POS);
		}   
	}	
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_SetMask_Enable()
* ˵:	ιǷʹ
*     : PWMPLUS_TypeDef * PWMPLUSx          ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         ͨѡ  Զͨв   PWMPLUS_CH0 | PWMPLUS_CH1
*		    FunctionalState Mask_Enable		    
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetMask_Enable(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,FunctionalState Mask_Enable)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CHANNEL_ALL(CHx));                           //ĲCHxǷϷ  
	
//	assert_param(IS_PWMPLUS_MASK_EN(Mask_Enable));                       //ĲMask_EnableǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		if(Mask_Enable == DISABLE)
		{
			PWMPLUSx->MSK_EN &= ~(0x01 << PWMPLUS_MSK_EN_CH0_POS);    
		}
		else if(Mask_Enable == ENABLE)
		{
			PWMPLUSx->MSK_EN |= (0x01 << PWMPLUS_MSK_EN_CH0_POS);
		} 
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		if(Mask_Enable == DISABLE)
		{
			PWMPLUSx->MSK_EN &= ~(0x01 << PWMPLUS_MSK_EN_CH1_POS);    
		}
		else if(Mask_Enable == ENABLE)
		{
			PWMPLUSx->MSK_EN |= (0x01 << PWMPLUS_MSK_EN_CH1_POS);
		} 
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		if(Mask_Enable == DISABLE)
		{
			PWMPLUSx->MSK_EN &= ~(0x01 << PWMPLUS_MSK_EN_CH2_POS);    
		}
		else if(Mask_Enable == ENABLE)
		{
			PWMPLUSx->MSK_EN |= (0x01 << PWMPLUS_MSK_EN_CH2_POS);
		} 
	}
	
	if((CHx & PWMPLUS_CH0N) == PWMPLUS_CH0N) 
	{
		if(Mask_Enable == DISABLE)
		{
			PWMPLUSx->MSK_EN &= ~(0x01 << PWMPLUS_MSK_EN_CH0N_POS);    
		}
		else if(Mask_Enable == ENABLE)
		{
			PWMPLUSx->MSK_EN |= (0x01 << PWMPLUS_MSK_EN_CH0N_POS);
		} 
	}
	
	if((CHx & PWMPLUS_CH1N) == PWMPLUS_CH1N) 
	{
		if(Mask_Enable == DISABLE)
		{
			PWMPLUSx->MSK_EN &= ~(0x01 << PWMPLUS_MSK_EN_CH1N_POS);    
		}
		else if(Mask_Enable == ENABLE)
		{
			PWMPLUSx->MSK_EN |= (0x01 << PWMPLUS_MSK_EN_CH1N_POS);
		} 
	}
	
	if((CHx & PWMPLUS_CH2N) == PWMPLUS_CH2N) 
	{
		if(Mask_Enable == DISABLE)
		{
			PWMPLUSx->MSK_EN &= ~(0x01 << PWMPLUS_MSK_EN_CH2N_POS);    
		}
		else if(Mask_Enable == ENABLE)
		{
			PWMPLUSx->MSK_EN |= (0x01 << PWMPLUS_MSK_EN_CH2N_POS);
		} 
	}
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetMask_Level()
* ˵:	ƽ
*     : PWMPLUS_TypeDef * PWMPLUSx          ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         ͨѡ  Զͨв   PWMPLUS_CH0 | PWMPLUS_CH1
*		    PWMPLUS_Level_TypeDef Mask_Level		    
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetMask_Level(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,PWMPLUS_Level_TypeDef Mask_Level)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CHANNEL_ALL(CHx));                           //ĲCHxǷϷ  
	
//	assert_param(IS_PWMPLUS_MASK_LEVEL(Mask_Level));                     //ĲMask_LevelǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		if(Mask_Level == LEVEL_LOW)
		{
			PWMPLUSx->MSK_LEVEL &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH0_POS); 
		}
		else if(Mask_Level == LEVEL_HIGH)
		{
			PWMPLUSx->MSK_LEVEL |= (0x01 << PWMPLUS_MSK_LEVEL_CH0_POS);
		}   
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		if(Mask_Level == LEVEL_LOW)
		{
			PWMPLUSx->MSK_LEVEL &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH1_POS); 
		}
		else if(Mask_Level == LEVEL_HIGH)
		{
			PWMPLUSx->MSK_LEVEL |= (0x01 << PWMPLUS_MSK_LEVEL_CH1_POS);
		}   
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		if(Mask_Level == LEVEL_LOW)
		{
			PWMPLUSx->MSK_LEVEL &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH2_POS); 
		}
		else if(Mask_Level == LEVEL_HIGH)
		{
			PWMPLUSx->MSK_LEVEL |= (0x01 << PWMPLUS_MSK_LEVEL_CH2_POS);
		}   
	}
	
	if((CHx & PWMPLUS_CH0N) == PWMPLUS_CH0N) 
	{
		if(Mask_Level == LEVEL_LOW)
		{
			PWMPLUSx->MSK_LEVEL &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH0N_POS); 
		}
		else if(Mask_Level == LEVEL_HIGH)
		{
			PWMPLUSx->MSK_LEVEL |= (0x01 << PWMPLUS_MSK_LEVEL_CH0N_POS);
		}   
	}
	
	if((CHx & PWMPLUS_CH1N) == PWMPLUS_CH1N) 
	{
		if(Mask_Level == LEVEL_LOW)
		{
			PWMPLUSx->MSK_LEVEL &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH1N_POS); 
		}
		else if(Mask_Level == LEVEL_HIGH)
		{
			PWMPLUSx->MSK_LEVEL |= (0x01 << PWMPLUS_MSK_LEVEL_CH1N_POS);
		}   
	}
	
	if((CHx & PWMPLUS_CH2N) == PWMPLUS_CH2N) 
	{
		if(Mask_Level == LEVEL_LOW)
		{
			PWMPLUSx->MSK_LEVEL &= ~(0x01 << PWMPLUS_MSK_LEVEL_CH2N_POS); 
		}
		else if(Mask_Level == LEVEL_HIGH)
		{
			PWMPLUSx->MSK_LEVEL |= (0x01 << PWMPLUS_MSK_LEVEL_CH2N_POS);
		}   
	}
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetStartLevel()
* ˵:	PWMPLUSʼƽ
*     : PWMPLUS_TypeDef * PWMPLUSx          ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         ͨѡ  Զͨв   PWMPLUS_CH0 | PWMPLUS_CH1
*           PWMPLUS_Level_TypeDef StartLevel    ʼƽ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetStartLevel(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,PWMPLUS_Level_TypeDef StartLevel)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
//	assert_param(IS_PWMPLUS_START_LEVEL(StartLevel));                    //ĲStartLevelǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		if(StartLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH0_START_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0_START_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		if(StartLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH1_START_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1_START_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		if(StartLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH2_START_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2_START_POS);
		}
	}
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetIdleLevel()
* ˵:	PWMPLUSƽ
*     : PWMPLUS_TypeDef * PWMPLUSx         ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                        ͨѡ  Զͨв   PWMPLUS_CH0 | PWMPLUS_CH0N | PWMPLUS_CH1
*           PWMPLUS_Level_TypeDef  IdleLevel   ЧֵLEVEL_LOW  LEVEL_HIGH
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetIdleLevel(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,PWMPLUS_Level_TypeDef  IdleLevel)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CHANNEL_ALL(CHx));                           //ĲCHxǷϷ  
	
//	assert_param(IS_PWMPLUS_IDLE_LEVEL(IdleLevel));                      //ĲIdleLevelǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		if(IdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH0_IDLE_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0_IDLE_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		if(IdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH1_IDLE_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1_IDLE_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		if(IdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH2_IDLE_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2_IDLE_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH0N) == PWMPLUS_CH0N) 
	{
		if(IdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH0N_IDLE_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0N_IDLE_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH1N) == PWMPLUS_CH1N) 
	{
		if(IdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH1N_IDLE_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1N_IDLE_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH2N) == PWMPLUS_CH2N) 
	{
		if(IdleLevel == LEVEL_HIGH)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH2N_IDLE_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2N_IDLE_POS);
		}
	}
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetOutEn()
* ˵:	PWMPLUSʹ
*     : PWMPLUS_TypeDef * PWMPLUSx     ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                    ͨѡ  Զͨв   PWMPLUS_CH0 | PWMPLUS_CH0N | PWMPLUS_CH1
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetOutEn(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,FunctionalState  OutEn)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CHANNEL_ALL(CHx));                           //ĲCHxǷϷ  
	
//	assert_param(IS_PWMPLUS_OUTEN(OutEn));                               //ĲOutEnǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		if(OutEn == ENABLE)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH0_OUTEN_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0_OUTEN_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		if(OutEn == ENABLE)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH1_OUTEN_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1_OUTEN_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		if(OutEn == ENABLE)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH2_OUTEN_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2_OUTEN_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH0N) == PWMPLUS_CH0N) 
	{
		if(OutEn == ENABLE)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH0N_OUTEN_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0N_OUTEN_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH1N) == PWMPLUS_CH1N) 
	{
		if(OutEn == ENABLE)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH1N_OUTEN_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1N_OUTEN_POS);
		}
	}
	
	if((CHx & PWMPLUS_CH2N) == PWMPLUS_CH2N) 
	{
		if(OutEn == ENABLE)
		{
			PWMPLUSx->OUTCTR |= 0x01 << PWMPLUS_OUTCTR_CH2N_OUTEN_POS;
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2N_OUTEN_POS);
		}
	}
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetOutInv()
* ˵:	PWMPLUSźŷת
*     : PWMPLUS_TypeDef * PWMPLUSx     ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                    ͨѡ  Զͨв   PWMPLUS_CH0 | PWMPLUS_CH0N | PWMPLUS_CH1
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetOutInv(PWMPLUS_TypeDef * PWMPLUSx,uint8_t CHx,FunctionalState  OutInv)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CHANNEL_ALL(CHx));                           //ĲCHxǷϷ  
	
//	assert_param(IS_PWMPLUS_OUTINV(OutInv));                             //ĲOutInvǷϷ  

	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		if(OutInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH0_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0_INV_POS);
		}	
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		if(OutInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH1_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1_INV_POS);
		}	
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		if(OutInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH2_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2_INV_POS);
		}	
	}
	
	if((CHx & PWMPLUS_CH0N) == PWMPLUS_CH0N) 
	{
		if(OutInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH0N_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH0N_INV_POS);
		}	
	}
	
	if((CHx & PWMPLUS_CH1N) == PWMPLUS_CH1N) 
	{
		if(OutInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH1N_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH1N_INV_POS);
		}	
	}
	
	if((CHx & PWMPLUS_CH2N) == PWMPLUS_CH2N) 
	{
		if(OutInv == ENABLE)
		{
			PWMPLUSx->OUTCTR |= (0x01 << PWMPLUS_OUTCTR_CH2N_INV_POS);
		}
		else
		{
			PWMPLUSx->OUTCTR &= ~(0x01 << PWMPLUS_OUTCTR_CH2N_INV_POS);
		}	
	}
}



/****************************************************************************************************************************************** 
* :	PWMPLUS_SetPeriod()
* ˵:	
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*			uint32_t Period			            Ҫ趨ֵ,16λ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetPeriod(PWMPLUS_TypeDef * PWMPLUSx, uint32_t Period)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                            //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_PERIOD(Period));                           //ĲCHxǷϷ  
	
	if(Period == 0 || Period > 0xFFFF)
	{
		Period = 0xFFFF;
	}
	else
	{
		Period -= 1;
	}
	
	PWMPLUSx->PERIOD = Period;
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_GetPeriod()
* ˵:	ȡ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : ֵ
* ע: 
******************************************************************************************************************************************/
uint32_t PWMPLUS_GetPeriod(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                            //ĲPWMPLUSxǷϷ   
	
	return PWMPLUSx->PERIOD;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetComp()
* ˵:	÷ת
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*			uint32_t Comp			            Ҫ趨ķת,16λ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetComp(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx,uint32_t Comp)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
//	assert_param(IS_PWMPLUS_COMP(Comp));                                 //ĲCompǷϷ  

	if(Comp > PWMPLUS_GetPeriod(PWMPLUSx))
	{
		Comp = 0;
	}
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		PWMPLUSx->CH0_COMP  = Comp;
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		PWMPLUSx->CH1_COMP  = Comp;
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		PWMPLUSx->CH2_COMP  = Comp;
	}
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_GetComp()
* ˵:	ȡõķת
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*     : õķת
* ע: 
******************************************************************************************************************************************/
uint32_t PWMPLUS_GetComp(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		return PWMPLUSx->CH0_COMP;
	}
	else if(CHx == PWMPLUS_CH1) 
	{
		return PWMPLUSx->CH1_COMP;
	}
	else if(CHx == PWMPLUS_CH2) 
	{
		return PWMPLUSx->CH2_COMP;
	}
	
	return 0;
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_SetDeadZone()
* ˵:	ͨ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*			uint16_t DeadZone			        Ҫ趨,10λ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetDeadZone(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx,uint16_t DeadZone)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
//	assert_param(IS_PWMPLUS_DEADZONE(DeadZone));                         //ĲDeadZoneǷϷ  

	if(DeadZone > PWMPLUS_GetComp(PWMPLUSx,CHx))
	{
		DeadZone = PWMPLUS_GetComp(PWMPLUSx,CHx);
		
		if(DeadZone > 1023)
		{
			DeadZone = 1023;
		}
	}
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		PWMPLUSx->CH0_DEADZONE  = DeadZone;
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		PWMPLUSx->CH1_DEADZONE  = DeadZone;
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		PWMPLUSx->CH2_DEADZONE  = DeadZone;
	}
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_GetDeadZone()
* ˵:	ȡͨ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*     : õͨ
* ע: 
******************************************************************************************************************************************/
uint16_t PWMPLUS_GetDeadZone(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ   
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		return PWMPLUSx->CH0_DEADZONE;
	}
	else if(CHx == PWMPLUS_CH1) 
	{
		return PWMPLUSx->CH1_DEADZONE;
	}
	else if(CHx == PWMPLUS_CH2) 
	{
		return PWMPLUSx->CH2_DEADZONE;
	}
	
	return 0;
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_SetTrig_Comp()
* ˵:	ڲ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*			uint32_t Trig_Comp			        Ҫõڲ,16λ  Сֵ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetTrig_Comp(PWMPLUS_TypeDef * PWMPLUSx, uint32_t Trig_Comp)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
//	assert_param(IS_PWMPLUS_TRIG_COMP(Trig_Comp));                       //ĲTrig_CompǷϷ  
	
	if(Trig_Comp > PWMPLUS_GetPeriod(PWMPLUSx))
	{
		Trig_Comp = 0;
	}
	
	PWMPLUSx->TRIG_COMP = Trig_Comp;            //ڲ
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_GetTrig_Comp()
* ˵:	ȡڲ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : ڲ
* ע: 
******************************************************************************************************************************************/
uint32_t PWMPLUS_GetTrig_Comp(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	return PWMPLUSx->TRIG_COMP;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetTrig_Sel()
* ˵:	ôźŹѡ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*			PWMPLUS_TrigSel_TypeDef Trig_Sel    ҪõĴźŹѡ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetTrig_Sel0(PWMPLUS_TypeDef * PWMPLUSx, PWMPLUS_TrigSel_TypeDef Trig_Sel)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
//	
//	assert_param(IS_PWMPLUS_TRIG_SEL(Trig_Sel));                         //ĲTrig_SelǷϷ  
	
	temp = PWMPLUSx->TRIG_SEL;
	
	temp &= ~(0x0F << PWMPLUS_TRIG_CTR_SEL0_POS);
	temp |= (Trig_Sel << PWMPLUS_TRIG_CTR_SEL0_POS);                     //ôźŹѡ
	
	PWMPLUSx->TRIG_SEL = temp;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetTrig_Sel1()
* ˵:	ôź1ѡ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*			PWMPLUS_TrigSel_TypeDef Trig_Sel    ҪõĴźŹѡ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetTrig_Sel1(PWMPLUS_TypeDef * PWMPLUSx, PWMPLUS_TrigSel_TypeDef Trig_Sel)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
//	
//	assert_param(IS_PWMPLUS_TRIG_SEL(Trig_Sel));                         //ĲTrig_SelǷϷ  
	
	temp = PWMPLUSx->TRIG_SEL;
	
	temp &= ~(0x0F << PWMPLUS_TRIG_CTR_SEL1_POS);
	temp |= (Trig_Sel << PWMPLUS_TRIG_CTR_SEL1_POS);                     //ôźŹѡ
	
	PWMPLUSx->TRIG_SEL = temp;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetTrig_Sel2()
* ˵:	ôź2ѡ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*			PWMPLUS_TrigSel_TypeDef Trig_Sel    ҪõĴźŹѡ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetTrig_Sel2(PWMPLUS_TypeDef * PWMPLUSx, PWMPLUS_TrigSel_TypeDef Trig_Sel)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
//	
//	assert_param(IS_PWMPLUS_TRIG_SEL(Trig_Sel));                         //ĲTrig_SelǷϷ  
	
	temp = PWMPLUSx->TRIG_SEL;
	
	temp &= ~(0x0F << PWMPLUS_TRIG_CTR_SEL2_POS);
	temp |= (Trig_Sel << PWMPLUS_TRIG_CTR_SEL2_POS);                     //ôźŹѡ
	
	PWMPLUSx->TRIG_SEL = temp;
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SetTrig_Sel3()
* ˵:	ôź3ѡ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*			PWMPLUS_TrigSel_TypeDef Trig_Sel    ҪõĴźŹѡ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SetTrig_Sel3(PWMPLUS_TypeDef * PWMPLUSx, PWMPLUS_TrigSel_TypeDef Trig_Sel)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
//	
//	assert_param(IS_PWMPLUS_TRIG_SEL(Trig_Sel));                         //ĲTrig_SelǷϷ  
	
	temp = PWMPLUSx->TRIG_SEL;
	
	temp &= ~(0x0F << PWMPLUS_TRIG_CTR_SEL3_POS);
	temp |= (Trig_Sel << PWMPLUS_TRIG_CTR_SEL3_POS);                     //ôźŹѡ
	
	PWMPLUSx->TRIG_SEL = temp;
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntReloadEn()
* ˵:	Զװжʹ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntReloadEn(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_RELOAD_POS);                     //Զװжʹ
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntReloadDis()
* ˵:	ԶװжϽ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntReloadDis(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_RELOAD_POS);                    //ԶװжϽ
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_IntReloadState()
* ˵:	ȡԶװж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 1 ԶװжѾ    0  Զװжδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_IntReloadState(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	if(PWMPLUSx->IF & PWMPLUS_IF_RELOAD_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntReloadClr()
* ˵:	Զװж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntReloadClr(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IF = (0x01 << PWMPLUS_IF_RELOAD_POS);	
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntBrake0En()
* ˵:	ɲ0жʹ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntBrake0En(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_BRK0_POS);                       //ɲ0жʹ
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntBrake0Dis()
* ˵:	ɲ0жϽ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntBrake0Dis(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_BRK0_POS);                      //ԶװжϽ
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_IntBrake0State()
* ˵:	ȡɲ0ж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 1 ɲ0жѾ    0  ɲ0жδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_IntBrake0State(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	if(PWMPLUSx->IF & PWMPLUS_IF_BRK0_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntBrake0Clr()
* ˵:	ɲ0ж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntBrake0Clr(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IF = (0x01 << PWMPLUS_IF_BRK0_POS);	
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntBrake1En()
* ˵:	ɲ1жʹ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntBrake1En(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_BRK1_POS);                       //ɲ0жʹ
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntBrake1Dis()
* ˵:	ɲ1жϽ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntBrake1Dis(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_BRK1_POS);                      //ɲ0жϽ
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_IntBrake1State()
* ˵:	ȡɲ1ж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 1 ɲ1жѾ    0  ɲ1жδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_IntBrake1State(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  

	if(PWMPLUSx->IF & PWMPLUS_IF_BRK1_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntBrake1Clr()
* ˵:	ɲ1ж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntBrake1Clr(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IF = (0x01 << PWMPLUS_IF_BRK1_POS);	
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_OvfEn()
* ˵:	ϼжʹ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntUp_OvfEn(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_UP_OVF_POS);                     //ϼжʹ
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_OvfDis()
* ˵:	ϼжϽ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntUp_OvfDis(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_UP_OVF_POS);                    //ϼжϽ
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_OvfState()
* ˵:	ȡϼж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 1 ϼжѾ    0  ϼжδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_IntUp_OvfState(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	if(PWMPLUSx->IF & PWMPLUS_IF_UP_OVF_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_OvfClr()
* ˵:	ϼж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntUp_OvfClr(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IF = (0x01 << PWMPLUS_IF_UP_OVF_POS);	
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_TrigCompEn()
* ˵:	ϼﴥжʹ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntUp_TrigCompEn(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_UP_TRIG_POS);                    //ϼﴥжʹ
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_TrigCompDis()
* ˵:	ϼﴥжϽ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntUp_TrigCompDis(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_UP_TRIG_POS);                   //ϼﴥжϽ
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_TrigCompState()
* ˵:	ȡϼﴥж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 1 ϼﴥжѾ    0  ϼﴥжδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_IntUp_TrigCompState(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	if(PWMPLUSx->IF & PWMPLUS_IF_UP_TRIG_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_TrigCompClr()
* ˵:	ϼﴥж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntUp_TrigCompClr(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IF = (0x01 << PWMPLUS_IF_UP_TRIG_POS);	
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_OvfEn()
* ˵:	¼жʹ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntDown_OvfEn(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_DOWN_OVF_POS);                   //¼жʹ
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_OvfDis()
* ˵:	¼жϽ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntDown_OvfDis(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_DOWN_OVF_POS);                  //¼жϽ
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_OvfState()
* ˵:	ȡ¼ж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 1 ¼жѾ    0  ¼жδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_IntDown_OvfState(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	if(PWMPLUSx->IF & PWMPLUS_IF_DOWN_OVF_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_OvfClr()
* ˵:	¼ж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntDown_OvfClr(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IF = (0x01 << PWMPLUS_IF_DOWN_OVF_POS);	
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_TrigCompEn()
* ˵:	¼ﴥжʹ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntDown_TrigCompEn(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_DOWN_TRIG_POS);                  //¼ﴥжʹ
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_TrigCompDis()
* ˵:	¼ﴥжϽ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntDown_TrigCompDis(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_DOWN_TRIG_POS);                 //¼ﴥжϽ
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_TrigCompState()
* ˵:	ȡ¼ﴥж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 1 ¼ﴥжѾ    0  ¼ﴥжδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_IntDown_TrigCompState(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	if(PWMPLUSx->IF & PWMPLUS_IF_DOWN_TRIG_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_TrigCompClr()
* ˵:	¼ﴥж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntDown_TrigCompClr(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->IF = (0x01 << PWMPLUS_IF_DOWN_TRIG_POS);	
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_CompEn()
* ˵:	ϼ﷭תжʹ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntUp_CompEn(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_CH0_UP_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_CH1_UP_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_CH2_UP_COMP_POS);
	}
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_CompDis()
* ˵:	ϼ﷭תжϽ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntUp_CompDis(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_CH0_UP_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_CH1_UP_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_CH2_UP_COMP_POS);
	}
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_CompState()
* ˵:	ȡϼ﷭תж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*     : 1 ϼ﷭תжѾ    0  ϼ﷭תжδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_IntUp_CompState(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		if(PWMPLUSx->IF & PWMPLUS_IF_CH0_UP_COMP_MSK)
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		if(PWMPLUSx->IF & PWMPLUS_IF_CH1_UP_COMP_MSK)
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		if(PWMPLUSx->IF & PWMPLUS_IF_CH2_UP_COMP_MSK)
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
	
	return 0;
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntUp_CompClr()
* ˵:	ϼ﷭תж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntUp_CompClr(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		PWMPLUSx->IF = (0x01 << PWMPLUS_IF_CH0_UP_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		PWMPLUSx->IF = (0x01 << PWMPLUS_IF_CH1_UP_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		PWMPLUSx->IF = (0x01 << PWMPLUS_IF_CH2_UP_COMP_POS);
	}
}



/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_CompEn()
* ˵:	¼﷭תжʹ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntDown_CompEn(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_CH0_DOWN_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_CH1_DOWN_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		PWMPLUSx->IE |= (0x01 << PWMPLUS_IE_CH2_DOWN_COMP_POS);
	}
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_CompDis()
* ˵:	¼﷭תжϽ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntDown_CompDis(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_CH0_DOWN_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_CH1_DOWN_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		PWMPLUSx->IE &= ~(0x01 << PWMPLUS_IE_CH2_DOWN_COMP_POS);
	}
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_CompState()
* ˵:	ȡ¼﷭תж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*     : 1 ¼﷭תжѾ    0  ¼﷭תжδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_IntDown_CompState(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		if(PWMPLUSx->IF & PWMPLUS_IF_CH0_DOWN_COMP_MSK)
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		if(PWMPLUSx->IF & PWMPLUS_IF_CH1_DOWN_COMP_MSK)
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		if(PWMPLUSx->IF & PWMPLUS_IF_CH2_DOWN_COMP_MSK)
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
	
	return 0;
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_IntDown_CompClr()
* ˵:	¼﷭תж״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           uint8_t CHx                         PWMPLUS_CH0    PWMPLUS_CH1   PWMPLUS_CH2
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_IntDown_CompClr(PWMPLUS_TypeDef * PWMPLUSx, uint8_t CHx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
//	assert_param(IS_PWMPLUS_CHANNEL_HALF(CHx));                          //ĲCHxǷϷ  
	
	if((CHx & PWMPLUS_CH0) == PWMPLUS_CH0) 
	{
		PWMPLUSx->IF = (0x01 << PWMPLUS_IF_CH0_DOWN_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH1) == PWMPLUS_CH1) 
	{
		PWMPLUSx->IF = (0x01 << PWMPLUS_IF_CH1_DOWN_COMP_POS);
	}
	
	if((CHx & PWMPLUS_CH2) == PWMPLUS_CH2) 
	{
		PWMPLUSx->IF = (0x01 << PWMPLUS_IF_CH2_DOWN_COMP_POS);
	}
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_SoftLoad()
* ˵:	PWMPLUSLOAD
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           
*     : 
* ע: 
******************************************************************************************************************************************/
void PWMPLUS_SoftLoad(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	PWMPLUSx->SWLOAD = (0x01 << PWMPLUS_SWLOAD_POS);
//	PWMPLUSx->SWLOAD = (0x01 << PWMPLUS_SWLOAD_MSK);	
	
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_GetCntState()
* ˵:	ȡPWMPLUS״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           
*     : 1 ڼ   0 δ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_GetCntState(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	if(PWMPLUSx->CNT_STATE & PWMPLUS_CNT_STATE_STATE_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/****************************************************************************************************************************************** 
* :	PWMPLUS_GetCntDir()
* ˵:	ȡPWMPLUSǰ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           
*     : 1 ǰ¼   0 ǰϼ
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_GetCntDir(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	if(PWMPLUSx->CNT_STATE & PWMPLUS_CNT_STATE_DIR_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_GetCurrentCnt()
* ˵:	ȡPWMPLUSǰֵ
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           
*     : ǰֵ
* ע: 
******************************************************************************************************************************************/
uint16_t PWMPLUS_GetCurrentCnt(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	return (PWMPLUSx->CNT_STATE & 0xFFFF);
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_GetBrake0State()
* ˵:	ȡPWMPLUSɲ0ĵǰ״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           
*     : ɲ0ĵǰ״̬
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_GetBrake0State(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	if(PWMPLUSx->BRK_STATE & PWMPLUS_BRK0_STATE_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}


/****************************************************************************************************************************************** 
* :	PWMPLUS_GetBrake1State()
* ˵:	ȡPWMPLUSɲ1ĵǰ״̬
*     : PWMPLUS_TypeDef * PWMPLUSx			ָҪõPWMPLUSЧֵPWMPLUS0
*           
*     : ɲ1ĵǰ״̬
* ע: 
******************************************************************************************************************************************/
uint8_t PWMPLUS_GetBrake1State(PWMPLUS_TypeDef * PWMPLUSx)
{
//	assert_param(IS_PWMPLUS_ALL(PWMPLUSx));                              //ĲPWMPLUSxǷϷ  
	
	if(PWMPLUSx->BRK_STATE & PWMPLUS_BRK1_STATE_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}



