#include "BL2101_timer.h"

/****************************************************************************************************************************************** 
* : TIMER_Init()
* ˵:	ʱʼ
*     : mode	ģʽѡ   016λʱ  116λʱ  2 32λʱ
*			period 	ʱڣλus    16λʱ뷶Χ1--65536  Ҳඨʱ65.536ms   Ҫʱʱѡ32λʱ	
*			int_en	жʹ    0   1ʹ  
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMER_Init(uint8_t mode,uint32_t period,uint8_t int_en)
{
	SYS->CLKEN |= 0x01 << SYS_CLKEN_TIMER_POS;    //ʱʱ
	
	TIMER_Stop(mode);                             //ֹͣʱ
	
	TIMER->DIV = CyclesPerUs - 1;                 //ƵʱΪ1M           
	
	if(mode == TIMER_LOW16BIT)                    
	{
		TIMER->CTR = 0 << TIMER_CTR_POS;          //16λʱ͸16λʱ      
		
		TIMER->LOAD |= (period - 1)&0xFFFF;       //16λʱֵ
	}
	else if(mode == TIMER_HIGH16BIT)              
	{
		TIMER->CTR = 0 << TIMER_CTR_POS;          //16λʱ͸16λʱ
		
		TIMER->LOAD |= (((period - 1)&0xFFFF)<<16)&0xFFFF0000;   //16λʱֵ
	}
	else if(mode == TIMER_32BIT)                           
	{
		TIMER->CTR = 1 << TIMER_CTR_POS;          //16λʱ͸16λʱ
		
		TIMER->LOAD = period - 1;                 //32λʱֵ 
	}
	
	if(int_en)                                    //ʱжʹ
	{
		TIMER->IE |= 0x01<<mode;
		
		NVIC_EnableIRQ(TIMER_IRQn);
	}
	else                                          //ʱжϽ
	{
		TIMER->IE &= ~(0x01<<mode);
		NVIC_DisableIRQ(TIMER_IRQn);
	}
}


/****************************************************************************************************************************************** 
* :	TIMER_Start()
* ˵:	ʱӳʼֵʼʱ/
*     : uint8_t mode	ģʽѡ   016λʱ  116λʱ  2 32λʱ
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMER_Start(uint8_t mode)
{
	if(mode == TIMER_LOW16BIT || mode == TIMER_32BIT)
	{
		TIMER->EN |= 0x01<< TIMER_LOW16BIT_EN_POS;
	}
	else if(mode == TIMER_HIGH16BIT)
	{
		TIMER->EN |= 0x01<< TIMER_HIGH16BIT_EN_POS;
	}
}


/****************************************************************************************************************************************** 
* :	TIMER_Stop()
* ˵:	ֹͣʱ
*     : uint8_t mode	ģʽѡ   016λʱ  116λʱ  2 32λʱ
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMER_Stop(uint8_t mode)
{
	if(mode == TIMER_LOW16BIT || mode == TIMER_32BIT)
	{
		TIMER->EN &= ~TIMER_LOW16BIT_EN_MSK;
	}
	else if(mode == TIMER_HIGH16BIT)
	{
		TIMER->EN &= ~TIMER_HIGH16BIT_EN_MSK;
	}
}


/****************************************************************************************************************************************** 
* : TIMER_SetPeriod()
* ˵:	öʱ/
*     : mode	ģʽѡ   016λʱ  116λʱ  2 32λʱ
*			period 	ʱڣλus    16λʱ뷶Χ1--65536  Ҳඨʱ65.536ms   Ҫʱʱѡ32λʱ
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMER_SetPeriod(uint8_t mode,uint32_t period)
{
	if(mode == TIMER_LOW16BIT)
	{
		TIMER->LOAD |= (period - 1)&0xFFFF;
	}
	else if(mode == TIMER_HIGH16BIT)
	{
		TIMER->LOAD |= (((period - 1)&0xFFFF)<<16)&0xFFFF0000;
	}
	else if(mode == TIMER_32BIT)
	{
		TIMER->LOAD = period - 1;
	}
}


/****************************************************************************************************************************************** 
* : TIMER_GetPeriod()
* ˵:	ȡʱ/
*     : mode	ģʽѡ   016λʱ  116λʱ  2 32λʱ		
*     : period 	ʱڣλus    16λʱ뷶Χ1--65536  Ҳඨʱ65.536ms   Ҫʱʱѡ32λʱ
* ע: 
******************************************************************************************************************************************/
uint32_t TIMER_GetPeriod(uint8_t mode)
{
	uint32_t temp;
	
	temp = TIMER->LOAD;
	
	if(mode == TIMER_LOW16BIT)
	{
		return ((temp&0xFFFF) + 1);
	}
	else if(mode == TIMER_HIGH16BIT)
	{
		return ((temp>>16) + 1);
	}
	else if(mode == TIMER_32BIT)
	{
		return (temp + 1);
	}
	else
	{
		return 0;
	}
}

/****************************************************************************************************************************************** 
* :	TIMR_GetCurValue()
* ˵:	ȡǰֵ
*     : mode	    ģʽѡ   016λʱ  116λʱ  2 32λʱ		
*     : ǰֵ 	λus    16λʱ뷶Χ1--65536  Ҳඨʱ65.536ms   Ҫʱʱѡ32λʱ
* ע: 
******************************************************************************************************************************************/
uint32_t TIMER_GetCurValue(uint8_t mode)
{
	uint32_t temp;
	
	temp = TIMER->CNT;
	
	if(mode == TIMER_LOW16BIT)
	{
		return ((temp&0xFFFF) + 1);
	}
	else if(mode == TIMER_HIGH16BIT)
	{
		return ((temp>>16) + 1);
	}
	else if(mode == TIMER_32BIT)
	{
		return (temp + 1);
	}
	else
	{
		return 0;
	}
}


/****************************************************************************************************************************************** 
* :	TIMER_INTEn()
* ˵:	ʹж
*     : mode	    ģʽѡ   016λʱ  116λʱ  2 32λʱ	
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMER_INTEn(uint8_t mode)
{
	TIMER->IE |= 0x01<<mode;
}


/****************************************************************************************************************************************** 
* :	TIMER_INTDis()
* ˵:	ж
*     : mode	    ģʽѡ   016λʱ  116λʱ  2 32λʱ	
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMER_INTDis(uint8_t mode)
{
	TIMER->IE &= ~(0x01<<mode);
}


/****************************************************************************************************************************************** 
* :	TIMER_INTClr()
* ˵:	жϱ־
*     : mode	    ģʽѡ   016λʱ  116λʱ  2 32λʱ	
*     : 
* ע: 
******************************************************************************************************************************************/
void TIMER_INTClr(uint8_t mode)
{
	TIMER->STAT = 0x01<<mode;
}

/****************************************************************************************************************************************** 
* : TIMER_INTStat()
* ˵:	ȡж״̬
*     : mode	    ģʽѡ   016λʱ  116λʱ  2 32λʱ	
*     : uint8_t 			   0 TIMERδж    1 TIMERж
* ע: 
******************************************************************************************************************************************/
uint8_t TIMER_INTStat(uint8_t mode)
{
	return (TIMER->STAT & (0x01<<mode)) ? 1 : 0;
}



