#ifndef __BL2101_H__
#define __BL2101_H__

/*
 * ==========================================================================
 * ---------- Interrupt Number Definition -----------------------------------
 * ==========================================================================
 */
typedef enum IRQn
{
/******  Cortex-M0 Processor Exceptions Numbers **********************************************/
  NonMaskableInt_IRQn         = -14,    /*!< 2 Non Maskable Interrupt                        */
  HardFault_IRQn	          = -13,	/*!< 3 Cortex-M0 Hard Fault Interrupt				 */
  SVCall_IRQn                 = -5,     /*!< 11 Cortex-M0 SV Call Interrupt                  */
  PendSV_IRQn                 = -2,     /*!< 14 Cortex-M0 Pend SV Interrupt                  */
  SysTick_IRQn                = -1,     /*!< 15 Cortex-M0 System Tick Interrupt              */
  
/******  Cortex-M0 specific Interrupt Numbers ************************************************/
  UART0_IRQn          = 0,
  UART1_IRQn          = 1,
  UART2_IRQn          = 2,
  TIMER_IRQn          = 3,
  PWM_IRQn            = 4,
  ADC_IRQn            = 5,
  RTC_IRQn            = 6,
  IIC_IRQn            = 7,
  SPI_IRQn            = 8,
  AES_IRQn            = 9,
  WDT_IRQn            = 10,
  GPIOA0_IRQn         = 11,
  GPIOA1_IRQn         = 12,
  GPIOA4_IRQn         = 13,
  GPIOA5_IRQn         = 14,
  GPIOB0_IRQn         = 15,
  GPIOB1_IRQn         = 16,
  GPIOA14_IRQn        = 17,
  GPIOA15_IRQn        = 18,	
  GPIOA_IRQn          = 19,
  GPIOB_IRQn          = 20,
  IRQ21_IRQn          = 21,
  IRQ22_IRQn          = 22,
  IRQ23_IRQn          = 23,
  IRQ24_IRQn          = 24,
  IRQ25_IRQn          = 25,
  IRQ26_IRQn          = 26,
  IRQ27_IRQn          = 27,
  IRQ28_IRQn          = 28,
  IRQ29_IRQn          = 29,
  IRQ30_IRQn          = 30,
  IRQ31_IRQn          = 31,
} IRQn_Type;

/*
 * ==========================================================================
 * ----------- Processor and Core Peripheral Section ------------------------
 * ==========================================================================
 */

/* Configuration of the Cortex-M0 Processor and Core Peripherals */
#define __MPU_PRESENT		    0	   /*!< UART does not provide a MPU present or not	     */
#define __NVIC_PRIO_BITS		2	   /*!< UART Supports 2 Bits for the Priority Levels	 */
#define __Vendor_SysTickConfig  0	   /*!< Set to 1 if different SysTick Config is used	 */

#if   defined ( __CC_ARM )
  #pragma anon_unions
#endif

#include <stdio.h>
#include "core_cm0.h"				   /* Cortex-M0 processor and core peripherals		     */

typedef enum {RESET = 0, SET = 1} FlagStatus, ITStatus;

typedef enum {DISABLE = 0, ENABLE = 1} FunctionalState;

#define IS_FUNCTIONAL_STATE(STATE) (((STATE) == DISABLE) || ((STATE) == ENABLE))

typedef enum {ERROR = 0, SUCCESS = 1} ErrorStatus;


/******************************************************************************/
/*				Device Specific Peripheral registers structures			 */
/******************************************************************************/

typedef struct {
	__IO uint32_t CLKSEL;				//Clock Select

	__IO uint32_t CLKDIV_EN;			//CLK_DIVʱԴ

	__IO uint32_t CLKEN;			    //Clock Enable

	uint32_t RESERVED1[1];
	
	__IO uint32_t WDTRST_ST;            //Źλ״̬             
	
	uint32_t RESERVED3[(0x84 - 0x14)/4];
	
	__IO uint32_t XTALCR;					//XTAL Control Register
} SYS_TypeDef;

#define SYS_CLKSEL_SYS_POS		  0		//ϵͳʱѡ	0 HRC  1 CLK_DIVx
#define SYS_CLKSEL_SYS_MSK		  (0x01 << SYS_CLKSEL_SYS_POS)

#define SYS_CLKSEL_DIV_POS		  1		//ѡCLK_DIVx  0 CLK_DIV1   1 CLK_DIV2   2 CLK_DIV4   3 CLK_DIV8
#define SYS_CLKSEL_DIV_MSK		  (0x03 << SYS_CLKSEL_DIV_POS)

#define SYS_CLKSEL_SRC_POS		  3		//ѡSRC  0 HRC   1 LRC   2 XTAL   3 RESERVED
#define SYS_CLKSEL_SRC_MSK		  (0x03 << SYS_CLKSEL_SRC_POS)

#define SYS_CLKSEL_ADC_POS		  6		//ADCʱѡ  0 1Ƶ   1 2Ƶ   2 4Ƶ   3 8Ƶ
#define SYS_CLKSEL_ADC_MSK		  (0x03 << SYS_CLKSEL_ADC_POS)

#define SYS_CLKSEL_WDT_POS		  8		//WDTʱѡ	0 LRC	1 SYS
#define SYS_CLKSEL_WDT_MSK		  (0x01 << SYS_CLKSEL_WDT_POS)


#define SYS_CLKDIV_EN_DIV_POS	  0		//Ƶʱѡ	0 ʹܷƵʱ  1 ֹƵʱ	
#define SYS_CLKDIV_EN_DIV_MSK     (0x01 << SYS_CLKDIV_EN_DIV_POS)


#define SYS_CLKEN_GPIOA_POS		  0		//GPIOAʱſ   
#define SYS_CLKEN_GPIOA_MSK		  (0x01 << SYS_CLKEN_GPIOA_POS)

#define SYS_CLKEN_GPIOB_POS		  1		//GPIOBʱſ   
#define SYS_CLKEN_GPIOB_MSK		  (0x01 << SYS_CLKEN_GPIOB_POS)

#define SYS_CLKEN_IIC_POS		  4		//IICʱſ   
#define SYS_CLKEN_IIC_MSK		  (0x01 << SYS_CLKEN_IIC_POS)

#define SYS_CLKEN_WDT_POS		  6		//WDTʱſ   
#define SYS_CLKEN_WDT_MSK		  (0x01 << SYS_CLKEN_WDT_POS)

#define SYS_CLKEN_RTC_POS		  7		//RTCʱſ   
#define SYS_CLKEN_RTC_MSK		  (0x01 << SYS_CLKEN_RTC_POS)

#define SYS_CLKEN_TIMER_POS		  8		//TIMERʱſ   
#define SYS_CLKEN_TIMER_MSK	      (0x01 << SYS_CLKEN_TIMER_POS)

#define SYS_CLKEN_PWM_POS		  9		//PWMʱſ   
#define SYS_CLKEN_PWM_MSK		  (0x01 << SYS_CLKEN_PWM_POS)

#define SYS_CLKEN_SPI_POS		  10    //SPIʱſ   
#define SYS_CLKEN_SPI_MSK		  (0x01 << SYS_CLKEN_SPI_POS)

#define SYS_CLKEN_UART0_POS		  14    //UARTʱſ   
#define SYS_CLKEN_UART0_MSK		  (0x01 << SYS_CLKEN_UART0_POS)

#define SYS_CLKEN_UART1_POS		  15    //UART1ʱſ   
#define SYS_CLKEN_UART1_MSK		  (0x01 << SYS_CLKEN_UART1_POS)

#define SYS_CLKEN_UART2_POS		  16    //UART2ʱſ   
#define SYS_CLKEN_UART2_MSK		  (0x01 << SYS_CLKEN_UART2_POS)

#define SYS_CLKEN_AES_POS		   20   //AESʱſ   
#define SYS_CLKEN_AES_MSK		  (0x01 << SYS_CLKEN_AES_POS)

#define SYS_CLKEN_ADC_POS		   21   //ADCʱſ   
#define SYS_CLKEN_ADC_MSK		  (0x01 << SYS_CLKEN_ADC_POS)


#define SYS_WDTRST_ST_POS		   0	//Źλ״̬
#define SYS_WDTRST_ST_MSK		  (0x01 << SYS_WDTRST_ST_POS)


#define SYS_XTAL_EN_POS		       0	//XTALʹ
#define SYS_XTAL_EN_MSK		       (0x01 << SYS_XTAL_EN_POS)


typedef struct {
	__IO uint32_t PORTA_SEL;                //ѡ
	
	__IO uint32_t PORTB_SEL;
	
	uint32_t RESERVED1[(0x100 - 0x08)/4];
	
	__IO uint32_t PORTA_INEN;               //ʹ
	
	__IO uint32_t PORTB_INEN; 

	uint32_t RESERVED2[(0x200 - 0x108)/4];
	
	__IO uint32_t PORTA_PU_IN;              //ʹ
		 
    __IO uint32_t PORTB_PU_IN;  
	
	uint32_t RESERVED3[(0x300 - 0x208)/4];
	
    __IO uint32_t PORTA_PD_IN;              //ʹ
  
	__IO uint32_t PORTB_PD_IN;
	
    uint32_t RESERVED4[(0x400 - 0x308)/4];     
			 
	__IO uint32_t PORTA_OD_OUT;              //©ʹ
    
    __IO uint32_t PORTB_OD_OUT; 
 
    uint32_t RESERVED5[(0x500 - 0x408)/4]; 
	
	__IO uint32_t PORTA_WAKEUP;             //ʹ
    
    __IO uint32_t PORTB_WAKEUP; 

    uint32_t RESERVED6[(0x700 - 0x508)/4]; 
	
	__IO uint32_t PORT_CFG;                 //˿
} PORT_TypeDef;


#define PORT_CFG_A0_7_DS_POS		    0		//A0_7ѡ  00 5ma  01 14ma  10 22ma  11 30ma 
#define PORT_CFG_A0_7_DS_MSK		    (0x03 << PORT_CFG_A0_7_DS_POS)

#define PORT_CFG_A8_15_DS_POS		    2		//A8_15ѡ  00 5ma  01 14ma  10 22ma  11 30ma 
#define PORT_CFG_A8_15_DS_MSK		    (0x03 << PORT_CFG_A8_15_DS_POS)

#define PORT_CFG_B0_7_DS_POS		    4		//B0_7ѡ  00 5ma  01 14ma  10 22ma  11 30ma 
#define PORT_CFG_B0_7_DS_MSK		    (0x03 << PORT_CFG_B0_7_DS_POS)

#define PORT_CFG_PUR_POS		        8		//ѡ  00   01  150K   10 40K    11  32K  
#define PORT_CFG_PUR_MSK		        (0x03 << PORT_CFG_PUR_POS)

#define PORT_CFG_HYS_POS		        10		//͵ȼѡ  0   >0.7VDD  <0.3VDD   1   >0.85VDD <0.15VDD 
#define PORT_CFG_HYS_MSK		        (0x01 << PORT_CFG_HYS_POS)

#define PORT_CFG_WKRF_POS		        11		//ѹѡ  0  ½  1
#define PORT_CFG_WKRF_MSK		        (0x01 << PORT_CFG_WKRF_POS)


typedef struct {
	__IO uint32_t DATA;                 //ݼĴ

	__IO uint32_t DIR;					//0 	1 

	__IO uint32_t INTLVLTRG;			//Interrupt Level Trigger  1 ƽж	0 شж

	__IO uint32_t INTBE;			    //Both EdgeINTLVLTRGΪشжʱλ1ʾغ½ضжϣ0ʱINTRISEENѡ

	__IO uint32_t INTRISEEN;			//Interrupt Rise Edge Enable   1 /ߵƽж	0 ½/͵ƽж

	__IO uint32_t INTEN;			    //1 жʹ	0 жϽֹ

	__IO uint32_t INTRAWSTAT;			//жϼⵥԪǷ⵽˴жϵ 1 ⵽жϴ	0 ûм⵽жϴ

	__IO uint32_t INTSTAT;				//INTSTAT.PIN0 = INTRAWSTAT.PIN0 & INTEN.PIN0

	__IO uint32_t INTCLR;			    //д1жϱ־ֻԱشж

} GPIO_TypeDef;



typedef struct {
	__IO uint32_t EN;             //ʱʹ
	
	__IO uint32_t DIV;            //ʱƵֵ
	
	__IO uint32_t CTR;            //ʱƼĴ
	
	uint32_t RESERVED1[1];
	
	__IO uint32_t IE;             //жʹܼĴ
		
	__IO uint32_t STAT;           //״̬Ĵ
	
	uint32_t RESERVED2[(0x80 - 0x18)/4];
	
	__IO uint32_t LOAD;						//ʱֵʹܺʱ0ʼüֵж״̬
	
	__IO uint32_t CNT;                      //ǰֵ
	
} TIMER_TypeDef;


#define TIMER_LOW16BIT_EN_POS         0        //16λʱʹܼĴ    32λʱʱɸλ
#define TIMER_LOW16BIT_EN_MSK         (0x01 << TIMER_LOW16BIT_EN_POS)

#define TIMER_HIGH16BIT_EN_POS        1        //16λʱʹܼĴ    32λʱʱλЧ
#define TIMER_HIGH16BIT_EN_MSK        (0x01 << TIMER_HIGH16BIT_EN_POS)

#define TIMER_DIV_POS                 0        //ʱƵĴ  0 1Ƶ   1  2Ƶ    FF 256Ƶ
#define TIMER_DIV_MSK                 (0xFF << TIMER_DIV_POS)  

#define TIMER_CTR_POS                 0        //ƼĴ    0ʾ   1ʾ
#define TIMER_CTR_MSK                 (0x01 << TIMER_CTR_POS)

#define TIMER_IE_LOW16BIT_POS         0        //16λжʹܼĴ    ģʽ¸λЧ   
#define TIMER_IE_LOW16BIT_MSK         (0x01 << TIMER_IE_LOW16BIT_POS)

#define TIMER_IE_HIGH16BIT_POS        1        //16λжʹܼĴ    ģʽ¸λЧ   
#define TIMER_IE_HIGH16BIT_MSK        (0x01 << TIMER_IE_HIGH16BIT_POS)

#define TIMER_IE_32BIT_POS            2        //32λжʹܼĴ    ֻмģʽ¸λЧ 
#define TIMER_IE_32BIT_MSK            (0x01 << TIMER_IE_32BIT_POS)

#define TIMER_STAT_LOW16BIT_POS       0        //16λ״̬Ĵ    ģʽ¸λЧ   
#define TIMER_STAT_LOW16BIT_MSK       (0x01 << TIMER_STAT_LOW16BIT_POS)

#define TIMER_STAT_HIGH16BIT_POS      1        //16λ״̬Ĵ    ģʽ¸λЧ   
#define TIMER_STAT_HIGH16BIT_MSK      (0x01 << TIMER_STAT_HIGH16BIT_POS)

#define TIMER_STAT_32BIT_POS          2        //32λ״̬Ĵ    ֻмģʽ¸λЧ 
#define TIMER_STAT_32BIT_MSK          (0x01 << TIMER_STAT_32BIT_POS)

#define TIMER_LOAD_LOW16BIT_POS       0        //16λʱĿüĴ
#define TIMER_LOAD_LOW16BIT_MSK       (0xFFFF << TIMER_LOAD_LOW16BIT_POS)

#define TIMER_LOAD_HIGH16BIT_POS      16       //16λʱĿüĴ
#define TIMER_LOAD_HIGH16BIT_MSK      (0xFFFF << TIMER_LOAD_HIGH16BIT_POS)

#define TIMER_CNT_LOW16BIT_POS        0        //16λʱĿüĴ
#define TIMER_CNT_LOW16BIT_MSK        (0xFFFF << TIMER_CNT_LOW16BIT_POS)

#define TIMER_CNT_HIGH16BIT_POS       16       //16λʱĿüĴ
#define TIMER_CNT_HIGH16BIT_MSK       (0xFFFF << TIMER_CNT_HIGH16BIT_POS)

typedef struct {
	__IO uint32_t EN;                     //PWMʹܼĴ
											
	__IO uint32_t DIV;                    //PWMƵĴ
	
	__IO uint32_t INV;                    //PWMתĴ
	
	uint32_t RESERVED1[1];
	
	__IO uint32_t IE;                     //PWMжʹܼĴ
	
	__IO uint32_t IF;                     //PWMж״̬Ĵ
} PWMG_TypeDef;

typedef struct {
	__IO uint32_t PERIOD;                 //PWMüĴ
											
	__IO uint32_t HIGH;                   //PWMߵƽüĴ
} PWM_TypeDef;


#define PWMG_PWM0_EN_POS           0   //PWM0ʹܼĴ
#define PWMG_PWM0_EN_MSK           (0x01 << PWMG_PWM0_EN_POS)

#define PWMG_PWM1_EN_POS           1   //PWM1ʹܼĴ
#define PWMG_PWM1_EN_MSK           (0x01 << PWMG_PWM1_EN_POS)

#define PWMG_PWM2_EN_POS           2   //PWM2ʹܼĴ
#define PWMG_PWM2_EN_MSK           (0x01 << PWMG_PWM2_EN_POS)

#define PWMG_PWM3_EN_POS           3   //PWM3ʹܼĴ
#define PWMG_PWM3_EN_MSK           (0x01 << PWMG_PWM3_EN_POS)

#define PWMG_PWM4_EN_POS           4   //PWM4ʹܼĴ
#define PWMG_PWM4_EN_MSK           (0x01 << PWMG_PWM4_EN_POS)

#define PWMG_DIV_POS               0   //PWMʱӷƵĴ
#define PWMG_DIV_MSK               (0x07 << PWMG_DIV_POS)

#define PWMG_PWM0_INV_POS          0   //PWM0תĴ
#define PWMG_PWM0_INV_MSK          (0x01 << PWMG_PWM0_INV_POS)

#define PWMG_PWM1_INV_POS          1   //PWM1תĴ
#define PWMG_PWM1_INV_MSK          (0x01 << PWMG_PWM1_INV_POS)

#define PWMG_PWM2_INV_POS          2   //PWM2תĴ
#define PWMG_PWM2_INV_MSK          (0x01 << PWMG_PWM2_INV_POS)

#define PWMG_PWM3_INV_POS          3  //PWM3תĴ
#define PWMG_PWM3_INV_MSK          (0x01 << PWMG_PWM3_INV_POS)

#define PWMG_PWM4_INV_POS          4   //PWM4תĴ
#define PWMG_PWM4_INV_MSK          (0x01 << PWMG_PWM4_INV_POS)

#define PWMG_PWM0_HEND_IE_POS      0   //PWM0ߵƽжʹ
#define PWMG_PWM0_HEND_IE_MSK      (0x01 << PWMG_PWM0_HEND_IE_POS)

#define PWMG_PWM0_OVF_IE_POS       1   //PWM0жʹ
#define PWMG_PWM0_OVF_IE_MSK       (0x01 << PWMG_PWM0_OVF_IE_POS)

#define PWMG_PWM1_HEND_IE_POS      4   //PWM1ߵƽжʹ
#define PWMG_PWM1_HEND_IE_MSK      (0x01 << PWMG_PWM1_HEND_IE_POS)

#define PWMG_PWM1_OVF_IE_POS       5   //PWM1жʹ
#define PWMG_PWM1_OVF_IE_MSK       (0x01 << PWMG_PWM1_OVF_IE_POS)

#define PWMG_PWM2_HEND_IE_POS      8   //PWM2ߵƽжʹ
#define PWMG_PWM2_HEND_IE_MSK      (0x01 << PWMG_PWM2_HEND_IE_POS)

#define PWMG_PWM2_OVF_IE_POS       9   //PWM2жʹ
#define PWMG_PWM2_OVF_IE_MSK       (0x01 << PWMG_PWM2_OVF_IE_POS)

#define PWMG_PWM3_HEND_IE_POS      12  //PWM3ߵƽжʹ
#define PWMG_PWM3_HEND_IE_MSK      (0x01 << PWMG_PWM3_HEND_IE_POS)

#define PWMG_PWM3_OVF_IE_POS       13  //PWM3жʹ
#define PWMG_PWM3_OVF_IE_MSK       (0x01 << PWMG_PWM3_OVF_IE_POS)

#define PWMG_PWM4_HEND_IE_POS      16  //PWM4ߵƽжʹ
#define PWMG_PWM4_HEND_IE_MSK      (0x01 << PWMG_PWM4_HEND_IE_POS)

#define PWMG_PWM4_OVF_IE_POS       17  //PWM4жʹ
#define PWMG_PWM4_OVF_IE_MSK       (0x01 << PWMG_PWM4_OVF_IE_POS)


#define PWMG_PWM0_HEND_IF_POS      0   //PWM0ߵƽж״̬
#define PWMG_PWM0_HEND_IF_MSK      (0x01 << PWMG_PWM0_HEND_IF_POS)

#define PWMG_PWM0_OVF_IF_POS       1   //PWM0ж״̬
#define PWMG_PWM0_OVF_IF_MSK       (0x01 << PWMG_PWM0_OVF_IF_POS)

#define PWMG_PWM1_HEND_IF_POS      4   //PWM1ߵƽж״̬
#define PWMG_PWM1_HEND_IF_MSK      (0x01 << PWMG_PWM1_HEND_IF_POS)

#define PWMG_PWM1_OVF_IF_POS       5   //PWM1ж״̬
#define PWMG_PWM1_OVF_IF_MSK       (0x01 << PWMG_PWM1_OVF_IF_POS)

#define PWMG_PWM2_HEND_IF_POS      8   //PWM2ߵƽж״̬
#define PWMG_PWM2_HEND_IF_MSK      (0x01 << PWMG_PWM2_HEND_IF_POS)

#define PWMG_PWM2_OVF_IF_POS       9   //PWM2ж״̬
#define PWMG_PWM2_OVF_IF_MSK       (0x01 << PWMG_PWM2_OVF_IF_POS)

#define PWMG_PWM3_HEND_IF_POS      12  //PWM3ߵƽж״̬
#define PWMG_PWM3_HEND_IF_MSK      (0x01 << PWMG_PWM3_HEND_IF_POS)

#define PWMG_PWM3_OVF_IF_POS       13  //PWM3ж״̬
#define PWMG_PWM3_OVF_IF_MSK       (0x01 << PWMG_PWM3_OVF_IF_POS)

#define PWMG_PWM4_HEND_IF_POS      16  //PWM4ߵƽж״̬
#define PWMG_PWM4_HEND_IF_MSK      (0x01 << PWMG_PWM4_HEND_IF_POS)

#define PWMG_PWM4_OVF_IF_POS       17  //PWM4ж״̬
#define PWMG_PWM4_OVF_IF_MSK       (0x01 << PWMG_PWM4_OVF_IF_POS)

#define PWM_PERIOD_POS             0  //PWMüĴ
#define PWM_PERIOD_MSK             (0xFFF << PWM_PERIOD_POS)

#define PWM_HIGH_POS               0  //PWMߵƽüĴ
#define PWM_HIGH_MSK               (0xFFF << PWM_HIGH_POS)


typedef struct {
    __IO uint32_t EN;               //[0] 1 RTCʹ
    
    __IO uint32_t ALARM;            //üĴ
    
    __IO uint32_t SECOND;           //üĴ
    
    __IO uint32_t TIME;             //ʱ
    
    __IO uint32_t IE;               //жʹܼĴ
	
	__IO uint32_t IF;               //ж״̬Ĵ
 
} RTC_TypeDef;


#define RTC_SECOND_IE_POS     0   //RTCжʹ
#define RTC_SECOND_IE_MSK     (0x01 << RTC_SECOND_IE_POS)

#define RTC_ALARM_IE_POS      1   //RTCжʹ
#define RTC_ALARM_IE_MSK      (0x01 << RTC_ALARM_IE_POS)

#define RTC_OVF_IE_POS        2   //RTCжʹ
#define RTC_OVF_IE_MSK        (0x01 << RTC_OVF_IE_POS)

#define RTC_SECOND_IF_POS     0   //RTCж״̬
#define RTC_SECOND_IF_MSK     (0x01 << RTC_SECOND_IF_POS)

#define RTC_ALARM_IF_POS      1   //RTCж״̬
#define RTC_ALARM_IF_MSK      (0x01 << RTC_ALARM_IF_POS)

#define RTC_OVF_IF_POS        2   //RTCж״̬
#define RTC_OVF_IF_MSK        (0x01 << RTC_OVF_IF_POS)



typedef struct {
	__IO uint32_t LOAD;					    //WDTʼֵ
	
	__IO uint32_t VALUE;					//WDTǰֵ
	
	__IO uint32_t CTRL;                     //WDTƼĴ
	
	__IO uint32_t IF;						//[0] жϱ־д0 
	
	__IO uint32_t FEED;                     //ιĴ  д0x55ι
	
} WDT_TypeDef;


#define WDT_CTRL_EN_POS      0   //WDTʹ
#define WDT_CTRL_EN_MSK      (0x01 << WDT_CTRL_EN_POS)

#define WDT_CTRL_RSTEN_POS   1   //WDTλʹ
#define WDT_CTRL_RSTEN_MSK   (0x01 << WDT_CTRL_RSTEN_POS)


typedef struct {
	__IO uint32_t CTRL;       //ƼĴ

	__IO uint32_t WDATA;      //дݼĴ

	__IO uint32_t RDATA;      //ݼĴ

	uint32_t RESERVED1[1];
	
	__IO uint32_t IE;         //жʹ

	__IO uint32_t IF;         //ж״̬
	
} SPI_TypeDef;


#define SPI_CTRL_CLKDIV_POS     0           //Clock Divider, SPIʱ = SYS_Freq/pow(2, CLKDIV+2)
#define SPI_CTRL_CLKDIV_MSK     (0x07 << SPI_CTRL_CLKDIV_POS)

#define SPI_CTRL_EN_POS         3           //SPIϵͳʹ
#define SPI_CTRL_EN_MSK         (0x01 << SPI_CTRL_EN_POS)

#define SPI_CTRL_CPHA_POS		4		    //0 SCLKĵһز	1 SCLKĵڶز
#define SPI_CTRL_CPHA_MSK		(0x01 << SPI_CTRL_CPHA_POS)

#define SPI_CTRL_CPOL_POS		5		    //0 ״̬SCLKΪ͵ƽ		  1 ״̬SCLKΪߵƽ
#define SPI_CTRL_CPOL_MSK		(0x01 << SPI_CTRL_CPOL_POS)

#define SPI_CTRL_MSTR_POS		6		    //Master, 1 ģʽ	0 ģʽ
#define SPI_CTRL_MSTR_MSK		(0x01 << SPI_CTRL_MSTR_POS)

#define SPI_CTRL_LSBF_POS		7		    //ݴ˳ѡ  0 MSB Fisrt  1 LSB Fisrt
#define SPI_CTRL_LSBF_MSK		(0x01 << SPI_CTRL_LSBF_POS)

#define SPI_CTRL_DATAHOLD_POS   8           //ģʽCPHAΪ1ʱݱʱüĴ
#define SPI_CTRL_DATAHOLD_MSK   (0x0F << SPI_CTRL_DATAHOLD_POS)

#define SPI_CTRL_MST_SSN_POS    12          //ģʽ£SSN   Ĭߵƽ
#define SPI_CTRL_MST_SSN_MSK    (0x01 << SPI_CTRL_MST_SSN_POS)

#define SPI_SPIF_IE_POS         1           //жʹ
#define SPI_SPIF_IE_MSK         (0x01 << SPI_SPIF_IE_POS)

#define SPI_WDFL_IE_POS         2           //дݳͻжʹ
#define SPI_WDFL_IE_MSK         (0x01 << SPI_WDFL_IE_POS)

#define SPI_SPIF_IF_POS         1           //ж״̬
#define SPI_SPIF_IF_MSK         (0x01 << SPI_SPIF_IF_POS)

#define SPI_WDFL_IF_POS         2           //дݳͻж״̬
#define SPI_WDFL_IF_MSK         (0x01 << SPI_WDFL_IF_POS)


typedef struct {
	__IO uint32_t CR;              //ƼĴ
            
	__IO uint32_t SR;              //״̬Ĵ

	__IO uint32_t DINR;            //ݼĴ

	__IO uint32_t DOUTR;           //ݼĴ

	__IO uint32_t KEYR0;           //ԿĴ0
	
	__IO uint32_t KEYR1;           //ԿĴ1
	
	__IO uint32_t KEYR2;           //ԿĴ2
	
	__IO uint32_t KEYR3;           //ԿĴ3
	
	__IO uint32_t IVR0;            //ʼĴ0
	
	__IO uint32_t IVR1;            //ʼĴ1
	
	__IO uint32_t IVR2;            //ʼĴ2
	
	__IO uint32_t IVR3;            //ʼĴ3
	
} AES128_TypeDef;

#define AES128_CR_EN_POS               0          //AES128ʹź
#define AES128_CR_EN_MSK               (0x01 << AES128_CR_EN_POS)

#define AES128_CR_DATATYPE_POS         1          //AES128ѡ
#define AES128_CR_DATATYPE_MSK         (0x03 << AES128_CR_DATATYPE_POS)

#define AES128_CR_MODE_POS             3          //AES128ģʽѡ
#define AES128_CR_MODE_MSK             (0x03 << AES128_CR_MODE_POS)

#define AES128_CR_CHMODE_POS           5          //AES128ģʽѡ
#define AES128_CR_CHMODE_MSK           (0x03 << AES128_CR_CHMODE_POS)

#define AES128_CR_CCFC_POS             7          //AES128ɱ־
#define AES128_CR_CCFC_MSK             (0x01 << AES128_CR_CCFC_POS)

#define AES128_CR_ERRC_POS             8          //AES128־
#define AES128_CR_ERRC_MSK             (0x01 << AES128_CR_ERRC_POS)

#define AES128_CR_CCFIE_POS            9          //AES128жʹ
#define AES128_CR_CCFIE_MSK            (0x01 << AES128_CR_CCFIE_POS)

#define AES128_CR_ERRIE_POS            10         //AES128жʹ
#define AES128_CR_ERRIE_MSK            (0x01 << AES128_CR_ERRIE_POS)

#define AES128_SR_CCF_POS              0          //AES128ɱ־
#define AES128_SR_CCF_MSK              (0x01 << AES128_SR_CCF_POS)

#define AES128_SR_RDERR_POS            1          //AES128ȡ־
#define AES128_SR_RDERR_MSK            (0x01 << AES128_SR_RDERR_POS)

#define AES128_SR_WRERR_POS            2          //AES128д־
#define AES128_SR_WRERR_MSK            (0x01 << AES128_SR_WRERR_POS)


typedef struct {
	__IO uint32_t CFG;                //ƼĴ
	__IO uint32_t PROGDATA;           //ݼĴ
	__IO uint32_t ADDR;               //ַĴ
	__IO uint32_t PROGEN;             //ʹܼĴ
	__IO uint32_t RDATA;              //ݼĴ
	__IO uint32_t RDEN;               //ʹܼĴ
	
	__IO uint32_t PROG_UNLOCK;        //Ĵ
	
} OTP_TypeDef;

#define OTP_CFG_MD_POS           0             //ģʽѡ
#define OTP_CFG_MD_MASK          (0x0F<<OTP_CFG_MD_POS)

#define OTP_CFG_TPW_POS          4             //TPWʱĴ
#define OTP_CFG_TPW_MASK         (0x7FF<<OTP_CFG_TPW_POS)

#define OTP_CFG_TCPS_POS         16            //TPCSʱĴ
#define OTP_CFG_TCPS_MASK        (0xFF<<OTP_CFG_TCPS_POS)

#define OTP_CFG_SDY_POS          31            //STANDBY״̬Ĵ
#define OTP_CFG_SDY_MASK         (0x01<<OTP_CFG_SDY_POS)

#define OTP_PROGEN_EN_POS        0             //ʹܼĴ
#define OTP_PROGEN_EN_MASK       (0x01<<OTP_PROGEN_EN_POS)

#define OTP_PROGEN_ST_POS        1             //״̬Ĵ
#define OTP_PROGEN_ST_MASK       (0x01<<OTP_PROGEN_ST_POS)

#define OTP_PROGEN_FAIL_POS      2             //ʧܱ־
#define OTP_PROGEN_FAIL_MASK     (0x01<<OTP_PROGEN_FAIL_POS)

#define OTP_PROGEN_INIT_POS      3             //ʼ״̬
#define OTP_PROGEN_INIT_MASK     (0x01<<OTP_PROGEN_INIT_POS)

#define OTP_PROGEN_LOCK_POS      4             //Ĵ
#define OTP_PROGEN_LOCK_MSK      (0xFF<<OTP_PROGEN_LOCK_POS)


#define OTP_RDEN_EN_POS          0             //ʹ
#define OTP_RDEN_EN_MASK         (0x01<<OTP_RDEN_EN_POS)

#define OTP_RDEN_ST_POS          1             //״̬Ĵ
#define OTP_RDEN_ST_MASK         (0x01<<OTP_RDEN_ST_POS)

#define OTP_PROG_UNLOCK_POS      0             //Ĵ
#define OTP_PROG_UNLOCK_MSK      (0xFFFFFFFF<<OTP_PROG_UNLOCK_POS)


typedef struct {
	union {
		__IO uint32_t RDR;    //ݼĴ
		
		__IO uint32_t SDR;    //ݼĴ
		
		__IO uint32_t DLL;    //ʵͰλüĴ
	};
	union {
		__IO uint32_t DHL;    //ʸ߰λüĴ
		
		__IO uint32_t IE;     //жʹܼĴ   
	};
	
	__IO uint32_t RIID;       //жIDĴ  ֻ
	
	__IO uint32_t CTRL;       //ƼĴ
	
	__IO uint32_t MCR;        //LOOPBACKʹ 
	
	__IO uint32_t LSR;       //״̬Ĵ
	
} UART_TypeDef;



#define UART_IE_RXIEN_POS        0      //Чжʹ
#define UART_IE_RXIEN_MSK        (0x01 << UART_IE_RXIEN_POS)

#define UART_IE_TXE_POS          1      //ݼĴжʹ
#define UART_IE_TXE_MSK          (0x01 << UART_IE_TXE_POS)


#define UART_CTRL_DATALEN_POS    0      //λ  00 5bit   01  6bit  10  7bit  11 8bit
#define UART_CTRL_DATALEN_MSK    (0x03 << UART_CTRL_DATALEN_POS)

#define UART_CTRL_STOP2BIT_POS   2      //ֹͣλ   0  1stop    1   2stop
#define UART_CTRL_STOP2BIT_MSK   (0x01 << UART_CTRL_STOP2BIT_POS)

#define UART_CTRL_PARITY_POS	 3		//000 У    001 У   011 żУ   101 ̶Ϊ1    111 ̶Ϊ0
#define UART_CTRL_PARITY_MSK	 (0x07 << UART_CTRL_PARITY_POS)

#define UART_CTRL_BRKEN_POS		 6		//Breakʹ
#define UART_CTRL_BRKEN_MSK		 (0x01 << UART_CTRL_BRKEN_POS)

#define UART_CTRL_BAUDEN_POS	 7		//ÿλ
#define UART_CTRL_BAUDEN_MSK	 (0x01 << UART_CTRL_BAUDEN_POS)

#define UART_MCR_LOOPBACKEN_POS	 4      //ػģʽʹλ
#define UART_MCR_LOOPBACKEN_MSK	 (0x01 << UART_MCR_LOOPBACKEN_POS)
 
#define UART_LSR_REC_POS        0       //ݽ״̬
#define UART_LSR_REC_MSK        (0x01 << UART_LSR_REC_POS)

#define UART_LSR_OVF_POS        1       //״̬
#define UART_LSR_OVF_MSK        (0x01 << UART_LSR_OVF_POS)

#define UART_LSR_PARITY_POS     2       //żУ״̬
#define UART_LSR_PARITY_MSK     (0x01 << UART_LSR_PARITY_POS)

#define UART_LSR_STOP_POS       3       //STOP״̬
#define UART_LSR_STOP_MSK       (0x01 << UART_LSR_STOP_POS)

#define UART_LSR_BREAK_POS      4       //BREAK״̬
#define UART_LSR_BREAK_MSK      (0x01 << UART_LSR_BREAK_POS)

#define UART_LSR_THRE_POS       5       //ݼĴ״̬
#define UART_LSR_THRE_MSK       (0x01 << UART_LSR_THRE_POS)

#define UART_LSR_TEMT_POS       6       //޷״̬
#define UART_LSR_TEMT_MSK       (0x01 << UART_LSR_TEMT_POS)


typedef struct {
	__IO uint32_t CLKDIV;       //ƵĴ 
	
	__IO uint32_t CTRL;         //ƼĴ  
	
	__IO uint32_t TXR;          //ͼĴ
	
	__IO uint32_t RXR;          //ռĴ
	
	__IO uint32_t CR;           //Ĵ
	
	__IO uint32_t SR;           //״̬Ĵ
	
} IIC_TypeDef;

#define IIC_CTRL_EN_POS    0    //ģʹ
#define IIC_CTRL_EN_MSK    (0x01 << IIC_CTRL_EN_POS)

#define IIC_CTRL_IE_POS    1    //жʹ
#define IIC_CTRL_IE_MSK    (0x01 << IIC_CTRL_IE_POS)


#define IIC_CR_IF_POS      0    //ж
#define IIC_CR_IF_MSK      (0x01 << IIC_CR_IF_POS)

#define IIC_CR_ACK_POS     1    //ģʽ£߷ACK
#define IIC_CR_ACK_MSK     (0x01 << IIC_CR_ACK_POS)

#define IIC_CR_WR_POS      2    //ӻд
#define IIC_CR_WR_MSK      (0x01 << IIC_CR_WR_POS)

#define IIC_CR_RD_POS      3    //Ӵӻ
#define IIC_CR_RD_MSK      (0x01 << IIC_CR_RD_POS)

#define IIC_CR_STOP_POS    4    //STOPź
#define IIC_CR_STOP_MSK    (0x01 << IIC_CR_STOP_POS)

#define IIC_CR_START_POS   5    //STARTź
#define IIC_CR_START_MSK   (0x01 << IIC_CR_START_POS)


#define IIC_SR_IF_POS      0    //ж
#define IIC_SR_IF_MSK      (0x01 << IIC_SR_IF_POS)

#define IIC_SR_TIP_POS     1    //
#define IIC_SR_TIP_MSK     (0x01 << IIC_SR_TIP_POS)

#define IIC_SR_ARB_POS     2    //ٲöʧ
#define IIC_SR_ARB_MSK     (0x01 << IIC_SR_ARB_POS)

#define IIC_SR_BUSY_POS    3    //æ
#define IIC_SR_BUSY_MSK    (0x01 << IIC_SR_BUSY_POS)

#define IIC_SR_RACK_POS    4    //յӻ͹ACK
#define IIC_SR_RACK_MSK    (0x01 << IIC_SR_RACK_POS)


typedef struct {
	__IO uint32_t LPOW_MD;      //͹ģʽѡ
	
	__IO uint32_t LPMD_WKEN;    //͹ĻԴʹ
	
	__IO uint32_t LPMD_WKST;    //͹ĻԴ״̬
	
	uint32_t RESERVED1[5];
	
	__IO uint32_t TRIM_POW;     //POWER TRIM 
	
	__IO uint32_t TRIM_RC;      //RCHF RCLF TRIM
	
	__IO uint32_t TRIM_LOCK;    //TRIM LOCK
	
	uint32_t RESERVED2[1];
	
	__IO uint32_t RCHFCR;					//RC High speed Control Register
	
} PMU_TypeDef;


#define PMU_LPOW_MD_STANDBY_POS         0     //STANDBYģʽ
#define PMU_LPOW_MD_STANDBY_MSK         (0x01 << PMU_LPOW_MD_STANDBY_POS)

#define PMU_LPOW_MD_SLEEP_POS           1     //SLEEPģʽ
#define PMU_LPOW_MD_SLEEP_MSK           (0x01 << PMU_LPOW_MD_SLEEP_POS)

#define PMU_LPOW_MD_DEEPSLEEP_POS       2     //DEEPSLEEPģʽ
#define PMU_LPOW_MD_DEEPSLEEP_MSK       (0x01 << PMU_LPOW_MD_DEEPSLEEP_POS)

#define PMU_LPOW_MD_STOP_POS            3     //STOPģʽ
#define PMU_LPOW_MD_STOP_MSK            (0x01 << PMU_LPOW_MD_STOP_POS)

#define PMU_LPMD_WKEN_RTC_ALARM_POS     0     //͹ģʽ  RTCӻʹ
#define PMU_LPMD_WKEN_RTC_ALARM_MSK     (0x01 << PMU_LPMD_WKEN_RTC_ALARM_POS)

#define PMU_LPMD_WKEN_RTC_SEC_POS       1     //͹ģʽ  RTCźŻʹ
#define PMU_LPMD_WKEN_RTC_SEC_MSK       (0x01 << PMU_LPMD_WKEN_RTC_SEC_POS)

#define PMU_LPMD_WKEN_IO_POS            2     //͹ģʽ  IOźŻʹ
#define PMU_LPMD_WKEN_IO_MSK            (0x01 << PMU_LPMD_WKEN_IO_POS)


#define PMU_LPMD_WKST_RTC_ALARM_POS     0     //͹ģʽ  RTCӻѱ־
#define PMU_LPMD_WKST_RTC_ALARM_MSK     (0x01 << PMU_LPMD_WKST_RTC_ALARM_POS)

#define PMU_LPMD_WKST_RTC_SEC_POS       1     //͹ģʽ  RTCźŻѱ־
#define PMU_LPMD_WKST_RTC_SEC_MSK       (0x01 << PMU_LPMD_WKST_RTC_SEC_POS)

#define PMU_LPMD_WKST_IO_POS            2     //͹ģʽ  IOźŻѱ־
#define PMU_LPMD_WKST_IO_MSK            (0x01 << PMU_LPMD_WKST_IO_POS)


#define PMU_TRIM_LOCK_POS		        0	//TRIM_LOCK       д0x55TRIMĴ
#define PMU_TRIM_LOCK_MSK		        (0xFF << PMU_TRIM_LOCK_POS)


#define PMU_RCHFCR_EN_POS		        0	//RCHFʹ
#define PMU_RCHFCR_EN_MSK		        (0x01 << PMU_RCHFCR_EN_POS)


typedef struct {
	__IO uint32_t CFG;          //CACHEüĴ      
	
	__IO uint32_t PF_CTRL;      //ԤȡƼĴ   	
} CACHE_TypeDef;


#define CACHE_CFG_RESET_POS       0              //CACHEλź
#define CACHE_CFG_RESET_MSK       (0x01 << CACHE_CFG_RESET_POS)

#define CACHE_CFG_IDLE_POS        1              //CACHE״̬
#define CACHE_CFG_IDLE_MSK        (0x01 << CACHE_CFG_IDLE_POS)


#define CACHE_PF_CTRL_START_POS   0              //Ԥȡλ
#define CACHE_PF_CTRL_START_MSK   (0x01 << CACHE_PF_CTRL_START_POS)

#define CACHE_PF_CTRL_UNLOCK_POS  1              //ԤȡüĴ
#define CACHE_PF_CTRL_UNLOCK_MSK  (0x01 << CACHE_PF_CTRL_UNLOCK_POS)

#define CACHE_PF_CTRL_ADDR_POS    4             //ԤȡռĻַ
#define CACHE_PF_CTRL_ADDR_MSK    (0x1FF << CACHE_PF_CTRL_ADDR_POS)


typedef struct {
	__IO uint32_t CFG;               //ADCüĴ      
	
	__IO uint32_t START;             //ADCĴ  

	__IO uint32_t IE;                //ADCжʹܼĴ  
	
	__IO uint32_t IF;                //ADCж״̬Ĵ  
	
 	struct {
		__IO uint32_t STAT;          //ͨ״̬Ĵ
		
		__IO uint32_t DATA;          //ͨݼĴ
		
	    uint32_t RESERVED1[2];
	} CH[9];
	
	__IO uint32_t FIFO_STAT;         //FIFO״̬Ĵ
	
	__IO uint32_t FIFO_DATA;         //FIFOݼĴ
	
	uint32_t RESERVED2[14];
	
	__IO uint32_t CTRL;              //ADCƼĴ 
	
	uint32_t RESERVED3[3];
	
	__IO uint32_t CALIB_OFFSET;     //ADCУ׼OFFSETĴ
	
	__IO uint32_t CALIB_KD;         //ADCУ׼KDĴ
	
} ADC_TypeDef;


#define ADC_CFG_CH0_Pos			    0		//ͨ0ѡ
#define ADC_CFG_CH0_Msk			    (0x01 << ADC_CFG_CH0_Pos)

#define ADC_CFG_CH1_Pos			    1		//ͨ1ѡ
#define ADC_CFG_CH1_Msk			    (0x01 << ADC_CFG_CH1_Pos)

#define ADC_CFG_CH2_Pos			    2		//ͨ2ѡ
#define ADC_CFG_CH2_Msk			    (0x01 << ADC_CFG_CH2_Pos)

#define ADC_CFG_CH3_Pos			    3		//ͨ3ѡ
#define ADC_CFG_CH3_Msk			    (0x01 << ADC_CFG_CH3_Pos)

#define ADC_CFG_CH4_Pos			    4		//ͨ4ѡ
#define ADC_CFG_CH4_Msk			    (0x01 << ADC_CFG_CH4_Pos)

#define ADC_CFG_CH5_Pos			    5		//ͨ5ѡ
#define ADC_CFG_CH5_Msk			    (0x01 << ADC_CFG_CH5_Pos)

#define ADC_CFG_CH6_Pos			    6		//ͨ6ѡ
#define ADC_CFG_CH6_Msk			    (0x01 << ADC_CFG_CH6_Pos)
 
#define ADC_CFG_CH7_Pos			    7		//ͨ7ѡ
#define ADC_CFG_CH7_Msk			    (0x01 << ADC_CFG_CH7_Pos)

#define ADC_CFG_CH8_Pos			    8		//ͨ8ѡ
#define ADC_CFG_CH8_Msk			    (0x01 << ADC_CFG_CH8_Pos)

#define ADC_CFG_AVG_Pos		        9		//0 1β	  1 2βȡƽֵ	  2 4βȡƽֵ	  3 8βȡƽֵ	
#define ADC_CFG_AVG_Msk		        (0x03 << ADC_CFG_AVG_Pos)

#define ADC_CFG_CONT_Pos		    11		//Continuous conversionֻģʽЧ0 תתɺSTARTλԶֹͣת
#define ADC_CFG_CONT_Msk		    (0x01 << ADC_CFG_CONT_Pos)							//   1 תһֱתֱSTARTλ

#define ADC_CFG_SMPL_SETUP_Pos      12      //ADCⲿʱӷʽ²ʱ   0:1  1:2  2:4  3:8  4:16  5:32  6:64  7:128
#define ADC_CFG_SMPL_SETUP_Msk      (0x07 << ADC_CFG_SPL_SETUP_Pos)

#define ADC_CFG_MEM_MODE_Pos        15      //ADCݴ洢ʽѡ   0:FIFOģʽ   1:ͨģʽ
#define ADC_CFG_MEM_MODE_Msk        (0x01 << ADC_CFG_MEM_MODE_Pos)

#define ADC_CFG_SMPL_CLK_Pos        16      //ADCģʽѡ    0:ڲʱ  1:ⲿʱ
#define ADC_CFG_SMPL_CLK_Msk        (0x01 << ADC_CFG_SMPL_CLK_Pos)

#define ADC_CFG_IN_SMPL_WIN_Pos     17      //ADCڲʱӷʽ   0:1Tclk   1:3Tclk   2:5Tclk   3:7Tclk  4:9Tclk  5:11Tclk  6:13Tclk  7:15Tclk
#define ADC_CFG_IN_SMPL_WIN_Msk     (0x07 << ADC_CFG_IN_SMPL_WIN_Pos)

#define ADC_CFG_EN_Pos              20      //ADCʹܿλ   0:ʹ  1:ʹ
#define ADC_CFG_EN_Msk              (0x01 << ADC_CFG_EN_Pos)

#define ADC_CFG_EN_AVDDSNS_Pos      21      //ADC VDDʹܳλ   0:ֻͨ8Чʱ,VDDʹܲŴ   1:VDDʹܳ
#define ADC_CFG_EN_AVDDSNS_Msk      (0x01 << ADC_CFG_EN_AVDDSNS_Pos)


#define ADC_START_START_Pos         0      //ADCź   0:  1:
#define ADC_START_START_Msk         (0x01 << ADC_START_START_Pos) 

#define ADC_START_BUSY_Pos          1      //ADCæ״̬   0:  1:æ
#define ADC_START_BUSY_Msk          (0x01 << ADC_START_BUSY_Pos) 

#define ADC_START_SOFT_RESET_Pos    2      //ADCλʹλ
#define ADC_START_SOFT_RESET_Msk    (0x01 << ADC_START_SOFT_RESET_Pos) 

#define ADC_START_FIFOCLR_Pos       3      //ADC FIFOʹ
#define ADC_START_FIFOCLR_Msk       (0x01 << ADC_START_FIFOCLR_Pos) 


#define ADC_IE_CH0EOC_Pos			0		//CH0תжʹ
#define ADC_IE_CH0EOC_Msk			(0x01 << ADC_IE_CH0EOC_Pos)

#define ADC_IE_CH1EOC_Pos			1		//CH1תжʹ
#define ADC_IE_CH1EOC_Msk			(0x01 << ADC_IE_CH1EOC_Pos)

#define ADC_IE_CH2EOC_Pos			2		//CH2תжʹ
#define ADC_IE_CH2EOC_Msk			(0x01 << ADC_IE_CH2EOC_Pos)

#define ADC_IE_CH3EOC_Pos			3		//CH3תжʹ
#define ADC_IE_CH3EOC_Msk			(0x01 << ADC_IE_CH3EOC_Pos)

#define ADC_IE_CH4EOC_Pos			4		//CH4תжʹ
#define ADC_IE_CH4EOC_Msk			(0x01 << ADC_IE_CH4EOC_Pos)

#define ADC_IE_CH5EOC_Pos			5		//CH5תжʹ
#define ADC_IE_CH5EOC_Msk			(0x01 << ADC_IE_CH5EOC_Pos)

#define ADC_IE_CH6EOC_Pos			6		//CH6תжʹ
#define ADC_IE_CH6EOC_Msk			(0x01 << ADC_IE_CH6EOC_Pos)

#define ADC_IE_CH7EOC_Pos			7		//CH7תжʹ
#define ADC_IE_CH7EOC_Msk			(0x01 << ADC_IE_CH7EOC_Pos)

#define ADC_IE_CH8EOC_Pos			8		//CH8תжʹ
#define ADC_IE_CH8EOC_Msk			(0x01 << ADC_IE_CH8EOC_Pos)

#define ADC_IE_FIFO_FULL_Pos	    9       //FIFOжʹ
#define ADC_IE_FIFO_FULL_Msk	    (0x01 << ADC_IE_FIFO_FULL_Pos)

#define ADC_IE_FIFO_HFULL_Pos	    10       //FIFOжʹ
#define ADC_IE_FIFO_HFULL_Msk	    (0x01 << ADC_IE_FIFO_HFULL_Pos)

#define ADC_IE_FIFO_OVF_Pos			11		//FIFOжʹ
#define ADC_IE_FIFO_OVF_Msk			(0x01 << ADC_IE_FIFO_OVF_Pos)


#define ADC_IF_CH0EOC_Pos			0		//CH0תж״̬
#define ADC_IF_CH0EOC_Msk			(0x01 << ADC_IF_CH0EOC_Pos)

#define ADC_IF_CH1EOC_Pos			1		//CH1תж״̬
#define ADC_IF_CH1EOC_Msk			(0x01 << ADC_IF_CH1EOC_Pos)

#define ADC_IF_CH2EOC_Pos			2		//CH2תж״̬
#define ADC_IF_CH2EOC_Msk			(0x01 << ADC_IF_CH2EOC_Pos)

#define ADC_IF_CH3EOC_Pos			3		//CH3תж״̬
#define ADC_IF_CH3EOC_Msk			(0x01 << ADC_IF_CH3EOC_Pos)

#define ADC_IF_CH4EOC_Pos			4		//CH4תж״̬
#define ADC_IF_CH4EOC_Msk			(0x01 << ADC_IF_CH4EOC_Pos)

#define ADC_IF_CH5EOC_Pos			5		//CH5תж״̬
#define ADC_IF_CH5EOC_Msk			(0x01 << ADC_IF_CH5EOC_Pos)

#define ADC_IF_CH6EOC_Pos			6		//CH6תж״̬
#define ADC_IF_CH6EOC_Msk			(0x01 << ADC_IF_CH6EOC_Pos)

#define ADC_IF_CH7EOC_Pos			7		//CH7תж״̬
#define ADC_IF_CH7EOC_Msk			(0x01 << ADC_IF_CH7EOC_Pos)

#define ADC_IF_CH8EOC_Pos			8		//CH8תж״̬
#define ADC_IF_CH8EOC_Msk			(0x01 << ADC_IF_CH8EOC_Pos)

#define ADC_IF_FIFO_FULL_Pos	    9       //FIFOж״̬
#define ADC_IF_FIFO_FULL_Msk	    (0x01 << ADC_IF_FIFO_FULL_Pos)

#define ADC_IF_FIFO_HFULL_Pos	    10       //FIFOж״̬
#define ADC_IF_FIFO_HFULL_Msk	    (0x01 << ADC_IF_FIFO_HFULL_Pos)

#define ADC_IF_FIFO_OVF_Pos			11		//FIFOж״̬
#define ADC_IF_FIFO_OVF_Msk			(0x01 << ADC_IF_FIFO_OVF_Pos)


#define ADC_STAT_EOC_Pos			0		//ADC_IFӦͨӦλд1
#define ADC_STAT_EOC_Msk			(0x01 << ADC_STAT_EOC_Pos)
#define ADC_STAT_OVF_Pos			1		//ݼĴ
#define ADC_STAT_OVF_Msk			(0x01 << ADC_STAT_OVF_Pos)


#define ADC_DATA_DATA_Pos           0       //ADCͨݼĴ
#define ADC_DATA_DATA_Msk           (0xFFF << ADC_DATA_DATA_Pos)

#define ADC_DATA_NUM_Pos            12      //ADCݶӦͨ
#define ADC_DATA_NUM_Msk            (0x0F << ADC_DATA_NUM_Pos)


#define ADC_FIFO_STAT_FULL_Pos      0       //ADCFIFO־λ
#define ADC_FIFO_STAT_FULL_Msk      (0x01 << ADC_FIFO_STAT_FULL_Pos)

#define ADC_FIFO_STAT_HFULL_Pos     1       //ADCFIFO־λ
#define ADC_FIFO_STAT_HFULL_Msk     (0x01 << ADC_FIFO_STAT_HFULL_Pos)

#define ADC_FIFO_STAT_EMPTY_Pos     2       //ADCFIFOձ־λ
#define ADC_FIFO_STAT_EMPTY_Msk     (0x01 << ADC_FIFO_STAT_EMPTY_Pos)

#define ADC_FIFO_STAT_OVF_Pos       3       //ADCFIFO־λ
#define ADC_FIFO_STAT_OVF_Msk       (0x01 << ADC_FIFO_STAT_OVF_Pos)

#define ADC_FIFO_STAT_LEVEL_Pos     4       //ADCFIFOˮ
#define ADC_FIFO_STAT_LEVEL_Msk     (0x0F << ADC_FIFO_STAT_LEVEL_Pos)


#define ADC_FIFO_DATA_Pos           0       //ADCFIFOĴ
#define ADC_FIFO_DATA_Msk           (0xFFF << ADC_FIFO_DATA_Pos)

#define ADC_FIFO_NUM_Pos            12      //ADCFIFOӦͨ
#define ADC_FIFO_NUM_Msk            (0x0F << ADC_FIFO_NUM_Pos)


#define ADC_CTRL_VREF_Pos           0       //ADCڲVREFѡ   0:ڲ  1:ⲿ
#define ADC_CTRL_VREF_Msk           (0x01 << ADC_CTRL_VREF_Pos)


#define ADC_CALIB_OFFSET_Pos        0       //ADCУ׼OFFSET
#define ADC_CALIB_OFFSET_Msk        (0xFF << ADC_CALIB_OFFSET_Pos)

#define ADC_CALIB_OFFSET_VALID_Pos  16      //ADCУ׼OFFSETǷЧ
#define ADC_CALIB_OFFSET_VALID_Msk  (0xFF << ADC_CALIB_OFFSET_VALID_Pos)


#define ADC_CALIB_KD_Pos            0       //ADCУ׼KD
#define ADC_CALIB_KD_Msk            (0x3FF << ADC_CALIB_KD_Pos)

#define ADC_CALIB_KD_VALID_Pos      16      //ADCУ׼KDǷЧ
#define ADC_CALIB_KD_VALID_Msk      (0xFF << ADC_CALIB_KD_VALID_Pos)


/******************************************************************************/
/*						 Peripheral memory map							  */
/******************************************************************************/
#define RAM_BASE		    ((uint32_t)0x20000000)
#define AHB_BASE			((uint32_t)0x40000000)
#define APB1_BASE		 	((uint32_t)0x40040000)
#define APB2_BASE			((uint32_t)0x400A0000)
#define OTP_DATA            ((uint32_t)0x41000000)

/* AHB Peripheral memory map */
#define SYS_BASE			(AHB_BASE + 0x00000)
#define PMU_BASE			(AHB_BASE + 0x01000)
#define CACHE_BASE	        (AHB_BASE + 0x02000)


/* APB1 Peripheral memory map */

#define WDT_BASE		    (APB1_BASE + 0x1000)
#define TIMER_BASE		    (APB1_BASE + 0x1800)
#define RTC_BASE			(APB1_BASE + 0x2000)
#define SPI_BASE		    (APB1_BASE + 0x3000)
#define UART1_BASE		    (APB1_BASE + 0x4000)
#define UART2_BASE		    (APB1_BASE + 0x4800)
#define IIC_BASE		    (APB1_BASE + 0x5000)

/* APB2 Peripheral memory map */
#define PORT_BASE			(APB2_BASE + 0x0000)
#define GPIOA_BASE		    (APB2_BASE + 0x1000)
#define GPIOB_BASE		    (APB2_BASE + 0x1800)
#define OTP_BASE		    (APB2_BASE + 0x3000)
#define AES128_BASE		    (APB2_BASE + 0x3800)
#define UART0_BASE		    (APB2_BASE + 0x7000)
#define PWMG_BASE			(APB2_BASE + 0xA000)
#define PWM0_BASE			(APB2_BASE + 0xA100)
#define PWM1_BASE			(APB2_BASE + 0xA200)
#define PWM2_BASE			(APB2_BASE + 0xA300)
#define PWM3_BASE			(APB2_BASE + 0xA400)
#define PWM4_BASE			(APB2_BASE + 0xA500)
#define ADC_BASE			(APB2_BASE + 0xB000)

/******************************************************************************/
/*						 Peripheral declaration							 */
/******************************************************************************/
#define SYS					((SYS_TypeDef  *) SYS_BASE)

#define PMU 				((PMU_TypeDef  *) PMU_BASE)

#define CACHE				((CACHE_TypeDef*) CACHE_BASE)

#define WDT					((WDT_TypeDef  *) WDT_BASE)

#define TIMER				((TIMER_TypeDef *) TIMER_BASE)

#define RTC				    ((RTC_TypeDef *) RTC_BASE)

#define SPI				    ((SPI_TypeDef  *) SPI_BASE)

#define IIC                 ((IIC_TypeDef  *) IIC_BASE)

#define PORT				((PORT_TypeDef *) PORT_BASE)

#define GPIOA				((GPIO_TypeDef *) GPIOA_BASE)

#define GPIOB				((GPIO_TypeDef *) GPIOB_BASE)

#define OTP			        ((OTP_TypeDef  *) OTP_BASE)

#define AES128			    ((AES128_TypeDef  *) AES128_BASE)

#define UART0				((UART_TypeDef *) UART0_BASE)
#define UART1				((UART_TypeDef *) UART1_BASE)
#define UART2				((UART_TypeDef *) UART2_BASE)

#define PWMG				((PWMG_TypeDef *) PWMG_BASE)
#define PWM0				((PWM_TypeDef  *) PWM0_BASE)
#define PWM1				((PWM_TypeDef  *) PWM1_BASE)
#define PWM2				((PWM_TypeDef  *) PWM2_BASE)
#define PWM3				((PWM_TypeDef  *) PWM3_BASE)
#define PWM4				((PWM_TypeDef  *) PWM4_BASE)

#define ADC				    ((ADC_TypeDef  *) ADC_BASE)


#include "system_BL210x.h"
#include "BL210x_port.h"
#include "BL210x_gpio.h"
#include "BL2101_clk.h"
#include "BL2101_exti.h"
#include "BL2101_timer.h"
#include "BL2101_uart.h"
#include "BL2101_spi.h"
#include "BL2101_wdt.h"
#include "BL2101_rtc.h"
#include "BL2101_pwm.h"
#include "BL2101_otp.h"
#include "BL2101_aes.h"
#include "BL2101_iic.h"
#include "BL2101_power.h"
#include "BL2101_conf.h"
#include "BL2101_adc.h"



#endif //__BL2101_H__
