

#ifndef _PORTABLE_H
#define _PORTABLE_H

#define SUPPORT_RF

#ifdef WIN32
#define code
#define xdata
#define bit char
#endif 

// system on che MCU chip
void switch_clear_ram();
void hardware_init();

///RF Section

#ifdef SUPPORT_RF


///Timer
extern volatile unsigned char Pairing_Timer_mS;
extern unsigned char G_PAIRINT_TIMEOUT;

///for eeprom
#define EEPROM_SlotLink_BA_ADDRESS   0x50   //0x80

//extern unsigned char G_EEPROM_SlotLink_BA_ADDRESS; //EEPROM_SlotLink_BA_ADDRESS





typedef enum {
	Rf_PRX_Mode = 0,
	Rf_PTX_Mode,
	Rf_Carrier_Mode
}RF_ModeTypeDef;

///RF
void Port_MrfiChAddrSwitch(unsigned char *NextAddr);
void Port_MrfiEntryBrdcastAddrRxMode(void);
void Port_MiniBLE_RadioInit(void);
void Port_RW_Minible_Mode(void);
void Port_SendDataToRF(unsigned char *address,unsigned char *Tbuf,unsigned char len);
void Port_SendDataToPhone(unsigned char *address,unsigned char *Tbuf,unsigned char len);
unsigned int Port_RecivePack(unsigned char* buf);

// GPIO
// port: 0,1,2
void port_gpio_set(unsigned char uport, unsigned char ubit, unsigned char ulevel);

// PWM
void port_pwm_init(void);
void port_pwm1_duty_change(unsigned int u16_duty);
void port_pwm2_duty_change(unsigned int u16_duty);

///Flash
void port_read_flash(unsigned int addr,unsigned char *buf,unsigned char size);
void port_modify_flash(unsigned int addr, unsigned char *buf,unsigned char size);
void port_write_flash(unsigned int  addr, unsigned char *buf,unsigned char size);

///Watch Dog
void Port_Wdt_Clear(void);

///UART
void Port_Uart_SendData(unsigned char u8_length, unsigned char *u8_data_addr);

///LOG
void Port_LogStr(const char * str);


#endif

#endif
