#include <stdint.h>
#include "BL210x.h"

uint32_t SystemCoreClock  = __HSI;   				      //System Clock Frequency (Core Clock)
uint32_t CyclesPerUs      = (__HSI / 1000000); 		      //Cycles per micro second


/****************************************************************************************************************************************** 
* : 
* ˵: This function is used to update the variable SystemCoreClock and must be called whenever the core clock is changed
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void SystemCoreClockUpdate(void)    
{
 uint8_t Clk_Div = 1;
 uint32_t delay = 0;
 
 if((SYS->CLKSEL & SYS_CLKSEL_SYS_MSK) == 0)
 {
  if(SYS->RCCR & SYS_RCCR_RCHF_SEL_MSK)
  {
   SystemCoreClock  = __HSI >> 1; 
  }
  else
  {
   SystemCoreClock  = __HSI; 
  }
 }
 else
 {
  Clk_Div = 0x01 << ((SYS->CLKSEL & SYS_CLKSEL_DIV_MSK) >> SYS_CLKSEL_DIV_POS);
  
  if((SYS->RCCR & SYS_RCCR_RCHF_SEL_MSK)&&((SYS->CLKSEL&SYS_CLKSEL_SRC_MSK)==0))
  {
   Clk_Div  *= 2;      //RCHF24MƵϵ2
  }
  
  if(((SYS->CLKSEL & SYS_CLKSEL_SRC_MSK)>> SYS_CLKSEL_SRC_POS) == 0x00)
  {
   SystemCoreClock  = __HSI / Clk_Div; 
  }
  else if(((SYS->CLKSEL & SYS_CLKSEL_SRC_MSK) >> SYS_CLKSEL_SRC_POS) == 0x01)
  {
   SystemCoreClock  = __LSI / Clk_Div; 
  }
  else if(((SYS->CLKSEL & SYS_CLKSEL_SRC_MSK) >> SYS_CLKSEL_SRC_POS) == 0x02)
  {
   SystemCoreClock  = __HSE / Clk_Div; 
  } 
 }
 
 CyclesPerUs = SystemCoreClock/1000000;
 
 for(delay = 0;delay < 100000;delay++);
}


void Switch_CLK_48MHZ(void)
{
	SYS->RCCR |= 0x01 << SYS_RCCR_RCHF_EN_POS;             //RCHFʹ 
	SYS->RCCR &= ~(0x01 << SYS_RCCR_RCHF_SEL_POS);         //RCHFѡ48MHZ
	SYS->CLKSEL &= ~(0x03 << SYS_CLKSEL_SRC_POS);          //ʱԴѡRCHF
	SYS->CLKSEL &= ~(0x01 << SYS_CLKSEL_SYS_POS);          //ϵͳʱѡΪRCHF
	SYS->CLKDIV_EN &= ~(0x01 << SYS_CLKDIV_EN_DIV_POS);    //Ƶʱӽֹ
}


void Switch_CLK_48MHZ_DIV2(void)
{
	SYS->RCCR |= 0x01 << SYS_RCCR_RCHF_EN_POS;             //RCHFʹ 
	SYS->RCCR |= (0x01 << SYS_RCCR_RCHF_SEL_POS);          //RCHFѡ24MHZ
	SYS->CLKSEL &= ~(0x03 << SYS_CLKSEL_SRC_POS);          //ʱԴѡRCHF
	SYS->CLKSEL &= ~(0x01 << SYS_CLKSEL_SYS_POS);          //ϵͳʱѡΪRCHF
	SYS->CLKDIV_EN &= ~(0x01 << SYS_CLKDIV_EN_DIV_POS);    //Ƶʱӽֹ
}


void Switch_CLK_48MHZ_DIV4(void)
{
	Switch_CLK_48MHZ_DIV2();                            //лʱʱлصڲ24MHZ
	
	SYS->CLKSEL &= ~(0x07 << SYS_CLKSEL_DIV_POS);       
	SYS->CLKSEL |= 0x01 << SYS_CLKSEL_DIV_POS;          //Ƶʱѡ2Ƶ

	SYS->CLKDIV_EN |= 0x01 << SYS_CLKDIV_EN_DIV_POS;    //Ƶʱ 
	
	SYS->CLKSEL |= 0x01 << SYS_CLKSEL_SYS_POS;          //ϵͳʱѡƵʱ
}


void Switch_CLK_XTAL(void)
{
	uint32_t k = 0;
	
	Switch_CLK_48MHZ_DIV2();                            //лʱʱлصڲ24MHZ
	
	SYS->XTACR |= 0x01 << SYS_XTACR_XTAH_EN_POS;        //XTAHʹ
	
	for(k = 0; k < 100000;k++);                         //XTAHʹܺٵȴ2msʹ
	
	SYS->CLKSEL &= ~(0x07 << SYS_CLKSEL_DIV_POS);       //Ƶʱѡ1Ƶ
	
	SYS->CLKSEL &= ~(0x03 << SYS_CLKSEL_SRC_POS);       
	SYS->CLKSEL |= 0x02 << SYS_CLKSEL_SRC_POS;          //ʱԴѡXTAH
	
	SYS->CLKDIV_EN |= 0x01 << SYS_CLKDIV_EN_DIV_POS;    //Ƶʱ 
	
	SYS->CLKSEL |= 0x01 << SYS_CLKSEL_SYS_POS;          //ϵͳʱѡƵʱ
}


void Switch_CLK_XTAL_DIV2(void)
{
	uint32_t k = 0;
	
	Switch_CLK_48MHZ_DIV2();                            //лʱʱлصڲ24MHZ
	
	SYS->XTACR |= 0x01 << SYS_XTACR_XTAH_EN_POS;        //XTAHʹ
	
	for(k = 0; k < 100000;k++);                         //XTALʹܺٵȴ2msʹ
	
	SYS->CLKSEL &= ~(0x07 << SYS_CLKSEL_DIV_POS);       
	SYS->CLKSEL |= 0x01 << SYS_CLKSEL_DIV_POS;          //Ƶʱѡ2Ƶ
	
	SYS->CLKSEL &= ~(0x03 << SYS_CLKSEL_SRC_POS);       
	SYS->CLKSEL |= 0x02 << SYS_CLKSEL_SRC_POS;          //ʱԴѡXTAL
	
	SYS->CLKDIV_EN |= 0x01 << SYS_CLKDIV_EN_DIV_POS;    //Ƶʱ 
	
	SYS->CLKSEL |= 0x01 << SYS_CLKSEL_SYS_POS;          //ϵͳʱѡƵʱ
}


void Switch_CLK_XTAL_DIV4(void)
{
	uint32_t k = 0;
	
	Switch_CLK_48MHZ_DIV2();                            //лʱʱлصڲ24MHZ
	
	SYS->XTACR |= 0x01 << SYS_XTACR_XTAH_EN_POS;        //XTAHʹ
	
	for(k = 0; k < 100000;k++);                         //XTALʹܺٵȴ2msʹ
	
	SYS->CLKSEL &= ~(0x07 << SYS_CLKSEL_DIV_POS);       
	SYS->CLKSEL |= 0x02 << SYS_CLKSEL_DIV_POS;          //Ƶʱѡ4Ƶ
	
	SYS->CLKSEL &= ~(0x03 << SYS_CLKSEL_SRC_POS);       
	SYS->CLKSEL |= 0x02 << SYS_CLKSEL_SRC_POS;          //ʱԴѡXTAL
	
	SYS->CLKDIV_EN |= 0x01 << SYS_CLKDIV_EN_DIV_POS;    //Ƶʱ 
	
	SYS->CLKSEL |= 0x01 << SYS_CLKSEL_SYS_POS;          //ϵͳʱѡƵʱ
}


void Switch_CLK_32KHZ(void)
{
	Switch_CLK_48MHZ_DIV2();                            //лʱʱлصڲ24MHZ
	
	SYS->CLKSEL &= ~(0x07 << SYS_CLKSEL_DIV_POS);       //Ƶʱѡ1Ƶ
	
	SYS->CLKSEL &= ~(0x03 << SYS_CLKSEL_SRC_POS);       
	SYS->CLKSEL |= 0x01 << SYS_CLKSEL_SRC_POS;          //ʱԴѡڲ32KHZ
	
	SYS->CLKDIV_EN |= 0x01 << SYS_CLKDIV_EN_DIV_POS;    //Ƶʱ 
	
	SYS->CLKSEL |= 0x01 << SYS_CLKSEL_SYS_POS;          //ϵͳʱѡƵʱ            
}


/****************************************************************************************************************************************** 
* : 
* ˵: The necessary initializaiton of systerm
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void SystemClkSel(uint8_t clk)
{		
	uint32_t TRIM_POW_Addr = 0x3FFE4;
	uint32_t TRIM_RC_Addr = 0x3FFE0;
	
	PMU->TRIM_POW = FLASH_Read_Word_2(TRIM_POW_Addr);
	
	PMU->TRIM_RC = FLASH_Read_Word_2(TRIM_RC_Addr);
	
	switch(clk)
	{
		case SYS_CLK_48MHz:			        //0 ڲƵ48MHz RC
			
			Switch_CLK_48MHZ();
		
		break;
		
		case SYS_CLK_48MHz_DIV2:			//1 ڲƵ48MHz RC  2Ƶ
			
			Switch_CLK_48MHZ_DIV2();
		
		break;
		
		case SYS_CLK_48MHz_DIV4:			//2 ڲƵ48MHz RC  4Ƶ
			
			Switch_CLK_48MHZ_DIV4();
		
		break;
		
		case SYS_CLK_XTAL:			        //3 ⲿ4-32MHz
			
			Switch_CLK_XTAL();
		
		break;
		
		case SYS_CLK_XTAL_DIV2:			    //4 ⲿ4-32MHz  2Ƶ
			
			Switch_CLK_XTAL_DIV2();
		
		break;
		
		case SYS_CLK_XTAL_DIV4:			    //5 ⲿ4-32MHz  4Ƶ
			
			Switch_CLK_XTAL_DIV4();
		
		break;
		
		case SYS_CLK_32KHz:			        //6 ڲƵ32KHz RC
			
			Switch_CLK_32KHZ();
		
		break;	
	}	
}


/****************************************************************************************************************************************** 
* : 
* ˵: The necessary initializaiton of systerm
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void SystemInit(uint8_t clk)
{		
	FLASH_Init(FLASH_QuadReadData,FLASH_CLKDIV_1);
	
	SystemClkSel(SYS_CLK_48MHz);
	
	SystemCoreClockUpdate();	
}


