#include "BL210x_wdt.h"
#include "BL2102.h"

/****************************************************************************************************************************************** 
* :	IWDT_Init()
* ˵:	IWDTŹʼ
*     : IWDT_InitTypeDef * IWDT_InitStruct
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void IWDT_Init(IWDT_InitTypeDef * IWDT_InitStruct)
{
//	assert_param(IS_IWDT_RST(IWDT_InitStruct->RstEn));                 //ĲRstEnǷϷ      
//	
//	assert_param(IS_IWDT_LOAD(IWDT_InitStruct->Load));                 //ĲLoadǷϷ   
	
	SYS->CLKEN |= 0x01 << SYS_CLKEN_IWDT_POS;                          //IWDTʱʹ
	
	IWDT_Stop();                                                       //رIWDT
	
	IWDT->CTRL &= ~(0x01 << IWDT_CTRL_RSTEN_POS);
	IWDT->CTRL |= (IWDT_InitStruct->RstEn << IWDT_CTRL_RSTEN_POS);     //ʹܸλѡ
	
	IWDT->LOAD = IWDT_InitStruct->Load;                                //IWDTʼֵ

	NVIC_EnableIRQ(IWDT_IRQn);                                         //IWDTж
}


/****************************************************************************************************************************************** 
* :	IWDT_Start()
* ˵:	ָIWDTʼʱ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IWDT_Start(void)
{
	IWDT->CTRL |= (0x01 << IWDT_CTRL_EN_POS);
}

/****************************************************************************************************************************************** 
* :	IWDT_Stop()
* ˵:	رָIWDTֹͣʱ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IWDT_Stop(void)
{
	IWDT->CTRL &= ~(0x01 << IWDT_CTRL_EN_POS);
}


/****************************************************************************************************************************************** 
* :	IWDT_FEED()
* ˵:	ι
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IWDT_FEED(void)
{
	IWDT->FEED = 0x55;
}


/****************************************************************************************************************************************** 
* :	IWDT_INTStat()
* ˵:	ж״̬ѯ
*     : 
*     : uint8_t		1 ж    0 δж
* ע: 
******************************************************************************************************************************************/
uint8_t IWDT_INTStat(void)
{
	return IWDT->IF;
}


/****************************************************************************************************************************************** 
* :	IWDT_INTClr()
* ˵:	жϱ־
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IWDT_INTClr(void)
{
	IWDT->IF = 0;
}


