#include "portable.h"
#include "hs6200_rf.h"
#include "flash.h"
#include "timer.h"
#include "register.h"
//#include "eeprom.h"
#include "uart.h"

unsigned char G_PAIRINT_TIMEOUT = PAIRINT_TIMEOUT;
#define port_MAX_RETRAN_NUM  30


void Port_MrfiChAddrSwitch(unsigned char *NextAddr)
{
    HS6200_ChangeAddr_Reg(NextAddr, 5);
}

void Port_MrfiEntryBrdcastAddrRxMode(void)
{
	HS6200_CE_Low();
	//HS6200_ChangeAddr_Reg(mrfi_brdcast_addr,5); 
//TODO	Delay1ms(1);
	HS6200_Change_CH(0x02);
	HS6200_ModeSwitch(Rf_PRX_Mode);	
}

void Port_MiniBLE_RadioInit()
{
    HS6200_Init();
}

void Port_RW_Minible_Mode(void)
{
	const unsigned char BLE_Init_Dat[]  = 
	{
		HS6200_BANK0_RX_PW_P0,		1,		16,
		HS6200_BANK0_FEATURE,		1,		0x00,
		HS6200_BANK0_EN_AA,			1,		0x00,
		HS6200_BANK0_RF_CH,      	1,    	0x02,
		0xff
	};

	HS6200_CE_Low();
	HS6200_configure_Reg(BLE_Init_Dat);	

	//HS6200_ChangeAddr_Reg(mrfi_brdcast_addr, 5);
	
	HS6200_Flush_Rx();
	HS6200_CE_High();

}


void Port_SendDataToRF(unsigned char *address,unsigned char *Tbuf,unsigned char len)
{
        xdata unsigned char i;
        xdata unsigned char sta = 0;
        
        HS6200_CE_Low();
        HS6200_Flush_Tx();
    //  HS6200_write_byte(HS6200_BANK0_EN_AA,0x00);
    //  HS6200_ChangeAddr_Reg(address,5);
        
        HS6200_ModeSwitch(Rf_PTX_Mode);     
        HS6200_CE_High();   
        for(i = 0; i < port_MAX_RETRAN_NUM;i++)
        {
            HS6200_CE_Low();
            HS6200_Change_CH(2);
            HS6200_SendPack(HS6200_W_TX_PAYLOAD_NOACK,Tbuf, len);
            
            HS6200_RF_CE_High_Pulse();
            sta = HS6200_Operation(HS6200_READ_STATUS);
            while(!(sta&(HS6200_STATUS_MAX_RT|HS6200_STATUS_TX_DS))){
                sta = HS6200_Operation(HS6200_READ_STATUS);
            }       
            HS6200_write_byte(HS6200_BANK0_STATUS,0x20);
        }
        HS6200_ModeSwitch(Rf_PRX_Mode);     
      HS6200_CE_High(); 


}


void Port_SendDataToPhone(unsigned char *address,unsigned char *Tbuf,unsigned char len)
{

    xdata unsigned char i;
    xdata unsigned char sta = 0;
    //xdata unsigned char ch;

    HS6200_CE_Low();
    HS6200_Flush_Tx();
	//HS6200_ChangeAddr_Reg(address,5);
	HS6200_wr_buffer((HS6200_WR_REG|HS6200_BANK0_RX_ADDR_P0),address,5);
	HS6200_wr_buffer((HS6200_WR_REG|HS6200_BANK0_TX_ADDR),address,5);

    HS6200_ModeSwitch(Rf_PTX_Mode);                 
    for(i = 0; i < port_MAX_RETRAN_NUM; i++)
    {
        HS6200_CE_Low();
        HS6200_SendPack(HS6200_W_TX_PAYLOAD,Tbuf, len);
        //HS6200_CE_High();
        //Delay1ms(2);
        
        HS6200_RF_CE_High_Pulse();
        //sta = HS6200_Operation(HS6200_READ_STATUS);
        //while(!(sta&(HS6200_STATUS_MAX_RT|HS6200_STATUS_TX_DS))){
        //    sta = HS6200_Operation(HS6200_READ_STATUS);
        //}       
        //HS6200_write_byte(HS6200_BANK0_STATUS,0x20);
    }   


}

unsigned int Port_RecivePack(unsigned char* buf)
{
    return HS6200_RecivePack(buf);
}



