#include "bl210x_test.h"
#include "bl210x_uart.h"
//#include "bl2101_timer.h"
#include "bl210x_gpio.h"
#include "bl210x_port.h"
#include "bl210x_adc.h"
#include "BL210x_flash.h"
#include "BL210x_iic.h"
#include "BL210x_spi.h"
#include "BL210x_wdt.h"
#include "BL210x_pwmbase.h"
#include "BL210x_exti.h"

#include "common.h"
#include "BL2102_pwmplus.h"

#include "stdio.h"
#include "uti.h"

uint16_t time_1ms = 0;              //1ms 
uint16_t time_10ms = 0;             //10ms
uint16_t time_100ms = 0;            //100ms

uint16_t Serial_timeout_1ms = 0;    //ڳʱֵ

uint8_t Rec_Data[100] = {1,2};      //յݴ
uint8_t Rec_Num = 0;                //յݸ

uint8_t * UART_TXBuffer = 0;        //
uint32_t UART_TXCount = 0;          //ݸ
uint32_t UART_TXIndex = 0;          //

uint8_t Uart_Rec_flag=0;

// =================== UART  TEST DEMO ===================================================

///
/// ڳʼ
///
void uart_init(void)
{
	UART_InitTypeDef UART_InitStruct;
	PORT_InitTypeDef PORT_InitStruct;
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN1;
	PORT_InitStruct.Func = PORTA_PIN1_UART0_TX;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTA1Ϊ0ķ
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN2;
	PORT_InitStruct.Func = PORTA_PIN2_UART0_RX;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);     //PORTA2Ϊ0Ľ
	
	
	UART_InitStruct.Baudrate = 115200;            //115200
	UART_InitStruct.DataBits = UART_DATA_8BIT;    //λ8λ
	UART_InitStruct.Parity = UART_PARITY_NONE;    //У
	UART_InitStruct.StopBits = UART_STOP_1BIT;    //ֹͣλ1λ
	
	UART_InitStruct.RXIEn = 1;                    //жʹ
	
	UART_Init(UART0,&UART_InitStruct);            //ڳʼ
}

///
/// 0жϷ
///
void UART0_Handler(void)
{
	if(UART0->LSR & UART_LSR_REC_MSK)             //Ч
	{
		Serial_timeout_1ms = 0;                   //ڳʱ0
		//time_1ms=0;
		Rec_Data[Rec_Num++] = UART0->RDR;         //ȡյ
	  //Uart_Rec_flag = 1;
	//	printf("Rec_Num: %d\r\n", Rec_Num); 
	}
	
	if(UART0->LSR & UART_LSR_TEMT_MSK)            //
	{
		if(UART_TXIndex < UART_TXCount)
		{
			UART_SendData(UART0, UART_TXBuffer[UART_TXIndex]);
			UART_TXIndex++;
		}
		else
		{
			UART0->IE &= ~(0x01 << UART_IE_TXE_POS);    //رշж
		}
	}
}

///
/// жϷʽ
///
void UART_SendChars(uint8_t data[], uint32_t len)
{
	UART_TXBuffer = data;
	UART_TXCount = len;
	UART_TXIndex = 0;
	
	UART0->IE |= 0x01 << UART_IE_TXE_POS;
	NVIC_EnableIRQ(UART0_IRQn);
}



///
/// ڲԳ    
///
void uart_test_tx_rx(uint8_t senddata)
{
//	uint8_t k = 0;
	
	if(Serial_timeout_1ms > 10)                        //ڳʱ10ms
	{
		if(Rec_Num == 0)                               //ûյ0
		{
			Serial_timeout_1ms = 0;
		}
		else                                           //յ
		{
			
			Serial_timeout_1ms = 0;                    //ʱ0
			
			//for(k = 0; k < Rec_Num;k++)
			//{
			//	UART_SendData(UART0, Rec_Data[k]);     //ѯʽ 
			//}
			
			UART_SendChars(Rec_Data,Rec_Num);          //жϷʽ 
			
			Rec_Num = 0;	
		}
	}
}


/******************************************************************************************************************************************
* : fputc()
* ˵: printf()ʹô˺ʵʵĴڴӡ
*     : int ch		Ҫӡַ
*			FILE *f		ļ
*     : 
* ע: 
******************************************************************************************************************************************/
int fputc(int ch, FILE *f)
{
	UART_SendData(UART0,ch);
    return ch;
}
// =================== END OF UART  TEST DEMO ===================================================


// =================== TIMER  TEST DEMO ===================================================
#if TIMER_TEST

void timer_1ms_init(void)
{
#ifdef IC_BL2101
	  // 16λʱʼ
    TIMER_Init(TIMER_LOW16BIT,1000,1);      //16λʱ   ʱʱ1ms     TIMER_Start(TIMER_LOW16BIT);            //16λʱ
#else
	TIMPLUS_CommonInitTypeDef  TIMPLUS_CommonInitStruct = {0};

	TIMPLUS_CommonInitStruct.ClkDiv = SystemCoreClock/1000000 - 1;    //õ1usļʱʱ
	TIMPLUS_CommonInitStruct.Mode = TIMER_MODE;                       //ʱģʽ
	TIMPLUS_CommonInitStruct.ClkSel = SYSCLK_DIV;                     //ʱԴѡϵͳʱӷƵ
	TIMPLUS_CommonInitStruct.Period = 1000;                           //Ϊ1000ҲǶʱ1ms
	TIMPLUS_CommonInitStruct.OutEn = DISABLE;                         //
	TIMPLUS_CommonInitStruct.Ovf_IE = ENABLE;                         //жʹ
	
	TIMPLUS_Common_Init(TIMPLUS0,TIMPLUS_LOW,&TIMPLUS_CommonInitStruct);
	
	TIMPLUS_Start(TIMPLUS0,TIMPLUS_LOW);                              //ʱ
	
#endif
}
#ifdef IC_BL2102
void TIMPLUS0_Handler(void)
{

	if(TIMPLUS0->IF & TIMPLUS_IF_LOW_OVF_MSK)
	{
		TIMPLUS0->IF = (0x01 << TIMPLUS_IF_LOW_OVF_POS);              //ʱж״̬
		
		time_1ms++;
		if(time_1ms>1000)
		{
			time_1ms=0;
			LED1_TOGGLE;
		}
	}
}

#endif
#ifdef IC_BL2101
///
/// 16λʱʼ
///
void TIMER_H16_Init(void)
{
   TIMER_Init(TIMER_HIGH16BIT,10000,1);    //16λʱ   ʱʱ10ms   ж
   TIMER_Start(TIMER_HIGH16BIT);           //16λʱ
}

///
/// 32λʱʼ
///
void TIMER_HL32_Init(void)
{
	TIMER_Init(TIMER_32BIT,100000,1);      //32λʱ   ʱʱ100ms   ж
   TIMER_Start(TIMER_32BIT);              //32λʱ
}

///
/// ʱжϷ
///
void TIMER_Handler(void)
{
	if(TIMER_INTStat(TIMER_LOW16BIT))          //жϵ16λʱжϱ־ǷΪ1
	{
		TIMER_INTClr(TIMER_LOW16BIT);          //16λʱжϱ־
		
		time_1ms++;                            //1ms1
	}

	if(TIMER_INTStat(TIMER_HIGH16BIT))         //жϸ16λʱжϱ־ǷΪ1  
	{
		TIMER_INTClr(TIMER_HIGH16BIT);         //16λʱжϱ־
		
		time_10ms++;                           //10ms1
	}

	if(TIMER_INTStat(TIMER_32BIT))             //ж32λʱжϱ־ǷΪ1          
	{
		TIMER_INTClr(TIMER_32BIT);             //32λʱжϱ־
		
		time_100ms++;                          //100ms1
	}
}
#endif
void timer_test(void)
{
	timer_1ms_init();
}
#endif
// =================== END OF TIMER  TEST DEMO ===================================================

#if ADC_TEST
// =================== ADC  TEST DEMO ===================================================



uint16_t Adc_Data[100] = {0};     //ADCջ
uint16_t Adc_Num = 0;              //ADCֽڼ
uint8_t Flag_ADC_Over = 0;         //ADCɼɱ־

uint8_t Flag_Int = 0;      //жϲű־

uint16_t Fifo_Cnt0 = 0;    //ͨ0
uint16_t Fifo_Cnt1 = 0;    //ͨ1


/*************ADC_VDDβѯģʽʼ*************/
void ADC_VDD_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH8;                     //ADCתͨѡCH8
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_64;     //ⲿ
	ADC_initStruct.Vref = VREF_IN;                         //ADCοԴѡڲο 
	ADC_initStruct.Trig = TRIG_CPU;                        //CPUźŲɼ
	ADC_initStruct.Adcvdd_Open = ENABLE;                   //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdݲʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}

/*************ADC_VDDβѯģʽ*************/
void ADC_VDD_Check_Devote(void)
{
	uint16_t data = 0;
	
	while(ADC_IsEOC(ADC_CH8) == 0);                        //ȴת
	
	data = ADC_Read(ADC_CH8);                              //ȡת
	
	data = (data*3*1400)>>12;                              //תΪʵʵĵѹֵ λΪmV   ڲ1/3ѹвɼ
	
	printf("%d,",data);                                    //ӡת                    
	
	ADC_Start();                                           //ADCת
}
   


void Timerplus_Low_Trig_Adc_Init(void)
{
	TIMPLUS_CommonInitTypeDef  TIMPLUS_CommonInitStruct = {0};
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct = {0};
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7        
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH7;                     //ADCתͨѡCH7
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_128;    //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Trig = TRIG_EXT;                        //ⲿźŴADCɼ
	ADC_initStruct.ExtTrig_Sel = ADC_EXTTRIG_TIMPLUS_LOW;  //ⲿźѡTIMPLUS_LOW
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = DISABLE;                        //kdݽ
	ADC_initStruct.Offset_En = DISABLE;                    //offsetݽ
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ  
	
	
	TIMPLUS_CommonInitStruct.ClkDiv = SystemCoreClock/1000000 - 1;    //õ1usļʱʱ
	TIMPLUS_CommonInitStruct.Mode = TIMER_MODE;                       //ʱģʽ
	TIMPLUS_CommonInitStruct.ClkSel = SYSCLK_DIV;                     //ʱԴѡϵͳʱӷƵ
	TIMPLUS_CommonInitStruct.Period = 1000;                           //Ϊ1000ҲǶʱ1ms
	TIMPLUS_CommonInitStruct.OutEn = DISABLE;                         //
	TIMPLUS_CommonInitStruct.Ovf_IE = DISABLE;                        //жϽ
	
	TIMPLUS_Common_Init(TIMPLUS0,TIMPLUS_LOW,&TIMPLUS_CommonInitStruct);
	
	TIMPLUS_Start(TIMPLUS0,TIMPLUS_LOW);                              //ʱ   
}

void Timerplus_High_Trig_Adc_Init(void)
{
	TIMPLUS_CommonInitTypeDef  TIMPLUS_CommonInitStruct = {0};
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct = {0};
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7        
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH7;                     //ADCתͨѡCH7
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_128;    //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Trig = TRIG_EXT;                        //ⲿźŴADCɼ
	ADC_initStruct.ExtTrig_Sel = ADC_EXTTRIG_TIMPLUS_HIGH; //ⲿźѡTIMPLUS_HIGH
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = DISABLE;                        //kdݽ
	ADC_initStruct.Offset_En = DISABLE;                    //offsetݽ
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ  
	
	
	TIMPLUS_CommonInitStruct.ClkDiv = SystemCoreClock/1000000 - 1;    //õ1usļʱʱ
	TIMPLUS_CommonInitStruct.Mode = TIMER_MODE;                       //ʱģʽ
	TIMPLUS_CommonInitStruct.ClkSel = SYSCLK_DIV;                     //ʱԴѡϵͳʱӷƵ
	TIMPLUS_CommonInitStruct.Period = 1000;                           //Ϊ1000ҲǶʱ1ms
	TIMPLUS_CommonInitStruct.OutEn = DISABLE;                         //
	TIMPLUS_CommonInitStruct.Ovf_IE = DISABLE;                        //жϽ
	
	TIMPLUS_Common_Init(TIMPLUS0,TIMPLUS_HIGH,&TIMPLUS_CommonInitStruct);
	
	TIMPLUS_Start(TIMPLUS0,TIMPLUS_HIGH);                              //ʱ   
}

void Pwmplus_Trig_Adc_Init(void)
{
	PORT_InitTypeDef PORT_InitStruct = {0};
	PWMPLUS_CommonInitTypeDef PWMPLUS_CommonInitStruct ;
	PWMPLUS_ChannelInitTypeDef PWMPLUS_ChannelInitStruct ;
	ADC_InitStructure ADC_initStruct ;
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7        
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH7;                     //ADCתͨѡCH7
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_128;    //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Trig = TRIG_EXT;                        //ⲿźŴADCɼ
	ADC_initStruct.ExtTrig_Sel = ADC_EXTTRIG_PWMPLUS_TRIG0; //ⲿźѡPWMPLUS_TRIG0
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = DISABLE;                        //kdݽ
	ADC_initStruct.Offset_En = DISABLE;                    //offsetݽ
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ  
	

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN3;
	PORT_InitStruct.Func = PORTA_PIN3_PWMP0_CH0;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	PWMPLUS_CommonInitStruct.Clk_Src = CLKSRC_DIV;                         //ڲԤƵʱΪʱ           
	PWMPLUS_CommonInitStruct.ClkDiv = 15;                                  //ʱ16Ƶ
	PWMPLUS_CommonInitStruct.Mode = CYCLE_EDGE_ALIGN;                      //ض
	PWMPLUS_CommonInitStruct.Dir = DIR_UP;                                 //ϼ
	PWMPLUS_CommonInitStruct.Reload_Cnt = 0;                               //װشΪ1
	PWMPLUS_CommonInitStruct.Period = 10000;                               //Ϊ10000
	PWMPLUS_CommonInitStruct.Brake_Filter = BRAKE_FILTER_1;                //ɲ˲ϵΪ1
	PWMPLUS_CommonInitStruct.Brake_InputLevel = BRAKE0_HIGH_BRAKE1_HIGH;   //ɲ0Ϊߵƽ  ɲ1Ϊߵƽ
	PWMPLUS_CommonInitStruct.Trig_Comp = 2000;                             //ڲΪ2000
	PWMPLUS_CommonInitStruct.Trig0_Sel = CH0_UP_COMP_TRIG;                 //ϼ
	PWMPLUS_CommonInitStruct.Trig1_Sel = NOSIGNAL_TRIG;                    //޴ź
	PWMPLUS_CommonInitStruct.Trig2_Sel = NOSIGNAL_TRIG;                    //޴ź
	PWMPLUS_CommonInitStruct.Trig3_Sel = NOSIGNAL_TRIG;                    //޴ź
	PWMPLUS_CommonInitStruct.Reload_IE = DISABLE;                          //װжϽ
	PWMPLUS_CommonInitStruct.Brake0_IE = DISABLE;                          //ɲ0жϽ
	PWMPLUS_CommonInitStruct.Brake1_IE = DISABLE;                          //ɲ1жϽ
	PWMPLUS_CommonInitStruct.Up_OvfIE  = DISABLE;                          //ϼжϽ
	PWMPLUS_CommonInitStruct.Up_TrigCompIE  = DISABLE;                     //ϼڲжϽ
	PWMPLUS_CommonInitStruct.Down_OvfIE  = DISABLE;                        //¼жϽ
	PWMPLUS_CommonInitStruct.Down_TrigCompIE  = DISABLE;                   //¼ڲжϽ
	
	PWMPLUS_CommonInit(PWMPLUS0,&PWMPLUS_CommonInitStruct);
	
	PWMPLUS_ChannelInitStruct.Channel = PWMPLUS_CH0;                   //Ϊͨ0
	PWMPLUS_ChannelInitStruct.Comp = 4000;                             //ȽϵΪ4000
	PWMPLUS_ChannelInitStruct.DeadZone = 100;                          //Ϊ100
	PWMPLUS_ChannelInitStruct.StartLevel = LEVEL_LOW;                  //ʼƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.CHxIdleLevel = LEVEL_HIGH;               //ͨ0еƽΪߵƽ
	PWMPLUS_ChannelInitStruct.CHxNIdleLevel = LEVEL_HIGH;              //ͨ0NеƽΪߵƽ
	PWMPLUS_ChannelInitStruct.CHxInv = DISABLE;                        //ͨ0ת
	PWMPLUS_ChannelInitStruct.CHxNInv = DISABLE;                       //ͨ0Nת
	PWMPLUS_ChannelInitStruct.CHxOutEn = ENABLE;                       //ͨ0ʹ
	PWMPLUS_ChannelInitStruct.CHxNOutEn = DISABLE;                     //ͨ0N
	PWMPLUS_ChannelInitStruct.Brake_CHxOutLevel = LEVEL_LOW;           //ͨ0ɲƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Brake_CHxNOutLevel = LEVEL_LOW;          //ͨ0NɲƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Brake_Enable = BRAKE0_DIS_BRAKE1_DIS;    //ɲ0 ɲ1
	PWMPLUS_ChannelInitStruct.Mask_CHx_Level = LEVEL_LOW;              //ͨ0εƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Level = LEVEL_LOW;             //ͨ0NεƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Mask_CHx_Enable = DISABLE;               //ͨ0ιܽ
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Enable = DISABLE;              //ͨ0Nιܽ
	PWMPLUS_ChannelInitStruct.Up_CompIE  = DISABLE;                    //ͨ0ϼȽϵжϽ
	PWMPLUS_ChannelInitStruct.Down_CompIE  = DISABLE;                  //ͨ0¼ȽϵжϽ
	
	PWMPLUS_ChannelInit(PWMPLUS0,&PWMPLUS_ChannelInitStruct);
	
	PWMPLUS_Start(PWMPLUS0);
	
}



void Trig_Adc_Devote(void)
{
	uint16_t data = 0;
	
	while(ADC_IsEOC(ADC_CH7) == 0);                        //ȴת
	
	data = ADC_Read(ADC_CH7);                              //ȡת
	
	printf("%d,  ",data);                                    //ӡת   
}


/*************ͨβѯģʽʼ*************/
void SingleChn_Single_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN6;
	PORT_InitStruct.Func = PORTA_PIN6_ADC_CH6;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7        
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH6;                     //ADCתͨѡCH7
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_128;    //ⲿ
	ADC_initStruct.Vref = VREF_IN;                        //ADCοԴѡⲿο 
	ADC_initStruct.Trig = TRIG_CPU;                        //CPUźŲɼ
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}


/*************ͨβѯģʽ*************/
void SingleChn_Single_Check_Devote(void)
{
	uint16_t data = 0;
	
	while(ADC_IsEOC(ADC_CH6) == 0);                        //ȴת
	
	data = ADC_Read(ADC_CH6);                              //ȡת
	
	printf("%d,  ",data);                                    //ӡת                    
	
	ADC_Start();                                           //ADCת  
}


/*************ͨѯģʽʼ*************/
void SingleChn_Continue_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ2Ƶ                    
	ADC_initStruct.Channels = ADC_CH7;                     //ADCתͨѡCH7
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}


/*************ͨѯģʽ*************/
void SingleChn_Continue_Check_Devote(void)
{
	uint16_t data = 0;
	
	while(ADC_IsEOC(ADC_CH7) == 0);                        //ȴת
	
	data = ADC_Read(ADC_CH7);                              //ȡת
	
	printf("%d,",data);                                    //ӡת   
}


/*************ͨβжģʽʼ*************/
void SingleChn_Single_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ2Ƶ                    
	ADC_initStruct.Channels = ADC_CH7;                     //ADCתͨѡCH7
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 

	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH7;                      //ͨ7תжʹ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 1;
	
	ADC_Start();                                           //ADCת
}

/******************ͨβжģʽ***************/
void SingleChn_Single_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)                        //ɱ־
    {
        Flag_ADC_Over = 0;

        for(i = 0; i< 100; i++)
        {
            printf("%d,",Adc_Data[i]);            //ӡ
        }
		
		ADC_Start();                              //ת
    }
}

/*************ͨжģʽʼ*************/
void SingleChn_Continue_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ2Ƶ                    
	ADC_initStruct.Channels = ADC_CH7;                     //ADCתͨѡCH7
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH7;                      //ͨ7תжʹ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 2;
	
	ADC_Start();                                           //ADCת
}


/******************ͨжģʽ***************/
void SingleChn_Continue_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)                           //ɱ־
    {
        Flag_ADC_Over = 0;

        for(i = 0; i< 100; i++)
        {
            printf("%d,",Adc_Data[i]);               //ӡ
        }
		
		ADC_Start();                                 //ת
    }
}

/*************ͨβѯģʽʼ*************/
void MultiChn_Single_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN6;
	PORT_InitStruct.Func = PORTA_PIN6_ADC_CH6;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA6ΪADCͨ6
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH7 | ADC_CH6;           //ADCתͨѡCH7 CH6
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת     
}

/*************ͨβѯģʽ*************/
void MultiChn_Single_Check_Devote(void)
{
	uint16_t data = 0;
	

	while(ADC_IsEOC(ADC_CH7) == 0);                        //ȴͨ7ת   
	
	data = ADC_Read(ADC_CH6);                              //ȡͨ6ת
	
	printf("CH6:%d\r\n",data);                             //ӡͨ6ת 
	
	data = ADC_Read(ADC_CH7);                              //ȡͨ7ת
	
	printf("CH7:%d\r\n",data);                             //ӡͨ7ת 
	
	ADC_Start();                                           //ADCת
}

/*************ͨѯģʽʼ*************/
void MultiChn_Continue_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN6;
	PORT_InitStruct.Func = PORTA_PIN6_ADC_CH6;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA6ΪADCͨ6
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH7 | ADC_CH6 ;           //ADCתͨѡCH7 CH6
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}

/*************ͨѯģʽ*************/
void MultiChn_Continue_Check_Devote(void)
{
	uint16_t data = 0;
	
	while(ADC_IsEOC(ADC_CH7) == 0);                        //ȴͨ7ת   
	
	data = ADC_Read(ADC_CH6);                              //ȡͨ6ת
	
	printf("CH6:%d\r\n",data);                             //ӡͨ6ת 
	
	data = ADC_Read(ADC_CH7);                              //ȡͨ7ת
	
	printf("CH7:%d\r\n",data);                             //ӡͨ7ת 
}


/*************ͨβжģʽʼ*************/
void MultiChn_Single_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN6;
	PORT_InitStruct.Func = PORTA_PIN6_ADC_CH6;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA6ΪADCͨ6
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH7 | ADC_CH6 ;          //ADCתͨѡCH7 CH6
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH7;                      //ͨ7תжʹ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 3;
	
	ADC_Start();                                           //ADCת    
}

/******************ͨβжģʽ***************/
void MultiChn_Single_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)
    {
        Flag_ADC_Over = 0;

		printf("CH6 DATA :\r\n");
        for(i = 0; i< 50; i++)
        {
			printf("%d,",Adc_Data[i]);             //ӡͨ6ת 
        }
		printf("\r\n");
		
		printf("CH7 DATA :\r\n");
        for(i = 0; i< 50; i++)
        {
			printf("%d,",Adc_Data[i+50]);        //ӡͨ7ת 
        }
		printf("\r\n");
		
		ADC_Start();                              //ADCת 
    }
}

/*************ͨжģʽʼ*************/
void MultiChn_Continue_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN6;
	PORT_InitStruct.Func = PORTA_PIN6_ADC_CH6;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA6ΪADCͨ6
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH7 | ADC_CH6 ;           //ADCתͨѡCH7 CH6
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH7;                      //ͨ7תжʹ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 4;
	
	ADC_Start();                                           //ADCת    
}

/******************ͨжģʽ***************/
void MultiChn_Continue_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)
    {
        Flag_ADC_Over = 0;

		printf("CH6 DATA :\r\n");
        for(i = 0; i< 50; i++)
        {
			printf("%d,",Adc_Data[i]);            //ӡͨ6ת 
        }
		printf("\r\n");
		
		printf("CH7 DATA :\r\n");
        for(i = 0; i< 50; i++)
        {
			printf("%d,",Adc_Data[i+50]);       //ӡͨ7ת 
        }
		printf("\r\n");
		
		ADC_Start();                             //ADCת 
    }
}

/*************ͨFIFOжģʽʼ*************/
void MultiChn_Continue_Full_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN6;
	PORT_InitStruct.Func = PORTA_PIN6_ADC_CH6;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA6ΪADCͨ6
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH7 | ADC_CH6 ;           //ADCתͨѡCH7 CH6
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_FIFO;                       //ݴ洢ΪFIFOģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = ENABLE;                      //FIFOжʹ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 5;
	
	ADC_Start();                                           //ADCת   
}


/*************ͨFIFOжģʽʼ*************/
void MultiChn_Continue_HalfFull_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN6;
	PORT_InitStruct.Func = PORTA_PIN6_ADC_CH6;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA6ΪADCͨ6
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH7 | ADC_CH6 ;           //ADCתͨѡCH7 CH6
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_FIFO;                       //ݴ洢ΪFIFOģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = ENABLE;                  //FIFOжʹ
	ADC_initStruct.Ovf_IEn = DISABLE;                      //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 6;
	
	ADC_Start();                                           //ADCת 
}


/*************ͨFIFOжģʽʼ*************/
void MultiChn_Continue_Ovf_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct ;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_ADC_CH7;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA5ΪADCͨ7
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN6;
	PORT_InitStruct.Func = PORTA_PIN6_ADC_CH6;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTA6ΪADCͨ6
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH7 | ADC_CH6 ;           //ADCתͨѡCH7 CH6
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_FIFO;                       //ݴ洢ΪFIFOģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	
	ADC_initStruct.Adcvdd_Open = DISABLE;                  //ADC VDDʹܲ
	ADC_initStruct.Kd_En = ENABLE;                         //kdʹ 
	ADC_initStruct.Offset_En = ENABLE;                     //offsetʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = DISABLE;                     //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = DISABLE;                 //FIFOжϽ
	ADC_initStruct.Ovf_IEn = ENABLE;                       //FIFOжʹ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 7;
	
	ADC_Start();                                           //ADCת 
}


/******************ͨFIFOжģʽ***************/
void MultiChn_Continue_FIFO_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)
    {
        Flag_ADC_Over = 0;

		printf("CH6 DATA :\r\n");
        for(i = 0; i< 40; i++)
        {
			printf("%d,",Adc_Data[i]);              //ӡͨ6ת 
        }
		printf("\r\n");
		
		printf("CH7 DATA :\r\n");
        for(i = 0; i< 40; i++)
        {
			printf("%d,",Adc_Data[i+50]);         //ӡͨ7ת 
        }
		printf("\r\n");
		
		ADC_Start();                               //ADCת 
    }
}

/*************ADCжϴ************/
void ADC_Handler(void)
{
	uint16_t Fifo_Data[9] = {0};
	uint8_t j = 0;
	
	if(Flag_Int == 1 || Flag_Int == 2)                 //ADCͨж  ͨж
	{
		Adc_Data[Adc_Num++] = ADC_Read(ADC_CH7);
		
		if(Adc_Num >= 100)
		{
			Adc_Num = 0;
			
			Flag_ADC_Over = 1;
		}
	}
	else if(Flag_Int == 3 || Flag_Int == 4)           //ADCͨж  ͨж
	{
		Adc_Data[Adc_Num] = ADC_Read(ADC_CH6);
		Adc_Data[Adc_Num + 50] = ADC_Read(ADC_CH7);
		
		Adc_Num++;
		
		if(Adc_Num >= 50)
		{
			Adc_Num = 0;
			
			Flag_ADC_Over = 1;
		}
	}
	else if(Flag_Int == 5)                            //ADCͨFIFOж
	{
		if(ADC_IntFULLStat() == 1)
		{
			ADC_Read_FIFO(Fifo_Data,9);
			
			for(j = 0;j < 9;j++)
			{
				if((Fifo_Data[j] >> 12) == 6)
				{
					Adc_Data[Fifo_Cnt0] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt0++;
				}
				else if((Fifo_Data[j] >> 12) == 7)
				{
					Adc_Data[Fifo_Cnt1+50] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt1++;
				}
				
				if(Fifo_Cnt0 >= 40 || Fifo_Cnt1 >= 40)
				{
					Fifo_Cnt0 = 0;  
					Fifo_Cnt1 = 0;
					
					Flag_ADC_Over = 1;
					
					ADC_Stop();	
					
					ADC->START |= 0x01 << ADC_START_FIFOCLR_POS;
				}
			}
			
			ADC_IntFULLClr();
		}
	}
	else if(Flag_Int == 6)                     //ADCͨFIFOж
	{
		if(ADC_IntHALFFULLStat() == 1)
		{
			ADC_Read_FIFO(Fifo_Data,5);
			
			for(j = 0;j < 5;j++)
			{
				if((Fifo_Data[j] >> 12) == 6)
				{
					Adc_Data[Fifo_Cnt0] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt0++;
				}
				else if((Fifo_Data[j] >> 12) == 7)
				{
					Adc_Data[Fifo_Cnt1+50] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt1++;
				}
				
				if(Fifo_Cnt0 >= 40 || Fifo_Cnt1 >= 40)
				{
					Fifo_Cnt0 = 0;  
					Fifo_Cnt1 = 0;
					
					Flag_ADC_Over = 1;
					
					ADC_Stop();	
					
					ADC->START |= 0x01 << ADC_START_FIFOCLR_POS;
				}
			}
			
			ADC_IntHALFFULLClr();
		}
	}
	else if(Flag_Int == 7)                  //ADCͨFIFOж
	{
		if(ADC_IntOVFStat() == 1)
		{
			ADC_Read_FIFO(Fifo_Data,9);
			
			for(j = 0;j < 9;j++)
			{
				if((Fifo_Data[j] >> 12) == 6)
				{
					Adc_Data[Fifo_Cnt0] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt0++;
				}
				else if((Fifo_Data[j] >> 12) == 7)
				{
					Adc_Data[Fifo_Cnt1+50] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt1++;
				}
				
				if(Fifo_Cnt0 >= 40 || Fifo_Cnt1 >= 40)
				{
					Fifo_Cnt0 = 0;  
					Fifo_Cnt1 = 0;
					
					Flag_ADC_Over = 1;
					
					ADC_Stop();	
					
					ADC->START |= 0x01 << ADC_START_FIFOCLR_POS;
				}
			}
			
			ADC_IntOVFClr();
		}
	}
	
	if(Flag_Int == 1 || Flag_Int == 3)          //ADCͨж  ͨж
	{
		if(Flag_ADC_Over == 0)
		{
			ADC_Start();	
		}
	}
	else if(Flag_Int == 2 || Flag_Int == 4)    //ADCͨж   ͨж
	{
		if(Flag_ADC_Over == 1)
		{
			ADC_Stop();	
		}
	}
}
void adc_test(void)	
{
	//ADC_VDD_Check_Init();                                     //ADC_VDDβѯģʽʼ
	SingleChn_Single_Check_Init();                          //ͨβѯģʽʼ
	//SingleChn_Continue_Check_Init();                        //ͨѯģʽʼ
	//SingleChn_Single_Interrupt_Init();                      //ͨβжģʽʼ
	//SingleChn_Continue_Interrupt_Init();                    //ͨжģʽʼ
	//MultiChn_Single_Check_Init();                           //ͨβѯģʽʼ
	//MultiChn_Continue_Check_Init();                         //ͨѯģʽʼ
	//MultiChn_Single_Interrupt_Init();                       //ͨβжģʽʼ
	//MultiChn_Continue_Interrupt_Init();                     //ͨжģʽʼ
	//MultiChn_Continue_Full_Interrupt_Init();                //ͨFIFOжģʽʼ
	//MultiChn_Continue_HalfFull_Interrupt_Init();            //ͨFIFOжģʽʼ
	//MultiChn_Continue_Ovf_Interrupt_Init();                 //ͨFIFOжģʽʼ
	//Timerplus_Low_Trig_Adc_Init();
	//Timerplus_High_Trig_Adc_Init();
	//Pwmplus_Trig_Adc_Init();
	
	while(1)
	{
		//ADC_VDD_Check_Devote();                               //ADC_VDDβѯģʽ
		SingleChn_Single_Check_Devote();                    //ͨβѯģʽ
		//SingleChn_Continue_Check_Devote(); b'd                 //ͨѯģʽ
		//SingleChn_Single_Interrupt_Devote();                //ͨβжģʽ
		//SingleChn_Continue_Interrupt_Devote();              //ͨжģʽ		
		//MultiChn_Single_Check_Devote();                     //ͨβѯģʽ
		//MultiChn_Continue_Check_Devote();	                  //ͨѯģʽ
		//MultiChn_Single_Interrupt_Devote();                 //ͨβжģʽ
		//MultiChn_Continue_Interrupt_Devote();               //ͨжģʽ
		//MultiChn_Continue_FIFO_Interrupt_Devote();          //ͨFIFOжģʽ 
		
		//Trig_Adc_Devote();
	}	
}	
// =================== END OF ADC  TEST DEMO ===================================================
#endif

//LED IOʼ
void led_init(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;              /*һGPIO_InitTypeDef͵Ľṹ*/
	
	GPIO_InitStruct.Pin = LED1_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED1_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/

	
	GPIO_InitStruct.Pin = LED2_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED2_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_InitStruct.Pin = LED3_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED3_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/


	GPIO_InitStruct.Pin = LED4_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED4_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
			
	LED1_OFF;       
	LED2_OFF;
	LED3_OFF;
	LED4_OFF;		
}

// =================== start of flash ReadWrite TEST DEMO =====================================
#if FLASH_TEST
#define CODE_ADDR   0x3000    

uint32_t wdata[64] = {0};
/****************************************************************************************************************************************** 
* : FLASH_SingleRead()
* ˵:	FLASH߶ݲӡ   ַʽȡ
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_SingleRead(void)
{
	uint16_t k = 0;
	uint32_t data = 0;
	
	for(k = 0;k < 64;k++)
	{
		data = FLASH_Read_Word_1(FLASH_SingleReadData,CODE_ADDR + k*4);
		
		printf("data1[%d]: %x\r\n",k*4,data);
		
		data = FLASH_Read_Word_2(CODE_ADDR + k*4);
		
		printf("data2[%d]: %x\r\n",k*4,data);
	}
}

/****************************************************************************************************************************************** 
* : FLASH_DualRead()
* ˵:	FLASH˫߶ݲӡ    ַʽȡ
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_DualRead(void)
{
	uint16_t k = 0;
	uint32_t data = 0;
	
	for(k = 0;k < 64;k++)
	{
		data = FLASH_Read_Word_1(FLASH_DualReadData,CODE_ADDR + k*4);
		
		printf("data1[%d]: %x\r\n",k*4,data);
		
		data = FLASH_Read_Word_2(CODE_ADDR + k*4);
		
		printf("data2[%d]: %x\r\n",k*4,data);
	}
}

/****************************************************************************************************************************************** 
* : FLASH_QuadRead()
* ˵:	FLASH߶ݲӡ    ַʽȡ
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_QuadRead(void)
{
	uint16_t k = 0;
	uint32_t data = 0;
	
	for(k = 0;k < 64;k++)
	{
		data = FLASH_Read_Word_1(FLASH_QuadReadData,CODE_ADDR + k*4);
		
		printf("data1[%d]: %x\r\n",k*4,data);
		
		data = FLASH_Read_Word_2(CODE_ADDR + k*4);
		
		printf("data2[%d]: %x\r\n",k*4,data);
	}
}

/****************************************************************************************************************************************** 
* : FLASH_SingleReadWrite()
* ˵:	FLASH߶д
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_SingleReadWrite(void)
{
	uint32_t k = 0;
	
	FLASH_Init(FLASH_SingleReadData,FLASH_CLKDIV_1);   //FLASHʼ  ߶ģʽ  ʱӷƵ1

	FLASH_Erase_Command(FLASH_PageErase,CODE_ADDR);    //ҳ
	
	FLASH_SingleRead();                                //߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		FLASH_Write_Word(FLASH_SinglePageProgram,CODE_ADDR + k*4,k);   //д
	}
	printf("\r\n");
	printf("12\r\n");
	printf("\r\n");		
	FLASH_SingleRead();                                 //߶ӡ
	
	printf("\r\n");
	printf("1\r\n");
	printf("\r\n");	
	
	FLASH_Erase_Command(FLASH_SectorErase,CODE_ADDR);   //
	
	FLASH_SingleRead();                                 //߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		wdata[k] = k*0x111111;             
	}
	printf("\r\n");
	printf("2\r\n");
	printf("\r\n");		
	FLASH_Write_Words(FLASH_SinglePageProgram,CODE_ADDR,wdata,64);   //д
	
	FLASH_SingleRead();                                              //߶ӡ
	printf("\r\n");
	printf("3\r\n");
	printf("\r\n");	
}

/****************************************************************************************************************************************** 
* : FLASH_DualReadWrite()
* ˵:	FLASH˫߶д
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_DualReadWrite(void)
{
	uint32_t k = 0;
	
	FLASH_Init(FLASH_DualReadData,FLASH_CLKDIV_1);               //FLASHʼ  ˫߶ģʽ  ʱӷƵ1

	FLASH_Erase_Command(FLASH_PageErase,CODE_ADDR);              //ҳ
	
	FLASH_DualRead();                                            //˫߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		FLASH_Write_Word(FLASH_DualPageProgram,CODE_ADDR + k*4,k);     //˫д
	}
	
	FLASH_DualRead();                                                  //˫߶ӡ
	
	FLASH_Erase_Command(FLASH_SectorErase,CODE_ADDR);                  //
	
	FLASH_DualRead();                                                  //˫߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		wdata[k] = k*0x111111;
	}
	
	FLASH_Write_Words(FLASH_DualPageProgram,CODE_ADDR,wdata,64);  //˫д
	
	FLASH_DualRead();                               //˫߶ӡ
}

/****************************************************************************************************************************************** 
* : FLASH_QuadReadWrite()
* ˵:	FLASH߶д
*     :    
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_QuadReadWrite(void)
{
	uint32_t k = 0;
	
	FLASH_Init(FLASH_QuadReadData,FLASH_CLKDIV_1);                      //FLASHʼ  ߶ģʽ  ʱӷƵ1

	FLASH_Erase_Command(FLASH_PageErase,CODE_ADDR);                     //ҳ
	
	FLASH_QuadRead();                                                   //߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		FLASH_Write_Word(FLASH_QuadPageProgram,CODE_ADDR + k*4,k);      //д
	}
	
	FLASH_QuadRead();                                                   //߶ӡ
	
	FLASH_Erase_Command(FLASH_SectorErase,CODE_ADDR);                   //
	
	FLASH_QuadRead();                                                   //߶ӡ
	
	for(k = 0;k < 64;k++)
	{
		wdata[k] = k*0x111111;
	}
	
	FLASH_Write_Words(FLASH_QuadPageProgram,CODE_ADDR,wdata,64);        //д
	
	FLASH_QuadRead();                                                   //߶ӡ
}

void eflash_test(void)
{
	//------,дflash֮ǰرж
	printf("SingleReadWrite\r\n");
	printf("\r\n");
	
	FLASH_SingleReadWrite();            //߶дFLASH
	
//	printf("\r\n");
//	printf("DualReadWrite\r\n");
//	printf("\r\n");
//	
//	FLASH_DualReadWrite();             //˫߶дFLASH
//	
//	printf("\r\n");
//	printf("QuadReadWrite\r\n");
//	printf("\r\n");
//	
//	FLASH_QuadReadWrite();            //߶дFLASH
//	
//	printf("\r\n");
//	printf("eflash_test over\r\n");
//	printf("\r\n");
	
    while(1)
    {
			
	
    }
}
#endif
// =================== start of flash ReadWrite TEST DEMO =====================================
// =================== start of lowpower TEST DEMO =====================================
#if LOWPOWER_TEST

/****************************************************************************************************************************************** 
* : Enter_LowPower_Mode()
* ˵:	ý͹ģʽ     
*     : uint8_t Mode	1 STANDBY   2 SLEEP   4 STOP  	
*     : 
* ע: 
******************************************************************************************************************************************/
void Enter_LowPower_Mode(uint8_t Mode)
{
//	assert_param(IS_LOWPOWER_MODE(Mode));                              //ĲModeǷϷ 
//	
	switch(Mode)
	{
		case MODE_STANDBY:
			
			PMU->LPOW_MD = 0x01 << PMU_LPOW_MD_STANDBY_POS;            //ϵͳSTANDBYģʽ
		
		break;
		
		case MODE_SLEEP:
			
			FLASH_Set_DeepPowerDown();
			PMU->LPOW_MD = 0x01 << PMU_LPOW_MD_SLEEP_POS;              //ϵͳSLEEPģʽ
			FLASH_ReSet_DeepPowerDown();
		
		break;
		
		case MODE_STOP:
			
			FLASH_Set_DeepPowerDown();
			PMU->LPOW_MD = 0x01 << PMU_LPOW_MD_STOP_POS;               //ϵͳSTOPģʽ 
			FLASH_ReSet_DeepPowerDown();
		
		break;
		
	
		default:
			
		break;
	}
}

/****************************************************************************************************************************************** 
* : WakeUp_Style_Enable()
* ˵:	ģʽʹ  
*     : uint8_t WakeUp_Style   1 WAKEUP_IO  		
*     : 
* ע: 
******************************************************************************************************************************************/
void WakeUp_Style_Enable(uint8_t WakeUp_Style)
{
//	assert_param(IS_WAKEUP_MODE(WakeUp_Style));                         //ĲWakeUp_StyleǷϷ 
	
	switch(WakeUp_Style)
	{
		case WAKEUP_IO:
			
			PMU->LPMD_WKEN |= 0x01 << PMU_LPMD_WKEN_IO_POS;             //IOʹ
		
		break;
		
		default:
			
		break;
	}
}

/****************************************************************************************************************************************** 
* : WakeUp_Style_Disable()
* ˵:	ģʽ 
*     : uint8_t WakeUp_Style	 1 WAKEUP_IO  		
*     : 
* ע: 
******************************************************************************************************************************************/
void WakeUp_Style_Disable(uint8_t WakeUp_Style)
{
//	assert_param(IS_WAKEUP_MODE(WakeUp_Style));                            //ĲWakeUp_StyleǷϷ 
	
	switch(WakeUp_Style)
	{
		case WAKEUP_IO:
			
			PMU->LPMD_WKEN &= ~(0x01 << PMU_LPMD_WKEN_IO_POS);             //IOѽ
		
		break;
		
		default:
			
		break;
	}
}

/****************************************************************************************************************************************** 
* : WakeUp_State_Check()
* ˵:	״̬ѯ
*     : uint8_t WakeUp_Style	   1 WAKEUP_IO  		
*     : 1  ѱ־   0δѱ־
* ע: 
******************************************************************************************************************************************/
uint8_t WakeUp_State_Check(uint8_t WakeUp_Style)
{
	uint8_t state = 0;
	
//	assert_param(IS_WAKEUP_MODE(WakeUp_Style));                            //ĲWakeUp_StyleǷϷ 
	
	switch(WakeUp_Style)
	{
		case WAKEUP_IO:
			
			if(PMU->LPMD_WKST & PMU_LPMD_WKST_IO_MSK)                      //жǷIOѱ־
			{
				state = 1;
			}
		
		break;
		
		default:
			
			state = 0;
		
		break;
	}

	return state;
}

/****************************************************************************************************************************************** 
* : WakeUp_State_Clear()
* ˵:	״̬
*     : uint8_t WakeUp_Style	1 WAKEUP_IO  		
*     : 
* ע: 
******************************************************************************************************************************************/
void WakeUp_State_Clear(uint8_t WakeUp_Style)
{
//	assert_param(IS_WAKEUP_MODE(WakeUp_Style));                                //ĲWakeUp_StyleǷϷ 
	
	switch(WakeUp_Style)
	{
		case WAKEUP_IO:
			
			PMU->LPMD_WKST = 0x01 << PMU_LPMD_WKST_IO_POS;                     //IOѱ־
		
		break;
		
		default:	
		
		break;
	}
}
#define WAKEUP_GPIO_PORT    GPIOA		                
#define WAKEUP_GPIO_PIN		GPIO_PIN4			     

void Wakeup_IO_Init(void)
{
	GPIO_InitTypeDef GPIO_InitStruct = {0};          /*һGPIO_InitTypeDef͵Ľṹ*/
	
	GPIO_InitStruct.Pin = WAKEUP_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PU_IN;               //   
	
	GPIO_InitStruct.WakeUp_En = WAKEUP_ENABLE;       //ѹʹ
	
	GPIO_Init(WAKEUP_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
    
	PORT->PORT_CFG &= ~(0x01 << PORT_CFG_WKRF_POS);  //½ػ	
}

uint8_t Flag_Wakeup = 0;
void lowpower_test(void)
{
	uint8_t Delay_Cnt = 0;	
	Flag_Wakeup = 1;    //޸ͿԲԲͬĻģʽ  1---3
		led_init();  
    while(1)
    {
			
		if(time_1ms >= 1000)
		{
			time_1ms = 0;
			
			Delay_Cnt++;         //ֵ1  
			
			
			if(Delay_Cnt >= 5)       //ֵڵ5ֵ0
			{
				Delay_Cnt = 0;
			}
			printf("Delay_Cnt is %d\r\n",Delay_Cnt);
			switch(Delay_Cnt)
			{
				case 0:              //ֵΪ0ʱ4ȫ
					
					LED1_OFF;
					LED2_OFF;
					LED3_OFF;
					LED4_OFF;
				
				break;
				
				case 1:              //ֵΪ1ʱ1Ƶȫ
					
					LED1_ON;
					LED2_OFF;
					LED3_OFF;
					LED4_OFF;
				
				break;
				
				case 2:              //ֵΪ2ʱ2Ƶȫ
					
					LED1_OFF;
					LED2_ON;
					LED3_OFF;
					LED4_OFF;
				
				break;
				
				case 3:              //ֵΪ3ʱ3Ƶȫ
					
					LED1_OFF;
					LED2_OFF;
					LED3_ON;
					LED4_OFF;
				
				break;
				
				case 4:              //ֵΪ4ʱ4Ƶȫ
					
					LED1_OFF;
					LED2_OFF;
					LED3_OFF;
					LED4_ON;
				
				break;
			}
			
			if(Flag_Wakeup == 1)
			{
				if(Delay_Cnt == 0)
				{
					printf("go to MODE_STANDBY \r\n");
					Wakeup_IO_Init();                                          //IOųʼ
					
					WakeUp_Style_Enable(WAKEUP_IO);                            //IOʹ
					
					Enter_LowPower_Mode(MODE_STANDBY);                         //ϵͳSTANDBYģʽ
					printf("wake up\r\n");
				}
				
				if(WakeUp_State_Check(WAKEUP_IO))                              //жǷIOѱ־
				{
					WakeUp_State_Clear(WAKEUP_IO);                             //IOѱ־
					
					LED1_OFF;                                
					LED2_ON;
					LED3_ON;
					LED4_OFF;
				}
			}
			else if(Flag_Wakeup == 2)
			{
				if(Delay_Cnt == 0)
				{
					printf("go to MODE_SLEEP \r\n");
					Wakeup_IO_Init();                                          //IOųʼ
					
					WakeUp_Style_Enable(WAKEUP_IO);                            //IOʹ
					
					Enter_LowPower_Mode(MODE_SLEEP);                           //ϵͳSLEEPģʽ
					printf("wake up\r\n");
				}
				
				if(WakeUp_State_Check(WAKEUP_IO))                              //жǷIOѱ־
				{
					WakeUp_State_Clear(WAKEUP_IO);                             //IOѱ־
					
					LED1_ON;
					LED2_OFF;
					LED3_OFF;
					LED4_ON;
				}
			}
			else if(Flag_Wakeup == 3)
			{
				if(Delay_Cnt == 0)
				{
					printf("go to MODE_STOP \r\n");
					Wakeup_IO_Init();                                          //IOųʼ
					
					WakeUp_Style_Enable(WAKEUP_IO);                            //IOʹ
					
					Enter_LowPower_Mode(MODE_STOP);                            //ϵͳSTOPģʽ
					printf("wake up\r\n");
				}
				
				if(WakeUp_State_Check(WAKEUP_IO))                              //жǷIOѱ־
				{
					WakeUp_State_Clear(WAKEUP_IO);                             //IOѱ־
					
					LED1_ON;
					LED2_OFF;
					LED3_OFF;
					LED4_ON;
				}
			}
		}
    }

}
#endif

// =================== END of lowpower TEST DEMO =====================================
// =================== start of IIC TEST DEMO =====================================
#if IIC_TEST

/*
*********************************************************************************************************
*	  : AT24CXX_Init
*	˵: AT24CXXʼ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void AT24CXX_Init(void)
{
	PORT_InitTypeDef PORT_InitStruct;
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTA_PIN4_IIC_SCL;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);      //PORTA4ΪIICʱ
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN3;
	PORT_InitStruct.Func = PORTA_PIN3_IIC_SDA;
	PORT_InitStruct.Input_En = ENABLE;
	
	PORT_Init(&PORT_InitStruct);      //PORTA3ΪIIC

	IIC_Init(IIC0,400,DISABLE);           //IICʱΪ400K  ѯʽ
	
	IIC_Open(IIC0);                       //IIC
}

/*
*********************************************************************************************************
*	  : AT24CXX_WaitNACK
*	˵: ȴACKźţNACKֹͣź  ACKִ
*	    Σuint8_t nack    0 ʾNACK    1ʾACK
*	  ֵ: 0 ִ  1ʾִֹͣУ
*********************************************************************************************************
*/
uint8_t AT24CXX_WaitNACK(uint8_t nack)
{
	if(nack == 0)
	{
		IIC_Stop(IIC0);
		Delay1ms(1);
		
		return 1;
	}
	
	return 0;
}


/*
*********************************************************************************************************
*	  : AT24CXX_ReadBytes
*	˵: ӴEEPROMַָʼȡ
*	    ΣAddress : ʼַ
*			  Size : ݳȣλΪֽ
*			  ReadBuf : ŶݵĻָ
*	  ֵ: 0 ʾʧܣ1ʾɹ
*********************************************************************************************************
*/
uint8_t AT24CXX_ReadBytes(uint16_t Address,uint8_t *ReadBuf,uint16_t Size)
{
    uint16_t i = 0;
    uint8_t Rec = 0;
	
    /* ôEEPROMȡָУȡֽ */

    /* 1I2Cź ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ */
   
	if(EE_TYPE > AT24C16)
    {
        Rec = IIC_Start(IIC0,EEPROM_DEV_ADDR | EEPROM_I2C_WR);
		
		if(AT24CXX_WaitNACK(Rec))
		{
			return 0;
		}
		
		Rec = IIC_Write(IIC0,Address>>8);
    }
    else
    {
        Rec = IIC_Start(IIC0,(EEPROM_DEV_ADDR | EEPROM_I2C_WR) + ((Address>>8)<<1));
    }

    /* 2ȴACK */
    
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}
	
    /* 3ֽڵַ24C02ֻ256ֽڣ1ֽھ͹ˣ24C04ϣô˴Ҫַ */

	Rec = IIC_Write(IIC0,Address%256);
	
    /* 4ȴACK */
    
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}

    /* 5I2CߡǰĴĿEEPROM͵ַ濪ʼȡ
    ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ*/
    
	Rec = IIC_Start(IIC0,EEPROM_DEV_ADDR | EEPROM_I2C_RD);

    /* 6ȴACK */
    
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}
	
    /* 7ѭȡ */
    
	for (i = 0; i < Size; i++)
    {
        /* ÿ1ֽںҪAck һֽڲҪAckNack */
        if (i != Size - 1)
        {
            ReadBuf[i] = IIC_Read(IIC0,ACK);     /* мֽڶCPUACKź(SDA = 0) */	
        }
        else
        {
            ReadBuf[i] = IIC_Read(IIC0,NACK);
        }
    }

    /* ִгɹI2Cֹͣź */
    IIC_Stop(IIC0);
    Delay1ms(1);
    return 1;	/* ִгɹ */
}

/*
*********************************************************************************************************
*	  : AT24CXX_WriteBytes
*	˵: EEPROMַָдݣҳддЧ
*	    ΣAddress : ʼַ
*			  Size : ݳȣλΪֽ
*			  WriteBuf : ŶݵĻָ
*	  ֵ: 0 ʾʧܣ1ʾɹ
*********************************************************************************************************
*/
uint8_t AT24CXX_WriteBytes(uint16_t Address,uint8_t *WriteBuf,uint16_t Size)
{
    uint16_t i = 0;
    uint16_t Addr;
	uint8_t Rec = 0;
	
    /*
    	дEEPROMȡֽܶڣÿдֻͬһpage
    	24c02page size = 8
    	򵥵ĴΪֽдģʽÿд1ֽڣ͵ַ
    	ΪдЧ: page write
    */

    Addr = Address;
	
    for (i = 0; i < Size; i++)
    {
        /* ͵1ֽڻҳ׵ַʱҪ·źź͵ַ */
        if ((i == 0) || (Addr & (EEPROM_PAGE_SIZE - 1)) == 0)
        {
            /*ڣֹͣźţڲд*/
            IIC_Stop(IIC0);
            Delay1ms(10);

            /* 1I2Cź ֽڣ7bitǵַbit0Ƕдλ0ʾд1ʾ */
            if(EE_TYPE > AT24C16)
            {
                Rec = IIC_Start(IIC0,EEPROM_DEV_ADDR | EEPROM_I2C_WR);
		
				if(AT24CXX_WaitNACK(Rec))
				{
					return 0;
				}
				
				Rec = IIC_Write(IIC0,Addr>>8);
            }
            else
            {
                Rec = IIC_Start(IIC0,(EEPROM_DEV_ADDR | EEPROM_I2C_WR) + ((Addr>>8)<<1));
            }

            /* 2ȴACK */
			
            if(AT24CXX_WaitNACK(Rec))
			{
				return 0;
			}

            /* 3ֽڵַ24C02ֻ256ֽڣ1ֽھ͹ˣ24C04ϣô˴Ҫַ */
            Rec = IIC_Write(IIC0,Addr%256);
	
			/* 4ȴACK */
			
			if(AT24CXX_WaitNACK(Rec))
			{
				return 0;
			}
        }

        /* 5ʼд */ 
		
		Rec = IIC_Write(IIC0,WriteBuf[i]);

        /* 6ȴACK */
        
		if(AT24CXX_WaitNACK(Rec))
		{
			return 0;
		}
		
		Addr++;	/* ַ1 */
    }

    /* ִгɹI2Cֹͣź */
    IIC_Stop(IIC0);
    Delay1ms(10);

    return 1;
}

/*
*********************************************************************************************************
*	  : IIC_CheckDevice
*	˵: I2C豸CPU豸ַȻȡ豸Ӧжϸ豸Ƿ
*	  ֵ: ֵ 1 ʾȷ 0ʾδ̽⵽
*********************************************************************************************************
*/
uint8_t IIC_CheckDevice(void)
{
    uint8_t Rec = 0;
	
	Rec = IIC_Start(IIC0,EEPROM_DEV_ADDR | EEPROM_I2C_WR);
		
	if(AT24CXX_WaitNACK(Rec))
	{
		return 0;
	}

    IIC_Stop(IIC0);
    Delay1ms(1);

    return 1;
}


uint8_t buf[EEPROM_SIZE];

/******AT24CXXȫ******/
void AT24CXX_FullErase(void)
{
    uint16_t i;

    /* 仺 */
    for (i = 0; i < EEPROM_SIZE; i++)
    {
        buf[i] = 0xFF;
    }

    /* дEEPROM, ʼַ = 0ݳΪ 256 */
    if (AT24CXX_WriteBytes(0, buf, EEPROM_SIZE) == 0)
    {
        printf("eeprom\r\n");
    }
    else
    {
        printf("eepromɹ\r\n");
    }
}

//Ҫд뵽24c02ַ
uint8_t Send_Buffer[]={" Welcome to beijing!Welcome to CHINA!"};
#define SIZE sizeof(Send_Buffer)

uint8_t datatemp[SIZE];
uint8_t Flag_AT24CXX_OK = 0;
void i2c_test(void)
{
	AT24CXX_Init();        //AT24CXXʼ
	
    Flag_AT24CXX_OK = IIC_CheckDevice();  //I2C豸CPU豸ַȻȡ豸Ӧжϸ豸Ƿ
	
	if(Flag_AT24CXX_OK == 0x01)
	{
		printf("AT24CXX IS OK!\r\n");
	}
	else
	{
		printf("AT24CXX IS ERROR!\r\n");
	}
	
	printf("\r\n");
	
	while(1)
	{
		Delay1ms(200);
		Delay1ms(300);
		
		if(Flag_AT24CXX_OK == 1)
		{
			AT24CXX_WriteBytes(0,(uint8_t*)Send_Buffer,SIZE);      //AT24CXXд     
			AT24CXX_ReadBytes(0,datatemp,SIZE);                    //AT24CXX
			
			printf("the data is %s\r\n",datatemp);
			printf("\r\n");
			
			AT24CXX_FullErase();                                   //AT24CXXȫ
			AT24CXX_ReadBytes(0,datatemp,SIZE);                    //AT24CXX
			
			printf("data[0] is %x\r\n",datatemp[0]);
			printf("data[1] is %x\r\n",datatemp[1]);
			printf("data[2] is %x\r\n",datatemp[2]);
			printf("data[%d] is %x\r\n",SIZE-1,datatemp[SIZE - 1]);
			printf("\r\n");
		}	
	}
}
#endif 
// =================== end of IIC TEST DEMO =====================================
// =================== start of spi TEST DEMO ===================================
#if SPI_TEST
//SPIӲʼ
void SPI_Hard_Init(void)
{
	PORT_InitTypeDef PORT_InitStruct;
	SPI_InitTypeDef  SPI_InitStruct;
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN15;
	PORT_InitStruct.Func = PORTA_PIN15_SPI_SSN;
	PORT_InitStruct.Input_En = DISABLE;

	PORT_Init(&PORT_InitStruct);
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN10;
	PORT_InitStruct.Func = PORTA_PIN10_SPI_CLK;
	PORT_InitStruct.Input_En = DISABLE;

	PORT_Init(&PORT_InitStruct);
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN11;
	PORT_InitStruct.Func = PORTA_PIN11_SPI_MOSI;
	PORT_InitStruct.Input_En = DISABLE;

	PORT_Init(&PORT_InitStruct);
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN12;
	PORT_InitStruct.Func = PORTA_PIN12_SPI_MISO;
	PORT_InitStruct.Input_En = ENABLE;

	PORT_Init(&PORT_InitStruct);
	
	SPI_InitStruct.Master     = SPI_MASTER_MODE;        //ģʽ
	SPI_InitStruct.ClkDiv     = SPI_CLKDIV_8;           //ʱ4Ƶ
	SPI_InitStruct.SampleEdge = SPI_FIRST_EDGE;         //һزɼ
	SPI_InitStruct.IdleLevel  = SPI_LOW_LEVEL;          //Ϊ͵ƽ
	SPI_InitStruct.LsbFirst   = SPI_MSB_FISRT;          //MSBȷ
	
	SPI_Init(SPI0,&SPI_InitStruct);    
}

uint32_t rxdata, txdata = 0x01;    //ͽ

uint8_t SPI_Sel = 1;               //SPIģʽѡ

uint8_t Flag_spi_irq = 0;          //SPIжϱ־
uint8_t spi_irq_cnt = 0;           //SPIжģʽ

void spi_test(void)
{
	SPI_Hard_Init();          //SPIʼ 
	
    SPI_Sel = 0;              //ģʽѡ  0  ѯģʽ   1  жģʽ
	
	if(SPI_Sel == 0)          //ѯģʽ 
	{
		SPI_Open(SPI0);       //SPI0  
		
		printf("SPI0 Check Mode\r\n");
		printf("\r\n");
	}
	else                      //жģʽ
	{
		SPI0->IE = 0x01 << SPI_SPIF_IE_POS;   //SPI0ж
	
		NVIC_EnableIRQ(SPI0_IRQn);
		
		SPI_Open(SPI0);       //SPI0 
		
		printf("SPI Int Mode\r\n");
		printf("\r\n");
	}
	
	while(1)
	{
		if(SPI_Sel == 0)                          //ѯģʽ 
		{
			rxdata = SPI_ReadWrite(SPI0,txdata);  //SPI0ͽ
			printf("rxdata: 0x%X\r\n", rxdata);
			printf("txdata: 0x%X\r\n", txdata);
			txdata = rxdata + 1;		          //SPI_MOSISPI_MISO̽ӣɿӡֵһ

			printf("\r\n");
			Delay1ms(400);	
		}
		else                                      //жģʽ                                   
		{
			if(spi_irq_cnt == 0)                     
			{
				SPI_Master_SSN_Out(SPI0,0);
				
				SPI_Write(SPI0,txdata);           //SPI0
				spi_irq_cnt = 1;
			}
			else if(spi_irq_cnt == 1)
			{
				if(Flag_spi_irq == 1)             //жϱ־Ϊ1ʾSPI0
				{
					Flag_spi_irq = 0;
					
					rxdata = SPI0->RDATA;         //ȡ
					
					printf("txdata: 0x%02X\r\n", txdata);
					printf("rxdata: 0x%02X\r\n", rxdata);
					txdata = rxdata + 1;		  //SPI_MOSISPI_MISO̽ӣɿӡֵһ 
					
					SPI_Master_SSN_Out(SPI0,1);
					
					spi_irq_cnt = 2;
					
					printf("\r\n");
					printf("\r\n");
				}
			}
			else if(spi_irq_cnt == 2)
			{
				delay_ms(400);
				spi_irq_cnt = 0;
			}
		}		
	}
}
#endif
// =================== end of spi TEST DEMO =====================================
// =================== start of iwdt TEST DEMO ==================================
#if WDT_TEST
uint8_t IWDT_Sel = 0;         
uint8_t Flag_IWDT = 0;


//IWDT   32Kʱ  ܸλ
void IWDT_32K_Test(uint32_t load)
{
	IWDT_InitTypeDef IWDT_InitStruct;
	
	IWDT_InitStruct.RstEn = RstEn_DISABLE;     //ܸλ
	IWDT_InitStruct.Load = load;               //ʼֵ
	
	IWDT_Init(&IWDT_InitStruct);               //IWDTʼ

	IWDT_Start();                              //IWDT
}

//IWDT   32Kʱ  ʹܸλ
void IWDT_32K_Rst_Test(uint32_t load)
{
	IWDT_InitTypeDef IWDT_InitStruct;
	
	IWDT_InitStruct.RstEn = RstEn_ENABLE;      //ʹܸλ
	IWDT_InitStruct.Load = load;               //ʼֵ
	
	IWDT_Init(&IWDT_InitStruct);               //IWDTʼ

	IWDT_Start();                              //IWDT
}


void IWDT_Test(void)
{
	switch(IWDT_Sel)
	{
		case IWDT_32K_TEST:                //32Kʱ  ܸλ  ʱι
		case IWDT_32K_INT_TEST:            //32Kʱ  ܸλ  жϴ
			IWDT_32K_Test(32000);
			break;
		case IWDT_32K_RST_TEST:            //32Kʱ  ʹܸλ
			IWDT_32K_Rst_Test(32000);
			break;
	}
}

//IWDTжϷ
void IWDT_Handler(void)
{
	if(IWDT_Sel == IWDT_32K_INT_TEST)   //ǲжϹ
	{
		IWDT->IF = 0;              //жϱ־0
	}
	
	Flag_IWDT = 1;        
}


void iwdt_test(void)
{
	
	IWDT_Sel = IWDT_32K_RST_TEST;
	
	if(SYS->IWDTRST_ST & SYS_IWDTRST_ST_MSK)       //IWDTλ  ӡIWDT RESET!  λ־
	{
		printf("IWDT RESET!\r\n");
		
		SYS->IWDTRST_ST = 0x01 << SYS_IWDTRST_ST_POS;
	}
	else                                          //ϵ縴λӡPOWER ON RESET!
	{
		printf("POWER ON RESET!\r\n");
	}
	
	if(IWDT_Sel == IWDT_32K_TEST)                              
	{
		printf("IWDT_32K_TEST!\r\n");
	}
	else if(IWDT_Sel == IWDT_32K_INT_TEST)
	{
		printf("IWDT_32K_INT_TEST!\r\n");
	}
	else if(IWDT_Sel == IWDT_32K_RST_TEST)
	{
		printf("IWDT_32K_RST_TEST!\r\n");
	}
	
	IWDT_Test();
	
    while(1)
    {
        if(IWDT_Sel == IWDT_32K_TEST)
		{
			delay_ms(200);
			
			IWDT_FEED();                 //IWDTι
			
			printf("IWDT FEED!\r\n");
		}
		
		if(Flag_IWDT == 1)
		{
			Flag_IWDT = 0;
			
			printf("IWDT INTERRUPT!\r\n");
		}
    }	
}
#endif
// =================== end of iwdt TEST DEMO ==================================
// =================== start of uart TEST DEMO ================================
#if UART_TEST
void uart_test(void)
{
		uart_init();
		while(1)
		{
			if(time_1ms >= 1)
			{
				time_1ms = 0;
				Serial_timeout_1ms++;
			}
			
			uart_test_tx_rx(time_1ms);      //ڲԳ 	
		}
}
#endif
// =================== end of uart TEST DEMO ==================================
// =================== start of uart TEST DEMO ================================
#if PWM_BASE_TEST
void PWMBASE_Test(void)
{
	PORT_InitTypeDef PORT_InitStruct;
	PWMBASE_CommonInitTypeDef PWMBASE_CommonInitStruct;
	PWMBASE_ChannelInitTypeDef PWMBASE_ChannelInitStruct;
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN0;
	PORT_InitStruct.Func = PORTA_PIN0_PWMB0_CH0;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);

	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_PWMB0_CH1;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN9;
	PORT_InitStruct.Func = PORTA_PIN9_PWMB0_CH2;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN10;
//	PORT_InitStruct.Func = PORTA_PIN10_PWMB0_CH0;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN15;
//	PORT_InitStruct.Func = PORTA_PIN15_PWMB0_CH2;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);

	PWMBASE_CommonInitStruct.ClkDiv = 63;         //ʱ64Ƶ
	PWMBASE_CommonInitStruct.Period = 1000;       //Ϊ1000
	PWMBASE_CommonInitStruct.OvfIE = ENABLE;      //жʹ
	
	PWMBASE_Common_Init(PWMBASE0,&PWMBASE_CommonInitStruct);
	
	
	PWMBASE_ChannelInitStruct.Channel = PWMBASE_CH0;    //ѡͨ0
	PWMBASE_ChannelInitStruct.Inv = DISABLE;            //ת
	PWMBASE_ChannelInitStruct.OutEn = ENABLE;           //ʹ
	PWMBASE_ChannelInitStruct.Comp = 500;               //ȽϵΪ500
	PWMBASE_ChannelInitStruct.CompIE = ENABLE;          //Ƚϵжʹ
	
	PWMBASE_Channel_Init(PWMBASE0,&PWMBASE_ChannelInitStruct);
	
	
	PWMBASE_ChannelInitStruct.Channel = PWMBASE_CH1;
	PWMBASE_ChannelInitStruct.Inv = DISABLE;
	PWMBASE_ChannelInitStruct.OutEn = ENABLE;
	PWMBASE_ChannelInitStruct.Comp = 300;
	PWMBASE_ChannelInitStruct.CompIE = ENABLE;
	
	PWMBASE_Channel_Init(PWMBASE0,&PWMBASE_ChannelInitStruct);
	
	
	PWMBASE_ChannelInitStruct.Channel = PWMBASE_CH2;
	PWMBASE_ChannelInitStruct.Inv = DISABLE;
	PWMBASE_ChannelInitStruct.OutEn = ENABLE;
	PWMBASE_ChannelInitStruct.Comp = 800;
	PWMBASE_ChannelInitStruct.CompIE = ENABLE;

	PWMBASE_Channel_Init(PWMBASE0,&PWMBASE_ChannelInitStruct);
	
	PWMBASE_Start(PWMBASE0);        //PWMBASE0
}


void PWMBASE_IO_Indicate(void)
{
	GPIO_InitTypeDef GPIO_InitStruct;                     /*һGPIO_InitTypeDef͵Ľṹ*/
	
	
	GPIO_InitStruct.Pin = PWMBASE_IO0_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/
	
	GPIO_Init(PWMBASE_IO0_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	GPIO_InitStruct.Pin = PWMBASE_IO1_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/
	
	GPIO_Init(PWMBASE_IO1_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	GPIO_InitStruct.Pin = PWMBASE_IO2_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/

	GPIO_Init(PWMBASE_IO2_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_ClrBit(PWMBASE_IO0_GPIO_PORT,PWMBASE_IO0_GPIO_PIN);
	GPIO_ClrBit(PWMBASE_IO1_GPIO_PORT,PWMBASE_IO1_GPIO_PIN);
	GPIO_ClrBit(PWMBASE_IO2_GPIO_PORT,PWMBASE_IO2_GPIO_PIN);
}


//PWMBASE0жϷ
void PWMBASE0_Handler(void)
{
	if(PWMBASE0->IF & PWMBASE_IF_OVF_MSK)                 //жжϱ־
	{
		PWMBASE0->IF = (0x01 << PWMBASE_IF_OVF_POS);      //жϱ־
		
		PWMBASE_IO0_TOGGLE;
		PWMBASE_IO1_TOGGLE;
		PWMBASE_IO2_TOGGLE;
	}
	
	if(PWMBASE0->IF & PWMBASE_IF_CH0_COMP_MSK)              //жͨ0Ƚϵжϱ־
	{
		PWMBASE0->IF = (0x01 << PWMBASE_IF_CH0_COMP_POS);   //ͨ0Ƚϵжϱ־
		
		PWMBASE_IO0_TOGGLE;
	}
	
	if(PWMBASE0->IF & PWMBASE_IF_CH1_COMP_MSK)              //жͨ1Ƚϵжϱ־
	{
		PWMBASE0->IF = (0x01 << PWMBASE_IF_CH1_COMP_POS);   //ͨ1Ƚϵжϱ־
	
		PWMBASE_IO1_TOGGLE;
	}
	
	if(PWMBASE0->IF & PWMBASE_IF_CH2_COMP_MSK)              //жͨ2Ƚϵжϱ־
	{
		PWMBASE0->IF = (0x01 << PWMBASE_IF_CH2_COMP_POS);   //ͨ2Ƚϵжϱ־
		
		PWMBASE_IO2_TOGGLE;
	}
}

void pwm_base_test(void)
{
  PWMBASE_Test();            //PWMBASEʼ
	PWMBASE_IO_Indicate();     //ָʾIOʼ
	
    while(1)
    {
    PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH0,DISABLE);    //ת
		PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH1,DISABLE);
		PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH2,DISABLE);
		
		Delay1ms(100);
		
		PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH0,ENABLE);     //ת
		PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH1,ENABLE);
		PWMBASE_SetOutInv(PWMBASE0,PWMBASE_CH2,ENABLE);
		
		Delay1ms(100);
		
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH0,DISABLE);     //
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH1,DISABLE);
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH2,DISABLE);
		
		Delay1ms(100);
		
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH0,ENABLE);      //ʹ
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH1,ENABLE);
		PWMBASE_SetOutEn(PWMBASE0,PWMBASE_CH2,ENABLE);
		
		delay_ms(100);
    }
}
#endif
// =================== end of uart TEST DEMO ==================================
// =================== start of uart TEST DEMO ================================
#if PWM_PLUS_TEST
void PWMPLUS_Init(void)
{
	PORT_InitTypeDef PORT_InitStruct;
	PWMPLUS_CommonInitTypeDef PWMPLUS_CommonInitStruct;
	PWMPLUS_ChannelInitTypeDef PWMPLUS_ChannelInitStruct;
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN0;
	PORT_InitStruct.Func = PORTA_PIN0_PWMP0_CH0N;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);

	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN1;
	PORT_InitStruct.Func = PORTA_PIN1_PWMP0_CH1N;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN2;
	PORT_InitStruct.Func = PORTA_PIN2_PWMP0_CH2N;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN3;
	PORT_InitStruct.Func = PORTA_PIN3_PWMP0_CH0;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTA_PIN4_PWMP0_CH1;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTA_PIN5_PWMP0_CH2;
	PORT_InitStruct.Input_En = DISABLE;
	
	PORT_Init(&PORT_InitStruct);
	
	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN8;
//	PORT_InitStruct.Func = PORTA_PIN8_PWMP0_CH2;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN8;
//	PORT_InitStruct.Func = PORTA_PIN8_PWMP0_CH0N;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN9;
//	PORT_InitStruct.Func = PORTA_PIN9_PWMP0_CH1N;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN10;
//	PORT_InitStruct.Func = PORTA_PIN10_PWMP0_CH2N;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN11;
//	PORT_InitStruct.Func = PORTA_PIN11_PWMP0_CH0;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
//	
//	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN12;
//	PORT_InitStruct.Func = PORTA_PIN12_PWMP0_CH1;
//	PORT_InitStruct.Input_En = DISABLE;
//	
//	PORT_Init(&PORT_InitStruct);
	
//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN6;
//	PORT_InitStruct.Func = PORTA_PIN6_BREAK_IN0;
//	PORT_InitStruct.Input_En = ENABLE;
//	
//	PORT_Init(&PORT_InitStruct);

//	PORT_InitStruct.Port = PORTA;
//	PORT_InitStruct.Pin = GPIO_PIN7;
//	PORT_InitStruct.Func = PORTA_PIN7_BREAK_IN1;
//	PORT_InitStruct.Input_En = ENABLE;
//	
//	PORT_Init(&PORT_InitStruct);
	
	PWMPLUS_CommonInitStruct.Clk_Src = CLKSRC_DIV;                         //ڲԤƵʱΪʱ           
	PWMPLUS_CommonInitStruct.ClkDiv = 0;                                  //ʱ16Ƶ
	PWMPLUS_CommonInitStruct.Mode = CYCLE_EDGE_ALIGN;                      //ض
	PWMPLUS_CommonInitStruct.Dir = DIR_UP;                                 //ϼ
	PWMPLUS_CommonInitStruct.Reload_Cnt = 0;                               //װشΪ1
	PWMPLUS_CommonInitStruct.Period = 10000;                               //Ϊ10000
	PWMPLUS_CommonInitStruct.Brake_Filter = BRAKE_FILTER_1;                //ɲ˲ϵΪ1
	PWMPLUS_CommonInitStruct.Brake_InputLevel = BRAKE0_HIGH_BRAKE1_HIGH;   //ɲ0Ϊߵƽ  ɲ1Ϊߵƽ
	PWMPLUS_CommonInitStruct.Trig_Comp = 2000;                             //ڲΪ2000
	PWMPLUS_CommonInitStruct.Trig0_Sel = NOSIGNAL_TRIG;                    //޴ź
	PWMPLUS_CommonInitStruct.Trig1_Sel = NOSIGNAL_TRIG;                    //޴ź
	PWMPLUS_CommonInitStruct.Trig2_Sel = NOSIGNAL_TRIG;                    //޴ź
	PWMPLUS_CommonInitStruct.Trig3_Sel = NOSIGNAL_TRIG;                    //޴ź	PWMPLUS_CommonInitStruct.Reload_IE = DISABLE;                          //װжϽ
	PWMPLUS_CommonInitStruct.Brake0_IE = DISABLE;                          //ɲ0жϽ
	PWMPLUS_CommonInitStruct.Brake1_IE = DISABLE;                          //ɲ1жϽ
	PWMPLUS_CommonInitStruct.Up_OvfIE  = ENABLE;                           //ϼжʹ
	PWMPLUS_CommonInitStruct.Up_TrigCompIE  = DISABLE;                     //ϼڲжϽ
	PWMPLUS_CommonInitStruct.Down_OvfIE  = DISABLE;                        //¼жϽ
	PWMPLUS_CommonInitStruct.Down_TrigCompIE  = DISABLE;                   //¼ڲжϽ
	
	PWMPLUS_CommonInit(PWMPLUS0,&PWMPLUS_CommonInitStruct);
	
	PWMPLUS_ChannelInitStruct.Channel = PWMPLUS_CH0;                   //Ϊͨ0
	PWMPLUS_ChannelInitStruct.Comp = 2500;                             //ȽϵΪ4000
	PWMPLUS_ChannelInitStruct.DeadZone = 100;                          //Ϊ100
	PWMPLUS_ChannelInitStruct.StartLevel = LEVEL_LOW;                  //ʼƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.CHxIdleLevel = LEVEL_HIGH;               //ͨ0еƽΪߵƽ
	PWMPLUS_ChannelInitStruct.CHxNIdleLevel = LEVEL_HIGH;              //ͨ0NеƽΪߵƽ
	PWMPLUS_ChannelInitStruct.CHxInv = DISABLE;                        //ͨ0ת
	PWMPLUS_ChannelInitStruct.CHxNInv = DISABLE;                       //ͨ0Nת
	PWMPLUS_ChannelInitStruct.CHxOutEn = ENABLE;                       //ͨ0ʹ
	PWMPLUS_ChannelInitStruct.CHxNOutEn = ENABLE;                      //ͨ0Nʹ
	PWMPLUS_ChannelInitStruct.Brake_CHxOutLevel = LEVEL_LOW;           //ͨ0ɲƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Brake_CHxNOutLevel = LEVEL_LOW;          //ͨ0NɲƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Brake_Enable = BRAKE0_DIS_BRAKE1_DIS;    //ɲ0 ɲ1
	PWMPLUS_ChannelInitStruct.Mask_CHx_Level = LEVEL_LOW;              //ͨ0εƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Level = LEVEL_LOW;             //ͨ0NεƽΪ͵ƽ
	PWMPLUS_ChannelInitStruct.Mask_CHx_Enable = DISABLE;               //ͨ0ιܽ
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Enable = DISABLE;              //ͨ0Nιܽ
	PWMPLUS_ChannelInitStruct.Up_CompIE  = ENABLE;                     //ͨ0ϼȽϵжʹ
	PWMPLUS_ChannelInitStruct.Down_CompIE  = DISABLE;                  //ͨ0¼ȽϵжϽ
	
	PWMPLUS_ChannelInit(PWMPLUS0,&PWMPLUS_ChannelInitStruct);
	
	
	PWMPLUS_ChannelInitStruct.Channel = PWMPLUS_CH1;
	PWMPLUS_ChannelInitStruct.Comp = 3000;
	PWMPLUS_ChannelInitStruct.DeadZone = 100;
	PWMPLUS_ChannelInitStruct.StartLevel = LEVEL_HIGH;
	PWMPLUS_ChannelInitStruct.CHxIdleLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.CHxNIdleLevel = LEVEL_HIGH;
	PWMPLUS_ChannelInitStruct.CHxInv = DISABLE;
	PWMPLUS_ChannelInitStruct.CHxNInv = DISABLE;
	PWMPLUS_ChannelInitStruct.CHxOutEn = ENABLE;
	PWMPLUS_ChannelInitStruct.CHxNOutEn = ENABLE;
	PWMPLUS_ChannelInitStruct.Brake_CHxOutLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Brake_CHxNOutLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Brake_Enable = BRAKE0_DIS_BRAKE1_DIS;
	PWMPLUS_ChannelInitStruct.Mask_CHx_Level = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Level = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Mask_CHx_Enable = DISABLE;
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Enable = DISABLE;
	PWMPLUS_ChannelInitStruct.Up_CompIE  = ENABLE;
	PWMPLUS_ChannelInitStruct.Down_CompIE  = DISABLE;
	
	PWMPLUS_ChannelInit(PWMPLUS0,&PWMPLUS_ChannelInitStruct);
	
	
	PWMPLUS_ChannelInitStruct.Channel = PWMPLUS_CH2;
	PWMPLUS_ChannelInitStruct.Comp = 7000;
	PWMPLUS_ChannelInitStruct.DeadZone = 100;
	PWMPLUS_ChannelInitStruct.StartLevel = LEVEL_HIGH;
	PWMPLUS_ChannelInitStruct.CHxIdleLevel = LEVEL_HIGH;
	PWMPLUS_ChannelInitStruct.CHxNIdleLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.CHxInv = DISABLE;
	PWMPLUS_ChannelInitStruct.CHxNInv = DISABLE;
	PWMPLUS_ChannelInitStruct.CHxOutEn = ENABLE;
	PWMPLUS_ChannelInitStruct.CHxNOutEn = ENABLE;
	PWMPLUS_ChannelInitStruct.Brake_CHxOutLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Brake_CHxNOutLevel = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Brake_Enable = BRAKE0_DIS_BRAKE1_DIS;
	PWMPLUS_ChannelInitStruct.Mask_CHx_Level = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Level = LEVEL_LOW;
	PWMPLUS_ChannelInitStruct.Mask_CHx_Enable = DISABLE;
	PWMPLUS_ChannelInitStruct.Mask_CHxN_Enable = DISABLE;
	PWMPLUS_ChannelInitStruct.Up_CompIE  = ENABLE;
	PWMPLUS_ChannelInitStruct.Down_CompIE  = DISABLE;
	
	PWMPLUS_ChannelInit(PWMPLUS0,&PWMPLUS_ChannelInitStruct);
	
	PWMPLUS_Start(PWMPLUS0);
//	PWMPLUS_SoftLoad(PWMPLUS0); 
}


void PWMPLUS_IO_Indicate(void)
{
	GPIO_InitTypeDef GPIO_InitStruct;                     /*һGPIO_InitTypeDef͵Ľṹ*/
	
	
	GPIO_InitStruct.Pin = PWMPLUS_IO0_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/
	
	GPIO_Init(PWMPLUS_IO0_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	GPIO_InitStruct.Pin = PWMPLUS_IO1_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/
	
	GPIO_Init(PWMPLUS_IO1_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	GPIO_InitStruct.Pin = PWMPLUS_IO2_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;                   /*ģʽΪ*/

	GPIO_Init(PWMPLUS_IO2_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_ClrBit(PWMPLUS_IO0_GPIO_PORT,PWMPLUS_IO0_GPIO_PIN);
	GPIO_ClrBit(PWMPLUS_IO1_GPIO_PORT,PWMPLUS_IO1_GPIO_PIN);
	GPIO_ClrBit(PWMPLUS_IO2_GPIO_PORT,PWMPLUS_IO2_GPIO_PIN);
//	PWMPLUS_SetPeriod(PWMPLUS_CH0,5000);
//	PWMPLUS_SetPeriod(PWMPLUS_CH1,5000);	
}


//PWMBASE0жϷ
void PWMPLUS0_Handler(void)
{
//	if(PWMPLUS0->IF & PWMPLUS_IF_RELOAD_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_RELOAD_POS);
//		
//		PWMPLUS_IO0_TOGGLE;
//	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_BRK0_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_BRK0_POS);
//		
//		PWMPLUS_IO1_TOGGLE;
//	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_BRK1_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_BRK1_POS);
//		
//		PWMPLUS_IO2_TOGGLE;
//	}
	
//	if(PWMPLUS0->IF & PWMPLUS_IF_UP_TRIG_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_UP_TRIG_POS);
//		
//		PWMPLUS_IO1_TOGGLE;
//	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_DOWN_TRIG_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_DOWN_TRIG_POS);
//		
//		PWMPLUS_IO2_TOGGLE;
//	}
	
	if(PWMPLUS0->IF & PWMPLUS_IF_UP_OVF_MSK)
	{
		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_UP_OVF_POS);
		
//		PWMPLUS_IO0_TOGGLE;
		PWMPLUS_IO1_TOGGLE;
		PWMPLUS_IO2_TOGGLE;
	}
	
//	if(PWMPLUS0->IF & PWMPLUS_IF_DOWN_OVF_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_DOWN_OVF_POS);
//		
//		PWMPLUS_IO2_TOGGLE;
//	}
	
	if(PWMPLUS0->IF & PWMPLUS_IF_CH0_UP_COMP_MSK)
	{
		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH0_UP_COMP_POS);
		
//		PWMPLUS_IO0_TOGGLE;
	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_CH0_DOWN_COMP_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH0_DOWN_COMP_POS);
//		
//		PWMPLUS_IO0_TOGGLE;
//	}
//	
	if(PWMPLUS0->IF & PWMPLUS_IF_CH1_UP_COMP_MSK)
	{
		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH1_UP_COMP_POS);
		
		PWMPLUS_IO1_TOGGLE;
	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_CH1_DOWN_COMP_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH1_DOWN_COMP_POS);
//		
//		PWMPLUS_IO1_TOGGLE;
//	}
//	
	if(PWMPLUS0->IF & PWMPLUS_IF_CH2_UP_COMP_MSK)
	{
		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH2_UP_COMP_POS);
		
		PWMPLUS_IO2_TOGGLE;
	}
//	
//	if(PWMPLUS0->IF & PWMPLUS_IF_CH2_DOWN_COMP_MSK)
//	{
//		PWMPLUS0->IF = (0x01 << PWMPLUS_IF_CH2_DOWN_COMP_POS);
//		
//		PWMPLUS_IO2_TOGGLE;
//	}
}
void PWMPLUS0_user_handle(void)
{
			static  uint16_t pwm_data;
	    if(time_1ms >= 1000)
		    {
			    time_1ms = 0;
			//    PWMPLUS_ChannelInitStruct.Channel = PWMPLUS_CH0;
					pwm_data+=2500;
					if(pwm_data>7500) pwm_data=0;
					PWMPLUS_SetComp(PWMPLUS0,1,pwm_data);
					PWMPLUS_SetComp(PWMPLUS0,2,pwm_data);
					PWMPLUS_SetComp(PWMPLUS0,4,pwm_data);			
					
					PWMPLUS_SoftLoad(PWMPLUS0); 
					
		    }

}	

#define DEMO_PWMPLUS          0x01
#define DEMO_PWMPLUS_TIMSRC   0x02
void TimerPlus_Tim_Init(void)
{
	TIMPLUS_CommonInitTypeDef  TIMPLUS_CommonInitStruct = {0};
	
	TIMPLUS_CommonInitStruct.ClkDiv = 0;
	TIMPLUS_CommonInitStruct.Mode = TIMER_MODE;
	TIMPLUS_CommonInitStruct.ClkSel = SYSCLK_DIV;
	TIMPLUS_CommonInitStruct.Period = 9;
	TIMPLUS_CommonInitStruct.OutEn = DISABLE;
	TIMPLUS_CommonInitStruct.Ovf_IE = DISABLE;
	
	TIMPLUS_Common_Init(TIMPLUS0,TIMPLUS_LOW,&TIMPLUS_CommonInitStruct);
	
	TIMPLUS_CommonInitStruct.Period = 19;
	TIMPLUS_Common_Init(TIMPLUS0,TIMPLUS_HIGH,&TIMPLUS_CommonInitStruct);
	
	
	TIMPLUS_Start(TIMPLUS0,TIMPLUS_LOW);
	TIMPLUS_Start(TIMPLUS0,TIMPLUS_HIGH);
}


void PWMPLUS_TimSrc(void)
{
	PWMPLUS_Init();

	TimerPlus_Tim_Init();
	
	while(1)
	{
		PWMPLUS0->CLK = CLKSRC_LOW16 << PWMPLUS_CLK_SRC_POS;
		
		PWMPLUS_Start(PWMPLUS0);
		
		delay_ms(200);
		
		PWMPLUS_Stop(PWMPLUS0);
		
		
		PWMPLUS0->CLK = CLKSRC_HIGH16 << PWMPLUS_CLK_SRC_POS;
		
		PWMPLUS_Start(PWMPLUS0);
		
		delay_ms(200);
		
		PWMPLUS_Stop(PWMPLUS0);
	}	
}

uint8_t Flag_Demo = 0;
void pwm_plus_test(void)
{
	Flag_Demo = DEMO_PWMPLUS_TIMSRC;	
	if(Flag_Demo == DEMO_PWMPLUS)
	{
		PWMPLUS_Init();
		PWMPLUS_IO_Indicate();
		
		while(1)
		{
	   
		}
	}
	else if(Flag_Demo == DEMO_PWMPLUS_TIMSRC)
	{
		PWMPLUS_TimSrc();
	} 
}
#endif
// =================== end of uart TEST DEMO ==================================
// =================== start of exti TEST DEMO ================================
#if EXTI_TEST
uint8_t Flag_Key1 = 0;      //1жϱ־λ
uint8_t Flag_Key2 = 0;      //2жϱ־λ
uint8_t Flag_Key3 = 0;      //3жϱ־λ
uint8_t Flag_Key4 = 0;      //4жϱ־λ
//ⲿжϳʼ
void Exti_Init(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;              /*һGPIO_InitTypeDef͵Ľṹ*/
	
   
	GPIO_InitStruct.Pin = KEY1_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PU_IN;             /*ģʽΪ*/
	
	GPIO_Init(KEY1_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_InitStruct.Pin = KEY2_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PU_IN;             /*ģʽΪ*/
	
	GPIO_Init(KEY2_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_InitStruct.Pin = KEY3_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PU_IN;             /*ģʽΪ*/
	
	GPIO_Init(KEY3_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_InitStruct.Pin = KEY4_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PU_IN;             /*ģʽΪ*/
	
	GPIO_Init(KEY4_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	EXTI_Init(KEY1_GPIO_PORT,KEY1_GPIO_PIN,EXTI_RISE_EDGE);   //ж
	EXTI_Init(KEY2_GPIO_PORT,KEY2_GPIO_PIN,EXTI_FALL_EDGE);   //½ж
	EXTI_Init(KEY3_GPIO_PORT,KEY3_GPIO_PIN,EXTI_BOTH_EDGE);   //˫ж
	EXTI_Init(KEY4_GPIO_PORT,KEY4_GPIO_PIN,EXTI_LOW_LEVEL);   //͵ƽж
	
	NVIC_EnableIRQ(KEY1_IRQn);                    //ʹܰ1ж     
	NVIC_EnableIRQ(KEY2_IRQn);                    //ʹܰ2ж    
	NVIC_EnableIRQ(KEY3_IRQn);                    //ʹܰ3ж    
	NVIC_EnableIRQ(KEY4_IRQn);                    //ʹܰ4ж    
	
	EXTI_Open(KEY1_GPIO_PORT,KEY1_GPIO_PIN);      //򿪰1ⲿж  
	EXTI_Open(KEY2_GPIO_PORT,KEY2_GPIO_PIN);      //򿪰2ⲿж  
	EXTI_Open(KEY3_GPIO_PORT,KEY3_GPIO_PIN);      //򿪰3ⲿж  
	EXTI_Open(KEY4_GPIO_PORT,KEY4_GPIO_PIN);      //򿪰4ⲿж  
}

//1жϷ
void KEY1_Handler(void)
{
	if(EXTI_State(KEY1_GPIO_PORT,KEY1_GPIO_PIN))    //ѯж״̬
	{
		EXTI_Clear(KEY1_GPIO_PORT,KEY1_GPIO_PIN);   //жϱ־
		
		Flag_Key1 = 1;                              //1ı־λ1
	}
}

//2жϷ
void KEY2_Handler(void)
{
	if(EXTI_State(KEY2_GPIO_PORT,KEY2_GPIO_PIN))    //ѯж״̬
	{
		EXTI_Clear(KEY2_GPIO_PORT,KEY2_GPIO_PIN);   //жϱ־ 
		
		Flag_Key2 = 1;                              //2ı־λ1
	}
}

//3жϷ
void KEY3_Handler(void)
{
	if(EXTI_State(KEY3_GPIO_PORT,KEY3_GPIO_PIN))    //ѯж״̬
	{
		EXTI_Clear(KEY3_GPIO_PORT,KEY3_GPIO_PIN);   //жϱ־ 
		
		Flag_Key3 = 1;                              //3ı־λ1
	}
}

//4жϷ
void KEY4_Handler(void)
{
	if(EXTI_State(KEY4_GPIO_PORT,KEY4_GPIO_PIN))    //ѯж״̬
	{
		EXTI_Clear(KEY4_GPIO_PORT,KEY4_GPIO_PIN);   //жϱ־ 
		
		Flag_Key4 = 1;                              //4ı־λ1
	}
}

void exti_test(void)
{
    Exti_Init();           //extiʼ
	
    while(1)
    {
        if(Flag_Key1 == 1)  //1ı־λΪ1ʱ  LED1ת
		{
			Flag_Key1 = 0;
			
			LED1_TOGGLE;
		}
		
		if(Flag_Key2 == 1)  //2ı־λΪ1ʱ  LED2ת
		{
			Flag_Key2 = 0;
			
			LED2_TOGGLE;
		}
		
		if(Flag_Key3 == 1)  //3ı־λΪ1ʱ  LED3ת
		{
			Flag_Key3 = 0;
			
			LED3_TOGGLE;
		}
		
		if(Flag_Key4 == 1)  //4ı־λΪ1ʱ  LED4ת
		{
			Flag_Key4 = 0;
			
			LED4_TOGGLE;
		}
    }

}
#endif
// =================== end of uart TEST DEMO ==================================








