#include "bl2101x_test.h"
#include "bl2101_uart.h"
#include "bl2101_timer.h"
#include "bl2101_gpio.h"
#include "bl2101_adc.h"

uint16_t time_1ms = 0;              //1ms 
uint16_t time_10ms = 0;             //10ms
uint16_t time_100ms = 0;            //100ms

uint16_t Serial_timeout_1ms = 0;    //ڳʱֵ

uint8_t Rec_Data[100] = {1,2};      //յݴ
uint8_t Rec_Num = 0;                //յݸ

uint8_t * UART_TXBuffer = 0;        //
uint32_t UART_TXCount = 0;          //ݸ
uint32_t UART_TXIndex = 0;          //

uint8_t Uart_Rec_flag=0;

// =================== UART  TEST DEMO ===================================================

///
/// ڳʼ
///
void uart_init(void)
{
	UART_InitTypeDef UART_InitStruct;
	PORT_InitTypeDef PORT_InitStruct;
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN0;
	PORT_InitStruct.Func = PORTA_PIN0_UART0_TX;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTA0Ϊ0ķ
	
	PORT_InitStruct.Port = PORTA;
	PORT_InitStruct.Pin = GPIO_PIN1;
	PORT_InitStruct.Func = PORTA_PIN1_UART0_RX;
	PORT_InitStruct.Input_En = 1;
	
	PORT_Init(&PORT_InitStruct);     //PORTA1Ϊ0Ľ
	
	
	UART_InitStruct.Baudrate = 19600;            //115200
	UART_InitStruct.DataBits = UART_DATA_8BIT;    //λ8λ
	UART_InitStruct.Parity = UART_PARITY_NONE;    //У
	UART_InitStruct.StopBits = UART_STOP_1BIT;    //ֹͣλ1λ
	
	UART_InitStruct.RXIEn = 1;                    //жʹ
	
	UART_Init(UART0,&UART_InitStruct);            //ڳʼ
}

///
/// 0жϷ
///
void UART0_Handler(void)
{
	if(UART0->LSR & UART_LSR_REC_MSK)             //Ч
	{
		//Serial_timeout_1ms = 0;                   //ڳʱ0
		time_1ms=0;
		Rec_Data[Rec_Num++] = UART0->RDR;         //ȡյ
	  Uart_Rec_flag = 1;
	}
	
	/*if(UART0->LSR & UART_LSR_TEMT_MSK)            //
	{
		if(UART_TXIndex < UART_TXCount)
		{
			UART_SendData(UART0, UART_TXBuffer[UART_TXIndex]);
			UART_TXIndex++;
		}
		else
		{
			UART0->IE &= ~(0x01 << UART_IE_TXE_POS);    //رշж
		}
	}*/
}

///
/// жϷʽ
///
void UART_SendChars(uint8_t data[], uint32_t len)
{
	UART_TXBuffer = data;
	UART_TXCount = len;
	UART_TXIndex = 0;
	
	UART0->IE |= 0x01 << UART_IE_TXE_POS;
	NVIC_EnableIRQ(UART0_IRQn);
}


///
/// ڲԳ    
///
void uart_test(uint8_t senddata)
{
	//uint8_t k = 0;
	
	UART_SendData(UART0, senddata);     //ѯʽ 
	
/*
	//UART_SendChars(Rec_Data,2); 
	if(time_1ms > 10  && Uart_Rec_flag==1)                        //ڳʱ10ms
	{
		Uart_Rec_flag = 0;
		if(Rec_Num == 0)                               //ûյ0
		{
			Serial_timeout_1ms = 0;
		}
		else                                           //յ
		{
			Serial_timeout_1ms = 0;                    //ʱ0
			
			for(k = 0; k < Rec_Num;k++)
			{
				UART_SendData(UART0, Rec_Data[k]);     //ѯʽ 
			}
			
			//UART_SendChars(Rec_Data,Rec_Num);          //жϷʽ 
			
			Rec_Num = 0;	
		}
	}
*/

}

// =================== END OF UART  TEST DEMO ===================================================


// =================== TIMER  TEST DEMO ===================================================

///
/// 16λʱʼ
///
void TIMER_L16_Init(void)
{
   TIMER_Init(TIMER_LOW16BIT,1000,1);      //16λʱ   ʱʱ1ms     TIMER_Start(TIMER_LOW16BIT);            //16λʱ
}

///
/// 16λʱʼ
///
void TIMER_H16_Init(void)
{
   TIMER_Init(TIMER_HIGH16BIT,10000,1);    //16λʱ   ʱʱ10ms   ж
   TIMER_Start(TIMER_HIGH16BIT);           //16λʱ
}

///
/// 32λʱʼ
///
void TIMER_HL32_Init(void)
{
	TIMER_Init(TIMER_32BIT,100000,1);      //32λʱ   ʱʱ100ms   ж
    TIMER_Start(TIMER_32BIT);              //32λʱ
}

///
/// ʱжϷ
///
void TIMER_Handler(void)
{
	if(TIMER_INTStat(TIMER_LOW16BIT))          //жϵ16λʱжϱ־ǷΪ1
	{
		TIMER_INTClr(TIMER_LOW16BIT);          //16λʱжϱ־
		
		time_1ms++;                            //1ms1
	}

	if(TIMER_INTStat(TIMER_HIGH16BIT))         //жϸ16λʱжϱ־ǷΪ1  
	{
		TIMER_INTClr(TIMER_HIGH16BIT);         //16λʱжϱ־
		
		time_10ms++;                           //10ms1
	}

	if(TIMER_INTStat(TIMER_32BIT))             //ж32λʱжϱ־ǷΪ1          
	{
		TIMER_INTClr(TIMER_32BIT);             //32λʱжϱ־
		
		time_100ms++;                          //100ms1
	}
}

// =================== END OF TIMER  TEST DEMO ===================================================

// =================== ADC  TEST DEMO ===================================================

#define adc_data_size  100

uint16_t Adc_Data[adc_data_size] = {0};     //ADCջ
uint16_t Adc_Num = 0;              //ADCֽڼ
uint8_t Flag_ADC_Over = 0;         //ADCɼɱ־

uint8_t Flag_Int = 0;              //жϲű־

uint16_t Fifo_Cnt0 = 0;            //ͨ0
uint16_t Fifo_Cnt1 = 0;            //ͨ1


///
/// ADC_VDDβѯģʽʼ
///
void ADC_VDD_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH8;                     //ADCתͨѡCH8
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_64;     //ⲿ
	ADC_initStruct.Vref = VREF_IN;                         //ADCοԴѡڲο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 1;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 1;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}

///
/// ADC_VDDβѯģʽ
///
void ADC_VDD_Check_Devote(void)
{
	uint16_t data = 0;
	
	while(ADC_IsEOC(ADC_CH8) == 0);                        //ȴת
	
	data = ADC_Read(ADC_CH8);                              //ȡת
	
	data = (data*3*1400)>>12;                              //תΪʵʵĵѹֵ λΪmV   ڲ1/3ѹвɼ
	
	printf("%d,",data);                                    //ӡת                    
	
	ADC_Start();                                           //ADCת
}
   

///
/// ͨβѯģʽʼ
///
void SingleChn_Single_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTB5ΪADCͨ0
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ2Ƶ                    
	ADC_initStruct.Channels = ADC_CH0;                     //ADCתͨѡCH0
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_16;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}


///
/// ͨβѯģʽ
///
void SingleChn_Single_Check_Devote(void)
{
	uint16_t data = 0;
	
	while(ADC_IsEOC(ADC_CH0) == 0);                        //ȴת
	
	data = ADC_Read(ADC_CH0);                              //ȡת
	
	printf("%d,",data);                                    //ӡת                    
	
	ADC_Start();                                           //ADCת
}


///
/// ͨѯģʽʼ
///
void SingleChn_Continue_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);                           //PORTB5ΪADCͨ0
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ2Ƶ                    
	ADC_initStruct.Channels = ADC_CH0;                     //ADCתͨѡCH0
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}


///
/// ͨѯģʽ
///
void SingleChn_Continue_Check_Devote(void)
{
	uint16_t data = 0;
	
	while(ADC_IsEOC(ADC_CH0) == 0);                        //ȴת
	
	data = ADC_Read(ADC_CH0);                              //ȡת
	
	printf("%d,",data);                                    //ӡת   
}


///
/// ͨβжģʽʼ
///
void SingleChn_Single_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ2Ƶ                    
	ADC_initStruct.Channels = ADC_CH0;                     //ADCתͨѡCH0
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH0;                      //ͨ0תжʹ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 1;
	
	ADC_Start();                                           //ADCת
}

///
/// ͨβжģʽ
///
void SingleChn_Single_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)                        //ɱ־
    {
        Flag_ADC_Over = 0;

        for(i = 0; i< adc_data_size; i++)
        {
            printf("%d,",Adc_Data[i]);            //ӡ
        }
		
		    ADC_Start();                              //ת
    }
}

///
/// ͨжģʽʼ
///
void SingleChn_Continue_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	ADC_initStruct.Clk_Div = CLK_DIV_2;                    //ADCתʱ2Ƶ                    
	ADC_initStruct.Channels = ADC_CH0;                     //ADCתͨѡCH0
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH0;                      //ͨ0תжʹ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 2;
	
	ADC_Start();                                           //ADCת
}


///
/// ͨжģʽ
///
void SingleChn_Continue_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)                           //ɱ־
    {
        Flag_ADC_Over = 0;

        for(i = 0; i< adc_data_size; i++)
        {
            printf("%d,",Adc_Data[i]);               //ӡ
        }
		
		    ADC_Start();                                 //ת
    }
}

///
/// ͨβѯģʽʼ
///
void MultiChn_Single_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת     
}

///
/// ͨβѯģʽ
///
void MultiChn_Single_check_Devote(void)
{
	uint16_t data = 0;
	

	while(ADC_IsEOC(ADC_CH1) == 0);                        //ȴͨ1ת   
	
	data = ADC_Read(ADC_CH0);                              //ȡͨ0ת
	
	printf("CH0:%d\r\n",data);                             //ӡͨ0ת 
	
	data = ADC_Read(ADC_CH1);                              //ȡͨ1ת
	
	printf("CH1:%d\r\n",data);                             //ӡͨ1ת 
	
	ADC_Start();                                           //ADCת
}

///
/// ͨѯģʽʼ
///
void MultiChn_Continue_Check_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1 ;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	ADC_Start();                                           //ADCת
}

///
/// ͨѯģʽ
///
void MultiChn_Continue_check_Devote(void)
{
	uint16_t data = 0;
	
	while(ADC_IsEOC(ADC_CH1) == 0);                        //ȴͨ1ת   
	
	data = ADC_Read(ADC_CH0);                              //ȡͨ0ת
	
	printf("CH0:%d\r\n",data);                             //ӡͨ0ת 
	
	data = ADC_Read(ADC_CH1);                              //ȡͨ1ת
	
	printf("CH1:%d\r\n",data);                             //ӡͨ1ת 
}


///
/// ͨβжģʽʼ
///
void MultiChn_Single_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_SINGLE;           //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH1;                      //ͨ1תжʹ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 3;
	
	ADC_Start();                                           //ADCת    
}

///
/// ͨβжģʽ
///
void MultiChn_Single_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)
    {
        Flag_ADC_Over = 0;

		    printf("CH0 DATA :\r\n");
        for(i = 0; i< adc_data_size/2; i++)
        {
			      printf("%d,",Adc_Data[i]);             //ӡͨ0ת 
        }
		    printf("\r\n");
		
		    printf("CH1 DATA :\r\n");
        for(i = 0; i< adc_data_size/2; i++)
        {
			      printf("%d,",Adc_Data[i+adc_data_size/2]);        //ӡͨ1ת 
        }
		    printf("\r\n");
		
		ADC_Start();                              //ADCת 
    }
}

///
/// ͨжģʽʼ
///
void MultiChn_Continue_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_CHAN;                       //ݴ洢Ϊͨģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = ADC_CH1;                      //ͨ1תжʹ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 4;
	
	ADC_Start();                                           //ADCת    
}

///
/// ͨжģʽ
///
void MultiChn_Continue_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)
    {
        Flag_ADC_Over = 0;

		    printf("CH0 DATA :\r\n");
        for(i = 0; i< adc_data_size/2; i++)
        {
			      printf("%d,",Adc_Data[i]);            //ӡͨ0ת 
        }
		    printf("\r\n");
		
		    printf("CH1 DATA :\r\n");
        for(i = 0; i< adc_data_size/2; i++)
        {
			      printf("%d,",Adc_Data[i+adc_data_size/2]);       //ӡͨ1ת 
        }
		    printf("\r\n");
		
		    ADC_Start();                             //ADCת 
    }
}

///
/// ͨFIFOжģʽʼ
///
void MultiChn_Continue_Full_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_FIFO;                       //ݴ洢ΪFIFOģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = ENABLE;                      //FIFOжʹ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 5;
	
	ADC_Start();                                           //ADCת   
}


///
/// ͨFIFOжģʽʼ
///
void MultiChn_Continue_HalfFull_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_FIFO;                       //ݴ洢ΪFIFOģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = ENABLE;                  //FIFOжʹ
	ADC_initStruct.Ovf_IEn = 0;                            //FIFOжϽ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 6;
	
	ADC_Start();                                           //ADCת 
}


///
/// ͨFIFOжģʽʼ
///
void MultiChn_Continue_Ovf_Interrupt_Init(void)
{
	ADC_InitStructure ADC_initStruct;
	PORT_InitTypeDef PORT_InitStruct;

	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN5;
	PORT_InitStruct.Func = PORTB_PIN5_ADC_CH0;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB5ΪADC
	
	PORT_InitStruct.Port = PORTB;
	PORT_InitStruct.Pin = GPIO_PIN4;
	PORT_InitStruct.Func = PORTB_PIN4_ADC_CH1;
	PORT_InitStruct.Input_En = 0;           
	
	PORT_Init(&PORT_InitStruct);     //PORTB4ΪADC
	
	
	ADC_initStruct.Clk_Div = CLK_DIV_8;                    //ADCתʱ8Ƶ                    
	ADC_initStruct.Channels = ADC_CH0 | ADC_CH1;           //ADCתͨѡCH0 CH1
	ADC_initStruct.SampAvg = SAMP_AVG_8;                   //ȡƽ  8ȡƽ
	ADC_initStruct.Samp_Mode = SAMP_MODE_CONTINUE;         //תģʽ
	ADC_initStruct.Mode = MODE_FIFO;                       //ݴ洢ΪFIFOģʽ 
	ADC_initStruct.SampClk = SAMP_CLK_EXT;                 //ADCʱѡⲿʱ
	ADC_initStruct.ExtSamp_ClkWin = EXTSAMP_CLKWIN_8;      //ⲿ
	ADC_initStruct.Vref = VREF_EXT;                        //ADCοԴѡⲿο 
	ADC_initStruct.Adcvdd_Open = 0;                        //ADC VDDʹܲ
	ADC_initStruct.Kd_En = 0;                              //kdݲʹ 
	ADC_initStruct.Offset_En = 0;                          //offsetݲʹ 
	ADC_initStruct.Eoc_IEn = 0;                            //ͨתжϽ
	ADC_initStruct.Full_IEn = 0;                           //FIFOжϽ
	ADC_initStruct.HalfFull_IEn = 0;                       //FIFOжϽ
	ADC_initStruct.Ovf_IEn = ENABLE;                       //FIFOжʹ
	
	ADC_Init(&ADC_initStruct);     //ADC 
	
	ADC_Open();                                            //ADC
	
	ADC_SoftReset();                                       //ADCλ 
	
	Flag_Int = 7;
	
	ADC_Start();                                           //ADCת 
}


///
/// ͨFIFOжģʽ
///
void MultiChn_Continue_FIFO_Interrupt_Devote(void)
{
    uint16_t i = 0;

    if(Flag_ADC_Over == 1)
    {
        Flag_ADC_Over = 0;

		    printf("CH0 DATA :\r\n");
        for(i = 0; i< 49; i++)
        {
			      printf("%d,",Adc_Data[i]);              //ӡͨ0ת 
        }
		    printf("\r\n");
		
		    printf("CH1 DATA :\r\n");
        for(i = 0; i< 49; i++)
        {
			      printf("%d,",Adc_Data[i+50]);         //ӡͨ1ת 
        }
		    printf("\r\n");
		
		    ADC_Start();                               //ADCת 
    }
}

///
/// ADCжϴ
///
void ADC_Handler(void)
{
	uint16_t Fifo_Data[9] = {0};
	uint8_t j = 0;
	
	if(Flag_Int == 1 || Flag_Int == 2)                 //ADCͨж  ͨж
	{
		   Adc_Data[Adc_Num++] = ADC_Read(ADC_CH0);
		
		   if(Adc_Num >= adc_data_size)
		   {
			     Adc_Num = 0;
			
			     Flag_ADC_Over = 1;
		   }
	}
	else if(Flag_Int == 3 || Flag_Int == 4)           //ADCͨж  ͨж
	{
		  Adc_Data[Adc_Num] = ADC_Read(ADC_CH0);
		  Adc_Data[Adc_Num + adc_data_size/2] = ADC_Read(ADC_CH1);
		
		  Adc_Num++;
		
		  if(Adc_Num >= adc_data_size/2)
		  {
			    Adc_Num = 0;
			
			    Flag_ADC_Over = 1;
		  }
	}
	else if(Flag_Int == 5)                            //ADCͨFIFOж
	{
		if(ADC_IntFULLStat() == 1)
		{
			ADC_Read_FIFO(Fifo_Data,9);
			
			for(j = 0;j < 9;j++)
			{
				if((Fifo_Data[j] >> 12) == 0)
				{
					Adc_Data[Fifo_Cnt0] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt0++;
				}
				else if((Fifo_Data[j] >> 12) == 1)
				{
					Adc_Data[Fifo_Cnt1+adc_data_size/2] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt1++;
				}
				
				if(Fifo_Cnt0 >= 49 || Fifo_Cnt1 >= 49)
				{
					Fifo_Cnt0 = 0;  
					Fifo_Cnt1 = 0;
					
					Flag_ADC_Over = 1;
					
					ADC_Stop();	
					
					ADC->START |= 0x01 << ADC_START_FIFOCLR_Pos;
				}
			}
			
			ADC_IntFULLClr();
		}
	}
	else if(Flag_Int == 6)                     //ADCͨFIFOж
	{
		if(ADC_IntHALFFULLStat() == 1)
		{
			ADC_Read_FIFO(Fifo_Data,5);
			
			for(j = 0;j < 5;j++)
			{
				if((Fifo_Data[j] >> 12) == 0)
				{
					Adc_Data[Fifo_Cnt0] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt0++;
				}
				else if((Fifo_Data[j] >> 12) == 1)
				{
					Adc_Data[Fifo_Cnt1+adc_data_size/2] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt1++;
				}
				
				if(Fifo_Cnt0 >= 49 || Fifo_Cnt1 >= 49)
				{
					Fifo_Cnt0 = 0;  
					Fifo_Cnt1 = 0;
					
					Flag_ADC_Over = 1;
					
					ADC_Stop();	
					
					ADC->START |= 0x01 << ADC_START_FIFOCLR_Pos;
				}
			}
			
			ADC_IntHALFFULLClr();
		}
	}
	else if(Flag_Int == 7)                  //ADCͨFIFOж
	{
		if(ADC_IntOVFStat() == 1)
		{
			ADC_Read_FIFO(Fifo_Data,9);
			
			for(j = 0;j < 9;j++)
			{
				if((Fifo_Data[j] >> 12) == 0)
				{
					Adc_Data[Fifo_Cnt0] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt0++;
				}
				else if((Fifo_Data[j] >> 12) == 1)
				{
					Adc_Data[Fifo_Cnt1+adc_data_size/2] = Fifo_Data[j] & 0xFFF;
					
					Fifo_Cnt1++;
				}
				
				if(Fifo_Cnt0 >= 49 || Fifo_Cnt1 >= 49)
				{
					Fifo_Cnt0 = 0;  
					Fifo_Cnt1 = 0;
					
					Flag_ADC_Over = 1;
					
					ADC_Stop();	
					
					ADC->START |= 0x01 << ADC_START_FIFOCLR_Pos;
				}
			}
			
			ADC_IntOVFClr();
		}
	}
	
	if(Flag_Int == 1 || Flag_Int == 3)          //ADCͨж  ͨж
	{
		if(Flag_ADC_Over == 0)
		{
			ADC_Start();	
		}
	}
	else if(Flag_Int == 2 || Flag_Int == 4)    //ADCͨж   ͨж
	{
		if(Flag_ADC_Over == 1)
		{
			ADC_Stop();	
		}
	}
}


void adc_test(void)
{

	//ADC_VDD_Check_Init();                                     //ADC_VDDβѯģʽʼ
	//SingleChn_Single_Check_Init();                          //ͨβѯģʽʼ
	//SingleChn_Continue_Check_Init();                        //ͨѯģʽʼ
	//SingleChn_Single_Interrupt_Init();                      //ͨβжģʽʼ
	//SingleChn_Continue_Interrupt_Init();                    //ͨжģʽʼ
	//MultiChn_Single_Check_Init();                           //ͨβѯģʽʼ
	MultiChn_Continue_Check_Init();                         //ͨѯģʽʼ
	//MultiChn_Single_Interrupt_Init();                       //ͨβжģʽʼ
	//MultiChn_Continue_Interrupt_Init();                     //ͨжģʽʼ
	//MultiChn_Continue_Full_Interrupt_Init();                //ͨFIFOжģʽʼ
	//MultiChn_Continue_HalfFull_Interrupt_Init();            //ͨFIFOжģʽʼ
	//MultiChn_Continue_Ovf_Interrupt_Init();                 //ͨFIFOжģʽʼ
	
	while(1)
	{
		//ADC_VDD_Check_Devote();                               //ADC_VDDβѯģʽ
		//SingleChn_Single_Check_Devote();                    //ͨβѯģʽ
		//SingleChn_Continue_Check_Devote();                  //ͨѯģʽ
		//SingleChn_Single_Interrupt_Devote();                //ͨβжģʽ
		//SingleChn_Continue_Interrupt_Devote();              //ͨжģʽ		
		//MultiChn_Single_check_Devote();                     //ͨβѯģʽ
		MultiChn_Continue_check_Devote();	                  //ͨѯģʽ
		//MultiChn_Single_Interrupt_Devote();                 //ͨβжģʽ
		//MultiChn_Continue_Interrupt_Devote();               //ͨжģʽ
		//MultiChn_Continue_FIFO_Interrupt_Devote();          //ͨFIFOжģʽ
	}	
}

// =================== END OF ADC  TEST DEMO ===================================================


//LED IOʼ
void led_init(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;              /*һGPIO_InitTypeDef͵Ľṹ*/
	
	GPIO_InitStruct.Pin = LED1_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED1_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/

	
	GPIO_InitStruct.Pin = LED2_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED2_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
	
	
	GPIO_InitStruct.Pin = LED3_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	GPIO_Init(LED3_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/


	//GPIO_InitStruct.Pin = LED4_GPIO_PIN;           /*ѡҪƵGPIO*/
	
	//GPIO_InitStruct.Mode = MODE_PP_OUT;            /*ģʽΪ*/
	
	//GPIO_Init(LED4_GPIO_PORT,&GPIO_InitStruct);    /*ÿ⺯ʼGPIO*/
			
	LED1_OFF;       
	LED2_OFF;
	LED3_OFF;
	//LED4_OFF;		
}

