#ifndef __OMW_FLASH_H__
#define __OMW_FLASH_H__
#include <stdint.h>

#include "omw_config.h"

#define OMW_FLASH_SECTOR_SIZE OMW_FLASH_SS

#ifdef OMW_FLASH_HAS_PE
#define OMW_FLASH_PAGE_SIZE   OMW_FLASH_PS
#else
#define OMW_FLASH_PAGE_SIZE   OMW_FLASH_SECTOR_SIZE
#endif

static inline void omw_flash_lock()
{
	__disable_irq();
}

static inline void omw_flash_unlock()
{
	__enable_irq();
}

void omw_flash_overwrite(uint32_t addr, uint8_t * buf, uint32_t len);
void omw_flash_erase_base(char *dst, int length
                            #ifdef OMW_FLASH_HAS_PE
                            , uint8_t pe_flag
                            #endif
                            );
void omw_flash_erase(uint32_t addr);
void omw_flash_read(uint32_t addr, uint8_t * buf, uint32_t len);
void omw_flash_write(uint32_t addr, uint8_t * buf, uint32_t len);
void omw_flash_get_uid( uint32_t * data);
void omw_flash_get_device_addr(uint8_t *dev_addr);
#ifdef OMW_FLASH_HAS_PE
void omw_flash_sector_erase(uint32_t addr);
#define omw_flash_page_erase(a)  omw_flash_erase(a)
#endif

#endif
