#include "omw_uart.h"
#include "t1001_it.h"
#include "omw_gpio.h"

extern void calc_hp_offset_at_curr_temp();
extern void RF_BT_IRQHandler(void);
extern void RF_BT_IRQHandler_RAM();
#if defined(OMW_BLE_V0) || defined(OMW_BLE_V0_2_0)
extern void BT_TIMER_IRQHandler(void);
#endif
extern void VTIMER_IRQHandler(void);
#ifdef OMW_EN_DEEP_SLEEP
extern void Check_PwrOn_OnBbDmaIrq();
extern void  Check_PwrOn_OnBbDmaIrq_Before();
#endif

void omw_cali_period_temp();
void omw_app_sleep_process();

ATTRIBUTE_ISR __RAM_CODE_SECTION void RADIO_DMA_Handler(void)
{
    #ifdef OMW_EN_DEEP_SLEEP
    Check_PwrOn_OnBbDmaIrq_Before();
    #endif

    omw_hw_set_in_irq_flag();

    RF_BT_IRQHandler_RAM();

    #ifdef OMW_EN_DEEP_SLEEP
    Check_PwrOn_OnBbDmaIrq();
    #endif

    omw_hw_clr_in_irq_flag();

	omw_cali_period_temp();

    #ifdef OMW_EN_SLEEP_TMR_CHK
	omw_app_sleep_process();
    #endif
}

#if defined(OMW_BLE_V0) || defined(OMW_BLE_V0_2_0)
ATTRIBUTE_ISR __RAM_CODE_SECTION void RADIO_TICK_Handler(void)
{
    BT_TIMER_IRQHandler(); //rom api

    #ifdef OMW_EN_DEEP_SLEEP
    Check_PwrOn_OnBbDmaIrq();
    #endif

    omw_cali_period_temp();
}
#endif

ATTRIBUTE_ISR void UART1_Handler(void)
{
    omw_uart_it_rx_by_base_addr(OMW_UART1);
}

#if defined(OMW_BLE_HOST_V0) || defined(OMW_BLE_HOST_V1) || defined(OMW_BLE_HOST_V2) || defined(OMW_BLE_HOST_OTHER) || defined(OMW_CLTR_SLEEP_TEST)
ATTRIBUTE_ISR void RTC_Handler(void)
{
    omw_hw_set_in_irq_flag();

    VTIMER_IRQHandler();

    omw_hw_clr_in_irq_flag();
}
#endif

#if 0
ATTRIBUTE_ISR void GPADC_Handler(void)
{

}

ATTRIBUTE_ISR void WDT_Handler(void)
{

}

ATTRIBUTE_ISR void GPIO_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER0_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER1_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER2_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER3_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER4_Handler(void)
{
  omw_gpio_set_output_en(OMW_GPIO_PIN19,ENABLE);
  omw_gpio_set_output(OMW_GPIO_PIN19, HIGH);
}

ATTRIBUTE_ISR void TIMER5_Handler(void)
{
  omw_gpio_set_output_en(OMW_GPIO_PIN19,ENABLE);
  omw_gpio_set_output(OMW_GPIO_PIN19, HIGH);
}

ATTRIBUTE_ISR void TIMER6_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER7_Handler(void)
{

}
#endif
