#ifndef __PERIPH_SPIS_H__
#define __PERIPH_SPIS_H__

#include "t1001.h"

#define SPIS0            SPIS

typedef struct
{
    uint32_t SPIS_Direction;

    uint32_t SPIS_SCPOL;                

    uint32_t SPIS_SCPH;
	
    uint32_t SPIS_RxFIFOThreshold;
	
    uint32_t SPIS_TxFIFOThreshold;
	
    uint32_t SPIS_Wires;

}SPIS_InitTypeDef;

//SPIS Direction mode
#define SPIS_DIRECTION_TX_AND_RX   (uint32_t)0x0000    ////全双工模式；发一字节，同时收一字节   
#define SPIS_DIRECTION_TX_ONLY     (uint32_t)0x0100    ////仅发送
#define SPIS_DIRECTION_RX_ONLY     (uint32_t)0x0600    ////仅接收


//SPIS Clock Polarity
#define SPIS_SCPOL_LOW   (uint32_t)0x0000  
#define SPIS_SCPOL_HIGH  (uint32_t)0x0080


//SPIS Clock Phase
#define SPIS_SCPH_MIDDLE  (uint32_t)0x0000
#define SPIS_SCPH_START   (uint32_t)0x0040


//SPIS WIRES
#define SPIS_WIRES_4    (uint32_t)0x00
#define SPIS_WIRES_3    (uint32_t)0x06


//SPIS Status Flag
#define SPIS_FLAG_DATA_COLLISION_ERROR    (uint8_t)0x40 
#define SPIS_FLAG_TRANSMISSION_ERROR      (uint8_t)0x20
#define SPIS_FLAG_RECEIVE_FIFO_FULL       (uint8_t)0x10
#define SPIS_FLAG_RECEIVE_FIFO_NOT_EMPTY  (uint8_t)0x08
#define SPIS_FLAG_TRANSMIT_FIFO_EMPTY     (uint8_t)0x04
#define SPIS_FLAG_TRANSMIT_FIFO_NOT_FULL  (uint8_t)0x02
#define SPIS_FLAG_BUSY                    (uint8_t)0x01

//SPIS Interrupt
#define SPIS_IT_RX_FIFO_FULL              (uint8_t)0x10
#define SPIS_IT_RX_FIFO_OVERFLOW          (uint8_t)0x08
#define SPIS_IT_RX_FIFO_UNDERFLOW         (uint8_t)0x04
#define SPIS_IT_TX_FIFO_OVERFLOW          (uint8_t)0x02
#define SPIS_IT_TX_FIFO_EMPTY             (uint8_t)0x01
#define SPIS_IT_ALL                       (uint8_t)0x3F

//SPIS FRAME DATA
#define SPIS_DATA_SIZE_8BITS    (uint32_t)0x0007

//SPIS Frame Format
#define SPIS_FRF_MOTOROLA_SPI   (uint32_t)0x0000         //Motorolla SPI Frame Format



//SPIS Function
void SPIS_DeInit(void);
void SPIS_StructInit(SPIS_InitTypeDef* SPIS_InitStruct);
void SPIS_Init(SPIS_InitTypeDef* SPIS_InitStruct);
void SPIS_Cmd(FunctionalState NewState);
void SPIS_SendData(uint8_t Data);
uint8_t SPIS_ReceiveData(void);
FlagStatus SPIS_GetUsrStatus(uint8_t Flag);
void SPIS_ITConfig(uint8_t SPIS_IT, FunctionalState NewState);
ITStatus SPIS_GetITStatus(uint8_t SPIS_IT);
void SPIS_Direction_Switch(uint32_t SPIS_Direction);

#endif
