
.//Obj/mcu_only.elf:     file format elf32-littleriscv


Disassembly of section .text:

10000000 <reset_handler>:

.section ".text.init"
.global reset_handler
.type reset_handler, %function
reset_handler:
    mv  x1, x0
10000000:	00000093          	li	ra,0
    mv  x2, x1
10000004:	8106                	mv	sp,ra
    mv  x3, x1
10000006:	8186                	mv	gp,ra
    mv  x4, x1
10000008:	8206                	mv	tp,ra
    mv  x5, x1
1000000a:	8286                	mv	t0,ra
    mv  x6, x1
1000000c:	8306                	mv	t1,ra
    mv  x7, x1
1000000e:	8386                	mv	t2,ra
    mv  x8, x1
10000010:	8406                	mv	s0,ra
    mv  x9, x1
10000012:	8486                	mv	s1,ra
    mv x10, x1
10000014:	8506                	mv	a0,ra
    mv x11, x1
10000016:	8586                	mv	a1,ra
    mv x12, x1
10000018:	8606                	mv	a2,ra
    mv x13, x1
1000001a:	8686                	mv	a3,ra
    mv x14, x1
1000001c:	8706                	mv	a4,ra
    mv x15, x1
1000001e:	8786                	mv	a5,ra

    la      a0, trap_handler
10000020:	10001517          	auipc	a0,0x10001
10000024:	b2050513          	addi	a0,a0,-1248 # 20000b40 <trap_handler>
    ori     a0, a0, 3
10000028:	00356513          	ori	a0,a0,3
    csrw    mtvec, a0
1000002c:	30551073          	csrw	mtvec,a0

    la      a0, __VECTOR_TABLE
10000030:	10001517          	auipc	a0,0x10001
10000034:	b5050513          	addi	a0,a0,-1200 # 20000b80 <__VECTOR_TABLE>
    csrw    mtvt, a0
10000038:	30751073          	csrw	mtvt,a0

    la      sp, __StackTop
1000003c:	10004117          	auipc	sp,0x10004
10000040:	fc410113          	addi	sp,sp,-60 # 20004000 <__StackTop>
    csrw    mscratch, sp
10000044:	34011073          	csrw	mscratch,sp

    jal     sys_entry
10000048:	370000ef          	jal	ra,100003b8 <sys_entry>

1000004c <__exit>:

    .size   reset_handler, . - reset_handler

__exit:
    j      __exit
1000004c:	a001                	j	1000004c <__exit>

1000004e <ram_init>:
extern const __zero_table_t __zero_table_start__;
extern const __zero_table_t __zero_table_end__;

void ram_init(void)
{
    for (__copy_table_t const* pTable = &__copy_table_start__; pTable < &__copy_table_end__; ++pTable)
1000004e:	10002737          	lui	a4,0x10002
10000052:	6f870713          	addi	a4,a4,1784 # 100026f8 <__exidx_end>
10000056:	100027b7          	lui	a5,0x10002
1000005a:	70478793          	addi	a5,a5,1796 # 10002704 <__copy_table_end__>
1000005e:	10002637          	lui	a2,0x10002
10000062:	6f860613          	addi	a2,a2,1784 # 100026f8 <__exidx_end>
10000066:	10002537          	lui	a0,0x10002
1000006a:	70450513          	addi	a0,a0,1796 # 10002704 <__copy_table_end__>
1000006e:	04f76a63          	bltu	a4,a5,100000c2 <ram_init+0x74>
        {
            pTable->dest[i] = pTable->src[i];
        }
    }

    for (__zero_table_t const* pTable = &__zero_table_start__; pTable < &__zero_table_end__; ++pTable)
10000072:	10002737          	lui	a4,0x10002
10000076:	70470713          	addi	a4,a4,1796 # 10002704 <__copy_table_end__>
1000007a:	100027b7          	lui	a5,0x10002
1000007e:	70c78793          	addi	a5,a5,1804 # 1000270c <__etext>
10000082:	06f77563          	bgeu	a4,a5,100000ec <ram_init+0x9e>
10000086:	100026b7          	lui	a3,0x10002
1000008a:	70468793          	addi	a5,a3,1796 # 10002704 <__copy_table_end__>
1000008e:	100025b7          	lui	a1,0x10002
10000092:	70b58593          	addi	a1,a1,1803 # 1000270b <__copy_table_end__+0x7>
10000096:	8d9d                	sub	a1,a1,a5
10000098:	99e1                	andi	a1,a1,-8
1000009a:	05a1                	addi	a1,a1,8
1000009c:	95be                	add	a1,a1,a5
1000009e:	70468693          	addi	a3,a3,1796
100000a2:	a089                	j	100000e4 <ram_init+0x96>
            pTable->dest[i] = pTable->src[i];
100000a4:	00279593          	slli	a1,a5,0x2
100000a8:	4214                	lw	a3,0(a2)
100000aa:	96ae                	add	a3,a3,a1
100000ac:	4294                	lw	a3,0(a3)
100000ae:	4258                	lw	a4,4(a2)
100000b0:	972e                	add	a4,a4,a1
100000b2:	c314                	sw	a3,0(a4)
        for(uint32_t i=0u; i<pTable->wlen; ++i)
100000b4:	0785                	addi	a5,a5,1
100000b6:	4618                	lw	a4,8(a2)
100000b8:	fee7e6e3          	bltu	a5,a4,100000a4 <ram_init+0x56>
    for (__copy_table_t const* pTable = &__copy_table_start__; pTable < &__copy_table_end__; ++pTable)
100000bc:	0631                	addi	a2,a2,12
100000be:	faa67ae3          	bgeu	a2,a0,10000072 <ram_init+0x24>
        for(uint32_t i=0u; i<pTable->wlen; ++i)
100000c2:	4618                	lw	a4,8(a2)
100000c4:	4781                	li	a5,0
100000c6:	ff79                	bnez	a4,100000a4 <ram_init+0x56>
100000c8:	bfd5                	j	100000bc <ram_init+0x6e>
    {
        for(uint32_t i=0u; i<pTable->wlen; ++i)
        {
            pTable->dest[i] = 0u;
100000ca:	4298                	lw	a4,0(a3)
100000cc:	00279613          	slli	a2,a5,0x2
100000d0:	9732                	add	a4,a4,a2
100000d2:	00072023          	sw	zero,0(a4)
        for(uint32_t i=0u; i<pTable->wlen; ++i)
100000d6:	0785                	addi	a5,a5,1
100000d8:	42d8                	lw	a4,4(a3)
100000da:	fee7e8e3          	bltu	a5,a4,100000ca <ram_init+0x7c>
    for (__zero_table_t const* pTable = &__zero_table_start__; pTable < &__zero_table_end__; ++pTable)
100000de:	06a1                	addi	a3,a3,8
100000e0:	00d58663          	beq	a1,a3,100000ec <ram_init+0x9e>
        for(uint32_t i=0u; i<pTable->wlen; ++i)
100000e4:	42d8                	lw	a4,4(a3)
100000e6:	4781                	li	a5,0
100000e8:	f36d                	bnez	a4,100000ca <ram_init+0x7c>
100000ea:	bfd5                	j	100000de <ram_init+0x90>
        }
    }
}
100000ec:	8082                	ret

100000ee <SystemInit>:

void force_sleep_wakeup_check();
#endif

void SystemInit (void)
{
100000ee:	1151                	addi	sp,sp,-12
100000f0:	c406                	sw	ra,8(sp)
    EN_RTC();
100000f2:	400807b7          	lui	a5,0x40080
100000f6:	4705                	li	a4,1
100000f8:	cbb8                	sw	a4,80(a5)

    REG_WRT(0x42000100, ((XTAL_FREQ - 1) << 8) + 1);  //enable BB us tick
100000fa:	42000737          	lui	a4,0x42000
100000fe:	6785                	lui	a5,0x1
10000100:	70178793          	addi	a5,a5,1793 # 1701 <bt_buf_check_allow_sleep+0x23>
10000104:	10f72023          	sw	a5,256(a4) # 42000100 <__StackTop+0x21ffc100>

    omw_otp_load_cfg();
10000108:	2b0010ef          	jal	ra,100013b8 <omw_otp_load_cfg>
    omw_otp_apply_cfg();
1000010c:	6ac010ef          	jal	ra,100017b8 <omw_otp_apply_cfg>
    #endif

    (void)omw_sleep_clr_wkup_rec();
	#endif

    REG_WRT_MSK(0x40000024, (3 << 16 | 3 << 10), (1 << 16 | 1 << 10));
10000110:	400006b7          	lui	a3,0x40000
10000114:	52dc                	lw	a5,36(a3)
10000116:	fffcf737          	lui	a4,0xfffcf
1000011a:	3ff70713          	addi	a4,a4,1023 # fffcf3ff <__StackTop+0xdffcb3ff>
1000011e:	8ff9                	and	a5,a5,a4
10000120:	6741                	lui	a4,0x10
10000122:	40070713          	addi	a4,a4,1024 # 10400 <rom_func_end_check_val+0x679c>
10000126:	8fd9                	or	a5,a5,a4
10000128:	d2dc                	sw	a5,36(a3)
    // // UART CLK, default xtal 24m
    // REG_WRT_BITS(0x40000024, 11, 10, 1);
    // // OTP CLK
    // REG_WRT_BITS(0x40000024, 17, 16, 1);
    if((REG_RD_BYTE(0x40010212)) == 0) REG_WRT_BYTE(0x40010212, 0x20);
1000012a:	400107b7          	lui	a5,0x40010
1000012e:	2127c783          	lbu	a5,530(a5) # 40010212 <__StackTop+0x2000c212>
10000132:	0ff7f793          	zext.b	a5,a5
10000136:	e799                	bnez	a5,10000144 <SystemInit+0x56>
10000138:	400107b7          	lui	a5,0x40010
1000013c:	02000713          	li	a4,32
10000140:	20e78923          	sb	a4,530(a5) # 40010212 <__StackTop+0x2000c212>


    #ifndef OMW_EN_WDG
    // wdt_en=0
    SYS_CTRL->WDT_CFG = 0x00;
10000144:	400007b7          	lui	a5,0x40000
10000148:	10078223          	sb	zero,260(a5) # 40000104 <__StackTop+0x1fffc104>
    #endif
}
1000014c:	40a2                	lw	ra,8(sp)
1000014e:	0131                	addi	sp,sp,12
10000150:	8082                	ret

10000152 <delay_us>:

#ifdef OMW_EN_DEEP_SLEEP
__RAM_CODE_SECTION
#endif
void delay_us(uint32_t us)
{
10000152:	1171                	addi	sp,sp,-4
    volatile uint32_t cur_us = REG_RD(0x42000104);
10000154:	420007b7          	lui	a5,0x42000
10000158:	1047a783          	lw	a5,260(a5) # 42000104 <__StackTop+0x21ffc104>
1000015c:	c03e                	sw	a5,0(sp)
    while(REG_RD(0x42000104) - cur_us < us);
1000015e:	420006b7          	lui	a3,0x42000
10000162:	1046a783          	lw	a5,260(a3) # 42000104 <__StackTop+0x21ffc104>
10000166:	4702                	lw	a4,0(sp)
10000168:	8f99                	sub	a5,a5,a4
1000016a:	fea7ece3          	bltu	a5,a0,10000162 <delay_us+0x10>
}
1000016e:	0111                	addi	sp,sp,4
10000170:	8082                	ret

10000172 <delay_ms>:

void delay_ms(uint32_t ms)
{
10000172:	1151                	addi	sp,sp,-12
10000174:	c406                	sw	ra,8(sp)
    delay_us(ms * 1000);
10000176:	3e800793          	li	a5,1000
1000017a:	02f50533          	mul	a0,a0,a5
1000017e:	3fd1                	jal	10000152 <delay_us>
}
10000180:	40a2                	lw	ra,8(sp)
10000182:	0131                	addi	sp,sp,12
10000184:	8082                	ret

10000186 <omw_gpio_set_func>:
void omw_gpio_set_func(OMW_ENUM_GPIO_PIN pin, uint32_t cfg_val)
{
    volatile uint32_t * pcfg = (volatile uint32_t *)OMW_GPIO_CFG_BASE_ADDR;

    uint32_t wof = (pin >> 2);
    uint32_t bof = (pin & 3);
10000186:	00357713          	andi	a4,a0,3
    uint32_t msk = (0xFF << (8 * bof));
1000018a:	070e                	slli	a4,a4,0x3
    uint32_t rv  = *(pcfg + wof);
1000018c:	9971                	andi	a0,a0,-4
1000018e:	400107b7          	lui	a5,0x40010
10000192:	20078793          	addi	a5,a5,512 # 40010200 <__StackTop+0x2000c200>
10000196:	953e                	add	a0,a0,a5
10000198:	4114                	lw	a3,0(a0)
    uint32_t msk = (0xFF << (8 * bof));
1000019a:	0ff00793          	li	a5,255
1000019e:	00e797b3          	sll	a5,a5,a4

    rv &= (~msk);
100001a2:	fff7c793          	not	a5,a5
100001a6:	8ff5                	and	a5,a5,a3
    rv |= (cfg_val << (8 * bof));
100001a8:	00e595b3          	sll	a1,a1,a4
100001ac:	8fcd                	or	a5,a5,a1

    *(pcfg + wof) = rv;
100001ae:	c11c                	sw	a5,0(a0)

}
100001b0:	8082                	ret

100001b2 <switch_uart_clk_src>:

omw_uart_it_rx_info  uart_it_rx_info[OMW_MAX_UART_NUM] = {{0}};

void switch_uart_clk_src(uint32_t new_clk_val)
{
    uint32_t  clk_val = *(volatile uint32_t *)CLK_SWITCH_ADDR;
100001b2:	400006b7          	lui	a3,0x40000
100001b6:	52dc                	lw	a5,36(a3)

    clk_val &= (~UART_CLK_SEL_MSK);
100001b8:	777d                	lui	a4,0xfffff
100001ba:	3ff70713          	addi	a4,a4,1023 # fffff3ff <__StackTop+0xdfffb3ff>
100001be:	8ff9                	and	a5,a5,a4
    clk_val |= (new_clk_val << UART_CLK_SEL_BIT_POS);
100001c0:	052a                	slli	a0,a0,0xa
100001c2:	8d5d                	or	a0,a0,a5

    *(volatile uint32_t *)CLK_SWITCH_ADDR = clk_val;
100001c4:	d2c8                	sw	a0,36(a3)
}
100001c6:	8082                	ret

100001c8 <wait_uart_not_busy>:

void wait_uart_not_busy(uint32_t * uart_base_addr)
{
    volatile uint32_t * uart_cfg_addr = uart_base_addr;

    while(uart_cfg_addr[OMW_UART_USR] & 0x1)
100001c8:	5d7c                	lw	a5,124(a0)
100001ca:	8b85                	andi	a5,a5,1
100001cc:	c791                	beqz	a5,100001d8 <wait_uart_not_busy+0x10>
    {
        if (uart_cfg_addr[OMW_UART_LSR] & 0x1)
100001ce:	495c                	lw	a5,20(a0)
100001d0:	8b85                	andi	a5,a5,1
100001d2:	dbfd                	beqz	a5,100001c8 <wait_uart_not_busy>
        {
            uart_cfg_addr[OMW_UART_RBR];
100001d4:	411c                	lw	a5,0(a0)
100001d6:	bfcd                	j	100001c8 <wait_uart_not_busy>
        }
    }
}
100001d8:	8082                	ret

100001da <omw_uart_set_baudrate>:
{
	SYS_CTRL->SYS_CLKSEL_b.REG_UART_CLK_SEL = uart_clk;
}

void omw_uart_set_baudrate(uint32_t * uart_base_addr, uint32_t cfg_val)
{
100001da:	1151                	addi	sp,sp,-12
100001dc:	c406                	sw	ra,8(sp)
100001de:	c222                	sw	s0,4(sp)
100001e0:	c026                	sw	s1,0(sp)
100001e2:	842a                	mv	s0,a0
100001e4:	84ae                	mv	s1,a1
    volatile uint32_t * uart_cfg_addr = uart_base_addr;

    wait_uart_not_busy(uart_base_addr);
100001e6:	37cd                	jal	100001c8 <wait_uart_not_busy>

    //not busy
    uart_cfg_addr[OMW_UART_LCR] |= OMW_LCR_SET_DLAB;
100001e8:	445c                	lw	a5,12(s0)
100001ea:	0807e793          	ori	a5,a5,128
100001ee:	c45c                	sw	a5,12(s0)

    /* DLL and DLH is lower 8-bits and higher 8-bits of cfg_val.*/
    uart_cfg_addr[OMW_UART_DLL] = cfg_val & 0xff;
100001f0:	0ff4f793          	zext.b	a5,s1
100001f4:	c01c                	sw	a5,0(s0)
    uart_cfg_addr[OMW_UART_DLH] = (cfg_val >> 8) & 0xff;
100001f6:	0084d793          	srli	a5,s1,0x8
100001fa:	0ff7f793          	zext.b	a5,a5
100001fe:	c05c                	sw	a5,4(s0)

    uart_cfg_addr[OMW_UART_DLF] = ((cfg_val >> 16) & 0xF);
10000200:	0104d793          	srli	a5,s1,0x10
10000204:	8bbd                	andi	a5,a5,15
10000206:	0cf42023          	sw	a5,192(s0)

    uart_cfg_addr[OMW_UART_LCR] &= (~OMW_LCR_SET_DLAB);
1000020a:	445c                	lw	a5,12(s0)
1000020c:	f7f7f793          	andi	a5,a5,-129
10000210:	c45c                	sw	a5,12(s0)

    if ((cfg_val >> 24) != 0xFF)
10000212:	0184d513          	srli	a0,s1,0x18
10000216:	0ff00793          	li	a5,255
1000021a:	00f51763          	bne	a0,a5,10000228 <omw_uart_set_baudrate+0x4e>
    {
        switch_uart_clk_src(cfg_val >> 24);
    }
}
1000021e:	40a2                	lw	ra,8(sp)
10000220:	4412                	lw	s0,4(sp)
10000222:	4482                	lw	s1,0(sp)
10000224:	0131                	addi	sp,sp,12
10000226:	8082                	ret
        switch_uart_clk_src(cfg_val >> 24);
10000228:	3769                	jal	100001b2 <switch_uart_clk_src>
}
1000022a:	bfd5                	j	1000021e <omw_uart_set_baudrate+0x44>

1000022c <omw_uart_init>:

void omw_uart_init(uint32_t * uart_base_addr, uint32_t baudrate, uint32_t rx_it_mode)
{
1000022c:	1121                	addi	sp,sp,-24
1000022e:	ca06                	sw	ra,20(sp)
10000230:	c822                	sw	s0,16(sp)
10000232:	c626                	sw	s1,12(sp)
10000234:	842a                	mv	s0,a0
10000236:	84ae                	mv	s1,a1
10000238:	c232                	sw	a2,4(sp)
    volatile uint32_t * uart_cfg_addr = uart_base_addr;
    int divisor = ((omw_get_uart_clk() / baudrate) >> 4) | (0xFF << 24);
1000023a:	28c9                	jal	1000030c <omw_get_uart_clk>
1000023c:	029555b3          	divu	a1,a0,s1
10000240:	8191                	srli	a1,a1,0x4
10000242:	ff0007b7          	lui	a5,0xff000
10000246:	8fcd                	or	a5,a5,a1
10000248:	c03e                	sw	a5,0(sp)
	int divf = ((((omw_get_uart_clk()<<4) / baudrate)+ 0xF)>>4)&0xF;
1000024a:	20c9                	jal	1000030c <omw_get_uart_clk>
1000024c:	00451593          	slli	a1,a0,0x4
10000250:	0295d5b3          	divu	a1,a1,s1
10000254:	05bd                	addi	a1,a1,15
    divisor |= divf<<16;
10000256:	05b2                	slli	a1,a1,0xc
10000258:	000f07b7          	lui	a5,0xf0
1000025c:	8dfd                	and	a1,a1,a5
1000025e:	4782                	lw	a5,0(sp)
10000260:	8ddd                	or	a1,a1,a5
    uint8_t uart_idx = (OMW_UART1 == uart_base_addr);
10000262:	beffe7b7          	lui	a5,0xbeffe
10000266:	97a2                	add	a5,a5,s0
10000268:	0017b793          	seqz	a5,a5

    RESET_UART(uart_idx);
1000026c:	07a9                	addi	a5,a5,10
1000026e:	4705                	li	a4,1
10000270:	00f717b3          	sll	a5,a4,a5
10000274:	40000737          	lui	a4,0x40000
10000278:	c71c                	sw	a5,8(a4)
1000027a:	c402                	sw	zero,8(sp)
1000027c:	4722                	lw	a4,8(sp)
1000027e:	47a5                	li	a5,9
10000280:	00e7c963          	blt	a5,a4,10000292 <omw_uart_init+0x66>
10000284:	4725                	li	a4,9
10000286:	47a2                	lw	a5,8(sp)
10000288:	0785                	addi	a5,a5,1
1000028a:	c43e                	sw	a5,8(sp)
1000028c:	47a2                	lw	a5,8(sp)
1000028e:	fef75ce3          	bge	a4,a5,10000286 <omw_uart_init+0x5a>
10000292:	400007b7          	lui	a5,0x40000
10000296:	0007a423          	sw	zero,8(a5) # 40000008 <__StackTop+0x1fffc008>

    //make uart device in idle state before starting to config
    uart_cfg_addr[OMW_UART_LCR] = 0x83;
1000029a:	08300793          	li	a5,131
1000029e:	c45c                	sw	a5,12(s0)
    uart_cfg_addr[OMW_UART_DLL] = 0x1;
100002a0:	4785                	li	a5,1
100002a2:	c01c                	sw	a5,0(s0)
    uart_cfg_addr[OMW_UART_DLH] = 0x0;
100002a4:	00042223          	sw	zero,4(s0)
    uart_cfg_addr[OMW_UART_FCR] = 0x1;
100002a8:	c41c                	sw	a5,8(s0)

    /////////////////start config//////////////////
    omw_uart_set_baudrate(uart_base_addr, divisor);
100002aa:	8522                	mv	a0,s0
100002ac:	373d                	jal	100001da <omw_uart_set_baudrate>

    //SetParity: NONE
    uart_cfg_addr[OMW_UART_LCR] &= (~OMW_LCR_PARITY_ENABLE);
100002ae:	445c                	lw	a5,12(s0)
100002b0:	9bdd                	andi	a5,a5,-9
100002b2:	c45c                	sw	a5,12(s0)

    //SetWordSize: LCR_WORD_SIZE_8
    uart_cfg_addr[OMW_UART_LCR] |= OMW_LCR_WORD_SIZE_8;
100002b4:	445c                	lw	a5,12(s0)
100002b6:	0037e793          	ori	a5,a5,3
100002ba:	c45c                	sw	a5,12(s0)

    //SetStopBit: LCR_STOP_BIT_1
    uart_cfg_addr[OMW_UART_LCR] &= OMW_LCR_STOP_BIT1;
100002bc:	445c                	lw	a5,12(s0)
100002be:	0fb7f793          	andi	a5,a5,251
100002c2:	c45c                	sw	a5,12(s0)

    if (!rx_it_mode)
100002c4:	4792                	lw	a5,4(sp)
100002c6:	ef99                	bnez	a5,100002e4 <omw_uart_init+0xb8>
    {
        //SetRXMode: Query mode
        uart_cfg_addr[OMW_UART_IER] &= (~OMW_IER_RDA_INT_ENABLE);
100002c8:	405c                	lw	a5,4(s0)
100002ca:	9bf9                	andi	a5,a5,-2
100002cc:	c05c                	sw	a5,4(s0)
        //SetRXMode: INT mode
        uart_cfg_addr[OMW_UART_IER] |= OMW_IER_RDA_INT_ENABLE;
    }

    //SetTXMode: Query mode
    uart_cfg_addr[OMW_UART_IER] &= (~OMW_IER_THRE_INT_ENABLE);
100002ce:	405c                	lw	a5,4(s0)
100002d0:	9bf5                	andi	a5,a5,-3
100002d2:	c05c                	sw	a5,4(s0)

    //SetFIFOMode
    uart_cfg_addr[OMW_UART_FCR] =  ((UART_RCV_TRI<<6)  | 1);
100002d4:	04100793          	li	a5,65
100002d8:	c41c                	sw	a5,8(s0)
}
100002da:	40d2                	lw	ra,20(sp)
100002dc:	4442                	lw	s0,16(sp)
100002de:	44b2                	lw	s1,12(sp)
100002e0:	0161                	addi	sp,sp,24
100002e2:	8082                	ret
        uart_cfg_addr[OMW_UART_IER] |= OMW_IER_RDA_INT_ENABLE;
100002e4:	405c                	lw	a5,4(s0)
100002e6:	0017e793          	ori	a5,a5,1
100002ea:	c05c                	sw	a5,4(s0)
100002ec:	b7cd                	j	100002ce <omw_uart_init+0xa2>

100002ee <omw_uart_send>:

    #ifdef OMW_HAS_SCH
    __disable_irq();
    #endif

    while (pos < len)
100002ee:	ce11                	beqz	a2,1000030a <omw_uart_send+0x1c>
100002f0:	872e                	mv	a4,a1
100002f2:	00c586b3          	add	a3,a1,a2
    {
        while (!(uart_cfg_addr[OMW_UART_LSR] & OMW_LSR_TRANS_EMPTY));
100002f6:	495c                	lw	a5,20(a0)
100002f8:	0207f793          	andi	a5,a5,32
100002fc:	dfed                	beqz	a5,100002f6 <omw_uart_send+0x8>

        uart_cfg_addr[OMW_UART_THR] = ptmp[pos++];
100002fe:	00074783          	lbu	a5,0(a4) # 40000000 <__StackTop+0x1fffc000>
10000302:	c11c                	sw	a5,0(a0)
    while (pos < len)
10000304:	0705                	addi	a4,a4,1
10000306:	fed718e3          	bne	a4,a3,100002f6 <omw_uart_send+0x8>
    }

    #ifdef OMW_HAS_SCH
    __enable_irq();
    #endif
}
1000030a:	8082                	ret

1000030c <omw_get_uart_clk>:

uint8_t  uart_irq_id[OMW_MAX_UART_NUM] = {UART0_IRQn, UART1_IRQn};

uint32_t omw_get_uart_clk()
{
    if( SYS_CTRL->SYS_CLKSEL_b.REG_UART_CLK_SEL == 2)
1000030c:	400007b7          	lui	a5,0x40000
10000310:	53dc                	lw	a5,36(a5)
10000312:	83a9                	srli	a5,a5,0xa
10000314:	8b8d                	andi	a5,a5,3
10000316:	4709                	li	a4,2
10000318:	00e78763          	beq	a5,a4,10000326 <omw_get_uart_clk+0x1a>
    {
        return (XTAL_FREQ) * 2000000;
    }
    else
    {
        return (XTAL_FREQ) * 1000000;
1000031c:	016e3537          	lui	a0,0x16e3
10000320:	60050513          	addi	a0,a0,1536 # 16e3600 <__ROM_SIZE+0x16a3600>
10000324:	8082                	ret
        return (XTAL_FREQ) * 2000000;
10000326:	02dc7537          	lui	a0,0x2dc7
1000032a:	c0050513          	addi	a0,a0,-1024 # 2dc6c00 <__ROM_SIZE+0x2d86c00>
    }
}
1000032e:	8082                	ret

10000330 <Default_Handler>:
    main();
}

void Default_Handler(void)
{
    GLOBAL_INT_STOP();
10000330:	300477f3          	csrrci	a5,mstatus,8

    while(1);
10000334:	a001                	j	10000334 <Default_Handler+0x4>

10000336 <clic_init>:
    CLIC->CLICCFG = (((CLIC->CLICINFO & CLIC_INFO_CLICINTCTLBITS_Msk) >> CLIC_INFO_CLICINTCTLBITS_Pos) << CLIC_CLICCFG_NLBIT_Pos);
10000336:	e0800737          	lui	a4,0xe0800
1000033a:	435c                	lw	a5,4(a4)
1000033c:	83d1                	srli	a5,a5,0x14
1000033e:	8bf9                	andi	a5,a5,30
10000340:	00f70023          	sb	a5,0(a4) # e0800000 <__StackTop+0xc07fc000>
    for (i = 0; i < 48; i++) {
10000344:	4701                	li	a4,0
10000346:	e0800537          	lui	a0,0xe0800
        CLIC->CLICINT[i].IP = 1;
1000034a:	6585                	lui	a1,0x1
1000034c:	4685                	li	a3,1
    for (i = 0; i < 48; i++) {
1000034e:	03000613          	li	a2,48
        CLIC->CLICINT[i].IP = 1;
10000352:	00271793          	slli	a5,a4,0x2
10000356:	97aa                	add	a5,a5,a0
10000358:	97ae                	add	a5,a5,a1
1000035a:	00d78023          	sb	a3,0(a5) # 40000000 <__StackTop+0x1fffc000>
        CLIC->CLICINT[i].IE = 0;
1000035e:	000780a3          	sb	zero,1(a5)
        CLIC->CLICINT[i].ATTR = 1; /* use vector interrupt */
10000362:	00d78123          	sb	a3,2(a5)
    for (i = 0; i < 48; i++) {
10000366:	0705                	addi	a4,a4,1
10000368:	fec715e3          	bne	a4,a2,10000352 <clic_init+0x1c>
    ADD_IRQ_HANDLE(RADIO_DMA_IRQn, RADIO_DMA_Handler);
1000036c:	200017b7          	lui	a5,0x20001
10000370:	b8078793          	addi	a5,a5,-1152 # 20000b80 <__VECTOR_TABLE>
10000374:	10000737          	lui	a4,0x10000
10000378:	33070713          	addi	a4,a4,816 # 10000330 <Default_Handler>
1000037c:	c7b8                	sw	a4,72(a5)
    ADD_IRQ_HANDLE(RADIO_TICK_IRQn, RADIO_TICK_Handler);
1000037e:	10000737          	lui	a4,0x10000
10000382:	33070713          	addi	a4,a4,816 # 10000330 <Default_Handler>
10000386:	c7f8                	sw	a4,76(a5)
    ADD_IRQ_HANDLE(UART1_IRQn, UART1_Handler);
10000388:	10000737          	lui	a4,0x10000
1000038c:	33070713          	addi	a4,a4,816 # 10000330 <Default_Handler>
10000390:	d3f8                	sw	a4,100(a5)
    ADD_IRQ_HANDLE(RTC_IRQn, RTC_Handler);
10000392:	10000737          	lui	a4,0x10000
10000396:	33070713          	addi	a4,a4,816 # 10000330 <Default_Handler>
1000039a:	08e7aa23          	sw	a4,148(a5)
	ADD_IRQ_HANDLE(TIMER1_IRQn, TIMER1_Handler);
1000039e:	10000737          	lui	a4,0x10000
100003a2:	33070713          	addi	a4,a4,816 # 10000330 <Default_Handler>
100003a6:	0ae7a223          	sw	a4,164(a5)
	ADD_IRQ_HANDLE(TIMER7_IRQn, TIMER7_Handler);
100003aa:	10000737          	lui	a4,0x10000
100003ae:	33070713          	addi	a4,a4,816 # 10000330 <Default_Handler>
100003b2:	0ae7ae23          	sw	a4,188(a5)
}
100003b6:	8082                	ret

100003b8 <sys_entry>:
{
100003b8:	1151                	addi	sp,sp,-12
100003ba:	c406                	sw	ra,8(sp)
    ram_init();
100003bc:	3949                	jal	1000004e <ram_init>
    clic_init();
100003be:	3fa5                	jal	10000336 <clic_init>
    SystemInit();
100003c0:	333d                	jal	100000ee <SystemInit>
    GLOBAL_INT_START();
100003c2:	300467f3          	csrrsi	a5,mstatus,8
    main();
100003c6:	4da010ef          	jal	ra,100018a0 <main>
}
100003ca:	40a2                	lw	ra,8(sp)
100003cc:	0131                	addi	sp,sp,12
100003ce:	8082                	ret

100003d0 <GPADC_InternalParseVoltageSample>:

static void GPADC_InternalParseVoltageSample(uint32_t d, uint32_t sd, uint32_t *v, uint32_t *s)
{
    uint32_t tv, ts;
    // voltage
    tv = (d >> 0) & 0xfff; // 12-bit
100003d0:	01451713          	slli	a4,a0,0x14
    tv *= GPADC_FIX_COEF;
100003d4:	8331                	srli	a4,a4,0xc
    // sample
    if((((d >> 14) & 1) == 1) && (((d >> 30) & 1) == 0)){ // 14-bit, already extend 4-bit
100003d6:	00e55793          	srli	a5,a0,0xe
100003da:	8b85                	andi	a5,a5,1
100003dc:	cb99                	beqz	a5,100003f2 <GPADC_InternalParseVoltageSample+0x22>
100003de:	01e55793          	srli	a5,a0,0x1e
100003e2:	8b85                	andi	a5,a5,1
100003e4:	e799                	bnez	a5,100003f2 <GPADC_InternalParseVoltageSample+0x22>
        ts = (d >> 16) & 0x3fff;
100003e6:	00251793          	slli	a5,a0,0x2
100003ea:	83c9                	srli	a5,a5,0x12
        ts *= (GPADC_FIX_COEF/16);
100003ec:	00479513          	slli	a0,a5,0x4
100003f0:	a029                	j	100003fa <GPADC_InternalParseVoltageSample+0x2a>
    } else { // 10-bit
        ts = (d >> 16) & 0x3ff;
100003f2:	8141                	srli	a0,a0,0x10
100003f4:	3ff57513          	andi	a0,a0,1023
        ts *= GPADC_FIX_COEF;
100003f8:	0522                	slli	a0,a0,0x8
    }
    // return
    *v = tv;
100003fa:	c218                	sw	a4,0(a2)
    *s = ts + sd;
100003fc:	952e                	add	a0,a0,a1
100003fe:	c288                	sw	a0,0(a3)
}
10000400:	8082                	ret

10000402 <GPADC_InternalSearchVoltageOffset>:
#define GPADC_STBL_VBAT_HI      33336
#define GPADC_STBL_COL_NUM      16


static uint16_t GPADC_InternalSearchVoltageOffset(uint16_t volt, uint16_t div_sel)
{
10000402:	1121                	addi	sp,sp,-24
10000404:	ca22                	sw	s0,20(sp)
10000406:	c826                	sw	s1,16(sp)
    int16_t col_lo, col_hi, row_lo, row_hi, rem;
    int16_t ofst, ofst_hi, ofst_lo;
    int16_t * stbl;
    //uint16_t volt_max[] = {0, 17408, 26624, 36864};
    uint16_t volt_min[] = {0, 2048,  13312, 23552};
10000408:	00011423          	sh	zero,8(sp)
1000040c:	6785                	lui	a5,0x1
1000040e:	80078793          	addi	a5,a5,-2048 # 800 <__STACK_SIZE+0x500>
10000412:	00f11523          	sh	a5,10(sp)
10000416:	678d                	lui	a5,0x3
10000418:	40078793          	addi	a5,a5,1024 # 3400 <isr_adv_isr_handle_cb+0x54>
1000041c:	00f11623          	sh	a5,12(sp)
10000420:	6799                	lui	a5,0x6
10000422:	c0078793          	addi	a5,a5,-1024 # 5c00 <hci_send_cmd_le_set_adv_enable+0xaa>
10000426:	00f11723          	sh	a5,14(sp)
    uint16_t volt_row[] = {0, 15,    13,    10}; // minus 1
1000042a:	00011023          	sh	zero,0(sp)
1000042e:	47bd                	li	a5,15
10000430:	00f11123          	sh	a5,2(sp)
10000434:	47b5                	li	a5,13
10000436:	00f11223          	sh	a5,4(sp)
1000043a:	47a9                	li	a5,10
1000043c:	00f11323          	sh	a5,6(sp)
    // search table column select
    col_lo = (g_gpadc_vbat - GPADC_STBL_VBAT_LO) >> 10;
10000440:	200017b7          	lui	a5,0x20001
10000444:	c827d783          	lhu	a5,-894(a5) # 20000c82 <g_gpadc_vbat>
    col_hi = col_lo + 1;
    if (g_gpadc_vbat <= GPADC_STBL_VBAT_LO)
10000448:	6711                	lui	a4,0x4
1000044a:	63870713          	addi	a4,a4,1592 # 4638 <ll_process_tx_acl_buf+0x92>
1000044e:	02f77363          	bgeu	a4,a5,10000474 <GPADC_InternalSearchVoltageOffset+0x72>
    {
        col_lo = 0;
        col_hi = 0;
    }
    else if (g_gpadc_vbat >= GPADC_STBL_VBAT_HI)
10000452:	6721                	lui	a4,0x8
10000454:	23770713          	addi	a4,a4,567 # 8237 <bt_gatt_disconnected+0x5b>
10000458:	04f76a63          	bltu	a4,a5,100004ac <GPADC_InternalSearchVoltageOffset+0xaa>
    col_lo = (g_gpadc_vbat - GPADC_STBL_VBAT_LO) >> 10;
1000045c:	7371                	lui	t1,0xffffc
1000045e:	9c830313          	addi	t1,t1,-1592 # ffffb9c8 <__StackTop+0xdfff79c8>
10000462:	933e                	add	t1,t1,a5
10000464:	40a35313          	srai	t1,t1,0xa
10000468:	841a                	mv	s0,t1
    col_hi = col_lo + 1;
1000046a:	0305                	addi	t1,t1,1
1000046c:	0342                	slli	t1,t1,0x10
1000046e:	41035313          	srai	t1,t1,0x10
10000472:	a019                	j	10000478 <GPADC_InternalSearchVoltageOffset+0x76>
        col_hi = 0;
10000474:	4301                	li	t1,0
        col_lo = 0;
10000476:	4401                	li	s0,0
    {
        col_lo = 15;
        col_hi = 15;
    }
    // search table row select
    row_lo = (volt - volt_min[div_sel]) >> 10;
10000478:	00159713          	slli	a4,a1,0x1
1000047c:	0741                	addi	a4,a4,16
1000047e:	970a                	add	a4,a4,sp
10000480:	ff875383          	lhu	t2,-8(a4)
10000484:	407503b3          	sub	t2,a0,t2
10000488:	40a3d393          	srai	t2,t2,0xa
1000048c:	869e                	mv	a3,t2
    row_hi = row_lo + 1;
    if (row_lo < 0)
1000048e:	0203c763          	bltz	t2,100004bc <GPADC_InternalSearchVoltageOffset+0xba>
    {
        row_lo = 0;
        row_hi = row_lo;
    }
    else if (row_lo >= volt_row[div_sel])
10000492:	00159713          	slli	a4,a1,0x1
10000496:	0741                	addi	a4,a4,16
10000498:	970a                	add	a4,a4,sp
1000049a:	ff075703          	lhu	a4,-16(a4)
1000049e:	00e3da63          	bge	t2,a4,100004b2 <GPADC_InternalSearchVoltageOffset+0xb0>
    row_hi = row_lo + 1;
100004a2:	0385                	addi	t2,t2,1
100004a4:	03c2                	slli	t2,t2,0x10
100004a6:	4103d393          	srai	t2,t2,0x10
100004aa:	a819                	j	100004c0 <GPADC_InternalSearchVoltageOffset+0xbe>
        col_hi = 15;
100004ac:	433d                	li	t1,15
        col_lo = 15;
100004ae:	443d                	li	s0,15
100004b0:	b7e1                	j	10000478 <GPADC_InternalSearchVoltageOffset+0x76>
    {
        row_lo = volt_row[div_sel];
100004b2:	01071693          	slli	a3,a4,0x10
100004b6:	86c1                	srai	a3,a3,0x10
        row_hi = row_lo;
100004b8:	83b6                	mv	t2,a3
100004ba:	a019                	j	100004c0 <GPADC_InternalSearchVoltageOffset+0xbe>
        row_hi = row_lo;
100004bc:	4381                	li	t2,0
        row_lo = 0;
100004be:	4681                	li	a3,0
    }
    // column search
    stbl = (int16_t *)(gpadc_ofst_array[div_sel]);
100004c0:	00259713          	slli	a4,a1,0x2
100004c4:	200015b7          	lui	a1,0x20001
100004c8:	b0058593          	addi	a1,a1,-1280 # 20000b00 <gpadc_ofst_array>
100004cc:	95ba                	add	a1,a1,a4
100004ce:	0005a283          	lw	t0,0(a1)
    rem = (g_gpadc_vbat - GPADC_STBL_VBAT_LO) & 0x3ff;
    ofst_lo = stbl[row_lo*GPADC_STBL_COL_NUM + col_lo] + (((stbl[row_lo*GPADC_STBL_COL_NUM + col_hi] - stbl[row_lo*GPADC_STBL_COL_NUM + col_lo])*rem)>>10);
100004d2:	0692                	slli	a3,a3,0x4
100004d4:	00868733          	add	a4,a3,s0
100004d8:	0706                	slli	a4,a4,0x1
100004da:	9716                	add	a4,a4,t0
100004dc:	00071483          	lh	s1,0(a4)
    rem = (g_gpadc_vbat - GPADC_STBL_VBAT_LO) & 0x3ff;
100004e0:	1c878793          	addi	a5,a5,456
    ofst_lo = stbl[row_lo*GPADC_STBL_COL_NUM + col_lo] + (((stbl[row_lo*GPADC_STBL_COL_NUM + col_hi] - stbl[row_lo*GPADC_STBL_COL_NUM + col_lo])*rem)>>10);
100004e4:	3ff7f593          	andi	a1,a5,1023
100004e8:	00668633          	add	a2,a3,t1
100004ec:	0606                	slli	a2,a2,0x1
100004ee:	9616                	add	a2,a2,t0
100004f0:	00061703          	lh	a4,0(a2)
100004f4:	8f05                	sub	a4,a4,s1
100004f6:	02b70733          	mul	a4,a4,a1
100004fa:	8729                	srai	a4,a4,0xa
100004fc:	9726                	add	a4,a4,s1
    ofst_hi = stbl[row_hi*GPADC_STBL_COL_NUM + col_lo] + (((stbl[row_hi*GPADC_STBL_COL_NUM + col_hi] - stbl[row_hi*GPADC_STBL_COL_NUM + col_lo])*rem)>>10);
100004fe:	0392                	slli	t2,t2,0x4
10000500:	007406b3          	add	a3,s0,t2
10000504:	0686                	slli	a3,a3,0x1
10000506:	9696                	add	a3,a3,t0
10000508:	00069683          	lh	a3,0(a3) # 40000000 <__StackTop+0x1fffc000>
1000050c:	931e                	add	t1,t1,t2
1000050e:	0306                	slli	t1,t1,0x1
10000510:	929a                	add	t0,t0,t1
10000512:	00029783          	lh	a5,0(t0)
10000516:	8f95                	sub	a5,a5,a3
10000518:	02b787b3          	mul	a5,a5,a1
1000051c:	87a9                	srai	a5,a5,0xa
1000051e:	97b6                	add	a5,a5,a3
    // row search
    rem = volt & 0x3ff;
    ofst = ofst_lo + (((ofst_hi - ofst_lo)*rem)>>10);
10000520:	07c2                	slli	a5,a5,0x10
10000522:	87c1                	srai	a5,a5,0x10
10000524:	01071693          	slli	a3,a4,0x10
10000528:	86c1                	srai	a3,a3,0x10
1000052a:	8f95                	sub	a5,a5,a3
1000052c:	3ff57693          	andi	a3,a0,1023
10000530:	02d787b3          	mul	a5,a5,a3
10000534:	87a9                	srai	a5,a5,0xa
10000536:	953a                	add	a0,a0,a4
#ifdef GPADC_DEBUG_PRINT
    printf("volt:%d, vbat:%d, offset:%d\n", volt, g_gpadc_vbat, ofst);
    printf("col_lo:%d, row_lo:%d \n", col_lo, row_lo);
    printf("col_hi:%d, row_hi:%d \n", col_hi, row_hi);
#endif
    volt += ofst;
10000538:	953e                	add	a0,a0,a5
    return volt;
}
1000053a:	0542                	slli	a0,a0,0x10
1000053c:	8141                	srli	a0,a0,0x10
1000053e:	4452                	lw	s0,20(sp)
10000540:	44c2                	lw	s1,16(sp)
10000542:	0161                	addi	sp,sp,24
10000544:	8082                	ret

10000546 <GPADC_InternalSearchBATVoltageOffset>:
    int16_t offset;
    int i = (vbat - GPADC_STBL_VBAT_LO) >> 10;
#ifdef GPADC_DEBUG_PRINT
    printf("vbat:%d, i:%d\n", vbat, i);
#endif
    if(vbat < GPADC_STBL_VBAT_LO){
10000546:	6791                	lui	a5,0x4
10000548:	63778793          	addi	a5,a5,1591 # 4637 <ll_process_tx_acl_buf+0x91>
1000054c:	04a7f763          	bgeu	a5,a0,1000059a <GPADC_InternalSearchBATVoltageOffset+0x54>
        offset = gpadc_batvoltoffset[0];
    }
    else if(vbat >= GPADC_STBL_VBAT_HI){
10000550:	6721                	lui	a4,0x8
10000552:	23770713          	addi	a4,a4,567 # 8237 <bt_gatt_disconnected+0x5b>
        offset = gpadc_batvoltoffset[15];
10000556:	fa500793          	li	a5,-91
    else if(vbat >= GPADC_STBL_VBAT_HI){
1000055a:	04a76263          	bltu	a4,a0,1000059e <GPADC_InternalSearchBATVoltageOffset+0x58>
    int i = (vbat - GPADC_STBL_VBAT_LO) >> 10;
1000055e:	7771                	lui	a4,0xffffc
10000560:	9c870713          	addi	a4,a4,-1592 # ffffb9c8 <__StackTop+0xdfff79c8>
10000564:	972a                	add	a4,a4,a0
10000566:	40a75613          	srai	a2,a4,0xa
    }
    else{
        int remainder = (vbat - GPADC_STBL_VBAT_LO) & 0x3ff;
        offset = gpadc_batvoltoffset[i] + (((gpadc_batvoltoffset[i+1] - gpadc_batvoltoffset[i]) * remainder) >> 10);
1000056a:	100026b7          	lui	a3,0x10002
1000056e:	cf068693          	addi	a3,a3,-784 # 10001cf0 <gpadc_batvoltoffset>
10000572:	00161793          	slli	a5,a2,0x1
10000576:	97b6                	add	a5,a5,a3
10000578:	00079583          	lh	a1,0(a5)
1000057c:	0605                	addi	a2,a2,1
1000057e:	0606                	slli	a2,a2,0x1
10000580:	96b2                	add	a3,a3,a2
10000582:	00069783          	lh	a5,0(a3)
10000586:	8f8d                	sub	a5,a5,a1
        int remainder = (vbat - GPADC_STBL_VBAT_LO) & 0x3ff;
10000588:	3ff77713          	andi	a4,a4,1023
        offset = gpadc_batvoltoffset[i] + (((gpadc_batvoltoffset[i+1] - gpadc_batvoltoffset[i]) * remainder) >> 10);
1000058c:	02e787b3          	mul	a5,a5,a4
10000590:	87a9                	srai	a5,a5,0xa
10000592:	97ae                	add	a5,a5,a1
10000594:	07c2                	slli	a5,a5,0x10
10000596:	87c1                	srai	a5,a5,0x10
10000598:	a019                	j	1000059e <GPADC_InternalSearchBATVoltageOffset+0x58>
        offset = gpadc_batvoltoffset[0];
1000059a:	f0b00793          	li	a5,-245
    }
#ifdef GPADC_DEBUG_PRINT
    printf("vbat:%d, offset:%d\n", vbat, offset);
#endif
    vbat = vbat + offset;
1000059e:	953e                	add	a0,a0,a5
    return vbat;
}
100005a0:	0542                	slli	a0,a0,0x10
100005a2:	8141                	srli	a0,a0,0x10
100005a4:	8082                	ret

100005a6 <GPADC_Init>:
    *(volatile int *)(0x40000028) |= (1<<15);
100005a6:	40000737          	lui	a4,0x40000
100005aa:	571c                	lw	a5,40(a4)
100005ac:	66a1                	lui	a3,0x8
100005ae:	8fd5                	or	a5,a5,a3
100005b0:	d71c                	sw	a5,40(a4)
    if (GPADC_InitStruct->GPADC_PositiveInputChannel == GPADC_CHANNEL_P_BAT)
100005b2:	00954703          	lbu	a4,9(a0) # e0800009 <__StackTop+0xc07fc009>
100005b6:	47a5                	li	a5,9
100005b8:	10f70163          	beq	a4,a5,100006ba <GPADC_Init+0x114>
        GPADC_ANA->GPADC_CTRL =     (GPADC_InitStruct->GPADC_InputDivide << 13)         |
100005bc:	00054783          	lbu	a5,0(a0)
100005c0:	07b6                	slli	a5,a5,0xd
                                    (GPADC_InitStruct->GPADC_NegativeInputChannel << 4) |
100005c2:	00854683          	lbu	a3,8(a0)
100005c6:	0692                	slli	a3,a3,0x4
100005c8:	8fd5                	or	a5,a5,a3
100005ca:	8fd9                	or	a5,a5,a4
                                    (GPADC_InitStruct->GPADC_DiffEN << 12)              |
100005cc:	4158                	lw	a4,4(a0)
100005ce:	0732                	slli	a4,a4,0xc
                                    (GPADC_InitStruct->GPADC_NegativeInputChannel << 4) |
100005d0:	8fd9                	or	a5,a5,a4
100005d2:	6705                	lui	a4,0x1
100005d4:	80070713          	addi	a4,a4,-2048 # 800 <__STACK_SIZE+0x500>
100005d8:	8fd9                	or	a5,a5,a4
100005da:	07c2                	slli	a5,a5,0x10
100005dc:	83c1                	srli	a5,a5,0x10
        GPADC_ANA->GPADC_CTRL =     (GPADC_InitStruct->GPADC_InputDivide << 13)         |
100005de:	40040737          	lui	a4,0x40040
100005e2:	00f71223          	sh	a5,4(a4) # 40040004 <__StackTop+0x2003c004>
    GPADC_DIG->GPADC_ACTION =   (GPADC_InitStruct->GPADC_AverageWindow << 12)       |
100005e6:	00a54783          	lbu	a5,10(a0)
100005ea:	07b2                	slli	a5,a5,0xc
                                (GPADC_InitStruct->GPADC_TimerSelect << 4)          |
100005ec:	01054703          	lbu	a4,16(a0)
100005f0:	0712                	slli	a4,a4,0x4
    GPADC_DIG->GPADC_ACTION =   (GPADC_InitStruct->GPADC_AverageWindow << 12)       |
100005f2:	8fd9                	or	a5,a5,a4
                                (GPADC_InitStruct->GPADC_TimerTrigEN << 3)          |
100005f4:	4558                	lw	a4,12(a0)
100005f6:	070e                	slli	a4,a4,0x3
                                (GPADC_InitStruct->GPADC_ContinueMode << 2)         ;
100005f8:	4954                	lw	a3,20(a0)
100005fa:	068a                	slli	a3,a3,0x2
                                (GPADC_InitStruct->GPADC_TimerTrigEN << 3)          |
100005fc:	8f55                	or	a4,a4,a3
100005fe:	8fd9                	or	a5,a5,a4
    GPADC_DIG->GPADC_ACTION =   (GPADC_InitStruct->GPADC_AverageWindow << 12)       |
10000600:	40040737          	lui	a4,0x40040
10000604:	06070693          	addi	a3,a4,96 # 40040060 <__StackTop+0x2003c060>
10000608:	d33c                	sw	a5,96(a4)
                                (GPADC_InitStruct->GPADC_ClkAutoGate << 1)          |
1000060a:	4d5c                	lw	a5,28(a0)
1000060c:	0786                	slli	a5,a5,0x1
                                (GPADC_InitStruct->GPADC_ClkSelect << 0)            ;
1000060e:	01954703          	lbu	a4,25(a0)
                                (GPADC_InitStruct->GPADC_ClkAutoGate << 1)          |
10000612:	8fd9                	or	a5,a5,a4
    GPADC_DIG->GPADC_CLK_CTRL = (GPADC_InitStruct->GPADC_ClkDivide << 8)            |
10000614:	01854703          	lbu	a4,24(a0)
10000618:	0722                	slli	a4,a4,0x8
                                (GPADC_InitStruct->GPADC_ClkAutoGate << 1)          |
1000061a:	8fd9                	or	a5,a5,a4
1000061c:	00c7e793          	ori	a5,a5,12
    GPADC_DIG->GPADC_CLK_CTRL = (GPADC_InitStruct->GPADC_ClkDivide << 8)            |
10000620:	ca9c                	sw	a5,16(a3)
    if(g_gpadc_stat == 0){
10000622:	200017b7          	lui	a5,0x20001
10000626:	c807c783          	lbu	a5,-896(a5) # 20000c80 <g_gpadc_stat>
1000062a:	e7ad                	bnez	a5,10000694 <GPADC_Init+0xee>
        g_gpadc_div1_a = 3601;
1000062c:	20001737          	lui	a4,0x20001
10000630:	6785                	lui	a5,0x1
10000632:	e1178793          	addi	a5,a5,-495 # e11 <__STACK_SIZE+0xb11>
10000636:	c4f72023          	sw	a5,-960(a4) # 20000c40 <g_gpadc_div1_a>
        g_gpadc_div1_b = 0;
1000063a:	200017b7          	lui	a5,0x20001
1000063e:	c407a223          	sw	zero,-956(a5) # 20000c44 <g_gpadc_div1_b>
        g_gpadc_div2_a = 2 * g_gpadc_div1_a;
10000642:	20001737          	lui	a4,0x20001
10000646:	6789                	lui	a5,0x2
10000648:	c2278793          	addi	a5,a5,-990 # 1c22 <link_control_cmd_handle+0x2a>
1000064c:	c4f72823          	sw	a5,-944(a4) # 20000c50 <g_gpadc_div2_a>
        g_gpadc_div2_b = 2 * g_gpadc_div1_b;
10000650:	200017b7          	lui	a5,0x20001
10000654:	c407aa23          	sw	zero,-940(a5) # 20000c54 <g_gpadc_div2_b>
        g_gpadc_div3_a = 3 * g_gpadc_div1_a;
10000658:	20001737          	lui	a4,0x20001
1000065c:	678d                	lui	a5,0x3
1000065e:	a3378793          	addi	a5,a5,-1485 # 2a33 <hci_msg_polling_work+0x1df>
10000662:	c6f72023          	sw	a5,-928(a4) # 20000c60 <g_gpadc_div3_a>
        g_gpadc_div3_b = 3 * g_gpadc_div1_b;
10000666:	200017b7          	lui	a5,0x20001
1000066a:	c607a223          	sw	zero,-924(a5) # 20000c64 <g_gpadc_div3_b>
        g_gpadc_div4_a = 4 * g_gpadc_div1_a;
1000066e:	6791                	lui	a5,0x4
10000670:	84478793          	addi	a5,a5,-1980 # 3844 <ll_conn_reset+0x18>
10000674:	20001737          	lui	a4,0x20001
10000678:	c6f72823          	sw	a5,-912(a4) # 20000c70 <g_gpadc_div4_a>
        g_gpadc_div4_b = 4 * g_gpadc_div1_b;
1000067c:	20001737          	lui	a4,0x20001
10000680:	c6072a23          	sw	zero,-908(a4) # 20000c74 <g_gpadc_div4_b>
        g_gpadc_vbat_a = 4 * g_gpadc_div1_a;
10000684:	20001737          	lui	a4,0x20001
10000688:	c8f72223          	sw	a5,-892(a4) # 20000c84 <g_gpadc_vbat_a>
        g_gpadc_vbat_b = 4 * g_gpadc_div1_b;
1000068c:	200017b7          	lui	a5,0x20001
10000690:	c807a423          	sw	zero,-888(a5) # 20000c88 <g_gpadc_vbat_b>
    *(volatile int *)(0x42002004) |= 0x301;
10000694:	42002737          	lui	a4,0x42002
10000698:	435c                	lw	a5,4(a4)
1000069a:	3017e793          	ori	a5,a5,769
1000069e:	c35c                	sw	a5,4(a4)
    t = *(volatile int*)(0x40080104);
100006a0:	400806b7          	lui	a3,0x40080
100006a4:	1046a783          	lw	a5,260(a3) # 40080104 <__StackTop+0x2007c104>
    t &= (~(0x1f<<8));
100006a8:	7779                	lui	a4,0xffffe
100006aa:	0ff70713          	addi	a4,a4,255 # ffffe0ff <__StackTop+0xdfffa0ff>
100006ae:	8ff9                	and	a5,a5,a4
    t |= (6 << 8);
100006b0:	6007e793          	ori	a5,a5,1536
    *(volatile int*)(0x40080104) = t;
100006b4:	10f6a223          	sw	a5,260(a3)
}
100006b8:	8082                	ret
                                    (GPADC_InitStruct->GPADC_DiffEN << 12)              |
100006ba:	415c                	lw	a5,4(a0)
100006bc:	07b2                	slli	a5,a5,0xc
                                    (GPADC_InitStruct->GPADC_NegativeInputChannel << 4) |
100006be:	00854703          	lbu	a4,8(a0)
100006c2:	0712                	slli	a4,a4,0x4
100006c4:	8fd9                	or	a5,a5,a4
100006c6:	671d                	lui	a4,0x7
100006c8:	80970713          	addi	a4,a4,-2039 # 6809 <bt_att_create_pdu+0x425>
100006cc:	8fd9                	or	a5,a5,a4
100006ce:	07c2                	slli	a5,a5,0x10
100006d0:	83c1                	srli	a5,a5,0x10
        GPADC_ANA->GPADC_CTRL =     (GPADC_INPUT_DIV4 << 13)         |
100006d2:	40040737          	lui	a4,0x40040
100006d6:	00f71223          	sh	a5,4(a4) # 40040004 <__StackTop+0x2003c004>
100006da:	b731                	j	100005e6 <GPADC_Init+0x40>

100006dc <GPADC_StructInit>:
    GPADC_InitStruct->GPADC_InputDivide = GPADC_INPUT_DIV2;
100006dc:	4785                	li	a5,1
100006de:	00f50023          	sb	a5,0(a0)
    GPADC_InitStruct->GPADC_DiffEN = DISABLE;
100006e2:	00052223          	sw	zero,4(a0)
    GPADC_InitStruct->GPADC_NegativeInputChannel= GPADC_CHANNEL_N_REF0V9;
100006e6:	4721                	li	a4,8
100006e8:	00e50423          	sb	a4,8(a0)
    GPADC_InitStruct->GPADC_PositiveInputChannel = GPADC_CHANNEL_CIN; // default channel core input
100006ec:	4729                	li	a4,10
100006ee:	00e504a3          	sb	a4,9(a0)
    GPADC_InitStruct->GPADC_AverageWindow = GPADC_AVG_NUM_32; // default 3M/32 ~= 100K
100006f2:	4715                	li	a4,5
100006f4:	00e50523          	sb	a4,10(a0)
    GPADC_InitStruct->GPADC_TimerSelect = 0;
100006f8:	00050823          	sb	zero,16(a0)
    GPADC_InitStruct->GPADC_TimerTrigEN = DISABLE;
100006fc:	00052623          	sw	zero,12(a0)
    GPADC_InitStruct->GPADC_ContinueMode = DISABLE;
10000700:	00052a23          	sw	zero,20(a0)
    GPADC_InitStruct->GPADC_ClkDivide = 3; // default sample rate: 12m/(ClkDivide+1) = 3M
10000704:	470d                	li	a4,3
10000706:	00e50c23          	sb	a4,24(a0)
    GPADC_InitStruct->GPADC_ClkSelect = GPADC_CLK_SRC_RC24M;
1000070a:	00050ca3          	sb	zero,25(a0)
    GPADC_InitStruct->GPADC_ClkAutoGate = ENABLE; // default enable
1000070e:	cd5c                	sw	a5,28(a0)
}
10000710:	8082                	ret

10000712 <GPADC_Cmd>:
    if (NewState != DISABLE){
10000712:	c105                	beqz	a0,10000732 <GPADC_Cmd+0x20>
        GPADC_ANA->GPADC_EN |= (uint32_t)(ENABLE << 1);
10000714:	40040737          	lui	a4,0x40040
10000718:	00074783          	lbu	a5,0(a4) # 40040000 <__StackTop+0x2003c000>
1000071c:	0ff7f793          	zext.b	a5,a5
10000720:	0027e793          	ori	a5,a5,2
10000724:	00f70023          	sb	a5,0(a4)
        GPADC_DIG->GPADC_ACTION |= (uint32_t)(ENABLE << 1);
10000728:	533c                	lw	a5,96(a4)
1000072a:	0027e793          	ori	a5,a5,2
1000072e:	d33c                	sw	a5,96(a4)
10000730:	8082                	ret
        GPADC_ANA->GPADC_EN &= ~((uint32_t)(ENABLE << 1));
10000732:	400407b7          	lui	a5,0x40040
10000736:	0007c703          	lbu	a4,0(a5) # 40040000 <__StackTop+0x2003c000>
1000073a:	0fd77713          	andi	a4,a4,253
1000073e:	00e78023          	sb	a4,0(a5)
        GPADC_DIG->GPADC_ACTION &= ~((uint32_t)(ENABLE << 1));
10000742:	53b8                	lw	a4,96(a5)
10000744:	9b75                	andi	a4,a4,-3
10000746:	d3b8                	sw	a4,96(a5)
}
10000748:	8082                	ret

1000074a <ADC_SoftwareStartConvCmd>:
  if (NewState != DISABLE)
1000074a:	c901                	beqz	a0,1000075a <ADC_SoftwareStartConvCmd+0x10>
    GPADC_DIG->GPADC_ACTION |= (uint32_t)(ENABLE << 31);
1000074c:	40040737          	lui	a4,0x40040
10000750:	533c                	lw	a5,96(a4)
10000752:	800006b7          	lui	a3,0x80000
10000756:	8fd5                	or	a5,a5,a3
10000758:	d33c                	sw	a5,96(a4)
}
1000075a:	8082                	ret

1000075c <GPADC_GetConversionVoltage>:
uint16_t GPADC_GetConversionVoltage(void){
1000075c:	1151                	addi	sp,sp,-12
1000075e:	c406                	sw	ra,8(sp)
10000760:	c222                	sw	s0,4(sp)
10000762:	c026                	sw	s1,0(sp)
    return GPADC_DIG->GPADC_SAMP;
10000764:	400407b7          	lui	a5,0x40040
10000768:	57e8                	lw	a0,108(a5)
    samp = GPADC_GetConversionValue();
1000076a:	0542                	slli	a0,a0,0x10
1000076c:	8141                	srli	a0,a0,0x10
    div_sel = ((GPADC_ANA->GPADC_CTRL) >> 13) & 0x03;
1000076e:	0047d403          	lhu	s0,4(a5) # 40040004 <__StackTop+0x2003c004>
    vip_sel = ((GPADC_ANA->GPADC_CTRL) >>  0) & 0x0f;
10000772:	0047d483          	lhu	s1,4(a5)
10000776:	88bd                	andi	s1,s1,15
    if (vip_sel == GPADC_CHANNEL_P_BAT){
10000778:	47a5                	li	a5,9
1000077a:	04f48b63          	beq	s1,a5,100007d0 <GPADC_GetConversionVoltage+0x74>
1000077e:	8035                	srli	s0,s0,0xd
10000780:	880d                	andi	s0,s0,3
        if(div_sel == 0){
10000782:	e82d                	bnez	s0,100007f4 <GPADC_GetConversionVoltage+0x98>
        volt = ((samp*a + b)*10)>>GPADC_CALI_ZOOM_SHIFT;
10000784:	200017b7          	lui	a5,0x20001
10000788:	c407a783          	lw	a5,-960(a5) # 20000c40 <g_gpadc_div1_a>
1000078c:	02f50533          	mul	a0,a0,a5
10000790:	200017b7          	lui	a5,0x20001
10000794:	c447a783          	lw	a5,-956(a5) # 20000c44 <g_gpadc_div1_b>
10000798:	953e                	add	a0,a0,a5
1000079a:	00251793          	slli	a5,a0,0x2
1000079e:	953e                	add	a0,a0,a5
100007a0:	051e                	slli	a0,a0,0x7
        volt = GPADC_InternalSearchVoltageOffset(volt, div_sel);
100007a2:	4581                	li	a1,0
100007a4:	8141                	srli	a0,a0,0x10
100007a6:	39b1                	jal	10000402 <GPADC_InternalSearchVoltageOffset>
    if(volt < 0) volt = 0;
100007a8:	fff54793          	not	a5,a0
100007ac:	87fd                	srai	a5,a5,0x1f
100007ae:	8d7d                	and	a0,a0,a5
    if(volt > (GPADC_DIV1_VOLT_MAX*(div_sel + 1))) volt = GPADC_DIV1_VOLT_MAX*(div_sel + 1);
100007b0:	0405                	addi	s0,s0,1
100007b2:	6789                	lui	a5,0x2
100007b4:	32878793          	addi	a5,a5,808 # 2328 <hci_vendor_cmd_handle+0x16>
100007b8:	02f40433          	mul	s0,s0,a5
100007bc:	00a47363          	bgeu	s0,a0,100007c2 <GPADC_GetConversionVoltage+0x66>
100007c0:	8522                	mv	a0,s0
    return (uint16_t)volt;
100007c2:	0542                	slli	a0,a0,0x10
100007c4:	8141                	srli	a0,a0,0x10
}
100007c6:	40a2                	lw	ra,8(sp)
100007c8:	4412                	lw	s0,4(sp)
100007ca:	4482                	lw	s1,0(sp)
100007cc:	0131                	addi	sp,sp,12
100007ce:	8082                	ret
        volt = ((samp*a + b)*10)>>GPADC_CALI_ZOOM_SHIFT;
100007d0:	200017b7          	lui	a5,0x20001
100007d4:	c847a783          	lw	a5,-892(a5) # 20000c84 <g_gpadc_vbat_a>
100007d8:	02f50533          	mul	a0,a0,a5
100007dc:	200017b7          	lui	a5,0x20001
100007e0:	c887a783          	lw	a5,-888(a5) # 20000c88 <g_gpadc_vbat_b>
100007e4:	953e                	add	a0,a0,a5
100007e6:	00251793          	slli	a5,a0,0x2
100007ea:	953e                	add	a0,a0,a5
100007ec:	051e                	slli	a0,a0,0x7
        volt = GPADC_InternalSearchBATVoltageOffset(volt);
100007ee:	8141                	srli	a0,a0,0x10
100007f0:	3b99                	jal	10000546 <GPADC_InternalSearchBATVoltageOffset>
        return volt;
100007f2:	bfd1                	j	100007c6 <GPADC_GetConversionVoltage+0x6a>
        } else if(div_sel == 1){
100007f4:	4785                	li	a5,1
100007f6:	04f40463          	beq	s0,a5,1000083e <GPADC_GetConversionVoltage+0xe2>
        } else if(div_sel == 2){
100007fa:	4789                	li	a5,2
100007fc:	04f40a63          	beq	s0,a5,10000850 <GPADC_GetConversionVoltage+0xf4>
            a = g_gpadc_div4_a;
10000800:	200017b7          	lui	a5,0x20001
10000804:	c707a703          	lw	a4,-912(a5) # 20000c70 <g_gpadc_div4_a>
            b = g_gpadc_div4_b;
10000808:	200017b7          	lui	a5,0x20001
1000080c:	c747a783          	lw	a5,-908(a5) # 20000c74 <g_gpadc_div4_b>
        volt = ((samp*a + b)*10)>>GPADC_CALI_ZOOM_SHIFT;
10000810:	02e50533          	mul	a0,a0,a4
10000814:	953e                	add	a0,a0,a5
10000816:	00251793          	slli	a5,a0,0x2
1000081a:	953e                	add	a0,a0,a5
1000081c:	051e                	slli	a0,a0,0x7
        volt = GPADC_InternalSearchVoltageOffset(volt, div_sel);
1000081e:	85a2                	mv	a1,s0
10000820:	8141                	srli	a0,a0,0x10
10000822:	36c5                	jal	10000402 <GPADC_InternalSearchVoltageOffset>
10000824:	87aa                	mv	a5,a0
        if ((div_sel != 0) && (vip_sel == GPADC_CHANNEL_GPIO15)){
10000826:	4711                	li	a4,4
10000828:	f8e490e3          	bne	s1,a4,100007a8 <GPADC_GetConversionVoltage+0x4c>
            volt = volt*1000/995;
1000082c:	3e800513          	li	a0,1000
10000830:	02a787b3          	mul	a5,a5,a0
10000834:	3e300513          	li	a0,995
10000838:	02a7c533          	div	a0,a5,a0
1000083c:	b7b5                	j	100007a8 <GPADC_GetConversionVoltage+0x4c>
            a = g_gpadc_div2_a;
1000083e:	200017b7          	lui	a5,0x20001
10000842:	c507a703          	lw	a4,-944(a5) # 20000c50 <g_gpadc_div2_a>
            b = g_gpadc_div2_b;
10000846:	200017b7          	lui	a5,0x20001
1000084a:	c547a783          	lw	a5,-940(a5) # 20000c54 <g_gpadc_div2_b>
1000084e:	b7c9                	j	10000810 <GPADC_GetConversionVoltage+0xb4>
            a = g_gpadc_div3_a;
10000850:	200017b7          	lui	a5,0x20001
10000854:	c607a703          	lw	a4,-928(a5) # 20000c60 <g_gpadc_div3_a>
            b = g_gpadc_div3_b;
10000858:	200017b7          	lui	a5,0x20001
1000085c:	c647a783          	lw	a5,-924(a5) # 20000c64 <g_gpadc_div3_b>
10000860:	bf45                	j	10000810 <GPADC_GetConversionVoltage+0xb4>

10000862 <GPADC_GetFlagStatus>:
  if ((uint8_t)(GPADC_DIG->GPADC_INT_CTRL & ADC_FLAG) != (uint8_t)RESET)
10000862:	400407b7          	lui	a5,0x40040
10000866:	06078793          	addi	a5,a5,96 # 40040060 <__StackTop+0x2003c060>
1000086a:	479c                	lw	a5,8(a5)
1000086c:	8d7d                	and	a0,a0,a5
}
1000086e:	00a03533          	snez	a0,a0
10000872:	8082                	ret

10000874 <GPADC_WaitWorkDone>:
{
10000874:	1141                	addi	sp,sp,-16
10000876:	c606                	sw	ra,12(sp)
10000878:	c422                	sw	s0,8(sp)
    volatile uint32_t cur_tick = CUR_TIME_TICK_US();
1000087a:	420007b7          	lui	a5,0x42000
1000087e:	1047a783          	lw	a5,260(a5) # 42000104 <__StackTop+0x21ffc104>
10000882:	c03e                	sw	a5,0(sp)
    while(GPADC_GetFlagStatus(GPADC_FLAG_SAMP) == 0 && CUR_TIME_TICK_US() - cur_tick < 2000);
10000884:	42000437          	lui	s0,0x42000
10000888:	4509                	li	a0,2
1000088a:	3fe1                	jal	10000862 <GPADC_GetFlagStatus>
1000088c:	e909                	bnez	a0,1000089e <GPADC_WaitWorkDone+0x2a>
1000088e:	10442783          	lw	a5,260(s0) # 42000104 <__StackTop+0x21ffc104>
10000892:	4702                	lw	a4,0(sp)
10000894:	8f99                	sub	a5,a5,a4
10000896:	7cf00713          	li	a4,1999
1000089a:	fef777e3          	bgeu	a4,a5,10000888 <GPADC_WaitWorkDone+0x14>
}
1000089e:	40b2                	lw	ra,12(sp)
100008a0:	4422                	lw	s0,8(sp)
100008a2:	0141                	addi	sp,sp,16
100008a4:	8082                	ret

100008a6 <GPADC_SampleVoltagePoll>:
uint16_t GPADC_SampleVoltagePoll(void){
100008a6:	1141                	addi	sp,sp,-16
100008a8:	c606                	sw	ra,12(sp)
100008aa:	c422                	sw	s0,8(sp)
100008ac:	c226                	sw	s1,4(sp)
    vip_chl = ((GPADC_ANA->GPADC_CTRL) >> 0) & 0xf;
100008ae:	40040737          	lui	a4,0x40040
100008b2:	00475783          	lhu	a5,4(a4) # 40040004 <__StackTop+0x2003c004>
    div_sel = ((GPADC_ANA->GPADC_CTRL) >> 13) & 0x3;
100008b6:	00475403          	lhu	s0,4(a4)
    cont_mode = ((GPADC_DIG->GPADC_ACTION) >> 2) & 0x1;
100008ba:	5338                	lw	a4,96(a4)
100008bc:	8309                	srli	a4,a4,0x2
100008be:	8b05                	andi	a4,a4,1
100008c0:	c03a                	sw	a4,0(sp)
    if (vip_chl != GPADC_CHANNEL_P_BAT)
100008c2:	8bbd                	andi	a5,a5,15
100008c4:	4725                	li	a4,9
100008c6:	0ce78763          	beq	a5,a4,10000994 <GPADC_SampleVoltagePoll+0xee>
100008ca:	0442                	slli	s0,s0,0x10
100008cc:	8041                	srli	s0,s0,0x10
    div_sel = ((GPADC_ANA->GPADC_CTRL) >> 13) & 0x3;
100008ce:	8035                	srli	s0,s0,0xd
100008d0:	880d                	andi	s0,s0,3
100008d2:	4491                	li	s1,4
100008d4:	a89d                	j	1000094a <GPADC_SampleVoltagePoll+0xa4>
            if(cont_mode == 0) ADC_SoftwareStartConvCmd(ENABLE);
100008d6:	4505                	li	a0,1
100008d8:	3d8d                	jal	1000074a <ADC_SoftwareStartConvCmd>
100008da:	a895                	j	1000094e <GPADC_SampleVoltagePoll+0xa8>
            if(((div_sel == 0) && (volt >= GPADC_DIV1_VALID_MIN) && (volt <= GPADC_DIV1_VALID_MAX)) ||
100008dc:	4785                	li	a5,1
100008de:	02f40063          	beq	s0,a5,100008fe <GPADC_SampleVoltagePoll+0x58>
                ((div_sel == 1) && (volt >= GPADC_DIV2_VALID_MIN) && (volt <= GPADC_DIV2_VALID_MAX)) ||
100008e2:	4789                	li	a5,2
100008e4:	08f41463          	bne	s0,a5,1000096c <GPADC_SampleVoltagePoll+0xc6>
                ((div_sel == 2) && (volt >= GPADC_DIV3_VALID_MIN) && (volt <= GPADC_DIV3_VALID_MAX)) ||
100008e8:	6791                	lui	a5,0x4
100008ea:	a9778793          	addi	a5,a5,-1385 # 3a97 <ll_phy_get+0x1>
100008ee:	02a7f363          	bgeu	a5,a0,10000914 <GPADC_SampleVoltagePoll+0x6e>
100008f2:	6799                	lui	a5,0x6
100008f4:	39c78793          	addi	a5,a5,924 # 639c <att_send+0x6e>
100008f8:	06a7e363          	bltu	a5,a0,1000095e <GPADC_SampleVoltagePoll+0xb8>
100008fc:	a045                	j	1000099c <GPADC_SampleVoltagePoll+0xf6>
                ((div_sel == 1) && (volt >= GPADC_DIV2_VALID_MIN) && (volt <= GPADC_DIV2_VALID_MAX)) ||
100008fe:	77fd                	lui	a5,0xfffff
10000900:	a8478793          	addi	a5,a5,-1404 # ffffea84 <__StackTop+0xdfffaa84>
10000904:	97aa                	add	a5,a5,a0
10000906:	07c2                	slli	a5,a5,0x10
10000908:	83c1                	srli	a5,a5,0x10
1000090a:	670d                	lui	a4,0x3
1000090c:	af870713          	addi	a4,a4,-1288 # 2af8 <hci_driver_node_rx_get+0x6>
10000910:	08f77663          	bgeu	a4,a5,1000099c <GPADC_SampleVoltagePoll+0xf6>
            if(volt <= GPADC_DIV1_VALID_MAX)        div_sel = 0;
10000914:	6789                	lui	a5,0x2
10000916:	b5878793          	addi	a5,a5,-1192 # 1b58 <bt_encrypt_sk+0xde>
1000091a:	4401                	li	s0,0
1000091c:	04a7e163          	bltu	a5,a0,1000095e <GPADC_SampleVoltagePoll+0xb8>
            t = GPADC_ANA->GPADC_CTRL;
10000920:	400406b7          	lui	a3,0x40040
10000924:	0046d783          	lhu	a5,4(a3) # 40040004 <__StackTop+0x2003c004>
10000928:	07c2                	slli	a5,a5,0x10
1000092a:	83c1                	srli	a5,a5,0x10
            t &= (~(3 << 13));
1000092c:	7769                	lui	a4,0xffffa
1000092e:	177d                	addi	a4,a4,-1
10000930:	8ff9                	and	a5,a5,a4
            t |= (div_sel << 13);
10000932:	00d41713          	slli	a4,s0,0xd
            GPADC_ANA->GPADC_CTRL = t;
10000936:	8fd9                	or	a5,a5,a4
10000938:	00f69223          	sh	a5,4(a3)
            DELAY_US(2); // wait settle
1000093c:	4509                	li	a0,2
1000093e:	815ff0ef          	jal	ra,10000152 <delay_us>
            if(i == 3) return 0xffff; // error value
10000942:	4785                	li	a5,1
10000944:	06f48463          	beq	s1,a5,100009ac <GPADC_SampleVoltagePoll+0x106>
        for(i=0; i<4; i++){
10000948:	14fd                	addi	s1,s1,-1
            if(cont_mode == 0) ADC_SoftwareStartConvCmd(ENABLE);
1000094a:	4782                	lw	a5,0(sp)
1000094c:	d7c9                	beqz	a5,100008d6 <GPADC_SampleVoltagePoll+0x30>
            GPADC_WaitWorkDone();
1000094e:	371d                	jal	10000874 <GPADC_WaitWorkDone>
            volt = GPADC_GetConversionVoltage();
10000950:	3531                	jal	1000075c <GPADC_GetConversionVoltage>
            if(((div_sel == 0) && (volt >= GPADC_DIV1_VALID_MIN) && (volt <= GPADC_DIV1_VALID_MAX)) ||
10000952:	f449                	bnez	s0,100008dc <GPADC_SampleVoltagePoll+0x36>
10000954:	6789                	lui	a5,0x2
10000956:	b5878793          	addi	a5,a5,-1192 # 1b58 <bt_encrypt_sk+0xde>
1000095a:	04a7f163          	bgeu	a5,a0,1000099c <GPADC_SampleVoltagePoll+0xf6>
            else if(volt <= GPADC_DIV2_VALID_MAX)   div_sel = 1;
1000095e:	6791                	lui	a5,0x4
10000960:	07478793          	addi	a5,a5,116 # 4074 <isr_conn_superto+0x20>
10000964:	4405                	li	s0,1
10000966:	faa7fde3          	bgeu	a5,a0,10000920 <GPADC_SampleVoltagePoll+0x7a>
1000096a:	a831                	j	10000986 <GPADC_SampleVoltagePoll+0xe0>
                ((div_sel == 2) && (volt >= GPADC_DIV3_VALID_MIN) && (volt <= GPADC_DIV3_VALID_MAX)) ||
1000096c:	478d                	li	a5,3
1000096e:	faf413e3          	bne	s0,a5,10000914 <GPADC_SampleVoltagePoll+0x6e>
                ((div_sel == 3) && (volt >= GPADC_DIV4_VALID_MIN) && (volt <= GPADC_DIV4_VALID_MAX)))
10000972:	6799                	lui	a5,0x6
10000974:	fb378793          	addi	a5,a5,-77 # 5fb3 <hci_send_cmd_le_set_adv_enable+0x45d>
10000978:	f8a7fee3          	bgeu	a5,a0,10000914 <GPADC_SampleVoltagePoll+0x6e>
1000097c:	67a9                	lui	a5,0xa
1000097e:	c4078793          	addi	a5,a5,-960 # 9c40 <bt_addr_le_any+0x29c>
10000982:	00a7fd63          	bgeu	a5,a0,1000099c <GPADC_SampleVoltagePoll+0xf6>
            else if(volt <= GPADC_DIV3_VALID_MAX)   div_sel = 2;
10000986:	6799                	lui	a5,0x6
10000988:	39c78413          	addi	s0,a5,924 # 639c <att_send+0x6e>
            else                                    div_sel = 3;
1000098c:	00a43433          	sltu	s0,s0,a0
10000990:	0409                	addi	s0,s0,2
10000992:	b779                	j	10000920 <GPADC_SampleVoltagePoll+0x7a>
        if(cont_mode == 0) ADC_SoftwareStartConvCmd(ENABLE);
10000994:	4782                	lw	a5,0(sp)
10000996:	cb81                	beqz	a5,100009a6 <GPADC_SampleVoltagePoll+0x100>
        GPADC_WaitWorkDone();
10000998:	3df1                	jal	10000874 <GPADC_WaitWorkDone>
        volt = GPADC_GetConversionVoltage();
1000099a:	33c9                	jal	1000075c <GPADC_GetConversionVoltage>
}
1000099c:	40b2                	lw	ra,12(sp)
1000099e:	4422                	lw	s0,8(sp)
100009a0:	4492                	lw	s1,4(sp)
100009a2:	0141                	addi	sp,sp,16
100009a4:	8082                	ret
        if(cont_mode == 0) ADC_SoftwareStartConvCmd(ENABLE);
100009a6:	4505                	li	a0,1
100009a8:	334d                	jal	1000074a <ADC_SoftwareStartConvCmd>
100009aa:	b7fd                	j	10000998 <GPADC_SampleVoltagePoll+0xf2>
            if(i == 3) return 0xffff; // error value
100009ac:	6541                	lui	a0,0x10
100009ae:	157d                	addi	a0,a0,-1
100009b0:	b7f5                	j	1000099c <GPADC_SampleVoltagePoll+0xf6>

100009b2 <GPADC_StartCalibrationEx>:
void GPADC_StartCalibrationEx(void){
100009b2:	7139                	addi	sp,sp,-64
100009b4:	de06                	sw	ra,60(sp)
100009b6:	dc22                	sw	s0,56(sp)
100009b8:	da26                	sw	s1,52(sp)
    GPADC_InternalParseVoltageSample(g_otp_cfg.gpadc_high_div1.raw, GPADC_CALI_DIV1_DELTA_HI, &hv, &hs);
100009ba:	200017b7          	lui	a5,0x20001
100009be:	c8c78413          	addi	s0,a5,-884 # 20000c8c <g_otp_cfg>
100009c2:	1074                	addi	a3,sp,44
100009c4:	1810                	addi	a2,sp,48
100009c6:	58e00593          	li	a1,1422
100009ca:	4448                	lw	a0,12(s0)
100009cc:	3411                	jal	100003d0 <GPADC_InternalParseVoltageSample>
    GPADC_InternalParseVoltageSample(g_otp_cfg.gpadc_low_div1.raw, GPADC_CALI_DIV1_DELTA_LO, &lv, &ls);
100009ce:	1054                	addi	a3,sp,36
100009d0:	1030                	addi	a2,sp,40
100009d2:	51000593          	li	a1,1296
100009d6:	c022                	sw	s0,0(sp)
100009d8:	4808                	lw	a0,16(s0)
100009da:	3add                	jal	100003d0 <GPADC_InternalParseVoltageSample>
    GPADC_InternalCalibrationOneRangeEx(&g_gpadc_div1_a, &g_gpadc_div1_b, hv, hs, lv, ls);
100009dc:	5492                	lw	s1,36(sp)
    temp = ((long long)volt_hi - (long long)volt_lo)*GPADC_CALI_ZOOM;
100009de:	5422                	lw	s0,40(sp)
100009e0:	55c2                	lw	a1,48(sp)
100009e2:	40858533          	sub	a0,a1,s0
100009e6:	00a5b5b3          	sltu	a1,a1,a0
100009ea:	40b005b3          	neg	a1,a1
100009ee:	01655793          	srli	a5,a0,0x16
100009f2:	05aa                	slli	a1,a1,0xa
    *a = temp/(samp_hi - samp_lo);
100009f4:	5632                	lw	a2,44(sp)
100009f6:	8e05                	sub	a2,a2,s1
100009f8:	4681                	li	a3,0
100009fa:	052a                	slli	a0,a0,0xa
100009fc:	8ddd                	or	a1,a1,a5
100009fe:	74d000ef          	jal	ra,1000194a <__divdi3>
10000a02:	200017b7          	lui	a5,0x20001
10000a06:	c4078793          	addi	a5,a5,-960 # 20000c40 <g_gpadc_div1_a>
10000a0a:	c23e                	sw	a5,4(sp)
10000a0c:	c388                	sw	a0,0(a5)
    *b = temp/GPADC_FIX_COEF;
10000a0e:	200017b7          	lui	a5,0x20001
10000a12:	c4478613          	addi	a2,a5,-956 # 20000c44 <g_gpadc_div1_b>
    temp = (long long)volt_lo*GPADC_CALI_ZOOM - (long long)samp_lo*(*a);
10000a16:	01645713          	srli	a4,s0,0x16
10000a1a:	042a                	slli	s0,s0,0xa
10000a1c:	41f55693          	srai	a3,a0,0x1f
10000a20:	029686b3          	mul	a3,a3,s1
10000a24:	02a487b3          	mul	a5,s1,a0
10000a28:	02a4b4b3          	mulhu	s1,s1,a0
10000a2c:	94b6                	add	s1,s1,a3
10000a2e:	40f407b3          	sub	a5,s0,a5
10000a32:	00f43433          	sltu	s0,s0,a5
10000a36:	8f05                	sub	a4,a4,s1
10000a38:	40870433          	sub	s0,a4,s0
    *b = temp/GPADC_FIX_COEF;
10000a3c:	41f45713          	srai	a4,s0,0x1f
10000a40:	0ff77713          	zext.b	a4,a4
10000a44:	97ba                	add	a5,a5,a4
10000a46:	00e7b733          	sltu	a4,a5,a4
10000a4a:	9722                	add	a4,a4,s0
10000a4c:	0762                	slli	a4,a4,0x18
10000a4e:	83a1                	srli	a5,a5,0x8
10000a50:	8fd9                	or	a5,a5,a4
10000a52:	c432                	sw	a2,8(sp)
10000a54:	c21c                	sw	a5,0(a2)
    GPADC_InternalParseVoltageSample(g_otp_cfg.gpadc_high_div2.raw, GPADC_CALI_DIV2_DELTA_HI, &hv, &hs);
10000a56:	1074                	addi	a3,sp,44
10000a58:	180c                	addi	a1,sp,48
10000a5a:	862e                	mv	a2,a1
10000a5c:	43200593          	li	a1,1074
10000a60:	4402                	lw	s0,0(sp)
10000a62:	4848                	lw	a0,20(s0)
10000a64:	32b5                	jal	100003d0 <GPADC_InternalParseVoltageSample>
    GPADC_InternalParseVoltageSample(g_otp_cfg.gpadc_low_div2.raw, GPADC_CALI_DIV2_DELTA_LO, &lv, &ls);
10000a66:	1054                	addi	a3,sp,36
10000a68:	102c                	addi	a1,sp,40
10000a6a:	862e                	mv	a2,a1
10000a6c:	32200593          	li	a1,802
10000a70:	c022                	sw	s0,0(sp)
10000a72:	4c08                	lw	a0,24(s0)
10000a74:	3ab1                	jal	100003d0 <GPADC_InternalParseVoltageSample>
    GPADC_InternalCalibrationOneRangeEx(&g_gpadc_div2_a, &g_gpadc_div2_b, hv, hs, lv, ls);
10000a76:	5492                	lw	s1,36(sp)
    temp = ((long long)volt_hi - (long long)volt_lo)*GPADC_CALI_ZOOM;
10000a78:	5422                	lw	s0,40(sp)
10000a7a:	55c2                	lw	a1,48(sp)
10000a7c:	40858533          	sub	a0,a1,s0
10000a80:	00a5b5b3          	sltu	a1,a1,a0
10000a84:	40b005b3          	neg	a1,a1
10000a88:	01655793          	srli	a5,a0,0x16
10000a8c:	05aa                	slli	a1,a1,0xa
    *a = temp/(samp_hi - samp_lo);
10000a8e:	5632                	lw	a2,44(sp)
10000a90:	8e05                	sub	a2,a2,s1
10000a92:	4681                	li	a3,0
10000a94:	052a                	slli	a0,a0,0xa
10000a96:	8ddd                	or	a1,a1,a5
10000a98:	6b3000ef          	jal	ra,1000194a <__divdi3>
10000a9c:	200017b7          	lui	a5,0x20001
10000aa0:	c5078693          	addi	a3,a5,-944 # 20000c50 <g_gpadc_div2_a>
10000aa4:	c636                	sw	a3,12(sp)
10000aa6:	c288                	sw	a0,0(a3)
    *b = temp/GPADC_FIX_COEF;
10000aa8:	200017b7          	lui	a5,0x20001
10000aac:	c5478593          	addi	a1,a5,-940 # 20000c54 <g_gpadc_div2_b>
    temp = (long long)volt_lo*GPADC_CALI_ZOOM - (long long)samp_lo*(*a);
10000ab0:	01645713          	srli	a4,s0,0x16
10000ab4:	042a                	slli	s0,s0,0xa
10000ab6:	41f55693          	srai	a3,a0,0x1f
10000aba:	029686b3          	mul	a3,a3,s1
10000abe:	02a487b3          	mul	a5,s1,a0
10000ac2:	02a4b4b3          	mulhu	s1,s1,a0
10000ac6:	94b6                	add	s1,s1,a3
10000ac8:	40f407b3          	sub	a5,s0,a5
10000acc:	00f43433          	sltu	s0,s0,a5
10000ad0:	8f05                	sub	a4,a4,s1
10000ad2:	40870433          	sub	s0,a4,s0
    *b = temp/GPADC_FIX_COEF;
10000ad6:	41f45713          	srai	a4,s0,0x1f
10000ada:	0ff77713          	zext.b	a4,a4
10000ade:	97ba                	add	a5,a5,a4
10000ae0:	00e7b733          	sltu	a4,a5,a4
10000ae4:	9722                	add	a4,a4,s0
10000ae6:	0762                	slli	a4,a4,0x18
10000ae8:	83a1                	srli	a5,a5,0x8
10000aea:	8fd9                	or	a5,a5,a4
10000aec:	c82e                	sw	a1,16(sp)
10000aee:	c19c                	sw	a5,0(a1)
    GPADC_InternalParseVoltageSample(g_otp_cfg.gpadc_high_div3.raw, GPADC_CALI_DIV3_DELTA_HI, &hv, &hs);
10000af0:	1068                	addi	a0,sp,44
10000af2:	86aa                	mv	a3,a0
10000af4:	1808                	addi	a0,sp,48
10000af6:	862a                	mv	a2,a0
10000af8:	37200593          	li	a1,882
10000afc:	4402                	lw	s0,0(sp)
10000afe:	4c48                	lw	a0,28(s0)
10000b00:	38c1                	jal	100003d0 <GPADC_InternalParseVoltageSample>
    GPADC_InternalParseVoltageSample(g_otp_cfg.gpadc_low_div3.raw, GPADC_CALI_DIV3_DELTA_LO, &lv, &ls);
10000b02:	1054                	addi	a3,sp,36
10000b04:	1028                	addi	a0,sp,40
10000b06:	862a                	mv	a2,a0
10000b08:	2e900593          	li	a1,745
10000b0c:	c022                	sw	s0,0(sp)
10000b0e:	5008                	lw	a0,32(s0)
10000b10:	30c1                	jal	100003d0 <GPADC_InternalParseVoltageSample>
    GPADC_InternalCalibrationOneRangeEx(&g_gpadc_div3_a, &g_gpadc_div3_b, hv, hs, lv, ls);
10000b12:	5492                	lw	s1,36(sp)
    temp = ((long long)volt_hi - (long long)volt_lo)*GPADC_CALI_ZOOM;
10000b14:	5422                	lw	s0,40(sp)
10000b16:	55c2                	lw	a1,48(sp)
10000b18:	40858533          	sub	a0,a1,s0
10000b1c:	00a5b5b3          	sltu	a1,a1,a0
10000b20:	40b005b3          	neg	a1,a1
10000b24:	01655793          	srli	a5,a0,0x16
10000b28:	05aa                	slli	a1,a1,0xa
    *a = temp/(samp_hi - samp_lo);
10000b2a:	5632                	lw	a2,44(sp)
10000b2c:	8e05                	sub	a2,a2,s1
10000b2e:	4681                	li	a3,0
10000b30:	052a                	slli	a0,a0,0xa
10000b32:	8ddd                	or	a1,a1,a5
10000b34:	617000ef          	jal	ra,1000194a <__divdi3>
10000b38:	200017b7          	lui	a5,0x20001
10000b3c:	c6078313          	addi	t1,a5,-928 # 20000c60 <g_gpadc_div3_a>
10000b40:	ca1a                	sw	t1,20(sp)
10000b42:	00a32023          	sw	a0,0(t1)
    *b = temp/GPADC_FIX_COEF;
10000b46:	200017b7          	lui	a5,0x20001
10000b4a:	c6478293          	addi	t0,a5,-924 # 20000c64 <g_gpadc_div3_b>
    temp = (long long)volt_lo*GPADC_CALI_ZOOM - (long long)samp_lo*(*a);
10000b4e:	01645713          	srli	a4,s0,0x16
10000b52:	042a                	slli	s0,s0,0xa
10000b54:	41f55693          	srai	a3,a0,0x1f
10000b58:	029686b3          	mul	a3,a3,s1
10000b5c:	02a487b3          	mul	a5,s1,a0
10000b60:	02a4b4b3          	mulhu	s1,s1,a0
10000b64:	94b6                	add	s1,s1,a3
10000b66:	40f407b3          	sub	a5,s0,a5
10000b6a:	00f43433          	sltu	s0,s0,a5
10000b6e:	8f05                	sub	a4,a4,s1
10000b70:	40870433          	sub	s0,a4,s0
    *b = temp/GPADC_FIX_COEF;
10000b74:	41f45713          	srai	a4,s0,0x1f
10000b78:	0ff77713          	zext.b	a4,a4
10000b7c:	97ba                	add	a5,a5,a4
10000b7e:	00e7b733          	sltu	a4,a5,a4
10000b82:	9722                	add	a4,a4,s0
10000b84:	0762                	slli	a4,a4,0x18
10000b86:	83a1                	srli	a5,a5,0x8
10000b88:	8fd9                	or	a5,a5,a4
10000b8a:	cc16                	sw	t0,24(sp)
10000b8c:	00f2a023          	sw	a5,0(t0)
    GPADC_InternalParseVoltageSample(g_otp_cfg.gpadc_high_div4.raw, GPADC_CALI_DIV4_DELTA_HI, &hv, &hs);
10000b90:	1068                	addi	a0,sp,44
10000b92:	86aa                	mv	a3,a0
10000b94:	1808                	addi	a0,sp,48
10000b96:	862a                	mv	a2,a0
10000b98:	2d200593          	li	a1,722
10000b9c:	4402                	lw	s0,0(sp)
10000b9e:	5048                	lw	a0,36(s0)
10000ba0:	831ff0ef          	jal	ra,100003d0 <GPADC_InternalParseVoltageSample>
    GPADC_InternalParseVoltageSample(g_otp_cfg.gpadc_low_div4.raw, GPADC_CALI_DIV4_DELTA_LO, &lv, &ls);
10000ba4:	1054                	addi	a3,sp,36
10000ba6:	1028                	addi	a0,sp,40
10000ba8:	862a                	mv	a2,a0
10000baa:	27000593          	li	a1,624
10000bae:	c022                	sw	s0,0(sp)
10000bb0:	5408                	lw	a0,40(s0)
10000bb2:	81fff0ef          	jal	ra,100003d0 <GPADC_InternalParseVoltageSample>
    GPADC_InternalCalibrationOneRangeEx(&g_gpadc_div4_a, &g_gpadc_div4_b, hv, hs, lv, ls);
10000bb6:	5492                	lw	s1,36(sp)
    temp = ((long long)volt_hi - (long long)volt_lo)*GPADC_CALI_ZOOM;
10000bb8:	5422                	lw	s0,40(sp)
10000bba:	55c2                	lw	a1,48(sp)
10000bbc:	40858533          	sub	a0,a1,s0
10000bc0:	00a5b5b3          	sltu	a1,a1,a0
10000bc4:	40b005b3          	neg	a1,a1
10000bc8:	01655793          	srli	a5,a0,0x16
10000bcc:	05aa                	slli	a1,a1,0xa
    *a = temp/(samp_hi - samp_lo);
10000bce:	5632                	lw	a2,44(sp)
10000bd0:	8e05                	sub	a2,a2,s1
10000bd2:	4681                	li	a3,0
10000bd4:	052a                	slli	a0,a0,0xa
10000bd6:	8ddd                	or	a1,a1,a5
10000bd8:	573000ef          	jal	ra,1000194a <__divdi3>
10000bdc:	200017b7          	lui	a5,0x20001
10000be0:	c7078393          	addi	t2,a5,-912 # 20000c70 <g_gpadc_div4_a>
10000be4:	ce1e                	sw	t2,28(sp)
10000be6:	00a3a023          	sw	a0,0(t2)
    *b = temp/GPADC_FIX_COEF;
10000bea:	200017b7          	lui	a5,0x20001
10000bee:	c7478093          	addi	ra,a5,-908 # 20000c74 <g_gpadc_div4_b>
    temp = (long long)volt_lo*GPADC_CALI_ZOOM - (long long)samp_lo*(*a);
10000bf2:	01645713          	srli	a4,s0,0x16
10000bf6:	042a                	slli	s0,s0,0xa
10000bf8:	41f55693          	srai	a3,a0,0x1f
10000bfc:	029686b3          	mul	a3,a3,s1
10000c00:	02a487b3          	mul	a5,s1,a0
10000c04:	02a4b4b3          	mulhu	s1,s1,a0
10000c08:	94b6                	add	s1,s1,a3
10000c0a:	40f407b3          	sub	a5,s0,a5
10000c0e:	00f43433          	sltu	s0,s0,a5
10000c12:	8f05                	sub	a4,a4,s1
10000c14:	40870433          	sub	s0,a4,s0
    *b = temp/GPADC_FIX_COEF;
10000c18:	41f45713          	srai	a4,s0,0x1f
10000c1c:	0ff77713          	zext.b	a4,a4
10000c20:	97ba                	add	a5,a5,a4
10000c22:	00e7b733          	sltu	a4,a5,a4
10000c26:	9722                	add	a4,a4,s0
10000c28:	0762                	slli	a4,a4,0x18
10000c2a:	83a1                	srli	a5,a5,0x8
10000c2c:	8fd9                	or	a5,a5,a4
10000c2e:	d006                	sw	ra,32(sp)
10000c30:	00f0a023          	sw	a5,0(ra)
    GPADC_InternalParseVoltageSample(g_otp_cfg.gpadc_vbat_high.raw, GPADC_CALI_VBAT_DELTA_HI, &hv, &hs);
10000c34:	1068                	addi	a0,sp,44
10000c36:	86aa                	mv	a3,a0
10000c38:	1808                	addi	a0,sp,48
10000c3a:	862a                	mv	a2,a0
10000c3c:	35b00593          	li	a1,859
10000c40:	4402                	lw	s0,0(sp)
10000c42:	4028                	lw	a0,64(s0)
10000c44:	f8cff0ef          	jal	ra,100003d0 <GPADC_InternalParseVoltageSample>
    GPADC_InternalParseVoltageSample(g_otp_cfg.gpadc_vbat_low.raw, GPADC_CALI_VBAT_DELTA_LO, &lv, &ls);
10000c48:	1054                	addi	a3,sp,36
10000c4a:	1028                	addi	a0,sp,40
10000c4c:	862a                	mv	a2,a0
10000c4e:	30000593          	li	a1,768
10000c52:	4068                	lw	a0,68(s0)
10000c54:	f7cff0ef          	jal	ra,100003d0 <GPADC_InternalParseVoltageSample>
    GPADC_InternalCalibrationOneRangeEx(&g_gpadc_vbat_a, &g_gpadc_vbat_b, hv, hs, lv, ls);
10000c58:	5492                	lw	s1,36(sp)
    temp = ((long long)volt_hi - (long long)volt_lo)*GPADC_CALI_ZOOM;
10000c5a:	5422                	lw	s0,40(sp)
10000c5c:	55c2                	lw	a1,48(sp)
10000c5e:	40858533          	sub	a0,a1,s0
10000c62:	00a5b5b3          	sltu	a1,a1,a0
10000c66:	40b005b3          	neg	a1,a1
10000c6a:	01655793          	srli	a5,a0,0x16
10000c6e:	05aa                	slli	a1,a1,0xa
    *a = temp/(samp_hi - samp_lo);
10000c70:	5632                	lw	a2,44(sp)
10000c72:	8e05                	sub	a2,a2,s1
10000c74:	4681                	li	a3,0
10000c76:	052a                	slli	a0,a0,0xa
10000c78:	8ddd                	or	a1,a1,a5
10000c7a:	4d1000ef          	jal	ra,1000194a <__divdi3>
10000c7e:	200017b7          	lui	a5,0x20001
10000c82:	c8a7a223          	sw	a0,-892(a5) # 20000c84 <g_gpadc_vbat_a>
    temp = (long long)volt_lo*GPADC_CALI_ZOOM - (long long)samp_lo*(*a);
10000c86:	01645713          	srli	a4,s0,0x16
10000c8a:	042a                	slli	s0,s0,0xa
10000c8c:	41f55693          	srai	a3,a0,0x1f
10000c90:	029686b3          	mul	a3,a3,s1
10000c94:	02a487b3          	mul	a5,s1,a0
10000c98:	02a4b4b3          	mulhu	s1,s1,a0
10000c9c:	94b6                	add	s1,s1,a3
10000c9e:	40f407b3          	sub	a5,s0,a5
10000ca2:	00f43433          	sltu	s0,s0,a5
10000ca6:	8f05                	sub	a4,a4,s1
10000ca8:	40870433          	sub	s0,a4,s0
    *b = temp/GPADC_FIX_COEF;
10000cac:	41f45713          	srai	a4,s0,0x1f
10000cb0:	0ff77713          	zext.b	a4,a4
10000cb4:	97ba                	add	a5,a5,a4
10000cb6:	00e7b733          	sltu	a4,a5,a4
10000cba:	9722                	add	a4,a4,s0
10000cbc:	0762                	slli	a4,a4,0x18
10000cbe:	83a1                	srli	a5,a5,0x8
10000cc0:	8fd9                	or	a5,a5,a4
10000cc2:	20001737          	lui	a4,0x20001
10000cc6:	c8f72423          	sw	a5,-888(a4) # 20000c88 <g_gpadc_vbat_b>
    g_gpadc_div1_samp_valid_min = 0;
10000cca:	200017b7          	lui	a5,0x20001
10000cce:	c407a623          	sw	zero,-948(a5) # 20000c4c <g_gpadc_div1_samp_valid_min>
    g_gpadc_div1_samp_valid_max = (GPADC_DIV1_VOLT_VALID_MAX*GPADC_CALI_ZOOM - g_gpadc_div1_b)/g_gpadc_div1_a;
10000cd2:	4622                	lw	a2,8(sp)
10000cd4:	4218                	lw	a4,0(a2)
10000cd6:	000af7b7          	lui	a5,0xaf
10000cda:	8f99                	sub	a5,a5,a4
10000cdc:	4712                	lw	a4,4(sp)
10000cde:	4318                	lw	a4,0(a4)
10000ce0:	02e7c7b3          	div	a5,a5,a4
10000ce4:	20001737          	lui	a4,0x20001
10000ce8:	c4f72423          	sw	a5,-952(a4) # 20000c48 <g_gpadc_div1_samp_valid_max>
    g_gpadc_div2_samp_valid_min = (GPADC_DIV2_VOLT_VALID_MIN*GPADC_CALI_ZOOM - g_gpadc_div2_b)/g_gpadc_div2_a;
10000cec:	45c2                	lw	a1,16(sp)
10000cee:	4190                	lw	a2,0(a1)
10000cf0:	46b2                	lw	a3,12(sp)
10000cf2:	4294                	lw	a3,0(a3)
10000cf4:	0008a737          	lui	a4,0x8a
10000cf8:	80070713          	addi	a4,a4,-2048 # 89800 <__ROM_SIZE+0x49800>
10000cfc:	8f11                	sub	a4,a4,a2
10000cfe:	02d74733          	div	a4,a4,a3
10000d02:	200017b7          	lui	a5,0x20001
10000d06:	c4e7ae23          	sw	a4,-932(a5) # 20000c5c <g_gpadc_div2_samp_valid_min>
    g_gpadc_div2_samp_valid_max = (GPADC_DIV2_VOLT_VALID_MAX*GPADC_CALI_ZOOM - g_gpadc_div2_b)/g_gpadc_div2_a;
10000d0a:	0019d7b7          	lui	a5,0x19d
10000d0e:	80078793          	addi	a5,a5,-2048 # 19c800 <__ROM_SIZE+0x15c800>
10000d12:	8f91                	sub	a5,a5,a2
10000d14:	02d7c7b3          	div	a5,a5,a3
10000d18:	20001737          	lui	a4,0x20001
10000d1c:	c4f72c23          	sw	a5,-936(a4) # 20000c58 <g_gpadc_div2_samp_valid_max>
    g_gpadc_div3_samp_valid_min = (GPADC_DIV3_VOLT_VALID_MIN*GPADC_CALI_ZOOM - g_gpadc_div3_b)/g_gpadc_div3_a;
10000d20:	42e2                	lw	t0,24(sp)
10000d22:	0002a603          	lw	a2,0(t0)
10000d26:	4352                	lw	t1,20(sp)
10000d28:	00032683          	lw	a3,0(t1)
10000d2c:	00177737          	lui	a4,0x177
10000d30:	8f11                	sub	a4,a4,a2
10000d32:	02d74733          	div	a4,a4,a3
10000d36:	200017b7          	lui	a5,0x20001
10000d3a:	c6e7a623          	sw	a4,-916(a5) # 20000c6c <g_gpadc_div3_samp_valid_min>
    g_gpadc_div3_samp_valid_max = (GPADC_DIV3_VOLT_VALID_MAX*GPADC_CALI_ZOOM - g_gpadc_div3_b)/g_gpadc_div3_a;
10000d3e:	0027e7b7          	lui	a5,0x27e
10000d42:	80078793          	addi	a5,a5,-2048 # 27d800 <__ROM_SIZE+0x23d800>
10000d46:	8f91                	sub	a5,a5,a2
10000d48:	02d7c7b3          	div	a5,a5,a3
10000d4c:	20001737          	lui	a4,0x20001
10000d50:	c6f72423          	sw	a5,-920(a4) # 20000c68 <g_gpadc_div3_samp_valid_max>
    g_gpadc_div4_samp_valid_min = (GPADC_DIV4_VOLT_VALID_MIN*GPADC_CALI_ZOOM - g_gpadc_div4_b)/g_gpadc_div4_a;
10000d54:	5782                	lw	a5,32(sp)
10000d56:	4394                	lw	a3,0(a5)
10000d58:	43f2                	lw	t2,28(sp)
10000d5a:	0003a703          	lw	a4,0(t2)
10000d5e:	002657b7          	lui	a5,0x265
10000d62:	80078793          	addi	a5,a5,-2048 # 264800 <__ROM_SIZE+0x224800>
10000d66:	8f95                	sub	a5,a5,a3
10000d68:	02e7c7b3          	div	a5,a5,a4
10000d6c:	20001637          	lui	a2,0x20001
10000d70:	c6f62e23          	sw	a5,-900(a2) # 20000c7c <g_gpadc_div4_samp_valid_min>
    g_gpadc_div4_samp_valid_max = (GPADC_DIV4_VOLT_VALID_MAX*GPADC_CALI_ZOOM - g_gpadc_div4_b)/g_gpadc_div4_a;
10000d74:	003e87b7          	lui	a5,0x3e8
10000d78:	8f95                	sub	a5,a5,a3
10000d7a:	02e7c7b3          	div	a5,a5,a4
10000d7e:	20001737          	lui	a4,0x20001
10000d82:	c6f72c23          	sw	a5,-904(a4) # 20000c78 <g_gpadc_div4_samp_valid_max>
    g_gpadc_stat = 1;
10000d86:	200017b7          	lui	a5,0x20001
10000d8a:	4705                	li	a4,1
10000d8c:	c8e78023          	sb	a4,-896(a5) # 20000c80 <g_gpadc_stat>
}
10000d90:	50f2                	lw	ra,60(sp)
10000d92:	5462                	lw	s0,56(sp)
10000d94:	54d2                	lw	s1,52(sp)
10000d96:	6121                	addi	sp,sp,64
10000d98:	8082                	ret

10000d9a <GPADC_BATUpdate>:
{
10000d9a:	1111                	addi	sp,sp,-28
10000d9c:	cc06                	sw	ra,24(sp)
10000d9e:	ca22                	sw	s0,20(sp)
10000da0:	c826                	sw	s1,16(sp)
    gpadc_ctrl = GPADC_ANA->GPADC_CTRL;
10000da2:	40040437          	lui	s0,0x40040
10000da6:	00445783          	lhu	a5,4(s0) # 40040004 <__StackTop+0x2003c004>
10000daa:	07c2                	slli	a5,a5,0x10
10000dac:	83c1                	srli	a5,a5,0x10
10000dae:	c03e                	sw	a5,0(sp)
    gpadc_clk_ctrl = GPADC_DIG->GPADC_CLK_CTRL;
10000db0:	583c                	lw	a5,112(s0)
10000db2:	c43e                	sw	a5,8(sp)
    gpadc_action = GPADC_DIG->GPADC_ACTION;
10000db4:	503c                	lw	a5,96(s0)
10000db6:	c63e                	sw	a5,12(sp)
    gpadc_cmd = GPADC_ANA->GPADC_EN;
10000db8:	00044783          	lbu	a5,0(s0)
10000dbc:	0ff7f793          	zext.b	a5,a5
10000dc0:	c23e                	sw	a5,4(sp)
    GPADC_ANA->GPADC_CTRL = 0x6889;
10000dc2:	679d                	lui	a5,0x7
10000dc4:	88978713          	addi	a4,a5,-1911 # 6889 <bt_att_create_pdu+0x4a5>
10000dc8:	00e41223          	sh	a4,4(s0)
    GPADC_DIG->GPADC_CLK_CTRL = 0x30E;
10000dcc:	30e00713          	li	a4,782
10000dd0:	d838                	sw	a4,112(s0)
    GPADC_DIG->GPADC_ACTION = 0x7002;
10000dd2:	0789                	addi	a5,a5,2
10000dd4:	d03c                	sw	a5,96(s0)
    GPADC_ANA->GPADC_EN = 0x0002;
10000dd6:	4789                	li	a5,2
10000dd8:	00f40023          	sb	a5,0(s0)
    ADC_SoftwareStartConvCmd(ENABLE);
10000ddc:	4505                	li	a0,1
10000dde:	32b5                	jal	1000074a <ADC_SoftwareStartConvCmd>
    GPADC_WaitWorkDone();
10000de0:	3c51                	jal	10000874 <GPADC_WaitWorkDone>
    return GPADC_DIG->GPADC_SAMP;
10000de2:	547c                	lw	a5,108(s0)
    div_sel = ((GPADC_ANA->GPADC_CTRL) >> 13) & 0x03;
10000de4:	00445483          	lhu	s1,4(s0)
    vip_sel = ((GPADC_ANA->GPADC_CTRL) >>  0) & 0x0f;
10000de8:	00445703          	lhu	a4,4(s0)
    if (vip_sel == GPADC_CHANNEL_P_BAT){
10000dec:	8b3d                	andi	a4,a4,15
10000dee:	46a5                	li	a3,9
10000df0:	02d70063          	beq	a4,a3,10000e10 <GPADC_BATUpdate+0x76>
    GPADC_ANA->GPADC_CTRL = gpadc_ctrl;
10000df4:	400407b7          	lui	a5,0x40040
10000df8:	4702                	lw	a4,0(sp)
10000dfa:	00e79223          	sh	a4,4(a5) # 40040004 <__StackTop+0x2003c004>
    GPADC_DIG->GPADC_CLK_CTRL = gpadc_clk_ctrl;
10000dfe:	46a2                	lw	a3,8(sp)
10000e00:	dbb4                	sw	a3,112(a5)
    GPADC_DIG->GPADC_ACTION = gpadc_action;
10000e02:	4732                	lw	a4,12(sp)
10000e04:	d3b8                	sw	a4,96(a5)
    GPADC_ANA->GPADC_EN = gpadc_cmd;
10000e06:	4712                	lw	a4,4(sp)
10000e08:	00e78023          	sb	a4,0(a5)
    int32_t samp, volt = 0, a, b;
10000e0c:	4781                	li	a5,0
10000e0e:	a8b9                	j	10000e6c <GPADC_BATUpdate+0xd2>
10000e10:	04c2                	slli	s1,s1,0x10
10000e12:	80c1                	srli	s1,s1,0x10
    samp = GPADC_GetConversionValue();
10000e14:	07c2                	slli	a5,a5,0x10
10000e16:	83c1                	srli	a5,a5,0x10
        volt = ((samp*a + b)*10)>>GPADC_CALI_ZOOM_SHIFT;
10000e18:	20001737          	lui	a4,0x20001
10000e1c:	c8472503          	lw	a0,-892(a4) # 20000c84 <g_gpadc_vbat_a>
10000e20:	02a787b3          	mul	a5,a5,a0
10000e24:	20001737          	lui	a4,0x20001
10000e28:	c8872503          	lw	a0,-888(a4) # 20000c88 <g_gpadc_vbat_b>
10000e2c:	97aa                	add	a5,a5,a0
10000e2e:	00279513          	slli	a0,a5,0x2
10000e32:	97aa                	add	a5,a5,a0
10000e34:	00779513          	slli	a0,a5,0x7
        volt = GPADC_InternalSearchBATVoltageOffset(volt);
10000e38:	8141                	srli	a0,a0,0x10
10000e3a:	f0cff0ef          	jal	ra,10000546 <GPADC_InternalSearchBATVoltageOffset>
    GPADC_ANA->GPADC_CTRL = gpadc_ctrl;
10000e3e:	400407b7          	lui	a5,0x40040
10000e42:	4702                	lw	a4,0(sp)
10000e44:	00e79223          	sh	a4,4(a5) # 40040004 <__StackTop+0x2003c004>
    GPADC_DIG->GPADC_CLK_CTRL = gpadc_clk_ctrl;
10000e48:	46a2                	lw	a3,8(sp)
10000e4a:	dbb4                	sw	a3,112(a5)
    GPADC_DIG->GPADC_ACTION = gpadc_action;
10000e4c:	4732                	lw	a4,12(sp)
10000e4e:	d3b8                	sw	a4,96(a5)
    GPADC_ANA->GPADC_EN = gpadc_cmd;
10000e50:	4712                	lw	a4,4(sp)
10000e52:	00e78023          	sb	a4,0(a5)
    div_sel = ((GPADC_ANA->GPADC_CTRL) >> 13) & 0x03;
10000e56:	80b5                	srli	s1,s1,0xd
    if(volt > (GPADC_DIV1_VOLT_MAX*(div_sel + 1))) volt = GPADC_DIV1_VOLT_MAX*(div_sel + 1);
10000e58:	888d                	andi	s1,s1,3
10000e5a:	0485                	addi	s1,s1,1
10000e5c:	6789                	lui	a5,0x2
10000e5e:	32878793          	addi	a5,a5,808 # 2328 <hci_vendor_cmd_handle+0x16>
10000e62:	02f484b3          	mul	s1,s1,a5
10000e66:	87a6                	mv	a5,s1
10000e68:	00a4fb63          	bgeu	s1,a0,10000e7e <GPADC_BATUpdate+0xe4>
    g_gpadc_vbat = volt;
10000e6c:	20001737          	lui	a4,0x20001
10000e70:	c8f71123          	sh	a5,-894(a4) # 20000c82 <g_gpadc_vbat>
}
10000e74:	40e2                	lw	ra,24(sp)
10000e76:	4452                	lw	s0,20(sp)
10000e78:	44c2                	lw	s1,16(sp)
10000e7a:	0171                	addi	sp,sp,28
10000e7c:	8082                	ret
        volt = GPADC_InternalSearchBATVoltageOffset(volt);
10000e7e:	87aa                	mv	a5,a0
10000e80:	b7f5                	j	10000e6c <GPADC_BATUpdate+0xd2>

10000e82 <print_string_to_buf>:

#endif

static void print_string_to_buf(uint8_t* uartSndBuf, uint8_t* uartSndBufUseLen, uint8_t* buf, int len)
{
	for(uint8_t i = 0; i < len; i ++)
10000e82:	04d05063          	blez	a3,10000ec2 <print_string_to_buf+0x40>
	{
		if(*uartSndBufUseLen >= DEBUG_STRING_LOG_SINGLE_LINE_MAX_SIZE)
10000e86:	0005c783          	lbu	a5,0(a1)
10000e8a:	0c700713          	li	a4,199
10000e8e:	02f76a63          	bltu	a4,a5,10000ec2 <print_string_to_buf+0x40>
	for(uint8_t i = 0; i < len; i ++)
10000e92:	4701                	li	a4,0
		if(*uartSndBufUseLen >= DEBUG_STRING_LOG_SINGLE_LINE_MAX_SIZE)
10000e94:	0c700313          	li	t1,199
		{
			return;
		}
		*(uartSndBuf + *uartSndBufUseLen) = buf[i];
10000e98:	00e602b3          	add	t0,a2,a4
10000e9c:	0002c283          	lbu	t0,0(t0)
10000ea0:	97aa                	add	a5,a5,a0
10000ea2:	00578023          	sb	t0,0(a5)

		*uartSndBufUseLen = *uartSndBufUseLen+1;
10000ea6:	0005c783          	lbu	a5,0(a1)
10000eaa:	0785                	addi	a5,a5,1
10000eac:	0ff7f793          	zext.b	a5,a5
10000eb0:	00f58023          	sb	a5,0(a1)
	for(uint8_t i = 0; i < len; i ++)
10000eb4:	0705                	addi	a4,a4,1
10000eb6:	0ff77713          	zext.b	a4,a4
10000eba:	00d75463          	bge	a4,a3,10000ec2 <print_string_to_buf+0x40>
		if(*uartSndBufUseLen >= DEBUG_STRING_LOG_SINGLE_LINE_MAX_SIZE)
10000ebe:	fcf37de3          	bgeu	t1,a5,10000e98 <print_string_to_buf+0x16>
	}
}
10000ec2:	8082                	ret

10000ec4 <omw_dbg_print_string_raw>:

void omw_dbg_print_string_raw(const char *format, va_list vaArgP)
{
10000ec4:	f0410113          	addi	sp,sp,-252
10000ec8:	dd86                	sw	ra,248(sp)
10000eca:	dba2                	sw	s0,244(sp)
10000ecc:	d9a6                	sw	s1,240(sp)
10000ece:	84aa                	mv	s1,a0
10000ed0:	c02e                	sw	a1,0(sp)
    char *pcStr, pcBuf[16], cFill;
    char HexFormat = 0;
    static const char* const g_pcHex1 = "0123456789abcdef";
    static const char* const g_pcHex2 = "0123456789ABCDEF";
    uint8_t uart_tx_buff[DEBUG_STRING_LOG_SINGLE_LINE_MAX_SIZE];
    uint8_t uart_tx_local_ptr = 0;
10000ed2:	000109a3          	sb	zero,19(sp)
    char HexFormat = 0;
10000ed6:	c202                	sw	zero,4(sp)
        {}

        // Write this portion of the string.
        if(ulIdx>0)
        {
            print_string_to_buf(uart_tx_buff, &uart_tx_local_ptr, (uint8_t*)format, ulIdx);
10000ed8:	8626                	mv	a2,s1
10000eda:	a449                	j	1000115c <omw_dbg_print_string_raw+0x298>
10000edc:	84a2                	mv	s1,s0
10000ede:	ac09                	j	100010f0 <omw_dbg_print_string_raw+0x22c>
                case '6':
                case '7':
                case '8':
                case '9':
                {
                    if((format[-1] == '0') && (ulCount == 0))
10000ee0:	00a70b63          	beq	a4,a0,10000ef6 <omw_dbg_print_string_raw+0x32>
                    {
                        cFill = '0';
                    }

                    ulCount *= 10;
10000ee4:	00241793          	slli	a5,s0,0x2
10000ee8:	943e                	add	s0,s0,a5
10000eea:	0406                	slli	s0,s0,0x1
10000eec:	fd040413          	addi	s0,s0,-48
                    ulCount += format[-1] - '0';
10000ef0:	943a                	add	s0,s0,a4
           switch(*format++)
10000ef2:	8626                	mv	a2,s1
10000ef4:	ac21                	j	1000110c <omw_dbg_print_string_raw+0x248>
                    if((format[-1] == '0') && (ulCount == 0))
10000ef6:	f47d                	bnez	s0,10000ee4 <omw_dbg_print_string_raw+0x20>
                        cFill = '0';
10000ef8:	833a                	mv	t1,a4
10000efa:	b7ed                	j	10000ee4 <omw_dbg_print_string_raw+0x20>
                    goto again;
                }

                case 'c':
                {
                    ulValue = va_arg(vaArgP, unsigned long);
10000efc:	4782                	lw	a5,0(sp)
10000efe:	00478413          	addi	s0,a5,4
10000f02:	439c                	lw	a5,0(a5)
10000f04:	d7be                	sw	a5,236(sp)
                    print_string_to_buf(uart_tx_buff, &uart_tx_local_ptr, (uint8_t*)&ulValue, 1);
10000f06:	4685                	li	a3,1
10000f08:	11f0                	addi	a2,sp,236
10000f0a:	01310593          	addi	a1,sp,19
10000f0e:	0848                	addi	a0,sp,20
10000f10:	3f8d                	jal	10000e82 <print_string_to_buf>
                    ulValue = va_arg(vaArgP, unsigned long);
10000f12:	c022                	sw	s0,0(sp)
                    break;
10000f14:	b7d1                	j	10000ed8 <omw_dbg_print_string_raw+0x14>
                }

                case 'd':
                case 'z':
                {
                    ulValue = va_arg(vaArgP, unsigned long);
10000f16:	4782                	lw	a5,0(sp)
10000f18:	00478713          	addi	a4,a5,4
10000f1c:	439c                	lw	a5,0(a5)
                    ulPos = 0;

                    if((long)ulValue < 0)
10000f1e:	0007c763          	bltz	a5,10000f2c <omw_dbg_print_string_raw+0x68>
                    ulValue = va_arg(vaArgP, unsigned long);
10000f22:	d7be                	sw	a5,236(sp)
10000f24:	c03a                	sw	a4,0(sp)
                        ulValue = -(long)ulValue;
                        ulNeg = 1;
                    }
                    else
                    {
                        ulNeg = 0;
10000f26:	4681                	li	a3,0
                    }

                    ulBase = 10;
10000f28:	4729                	li	a4,10
10000f2a:	a049                	j	10000fac <omw_dbg_print_string_raw+0xe8>
                        ulValue = -(long)ulValue;
10000f2c:	40f007b3          	neg	a5,a5
10000f30:	d7be                	sw	a5,236(sp)
                    ulValue = va_arg(vaArgP, unsigned long);
10000f32:	c03a                	sw	a4,0(sp)
                        ulNeg = 1;
10000f34:	4685                	li	a3,1
                    ulBase = 10;
10000f36:	4729                	li	a4,10
10000f38:	a895                	j	10000fac <omw_dbg_print_string_raw+0xe8>
                    goto convert;
                }

                case 's':
                {
                    pcStr = va_arg(vaArgP, char *);
10000f3a:	4782                	lw	a5,0(sp)
10000f3c:	00478713          	addi	a4,a5,4
10000f40:	c63a                	sw	a4,12(sp)
10000f42:	4390                	lw	a2,0(a5)

                    for(ulIdx = 0; pcStr[ulIdx] != '\0'; ulIdx++)
10000f44:	00064783          	lbu	a5,0(a2)
10000f48:	cba1                	beqz	a5,10000f98 <omw_dbg_print_string_raw+0xd4>
10000f4a:	4781                	li	a5,0
10000f4c:	0785                	addi	a5,a5,1
10000f4e:	00f60733          	add	a4,a2,a5
10000f52:	00074703          	lbu	a4,0(a4)
10000f56:	fb7d                	bnez	a4,10000f4c <omw_dbg_print_string_raw+0x88>
10000f58:	c43e                	sw	a5,8(sp)
                    {}

                    print_string_to_buf(uart_tx_buff, &uart_tx_local_ptr, (uint8_t*)pcStr, ulIdx);
10000f5a:	46a2                	lw	a3,8(sp)
10000f5c:	01310593          	addi	a1,sp,19
10000f60:	0848                	addi	a0,sp,20
10000f62:	3705                	jal	10000e82 <print_string_to_buf>
                    pcStr = va_arg(vaArgP, char *);
10000f64:	4732                	lw	a4,12(sp)
10000f66:	c03a                	sw	a4,0(sp)

                    if(ulCount > ulIdx)
10000f68:	47a2                	lw	a5,8(sp)
10000f6a:	f687f7e3          	bgeu	a5,s0,10000ed8 <omw_dbg_print_string_raw+0x14>
                    {
                        ulCount -= ulIdx;
10000f6e:	fff40793          	addi	a5,s0,-1
                        while(ulCount--)
10000f72:	4722                	lw	a4,8(sp)
10000f74:	40e78433          	sub	s0,a5,a4
                        {
                            print_string_to_buf(uart_tx_buff, &uart_tx_local_ptr, (uint8_t*)" ", 1);
10000f78:	4685                	li	a3,1
10000f7a:	100027b7          	lui	a5,0x10002
10000f7e:	25078613          	addi	a2,a5,592 # 10002250 <gpadc_div3_offset+0x160>
10000f82:	01310593          	addi	a1,sp,19
10000f86:	0848                	addi	a0,sp,20
10000f88:	3ded                	jal	10000e82 <print_string_to_buf>
                        while(ulCount--)
10000f8a:	147d                	addi	s0,s0,-1
10000f8c:	57fd                	li	a5,-1
10000f8e:	fef415e3          	bne	s0,a5,10000f78 <omw_dbg_print_string_raw+0xb4>
                    pcStr = va_arg(vaArgP, char *);
10000f92:	47b2                	lw	a5,12(sp)
10000f94:	c03e                	sw	a5,0(sp)
10000f96:	b789                	j	10000ed8 <omw_dbg_print_string_raw+0x14>
                    for(ulIdx = 0; pcStr[ulIdx] != '\0'; ulIdx++)
10000f98:	c402                	sw	zero,8(sp)
10000f9a:	b7c1                	j	10000f5a <omw_dbg_print_string_raw+0x96>
                    break;
                }

                case 'u':
                {
                    ulValue = va_arg(vaArgP, unsigned long);
10000f9c:	4702                	lw	a4,0(sp)
10000f9e:	431c                	lw	a5,0(a4)
10000fa0:	d7be                	sw	a5,236(sp)
10000fa2:	00470793          	addi	a5,a4,4
10000fa6:	c03e                	sw	a5,0(sp)
                    ulPos = 0;
                    ulBase = 10;
                    ulNeg = 0;
10000fa8:	4681                	li	a3,0
                    ulBase = 10;
10000faa:	4729                	li	a4,10
                    ulNeg = 0;
                     HexFormat='x';

        convert:
                    for(ulIdx = 1;
                        (((ulIdx * ulBase) <= ulValue) &&
10000fac:	55be                	lw	a1,236(sp)
                    for(ulIdx = 1;
10000fae:	06e5e263          	bltu	a1,a4,10001012 <omw_dbg_print_string_raw+0x14e>
                        (((ulIdx * ulBase) <= ulValue) &&
10000fb2:	863a                	mv	a2,a4
                         (((ulIdx * ulBase) / ulBase) == ulIdx));
                        ulIdx *= ulBase, ulCount--)
10000fb4:	147d                	addi	s0,s0,-1
                        (((ulIdx * ulBase) <= ulValue) &&
10000fb6:	87b2                	mv	a5,a2
10000fb8:	02e60633          	mul	a2,a2,a4
                    for(ulIdx = 1;
10000fbc:	00c5e663          	bltu	a1,a2,10000fc8 <omw_dbg_print_string_raw+0x104>
                         (((ulIdx * ulBase) / ulBase) == ulIdx));
10000fc0:	02e65533          	divu	a0,a2,a4
                        (((ulIdx * ulBase) <= ulValue) &&
10000fc4:	fef508e3          	beq	a0,a5,10000fb4 <omw_dbg_print_string_raw+0xf0>
                    {
                    }

                    if(ulNeg)
10000fc8:	04068c63          	beqz	a3,10001020 <omw_dbg_print_string_raw+0x15c>
                    {
                        ulCount--;
10000fcc:	fff40613          	addi	a2,s0,-1
                    }

                    if(ulNeg && (cFill == '0'))
10000fd0:	03000513          	li	a0,48
10000fd4:	04a30163          	beq	t1,a0,10001016 <omw_dbg_print_string_raw+0x152>
                    {
                        pcBuf[ulPos++] = '-';
                        ulNeg = 0;
                    }

                    if((ulCount > 1) && (ulCount < 16))
10000fd8:	ffd40293          	addi	t0,s0,-3
10000fdc:	4535                	li	a0,13
10000fde:	08557f63          	bgeu	a0,t0,1000107c <omw_dbg_print_string_raw+0x1b8>
10000fe2:	4601                	li	a2,0
10000fe4:	a0a5                	j	1000104c <omw_dbg_print_string_raw+0x188>
                    ulValue = va_arg(vaArgP, unsigned long);
10000fe6:	4682                	lw	a3,0(sp)
10000fe8:	429c                	lw	a5,0(a3)
10000fea:	d7be                	sw	a5,236(sp)
10000fec:	00468793          	addi	a5,a3,4
10000ff0:	c03e                	sw	a5,0(sp)
                    HexFormat='X';
10000ff2:	c23a                	sw	a4,4(sp)
                    ulNeg = 0;
10000ff4:	4681                	li	a3,0
                    ulBase = 16;
10000ff6:	4741                	li	a4,16
                    goto convert;
10000ff8:	bf55                	j	10000fac <omw_dbg_print_string_raw+0xe8>
                    ulValue = va_arg(vaArgP, unsigned long);
10000ffa:	4702                	lw	a4,0(sp)
10000ffc:	431c                	lw	a5,0(a4)
10000ffe:	d7be                	sw	a5,236(sp)
10001000:	00470793          	addi	a5,a4,4
10001004:	c03e                	sw	a5,0(sp)
                     HexFormat='x';
10001006:	07800793          	li	a5,120
1000100a:	c23e                	sw	a5,4(sp)
                    ulNeg = 0;
1000100c:	4681                	li	a3,0
                    ulBase = 16;
1000100e:	4741                	li	a4,16
10001010:	bf71                	j	10000fac <omw_dbg_print_string_raw+0xe8>
                    for(ulIdx = 1;
10001012:	4785                	li	a5,1
10001014:	bf55                	j	10000fc8 <omw_dbg_print_string_raw+0x104>
                        pcBuf[ulPos++] = '-';
10001016:	02d00513          	li	a0,45
1000101a:	0ca10e23          	sb	a0,220(sp)
                        ulCount--;
1000101e:	8432                	mv	s0,a2
                    if((ulCount > 1) && (ulCount < 16))
10001020:	ffe40613          	addi	a2,s0,-2
10001024:	4535                	li	a0,13
10001026:	02c56d63          	bltu	a0,a2,10001060 <omw_dbg_print_string_raw+0x19c>
1000102a:	4281                	li	t0,0
                    {
                        for(ulCount--; ulCount; ulCount--)
1000102c:	09f0                	addi	a2,sp,220
1000102e:	9636                	add	a2,a2,a3
10001030:	0db10513          	addi	a0,sp,219
10001034:	9536                	add	a0,a0,a3
10001036:	9522                	add	a0,a0,s0
                        {
                            pcBuf[ulPos++] = cFill;
10001038:	00660023          	sb	t1,0(a2)
                        for(ulCount--; ulCount; ulCount--)
1000103c:	0605                	addi	a2,a2,1
1000103e:	fec51de3          	bne	a0,a2,10001038 <omw_dbg_print_string_raw+0x174>
10001042:	96a2                	add	a3,a3,s0
                            pcBuf[ulPos++] = cFill;
10001044:	fff68613          	addi	a2,a3,-1
                        }
                    }

                    if(ulNeg)
10001048:	02028e63          	beqz	t0,10001084 <omw_dbg_print_string_raw+0x1c0>
                    {
                        pcBuf[ulPos++] = '-';
1000104c:	00160693          	addi	a3,a2,1
10001050:	0e060613          	addi	a2,a2,224
10001054:	0808                	addi	a0,sp,16
10001056:	962a                	add	a2,a2,a0
10001058:	02d00513          	li	a0,45
1000105c:	fea60623          	sb	a0,-20(a2)
                    }

                    for(; ulIdx; ulIdx /= ulBase)
10001060:	c3ad                	beqz	a5,100010c2 <omw_dbg_print_string_raw+0x1fe>
10001062:	0685                	addi	a3,a3,1
                    {
                        if(HexFormat=='x')  pcBuf[ulPos++] = g_pcHex1[(ulValue / ulIdx) % ulBase];//x
10001064:	07800513          	li	a0,120
                        else    pcBuf[ulPos++] = g_pcHex2[(ulValue / ulIdx) % ulBase];//X
10001068:	10002337          	lui	t1,0x10002
1000106c:	26830313          	addi	t1,t1,616 # 10002268 <gpadc_div3_offset+0x178>
                        if(HexFormat=='x')  pcBuf[ulPos++] = g_pcHex1[(ulValue / ulIdx) % ulBase];//x
10001070:	100022b7          	lui	t0,0x10002
10001074:	25428293          	addi	t0,t0,596 # 10002254 <gpadc_div3_offset+0x164>
10001078:	4392                	lw	t2,4(sp)
1000107a:	a815                	j	100010ae <omw_dbg_print_string_raw+0x1ea>
                    if((ulCount > 1) && (ulCount < 16))
1000107c:	82b6                	mv	t0,a3
                        ulCount--;
1000107e:	8432                	mv	s0,a2
                    if((ulCount > 1) && (ulCount < 16))
10001080:	4681                	li	a3,0
10001082:	b76d                	j	1000102c <omw_dbg_print_string_raw+0x168>
                            pcBuf[ulPos++] = cFill;
10001084:	86b2                	mv	a3,a2
10001086:	bfe9                	j	10001060 <omw_dbg_print_string_raw+0x19c>
                        if(HexFormat=='x')  pcBuf[ulPos++] = g_pcHex1[(ulValue / ulIdx) % ulBase];//x
10001088:	02f5d633          	divu	a2,a1,a5
1000108c:	02e67633          	remu	a2,a2,a4
10001090:	9616                	add	a2,a2,t0
10001092:	00064403          	lbu	s0,0(a2)
10001096:	09f0                	addi	a2,sp,220
10001098:	9636                	add	a2,a2,a3
1000109a:	fe860fa3          	sb	s0,-1(a2)
                    for(; ulIdx; ulIdx /= ulBase)
1000109e:	02e7d433          	divu	s0,a5,a4
100010a2:	00168613          	addi	a2,a3,1
100010a6:	00e7ee63          	bltu	a5,a4,100010c2 <omw_dbg_print_string_raw+0x1fe>
100010aa:	86b2                	mv	a3,a2
100010ac:	87a2                	mv	a5,s0
                        if(HexFormat=='x')  pcBuf[ulPos++] = g_pcHex1[(ulValue / ulIdx) % ulBase];//x
100010ae:	fca38de3          	beq	t2,a0,10001088 <omw_dbg_print_string_raw+0x1c4>
                        else    pcBuf[ulPos++] = g_pcHex2[(ulValue / ulIdx) % ulBase];//X
100010b2:	02f5d633          	divu	a2,a1,a5
100010b6:	02e67633          	remu	a2,a2,a4
100010ba:	961a                	add	a2,a2,t1
100010bc:	00064403          	lbu	s0,0(a2)
100010c0:	bfd9                	j	10001096 <omw_dbg_print_string_raw+0x1d2>
                    }

                    print_string_to_buf(uart_tx_buff, &uart_tx_local_ptr, (uint8_t*)pcBuf, ulPos);
100010c2:	09f0                	addi	a2,sp,220
100010c4:	01310593          	addi	a1,sp,19
100010c8:	0848                	addi	a0,sp,20
100010ca:	3b65                	jal	10000e82 <print_string_to_buf>
                    break;
100010cc:	b531                	j	10000ed8 <omw_dbg_print_string_raw+0x14>
                }

                case '%':
                {
                    print_string_to_buf(uart_tx_buff, &uart_tx_local_ptr, (uint8_t*)format - 1, 1);
100010ce:	4685                	li	a3,1
100010d0:	01310593          	addi	a1,sp,19
100010d4:	0848                	addi	a0,sp,20
100010d6:	3375                	jal	10000e82 <print_string_to_buf>
                    break;
100010d8:	b501                	j	10000ed8 <omw_dbg_print_string_raw+0x14>
                    goto again;
                }

                default:
                {
                    print_string_to_buf(uart_tx_buff, &uart_tx_local_ptr, (uint8_t*)"ERROR", 5);
100010da:	4695                	li	a3,5
100010dc:	10002637          	lui	a2,0x10002
100010e0:	27c60613          	addi	a2,a2,636 # 1000227c <gpadc_div3_offset+0x18c>
100010e4:	01310593          	addi	a1,sp,19
100010e8:	0848                	addi	a0,sp,20
100010ea:	3b61                	jal	10000e82 <print_string_to_buf>
                    break;
100010ec:	b3f5                	j	10000ed8 <omw_dbg_print_string_raw+0x14>
100010ee:	84b2                	mv	s1,a2
100010f0:	8426                	mv	s0,s1
            format++;
100010f2:	00140613          	addi	a2,s0,1
            cFill = ' ';
100010f6:	02000313          	li	t1,32
            ulCount = 0;
100010fa:	4401                	li	s0,0
           switch(*format++)
100010fc:	05500693          	li	a3,85
10001100:	100027b7          	lui	a5,0x10002
10001104:	28478593          	addi	a1,a5,644 # 10002284 <gpadc_div3_offset+0x194>
                    if((format[-1] == '0') && (ulCount == 0))
10001108:	03000513          	li	a0,48
           switch(*format++)
1000110c:	00160493          	addi	s1,a2,1
10001110:	00064703          	lbu	a4,0(a2)
10001114:	fdb70793          	addi	a5,a4,-37
10001118:	0ff7f293          	zext.b	t0,a5
1000111c:	fa56efe3          	bltu	a3,t0,100010da <omw_dbg_print_string_raw+0x216>
10001120:	00229793          	slli	a5,t0,0x2
10001124:	97ae                	add	a5,a5,a1
10001126:	439c                	lw	a5,0(a5)
10001128:	8782                	jr	a5
        }//if
    }//while

    // Send packet
#if defined(DEBUG_STRING_NO_PROTOCOL) || defined(FUNCTION_CONTROL_DEBUG_PRINTF_ONLY_ENABLE)
    omw_uart_send(OMW_LOG_UART, uart_tx_buff, uart_tx_local_ptr);
1000112a:	01314603          	lbu	a2,19(sp)
1000112e:	084c                	addi	a1,sp,20
10001130:	41001537          	lui	a0,0x41001
10001134:	9baff0ef          	jal	ra,100002ee <omw_uart_send>
#else
    omw_dbg_uart_protocol(DEBUG_PROTOCL_TYPE_STRING, uart_tx_buff, uart_tx_local_ptr, NULL, 0);
#endif
}
10001138:	50ee                	lw	ra,248(sp)
1000113a:	545e                	lw	s0,244(sp)
1000113c:	54ce                	lw	s1,240(sp)
1000113e:	0fc10113          	addi	sp,sp,252
10001142:	8082                	ret
        if(ulIdx>0)
10001144:	d6dd                	beqz	a3,100010f2 <omw_dbg_print_string_raw+0x22e>
            print_string_to_buf(uart_tx_buff, &uart_tx_local_ptr, (uint8_t*)format, ulIdx);
10001146:	01310593          	addi	a1,sp,19
1000114a:	0848                	addi	a0,sp,20
1000114c:	3b1d                	jal	10000e82 <print_string_to_buf>
        if(*format == '%')
1000114e:	00044703          	lbu	a4,0(s0)
10001152:	02500793          	li	a5,37
10001156:	d8f703e3          	beq	a4,a5,10000edc <omw_dbg_print_string_raw+0x18>
    char HexFormat = 0;
1000115a:	8622                	mv	a2,s0
    while(*format)
1000115c:	00064783          	lbu	a5,0(a2)
10001160:	d7e9                	beqz	a5,1000112a <omw_dbg_print_string_raw+0x266>
        for(ulIdx = 0; (format[ulIdx] != '%') && (format[ulIdx] != '\0');ulIdx++)
10001162:	02500713          	li	a4,37
10001166:	f8e784e3          	beq	a5,a4,100010ee <omw_dbg_print_string_raw+0x22a>
1000116a:	00160793          	addi	a5,a2,1
1000116e:	4681                	li	a3,0
10001170:	02500593          	li	a1,37
10001174:	0685                	addi	a3,a3,1
10001176:	843e                	mv	s0,a5
10001178:	0007c703          	lbu	a4,0(a5)
1000117c:	fcb704e3          	beq	a4,a1,10001144 <omw_dbg_print_string_raw+0x280>
10001180:	0785                	addi	a5,a5,1
10001182:	fb6d                	bnez	a4,10001174 <omw_dbg_print_string_raw+0x2b0>
        if(ulIdx>0)
10001184:	fc068be3          	beqz	a3,1000115a <omw_dbg_print_string_raw+0x296>
10001188:	bf7d                	j	10001146 <omw_dbg_print_string_raw+0x282>

1000118a <omw_dbg_init>:

void omw_dbg_init(void)
{
1000118a:	1151                	addi	sp,sp,-12
1000118c:	c406                	sw	ra,8(sp)
    //de-init uart gpio
    omw_gpio_set_func(OMW_GPIO_PIN20, 0);
1000118e:	4581                	li	a1,0
10001190:	4551                	li	a0,20
10001192:	ff5fe0ef          	jal	ra,10000186 <omw_gpio_set_func>
    omw_gpio_set_func(OMW_GPIO_PIN21, 0);
10001196:	4581                	li	a1,0
10001198:	4555                	li	a0,21
1000119a:	fedfe0ef          	jal	ra,10000186 <omw_gpio_set_func>

    omw_uart_init(OMW_LOG_UART, OMW_LOG_UART_BAUDRATE, 0);
1000119e:	4601                	li	a2,0
100011a0:	65f1                	lui	a1,0x1c
100011a2:	20058593          	addi	a1,a1,512 # 1c200 <rom_func_end_check_val+0x1259c>
100011a6:	41001537          	lui	a0,0x41001
100011aa:	882ff0ef          	jal	ra,1000022c <omw_uart_init>
    omw_gpio_set_func(OMW_LOG_UART_RX_PIN, OMW_GPIO_CFG_VAL(OMW_GPIO_DRIVE_STRENTH3, OMW_LOG_UART_RX_FUNC | OMW_GPIO_MODE_IN_PULL_UP));
100011ae:	03a00593          	li	a1,58
100011b2:	4551                	li	a0,20
100011b4:	fd3fe0ef          	jal	ra,10000186 <omw_gpio_set_func>
    omw_gpio_set_func(OMW_LOG_UART_TX_PIN, OMW_GPIO_CFG_VAL(OMW_GPIO_DRIVE_STRENTH3, OMW_LOG_UART_TX_FUNC));
100011b8:	45e9                	li	a1,26
100011ba:	4555                	li	a0,21
100011bc:	fcbfe0ef          	jal	ra,10000186 <omw_gpio_set_func>
}
100011c0:	40a2                	lw	ra,8(sp)
100011c2:	0131                	addi	sp,sp,12
100011c4:	8082                	ret

100011c6 <strlen>:

size_t strlen(const char * str)
{
    int c = 0;

    while(str[c++] != '\0');
100011c6:	4781                	li	a5,0
100011c8:	86be                	mv	a3,a5
100011ca:	0785                	addi	a5,a5,1
100011cc:	00f50733          	add	a4,a0,a5
100011d0:	fff74703          	lbu	a4,-1(a4)
100011d4:	fb75                	bnez	a4,100011c8 <strlen+0x2>

    return (c - 1);
}
100011d6:	8536                	mv	a0,a3
100011d8:	8082                	ret

100011da <puts>:

    return 0;
}

int puts(const char * str)
{
100011da:	1151                	addi	sp,sp,-12
100011dc:	c406                	sw	ra,8(sp)
100011de:	c222                	sw	s0,4(sp)
100011e0:	842a                	mv	s0,a0
	omw_uart_send(OMW_LOG_UART, (void *)str, strlen(str));
100011e2:	37d5                	jal	100011c6 <strlen>
100011e4:	862a                	mv	a2,a0
100011e6:	85a2                	mv	a1,s0
100011e8:	41001537          	lui	a0,0x41001
100011ec:	902ff0ef          	jal	ra,100002ee <omw_uart_send>
    omw_uart_send(OMW_LOG_UART, "\n", 1);
100011f0:	4605                	li	a2,1
100011f2:	100025b7          	lui	a1,0x10002
100011f6:	3dc58593          	addi	a1,a1,988 # 100023dc <gpadc_div3_offset+0x2ec>
100011fa:	41001537          	lui	a0,0x41001
100011fe:	8f0ff0ef          	jal	ra,100002ee <omw_uart_send>

    return 0;
}
10001202:	4501                	li	a0,0
10001204:	40a2                	lw	ra,8(sp)
10001206:	4412                	lw	s0,4(sp)
10001208:	0131                	addi	sp,sp,12
1000120a:	8082                	ret

1000120c <printf>:

int printf(const char *format, ...)
{
1000120c:	fdc10113          	addi	sp,sp,-36
10001210:	c606                	sw	ra,12(sp)
10001212:	c82e                	sw	a1,16(sp)
10001214:	ca32                	sw	a2,20(sp)
10001216:	cc36                	sw	a3,24(sp)
10001218:	ce3a                	sw	a4,28(sp)
1000121a:	d03e                	sw	a5,32(sp)
	va_list ap;

	va_start(ap, format);
1000121c:	080c                	addi	a1,sp,16
1000121e:	c02e                	sw	a1,0(sp)

    omw_dbg_print_string_raw(format, ap);
10001220:	3155                	jal	10000ec4 <omw_dbg_print_string_raw>

    va_end(ap);

    return 0;
}
10001222:	4501                	li	a0,0
10001224:	40b2                	lw	ra,12(sp)
10001226:	02410113          	addi	sp,sp,36
1000122a:	8082                	ret

1000122c <GPIO_FunctionConfig>:
void GPIO_FunctionConfig(uint8_t PinNum, uint8_t CfgVal)
{
    volatile uint32_t * pcfg = (volatile uint32_t *)OMW_GPIO_CFG_BASE_ADDR;

    uint32_t wof = (PinNum >> 2);
    uint32_t bof = (PinNum & 3);
1000122c:	00357713          	andi	a4,a0,3
    uint32_t msk = (0xFF << (8 * bof));
10001230:	070e                	slli	a4,a4,0x3
    uint32_t rv  = *(pcfg + wof);
10001232:	0fc57513          	andi	a0,a0,252
10001236:	400107b7          	lui	a5,0x40010
1000123a:	20078793          	addi	a5,a5,512 # 40010200 <__StackTop+0x2000c200>
1000123e:	953e                	add	a0,a0,a5
10001240:	4114                	lw	a3,0(a0)
    uint32_t msk = (0xFF << (8 * bof));
10001242:	0ff00793          	li	a5,255
10001246:	00e797b3          	sll	a5,a5,a4

    rv &= (~msk);
1000124a:	fff7c793          	not	a5,a5
1000124e:	8ff5                	and	a5,a5,a3
    rv |= (CfgVal << (8 * bof));
10001250:	00e595b3          	sll	a1,a1,a4
10001254:	8fcd                	or	a5,a5,a1

    *(pcfg + wof) = rv;
10001256:	c11c                	sw	a5,0(a0)
}
10001258:	8082                	ret

1000125a <GPIO_StructInit>:

// 结构体初始化函数
void GPIO_StructInit(GPIO_InitTypeDef *GPIO_InitStruct){
    GPIO_InitStruct->GPIO_Pin = GPIO_PIN_NONE;
1000125a:	00052023          	sw	zero,0(a0) # 41001000 <__StackTop+0x20ffd000>
    GPIO_InitStruct->GPIO_Mode = GPIO_MODE_HIZ;
1000125e:	4795                	li	a5,5
10001260:	00f50223          	sb	a5,4(a0)
    GPIO_InitStruct->GPIO_AltFunc = GPIO_ATF_NONE;
10001264:	000502a3          	sb	zero,5(a0)
    GPIO_InitStruct->GPIO_DriveStrength = GPIO_DRIVE_STRENGTH_0;
10001268:	00050323          	sb	zero,6(a0)
}
1000126c:	8082                	ret

1000126e <GPIO_OutputCMD>:
 * param:GPIO_Pin: (#define GPIO_PIN_0---#define GPIO_PIN_23)
 *       state : ENABLE/DISABLE
 */
void GPIO_OutputCMD(uint32_t GPIO_Pin, FunctionalState state)
{
    if(state != DISABLE)
1000126e:	c599                	beqz	a1,1000127c <GPIO_OutputCMD+0xe>
    {
        GPIO_INOUT->GPIO_OE |= GPIO_Pin;
10001270:	400107b7          	lui	a5,0x40010
10001274:	5b98                	lw	a4,48(a5)
10001276:	8d59                	or	a0,a0,a4
10001278:	db88                	sw	a0,48(a5)
1000127a:	8082                	ret
    }
    else
    {
        GPIO_INOUT->GPIO_OE &= ~GPIO_Pin;
1000127c:	400107b7          	lui	a5,0x40010
10001280:	5b98                	lw	a4,48(a5)
10001282:	fff54513          	not	a0,a0
10001286:	8d79                	and	a0,a0,a4
10001288:	db88                	sw	a0,48(a5)
    }
}
1000128a:	8082                	ret

1000128c <GPIO_Init>:
{
1000128c:	1141                	addi	sp,sp,-16
1000128e:	c606                	sw	ra,12(sp)
10001290:	c422                	sw	s0,8(sp)
10001292:	c226                	sw	s1,4(sp)
10001294:	84aa                	mv	s1,a0
    if (GPIO_InitStruct->GPIO_Mode == GPIO_MODE_OUT_PP)
10001296:	00454403          	lbu	s0,4(a0)
1000129a:	47c1                	li	a5,16
1000129c:	02f40463          	beq	s0,a5,100012c4 <GPIO_Init+0x38>
        func_atf = GPIO_InitStruct->GPIO_AltFunc;
100012a0:	00554783          	lbu	a5,5(a0)
100012a4:	c03e                	sw	a5,0(sp)
        GPIO_OutputCMD(GPIO_InitStruct->GPIO_Pin, DISABLE);
100012a6:	4581                	li	a1,0
100012a8:	4108                	lw	a0,0(a0)
100012aa:	37d1                	jal	1000126e <GPIO_OutputCMD>
    func = GPIO_FunctionAsselbme(func_mod, func_drv, func_atf);
100012ac:	0064c783          	lbu	a5,6(s1)
100012b0:	078e                	slli	a5,a5,0x3
100012b2:	4702                	lw	a4,0(sp)
100012b4:	8fd9                	or	a5,a5,a4
100012b6:	0416                	slli	s0,s0,0x5
100012b8:	8c5d                	or	s0,s0,a5
100012ba:	0ff47793          	zext.b	a5,s0
100012be:	c03e                	sw	a5,0(sp)
100012c0:	4401                	li	s0,0
100012c2:	a839                	j	100012e0 <GPIO_Init+0x54>
        GPIO_ResetBits(GPIO_InitStruct->GPIO_Pin);
100012c4:	4108                	lw	a0,0(a0)
}

// 对应引脚输出bit位，置0
void GPIO_ResetBits(uint32_t GPIO_Pin)
{
    GPIO_INOUT->GPIO_O_CLR = GPIO_Pin;
100012c6:	400107b7          	lui	a5,0x40010
100012ca:	08a7a823          	sw	a0,144(a5) # 40010090 <__StackTop+0x2000c090>
        GPIO_OutputCMD(GPIO_InitStruct->GPIO_Pin, ENABLE);
100012ce:	4585                	li	a1,1
100012d0:	3f79                	jal	1000126e <GPIO_OutputCMD>
        func_atf = 0;
100012d2:	c002                	sw	zero,0(sp)
        func_mod = 0;
100012d4:	4401                	li	s0,0
100012d6:	bfd9                	j	100012ac <GPIO_Init+0x20>
    for(i=0; i<24; i++)
100012d8:	0405                	addi	s0,s0,1
100012da:	47e1                	li	a5,24
100012dc:	00f40c63          	beq	s0,a5,100012f4 <GPIO_Init+0x68>
100012e0:	0ff47513          	zext.b	a0,s0
        if(((GPIO_InitStruct->GPIO_Pin) >> i) & 1)
100012e4:	409c                	lw	a5,0(s1)
100012e6:	0087d7b3          	srl	a5,a5,s0
100012ea:	8b85                	andi	a5,a5,1
100012ec:	d7f5                	beqz	a5,100012d8 <GPIO_Init+0x4c>
            GPIO_FunctionConfig(i, func);
100012ee:	4582                	lw	a1,0(sp)
100012f0:	3f35                	jal	1000122c <GPIO_FunctionConfig>
100012f2:	b7dd                	j	100012d8 <GPIO_Init+0x4c>
}
100012f4:	40b2                	lw	ra,12(sp)
100012f6:	4422                	lw	s0,8(sp)
100012f8:	4492                	lw	s1,4(sp)
100012fa:	0141                	addi	sp,sp,16
100012fc:	8082                	ret

100012fe <GPIO_SetBits>:
    GPIO_INOUT->GPIO_O_SET = GPIO_Pin;
100012fe:	400107b7          	lui	a5,0x40010
10001302:	08a7a023          	sw	a0,128(a5) # 40010080 <__StackTop+0x2000c080>
}
10001306:	8082                	ret

10001308 <GPIO_ResetBits>:
    GPIO_INOUT->GPIO_O_CLR = GPIO_Pin;
10001308:	400107b7          	lui	a5,0x40010
1000130c:	08a7a823          	sw	a0,144(a5) # 40010090 <__StackTop+0x2000c090>
}
10001310:	8082                	ret

10001312 <GPIO_GetIORes>:
{
    uint16_t *tbl;
    uint16_t vbat_idx;
    uint16_t res, res_base, res_diff;
    // table select
    if(isToGND)
10001312:	e651                	bnez	a2,1000139e <GPIO_GetIORes+0x8c>
    {
        tbl = (uint16_t *)gpio_res_tbl_gnd;
    }
    else
    {
        tbl = (uint16_t *)gpio_res_tbl_vdd;
10001314:	100026b7          	lui	a3,0x10002
10001318:	46068693          	addi	a3,a3,1120 # 10002460 <gpio_res_tbl_vdd>
    }
    // vbat index
    if(Vbat > GPIO_RES_TBL_VBAT_MAX)
1000131c:	6785                	lui	a5,0x1
1000131e:	ce478793          	addi	a5,a5,-796 # ce4 <__STACK_SIZE+0x9e4>
    {
        vbat_idx = GPIO_RES_TBL_VBAT_IDX_MAX;
10001322:	473d                	li	a4,15
    if(Vbat > GPIO_RES_TBL_VBAT_MAX)
10001324:	00b7ef63          	bltu	a5,a1,10001342 <GPIO_GetIORes+0x30>
    }
    else if(Vbat < GPIO_RES_TBL_VBAT_MIN)
10001328:	70700793          	li	a5,1799
    {
        vbat_idx = GPIO_RES_TBL_VBAT_IDX_MIN;
1000132c:	4701                	li	a4,0
    else if(Vbat < GPIO_RES_TBL_VBAT_MIN)
1000132e:	00b7fa63          	bgeu	a5,a1,10001342 <GPIO_GetIORes+0x30>
    }
    else
    {
        vbat_idx = (Vbat - GPIO_RES_TBL_VBAT_MIN)/100;
10001332:	8f858713          	addi	a4,a1,-1800
10001336:	06400793          	li	a5,100
1000133a:	02f74733          	div	a4,a4,a5
1000133e:	0742                	slli	a4,a4,0x10
10001340:	8341                	srli	a4,a4,0x10
    }
    DriveStrength &= 3;
    // get two adjacent elements
    res_base = tbl[vbat_idx*4 + DriveStrength];
10001342:	890d                	andi	a0,a0,3
10001344:	00271793          	slli	a5,a4,0x2
10001348:	97aa                	add	a5,a5,a0
1000134a:	0786                	slli	a5,a5,0x1
1000134c:	97b6                	add	a5,a5,a3
1000134e:	0007d783          	lhu	a5,0(a5)
    if(Vbat >= GPIO_RES_TBL_VBAT_MAX)
10001352:	6605                	lui	a2,0x1
10001354:	ce360613          	addi	a2,a2,-797 # ce3 <__STACK_SIZE+0x9e3>
10001358:	04b66863          	bltu	a2,a1,100013a8 <GPIO_GetIORes+0x96>
    {
        res = res_base;
        return ((res + 5)/10);
    }
    res_diff = res_base - tbl[(vbat_idx+1)*4 + DriveStrength];
1000135c:	0705                	addi	a4,a4,1
1000135e:	0742                	slli	a4,a4,0x10
10001360:	8341                	srli	a4,a4,0x10
10001362:	070a                	slli	a4,a4,0x2
10001364:	972a                	add	a4,a4,a0
10001366:	0706                	slli	a4,a4,0x1
10001368:	9736                	add	a4,a4,a3
1000136a:	00075503          	lhu	a0,0(a4)
1000136e:	40a78533          	sub	a0,a5,a0
    res = res_base - (res_diff * (Vbat%100) / 100);
10001372:	0542                	slli	a0,a0,0x10
10001374:	8141                	srli	a0,a0,0x10
10001376:	06400713          	li	a4,100
1000137a:	02e5f5b3          	remu	a1,a1,a4
1000137e:	02b50533          	mul	a0,a0,a1
10001382:	f9c00593          	li	a1,-100
10001386:	02b54533          	div	a0,a0,a1
1000138a:	953e                	add	a0,a0,a5
    // return
    return ((res + 5)/10);
1000138c:	0542                	slli	a0,a0,0x10
1000138e:	8141                	srli	a0,a0,0x10
10001390:	0515                	addi	a0,a0,5
10001392:	47a9                	li	a5,10
10001394:	02f54533          	div	a0,a0,a5
10001398:	0542                	slli	a0,a0,0x10
1000139a:	8141                	srli	a0,a0,0x10
}
1000139c:	8082                	ret
        tbl = (uint16_t *)gpio_res_tbl_gnd;
1000139e:	100026b7          	lui	a3,0x10002
100013a2:	3e068693          	addi	a3,a3,992 # 100023e0 <gpio_res_tbl_gnd>
100013a6:	bf9d                	j	1000131c <GPIO_GetIORes+0xa>
        return ((res + 5)/10);
100013a8:	00578513          	addi	a0,a5,5
100013ac:	47a9                	li	a5,10
100013ae:	02f54533          	div	a0,a0,a5
100013b2:	0542                	slli	a0,a0,0x10
100013b4:	8141                	srli	a0,a0,0x10
100013b6:	8082                	ret

100013b8 <omw_otp_load_cfg>:
#endif

void omw_otp_load_cfg()
{
    // Read from OTP
    memcpy((void*)&g_otp_cfg, (void *)OTP_CFG_ADDR, sizeof(otp_cfg_t));
100013b8:	1f8046b7          	lui	a3,0x1f804
100013bc:	f3068713          	addi	a4,a3,-208 # 1f803f30 <__FLASH_OP_BASE+0xf7c6f30>
100013c0:	200017b7          	lui	a5,0x20001
100013c4:	c8c78793          	addi	a5,a5,-884 # 20000c8c <g_otp_cfg>
100013c8:	f7868693          	addi	a3,a3,-136
100013cc:	00072383          	lw	t2,0(a4)
100013d0:	00472283          	lw	t0,4(a4)
100013d4:	00872303          	lw	t1,8(a4)
100013d8:	4748                	lw	a0,12(a4)
100013da:	4b0c                	lw	a1,16(a4)
100013dc:	4b50                	lw	a2,20(a4)
100013de:	0077a023          	sw	t2,0(a5)
100013e2:	0057a223          	sw	t0,4(a5)
100013e6:	0067a423          	sw	t1,8(a5)
100013ea:	c7c8                	sw	a0,12(a5)
100013ec:	cb8c                	sw	a1,16(a5)
100013ee:	cbd0                	sw	a2,20(a5)
100013f0:	0761                	addi	a4,a4,24
100013f2:	07e1                	addi	a5,a5,24
100013f4:	fcd71ce3          	bne	a4,a3,100013cc <omw_otp_load_cfg+0x14>

    // RF
    if (!OTP_CHECK_PARITY(g_otp_cfg.rf_bg_vtrim.raw, 1)) {
100013f8:	200017b7          	lui	a5,0x20001
100013fc:	c8c7c703          	lbu	a4,-884(a5) # 20000c8c <g_otp_cfg>
10001400:	0ff00793          	li	a5,255
10001404:	12f70663          	beq	a4,a5,10001530 <omw_otp_load_cfg+0x178>
        g_otp_cfg.rf_bg_vtrim.value = RF_BG_VTRIM_DEFAULT;
    }
    // if (!OTP_CHECK_PARITY(g_otp_cfg.rf_bg_volt_offset, 1)) {
    //     g_otp_cfg.rf_bg_volt_offset = 0;
    // }
    if (!OTP_CHECK_PARITY(g_otp_cfg.aon_rg_bg_vref_trim.raw, 1)) {
10001408:	200017b7          	lui	a5,0x20001
1000140c:	c8e7c703          	lbu	a4,-882(a5) # 20000c8e <g_otp_cfg+0x2>
10001410:	0ff00793          	li	a5,255
10001414:	12f70a63          	beq	a4,a5,10001548 <omw_otp_load_cfg+0x190>
    }
    // if (!OTP_CHECK_PARITY(g_otp_cfg.aon_bg_volt_offset, 1)) {
    //     g_otp_cfg.aon_bg_volt_offset = 0;
    // }
// #ifndef OMW_NO_RC_CAL
    if (!OTP_CHECK_PARITY(g_otp_cfg.aon_rco24m_cc.raw, 2)) {
10001418:	200017b7          	lui	a5,0x20001
1000141c:	c907d703          	lhu	a4,-880(a5) # 20000c90 <g_otp_cfg+0x4>
10001420:	67c1                	lui	a5,0x10
10001422:	17fd                	addi	a5,a5,-1
10001424:	12f70e63          	beq	a4,a5,10001560 <omw_otp_load_cfg+0x1a8>
        g_otp_cfg.aon_rco24m_cc.value = RCO_24M_CC_DEF;
    }
    if (!OTP_CHECK_PARITY(g_otp_cfg.aon_rco32k_cc.raw, 2)) {
10001428:	200017b7          	lui	a5,0x20001
1000142c:	c927d703          	lhu	a4,-878(a5) # 20000c92 <g_otp_cfg+0x6>
10001430:	67c1                	lui	a5,0x10
10001432:	17fd                	addi	a5,a5,-1
10001434:	12f70d63          	beq	a4,a5,1000156e <omw_otp_load_cfg+0x1b6>
        g_otp_cfg.aon_rco32k_cc.value = RCO_32K_CC_DEF;
    }
// #endif // !OMW_NO_RC_CAL

    if (!OTP_CHECK_PARITY(g_otp_cfg.corner_tgt_freq.raw, 2)) {
10001438:	200017b7          	lui	a5,0x20001
1000143c:	c947d703          	lhu	a4,-876(a5) # 20000c94 <g_otp_cfg+0x8>
10001440:	67c1                	lui	a5,0x10
10001442:	17fd                	addi	a5,a5,-1
10001444:	12f70c63          	beq	a4,a5,1000157c <omw_otp_load_cfg+0x1c4>
        g_otp_cfg.corner_tgt_freq.value = RF_CORNER_CLK_DEF;
    }
#ifndef OMW_NO_GPADC_CAL
    // GPADC DIV1
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.gpadc_high_div1.raw, 4)) {
10001448:	200017b7          	lui	a5,0x20001
1000144c:	c987a703          	lw	a4,-872(a5) # 20000c98 <g_otp_cfg+0xc>
10001450:	57fd                	li	a5,-1
10001452:	14f70263          	beq	a4,a5,10001596 <omw_otp_load_cfg+0x1de>
        g_otp_cfg.gpadc_high_div1.voltage = GPADC_DIV1_HI_VOLT_DEF;
        g_otp_cfg.gpadc_high_div1.sample = GPADC_DIV1_HI_SAMP_DEF;
    }
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.gpadc_low_div1.raw, 4)) {
10001456:	200017b7          	lui	a5,0x20001
1000145a:	c9c7a703          	lw	a4,-868(a5) # 20000c9c <g_otp_cfg+0x10>
1000145e:	57fd                	li	a5,-1
10001460:	14f70d63          	beq	a4,a5,100015ba <omw_otp_load_cfg+0x202>
        g_otp_cfg.gpadc_low_div1.voltage = GPADC_DIV1_LO_VOLT_DEF;
        g_otp_cfg.gpadc_low_div1.sample = GPADC_DIV1_LO_SAMP_DEF;
    }
    // GPADC DIV2
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.gpadc_high_div2.raw, 4)) {
10001464:	200017b7          	lui	a5,0x20001
10001468:	ca07a703          	lw	a4,-864(a5) # 20000ca0 <g_otp_cfg+0x14>
1000146c:	57fd                	li	a5,-1
1000146e:	16f70863          	beq	a4,a5,100015de <omw_otp_load_cfg+0x226>
        g_otp_cfg.gpadc_high_div2.voltage = GPADC_DIV2_HI_VOLT_DEF;
        g_otp_cfg.gpadc_high_div2.sample = GPADC_DIV2_HI_SAMP_DEF;
    }
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.gpadc_low_div2.raw, 4)) {
10001472:	200017b7          	lui	a5,0x20001
10001476:	ca47a703          	lw	a4,-860(a5) # 20000ca4 <g_otp_cfg+0x18>
1000147a:	57fd                	li	a5,-1
1000147c:	18f70363          	beq	a4,a5,10001602 <omw_otp_load_cfg+0x24a>
        g_otp_cfg.gpadc_low_div2.voltage = GPADC_DIV2_LO_VOLT_DEF;
        g_otp_cfg.gpadc_low_div2.sample = GPADC_DIV2_LO_SAMP_DEF;
    }
    // GPADC DIV3
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.gpadc_high_div3.raw, 4)) {
10001480:	200017b7          	lui	a5,0x20001
10001484:	ca87a703          	lw	a4,-856(a5) # 20000ca8 <g_otp_cfg+0x1c>
10001488:	57fd                	li	a5,-1
1000148a:	18f70e63          	beq	a4,a5,10001626 <omw_otp_load_cfg+0x26e>
        g_otp_cfg.gpadc_high_div3.voltage = GPADC_DIV3_HI_VOLT_DEF;
        g_otp_cfg.gpadc_high_div3.sample = GPADC_DIV3_HI_SAMP_DEF;
    }
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.gpadc_low_div3.raw, 4)) {
1000148e:	200017b7          	lui	a5,0x20001
10001492:	cac7a703          	lw	a4,-852(a5) # 20000cac <g_otp_cfg+0x20>
10001496:	57fd                	li	a5,-1
10001498:	1af70963          	beq	a4,a5,1000164a <omw_otp_load_cfg+0x292>
        g_otp_cfg.gpadc_low_div3.voltage = GPADC_DIV3_LO_VOLT_DEF;
        g_otp_cfg.gpadc_low_div3.sample = GPADC_DIV3_LO_SAMP_DEF;
    }
    // GPADC DIV4
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.gpadc_high_div4.raw, 4)) {
1000149c:	200017b7          	lui	a5,0x20001
100014a0:	cb07a703          	lw	a4,-848(a5) # 20000cb0 <g_otp_cfg+0x24>
100014a4:	57fd                	li	a5,-1
100014a6:	1cf70463          	beq	a4,a5,1000166e <omw_otp_load_cfg+0x2b6>
        g_otp_cfg.gpadc_high_div4.voltage = GPADC_DIV4_HI_VOLT_DEF;
        g_otp_cfg.gpadc_high_div4.sample = GPADC_DIV4_HI_SAMP_DEF;
    }
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.gpadc_low_div4.raw, 4)) {
100014aa:	200017b7          	lui	a5,0x20001
100014ae:	cb47a703          	lw	a4,-844(a5) # 20000cb4 <g_otp_cfg+0x28>
100014b2:	57fd                	li	a5,-1
100014b4:	1ef70163          	beq	a4,a5,10001696 <omw_otp_load_cfg+0x2de>
        g_otp_cfg.gpadc_low_div4.voltage = GPADC_DIV4_LO_VOLT_DEF;
        g_otp_cfg.gpadc_low_div4.sample = GPADC_DIV4_LO_SAMP_DEF;
    }
#endif
    // TEMP
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.temperature.raw, 4)) {
100014b8:	200017b7          	lui	a5,0x20001
100014bc:	cb87a703          	lw	a4,-840(a5) # 20000cb8 <g_otp_cfg+0x2c>
100014c0:	57fd                	li	a5,-1
100014c2:	1ef70c63          	beq	a4,a5,100016ba <omw_otp_load_cfg+0x302>
        g_otp_cfg.temperature.hp_offset_slope = HP_OFFSET_SLOPE_DEF;
        g_otp_cfg.temperature.vtrim_offset = 0xF;
        g_otp_cfg.temperature.sx_offset = 0xF;
    }
    // RX_RSSI
    if (!OTP_CHECK_PARITY(g_otp_cfg.rx_rssi_high.raw, 2)) {
100014c6:	200017b7          	lui	a5,0x20001
100014ca:	cbc7d703          	lhu	a4,-836(a5) # 20000cbc <g_otp_cfg+0x30>
100014ce:	67c1                	lui	a5,0x10
100014d0:	17fd                	addi	a5,a5,-1
100014d2:	22f70063          	beq	a4,a5,100016f2 <omw_otp_load_cfg+0x33a>
        g_otp_cfg.rx_rssi_high.value = 0;
    }
    if (!OTP_CHECK_PARITY(g_otp_cfg.rx_rssi_low.raw, 2)) {
100014d6:	200017b7          	lui	a5,0x20001
100014da:	cbe7d703          	lhu	a4,-834(a5) # 20000cbe <g_otp_cfg+0x32>
100014de:	67c1                	lui	a5,0x10
100014e0:	17fd                	addi	a5,a5,-1
100014e2:	22f70363          	beq	a4,a5,10001708 <omw_otp_load_cfg+0x350>
        g_otp_cfg.rx_rssi_low.value = 0;
    }
    // TX_RSSI
    if (!OTP_CHECK_PARITY(g_otp_cfg.tx_pwr_rx_rssi.raw, 2)) {
100014e6:	200017b7          	lui	a5,0x20001
100014ea:	cc07d703          	lhu	a4,-832(a5) # 20000cc0 <g_otp_cfg+0x34>
100014ee:	67c1                	lui	a5,0x10
100014f0:	17fd                	addi	a5,a5,-1
100014f2:	22f70663          	beq	a4,a5,1000171e <omw_otp_load_cfg+0x366>
        g_otp_cfg.tx_pwr_rx_rssi.value = RF_POWER_RX_RSSI_REF;
    }
#ifndef OMW_NO_XO_CTUNE_CAL
    // XO CTUNE
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.crystal_cal.raw, 4)) {
100014f6:	200017b7          	lui	a5,0x20001
100014fa:	cc47a703          	lw	a4,-828(a5) # 20000cc4 <g_otp_cfg+0x38>
100014fe:	57fd                	li	a5,-1
10001500:	22f70c63          	beq	a4,a5,10001738 <omw_otp_load_cfg+0x380>
    }
#endif // !OMW_NO_XO_CTUNE_CAL

#ifndef OMW_NO_GPADC_CAL
    // GPADC_RES
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.gpadc_res.raw, 4)) {
10001504:	200017b7          	lui	a5,0x20001
10001508:	cc87a703          	lw	a4,-824(a5) # 20000cc8 <g_otp_cfg+0x3c>
1000150c:	57fd                	li	a5,-1
1000150e:	24f70063          	beq	a4,a5,1000174e <omw_otp_load_cfg+0x396>
        g_otp_cfg.gpadc_res.value = GPADC_RES_DEF;
    }
    // GPADC_VBAT
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.gpadc_vbat_high.raw, 4)) {
10001512:	200017b7          	lui	a5,0x20001
10001516:	ccc7a703          	lw	a4,-820(a5) # 20000ccc <g_otp_cfg+0x40>
1000151a:	57fd                	li	a5,-1
1000151c:	24f70863          	beq	a4,a5,1000176c <omw_otp_load_cfg+0x3b4>
        g_otp_cfg.gpadc_vbat_high.voltage = GPADC_VBAT_HI_VOLT_DEF;
        g_otp_cfg.gpadc_vbat_high.sample = GPADC_VBAT_HI_SAMP_DEF;
    }
    if (!OTP_CHECK_WORD_PARITY(g_otp_cfg.gpadc_vbat_low.raw, 4)) {
10001520:	200017b7          	lui	a5,0x20001
10001524:	cd07a703          	lw	a4,-816(a5) # 20000cd0 <g_otp_cfg+0x44>
10001528:	57fd                	li	a5,-1
1000152a:	26f70563          	beq	a4,a5,10001794 <omw_otp_load_cfg+0x3dc>
    }
#endif  // !OMW_NO_GPADC_CAL
#ifdef OMW_FT_APP
    rf_rssi_cal = REG_RD(0x1F803FF0);
#endif
}
1000152e:	8082                	ret
        g_otp_cfg.rf_bg_vtrim.value = RF_BG_VTRIM_DEFAULT;
10001530:	20001737          	lui	a4,0x20001
10001534:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
10001538:	00074783          	lbu	a5,0(a4)
1000153c:	9bc1                	andi	a5,a5,-16
1000153e:	00a7e793          	ori	a5,a5,10
10001542:	00f70023          	sb	a5,0(a4)
10001546:	b5c9                	j	10001408 <omw_otp_load_cfg+0x50>
        g_otp_cfg.aon_rg_bg_vref_trim.value = RF_AON_BG_VTRIM_DEFAULT;
10001548:	20001737          	lui	a4,0x20001
1000154c:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
10001550:	00274783          	lbu	a5,2(a4)
10001554:	9bc1                	andi	a5,a5,-16
10001556:	0037e793          	ori	a5,a5,3
1000155a:	00f70123          	sb	a5,2(a4)
1000155e:	bd6d                	j	10001418 <omw_otp_load_cfg+0x60>
        g_otp_cfg.aon_rco24m_cc.value = RCO_24M_CC_DEF;
10001560:	200017b7          	lui	a5,0x20001
10001564:	f8d00713          	li	a4,-115
10001568:	c8e78823          	sb	a4,-880(a5) # 20000c90 <g_otp_cfg+0x4>
1000156c:	bd75                	j	10001428 <omw_otp_load_cfg+0x70>
        g_otp_cfg.aon_rco32k_cc.value = RCO_32K_CC_DEF;
1000156e:	200017b7          	lui	a5,0x20001
10001572:	fb700713          	li	a4,-73
10001576:	c8e78923          	sb	a4,-878(a5) # 20000c92 <g_otp_cfg+0x6>
1000157a:	bd7d                	j	10001438 <omw_otp_load_cfg+0x80>
        g_otp_cfg.corner_tgt_freq.value = RF_CORNER_CLK_DEF;
1000157c:	20001737          	lui	a4,0x20001
10001580:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
10001584:	00875783          	lhu	a5,8(a4)
10001588:	c007f793          	andi	a5,a5,-1024
1000158c:	1187e793          	ori	a5,a5,280
10001590:	00f71423          	sh	a5,8(a4)
10001594:	bd55                	j	10001448 <omw_otp_load_cfg+0x90>
        g_otp_cfg.gpadc_high_div1.voltage = GPADC_DIV1_HI_VOLT_DEF;
10001596:	20001737          	lui	a4,0x20001
1000159a:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
1000159e:	475c                	lw	a5,12(a4)
100015a0:	76fd                	lui	a3,0xfffff
100015a2:	8ff5                	and	a5,a5,a3
100015a4:	2587e793          	ori	a5,a5,600
        g_otp_cfg.gpadc_high_div1.sample = GPADC_DIV1_HI_SAMP_DEF;
100015a8:	fc0106b7          	lui	a3,0xfc010
100015ac:	16fd                	addi	a3,a3,-1
100015ae:	8ff5                	and	a5,a5,a3
100015b0:	02ab06b7          	lui	a3,0x2ab0
100015b4:	8fd5                	or	a5,a5,a3
100015b6:	c75c                	sw	a5,12(a4)
100015b8:	bd79                	j	10001456 <omw_otp_load_cfg+0x9e>
        g_otp_cfg.gpadc_low_div1.voltage = GPADC_DIV1_LO_VOLT_DEF;
100015ba:	20001737          	lui	a4,0x20001
100015be:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
100015c2:	4b1c                	lw	a5,16(a4)
100015c4:	76fd                	lui	a3,0xfffff
100015c6:	8ff5                	and	a5,a5,a3
100015c8:	0c87e793          	ori	a5,a5,200
        g_otp_cfg.gpadc_low_div1.sample = GPADC_DIV1_LO_SAMP_DEF;
100015cc:	fc0106b7          	lui	a3,0xfc010
100015d0:	16fd                	addi	a3,a3,-1
100015d2:	8ff5                	and	a5,a5,a3
100015d4:	00e406b7          	lui	a3,0xe40
100015d8:	8fd5                	or	a5,a5,a3
100015da:	cb1c                	sw	a5,16(a4)
100015dc:	b561                	j	10001464 <omw_otp_load_cfg+0xac>
        g_otp_cfg.gpadc_high_div2.voltage = GPADC_DIV2_HI_VOLT_DEF;
100015de:	20001737          	lui	a4,0x20001
100015e2:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
100015e6:	4b5c                	lw	a5,20(a4)
100015e8:	76fd                	lui	a3,0xfffff
100015ea:	8ff5                	and	a5,a5,a3
100015ec:	4b07e793          	ori	a5,a5,1200
        g_otp_cfg.gpadc_high_div2.sample = GPADC_DIV2_HI_SAMP_DEF;
100015f0:	fc0106b7          	lui	a3,0xfc010
100015f4:	16fd                	addi	a3,a3,-1
100015f6:	8ff5                	and	a5,a5,a3
100015f8:	02ab06b7          	lui	a3,0x2ab0
100015fc:	8fd5                	or	a5,a5,a3
100015fe:	cb5c                	sw	a5,20(a4)
10001600:	bd8d                	j	10001472 <omw_otp_load_cfg+0xba>
        g_otp_cfg.gpadc_low_div2.voltage = GPADC_DIV2_LO_VOLT_DEF;
10001602:	20001737          	lui	a4,0x20001
10001606:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
1000160a:	4f1c                	lw	a5,24(a4)
1000160c:	76fd                	lui	a3,0xfffff
1000160e:	8ff5                	and	a5,a5,a3
10001610:	1907e793          	ori	a5,a5,400
        g_otp_cfg.gpadc_low_div2.sample = GPADC_DIV2_LO_SAMP_DEF;
10001614:	fc0106b7          	lui	a3,0xfc010
10001618:	16fd                	addi	a3,a3,-1
1000161a:	8ff5                	and	a5,a5,a3
1000161c:	00e406b7          	lui	a3,0xe40
10001620:	8fd5                	or	a5,a5,a3
10001622:	cf1c                	sw	a5,24(a4)
10001624:	bdb1                	j	10001480 <omw_otp_load_cfg+0xc8>
        g_otp_cfg.gpadc_high_div3.voltage = GPADC_DIV3_HI_VOLT_DEF;
10001626:	20001737          	lui	a4,0x20001
1000162a:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
1000162e:	4f5c                	lw	a5,28(a4)
10001630:	76fd                	lui	a3,0xfffff
10001632:	8ff5                	and	a5,a5,a3
10001634:	7087e793          	ori	a5,a5,1800
        g_otp_cfg.gpadc_high_div3.sample = GPADC_DIV3_HI_SAMP_DEF;
10001638:	fc0106b7          	lui	a3,0xfc010
1000163c:	16fd                	addi	a3,a3,-1
1000163e:	8ff5                	and	a5,a5,a3
10001640:	02ab06b7          	lui	a3,0x2ab0
10001644:	8fd5                	or	a5,a5,a3
10001646:	cf5c                	sw	a5,28(a4)
10001648:	b599                	j	1000148e <omw_otp_load_cfg+0xd6>
        g_otp_cfg.gpadc_low_div3.voltage = GPADC_DIV3_LO_VOLT_DEF;
1000164a:	20001737          	lui	a4,0x20001
1000164e:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
10001652:	531c                	lw	a5,32(a4)
10001654:	76fd                	lui	a3,0xfffff
10001656:	8ff5                	and	a5,a5,a3
10001658:	2587e793          	ori	a5,a5,600
        g_otp_cfg.gpadc_low_div3.sample = GPADC_DIV3_LO_SAMP_DEF;
1000165c:	fc0106b7          	lui	a3,0xfc010
10001660:	16fd                	addi	a3,a3,-1
10001662:	8ff5                	and	a5,a5,a3
10001664:	00e406b7          	lui	a3,0xe40
10001668:	8fd5                	or	a5,a5,a3
1000166a:	d31c                	sw	a5,32(a4)
1000166c:	bd05                	j	1000149c <omw_otp_load_cfg+0xe4>
        g_otp_cfg.gpadc_high_div4.voltage = GPADC_DIV4_HI_VOLT_DEF;
1000166e:	20001737          	lui	a4,0x20001
10001672:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
10001676:	535c                	lw	a5,36(a4)
10001678:	76fd                	lui	a3,0xfffff
1000167a:	8ff5                	and	a5,a5,a3
1000167c:	6685                	lui	a3,0x1
1000167e:	96068693          	addi	a3,a3,-1696 # 960 <__STACK_SIZE+0x660>
10001682:	8fd5                	or	a5,a5,a3
        g_otp_cfg.gpadc_high_div4.sample = GPADC_DIV4_HI_SAMP_DEF;
10001684:	fc0106b7          	lui	a3,0xfc010
10001688:	16fd                	addi	a3,a3,-1
1000168a:	8ff5                	and	a5,a5,a3
1000168c:	02ab06b7          	lui	a3,0x2ab0
10001690:	8fd5                	or	a5,a5,a3
10001692:	d35c                	sw	a5,36(a4)
10001694:	bd19                	j	100014aa <omw_otp_load_cfg+0xf2>
        g_otp_cfg.gpadc_low_div4.voltage = GPADC_DIV4_LO_VOLT_DEF;
10001696:	20001737          	lui	a4,0x20001
1000169a:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
1000169e:	571c                	lw	a5,40(a4)
100016a0:	76fd                	lui	a3,0xfffff
100016a2:	8ff5                	and	a5,a5,a3
100016a4:	3207e793          	ori	a5,a5,800
        g_otp_cfg.gpadc_low_div4.sample = GPADC_DIV4_LO_SAMP_DEF;
100016a8:	fc0106b7          	lui	a3,0xfc010
100016ac:	16fd                	addi	a3,a3,-1
100016ae:	8ff5                	and	a5,a5,a3
100016b0:	00e406b7          	lui	a3,0xe40
100016b4:	8fd5                	or	a5,a5,a3
100016b6:	d71c                	sw	a5,40(a4)
100016b8:	b501                	j	100014b8 <omw_otp_load_cfg+0x100>
        g_otp_cfg.temperature.room_gpadc_value = GPADC_ROOM_TEMP_DEFAULT;
100016ba:	20001737          	lui	a4,0x20001
100016be:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
100016c2:	575c                	lw	a5,44(a4)
100016c4:	3ff7e793          	ori	a5,a5,1023
        g_otp_cfg.temperature.corner_offset_slope = CORNER_OFFSET_SLOPE_DEF;
100016c8:	76e1                	lui	a3,0xffff8
100016ca:	3ff68693          	addi	a3,a3,1023 # ffff83ff <__StackTop+0xdfff43ff>
100016ce:	8ff5                	and	a5,a5,a3
100016d0:	6689                	lui	a3,0x2
100016d2:	8fd5                	or	a5,a5,a3
        g_otp_cfg.temperature.hp_offset_slope = HP_OFFSET_SLOPE_DEF;
100016d4:	fff086b7          	lui	a3,0xfff08
100016d8:	16fd                	addi	a3,a3,-1
100016da:	8ff5                	and	a5,a5,a3
100016dc:	000c86b7          	lui	a3,0xc8
100016e0:	8fd5                	or	a5,a5,a3
        g_otp_cfg.temperature.vtrim_offset = 0xF;
100016e2:	00f006b7          	lui	a3,0xf00
100016e6:	8fd5                	or	a5,a5,a3
        g_otp_cfg.temperature.sx_offset = 0xF;
100016e8:	0f0006b7          	lui	a3,0xf000
100016ec:	8fd5                	or	a5,a5,a3
100016ee:	d75c                	sw	a5,44(a4)
100016f0:	bbd9                	j	100014c6 <omw_otp_load_cfg+0x10e>
        g_otp_cfg.rx_rssi_high.value = 0;
100016f2:	200017b7          	lui	a5,0x20001
100016f6:	c8c78793          	addi	a5,a5,-884 # 20000c8c <g_otp_cfg>
100016fa:	0307d703          	lhu	a4,48(a5)
100016fe:	76fd                	lui	a3,0xfffff
10001700:	8f75                	and	a4,a4,a3
10001702:	02e79823          	sh	a4,48(a5)
10001706:	bbc1                	j	100014d6 <omw_otp_load_cfg+0x11e>
        g_otp_cfg.rx_rssi_low.value = 0;
10001708:	200017b7          	lui	a5,0x20001
1000170c:	c8c78793          	addi	a5,a5,-884 # 20000c8c <g_otp_cfg>
10001710:	0327d703          	lhu	a4,50(a5)
10001714:	76fd                	lui	a3,0xfffff
10001716:	8f75                	and	a4,a4,a3
10001718:	02e79923          	sh	a4,50(a5)
1000171c:	b3e9                	j	100014e6 <omw_otp_load_cfg+0x12e>
        g_otp_cfg.tx_pwr_rx_rssi.value = RF_POWER_RX_RSSI_REF;
1000171e:	20001737          	lui	a4,0x20001
10001722:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
10001726:	03475783          	lhu	a5,52(a4)
1000172a:	76fd                	lui	a3,0xfffff
1000172c:	8ff5                	and	a5,a5,a3
1000172e:	40c7e793          	ori	a5,a5,1036
10001732:	02f71a23          	sh	a5,52(a4)
10001736:	b3c1                	j	100014f6 <omw_otp_load_cfg+0x13e>
        g_otp_cfg.crystal_cal.value = RF_XO_CTUNE_DEFAULT;
10001738:	20001737          	lui	a4,0x20001
1000173c:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
10001740:	5f1c                	lw	a5,56(a4)
10001742:	fc07f793          	andi	a5,a5,-64
10001746:	0357e793          	ori	a5,a5,53
1000174a:	df1c                	sw	a5,56(a4)
1000174c:	bb65                	j	10001504 <omw_otp_load_cfg+0x14c>
        g_otp_cfg.gpadc_res.value = GPADC_RES_DEF;
1000174e:	20001737          	lui	a4,0x20001
10001752:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
10001756:	5f5c                	lw	a5,60(a4)
10001758:	800006b7          	lui	a3,0x80000
1000175c:	8ff5                	and	a5,a5,a3
1000175e:	0003b6b7          	lui	a3,0x3b
10001762:	98068693          	addi	a3,a3,-1664 # 3a980 <rom_func_end_check_val+0x30d1c>
10001766:	8fd5                	or	a5,a5,a3
10001768:	df5c                	sw	a5,60(a4)
1000176a:	b365                	j	10001512 <omw_otp_load_cfg+0x15a>
        g_otp_cfg.gpadc_vbat_high.voltage = GPADC_VBAT_HI_VOLT_DEF;
1000176c:	20001737          	lui	a4,0x20001
10001770:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
10001774:	433c                	lw	a5,64(a4)
10001776:	76fd                	lui	a3,0xfffff
10001778:	8ff5                	and	a5,a5,a3
1000177a:	6685                	lui	a3,0x1
1000177c:	bb868693          	addi	a3,a3,-1096 # bb8 <__STACK_SIZE+0x8b8>
10001780:	8fd5                	or	a5,a5,a3
        g_otp_cfg.gpadc_vbat_high.sample = GPADC_VBAT_HI_SAMP_DEF;
10001782:	fc0106b7          	lui	a3,0xfc010
10001786:	16fd                	addi	a3,a3,-1
10001788:	8ff5                	and	a5,a5,a3
1000178a:	035506b7          	lui	a3,0x3550
1000178e:	8fd5                	or	a5,a5,a3
10001790:	c33c                	sw	a5,64(a4)
10001792:	b379                	j	10001520 <omw_otp_load_cfg+0x168>
        g_otp_cfg.gpadc_vbat_low.voltage = GPADC_VBAT_LO_VOLT_DEF;
10001794:	20001737          	lui	a4,0x20001
10001798:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
1000179c:	437c                	lw	a5,68(a4)
1000179e:	76fd                	lui	a3,0xfffff
100017a0:	8ff5                	and	a5,a5,a3
100017a2:	7d07e793          	ori	a5,a5,2000
        g_otp_cfg.gpadc_vbat_low.sample = GPADC_VBAT_LO_SAMP_DEF;
100017a6:	fc0106b7          	lui	a3,0xfc010
100017aa:	16fd                	addi	a3,a3,-1
100017ac:	8ff5                	and	a5,a5,a3
100017ae:	023906b7          	lui	a3,0x2390
100017b2:	8fd5                	or	a5,a5,a3
100017b4:	c37c                	sw	a5,68(a4)
}
100017b6:	bba5                	j	1000152e <omw_otp_load_cfg+0x176>

100017b8 <omw_otp_apply_cfg>:
{
    //-----------------------------------------------------
    // AON
    //-----------------------------------------------------
    // aon_rg_bg_vref_trim
    REG_WRT_BITS(0x40080104, 17, 14, g_otp_cfg.aon_rg_bg_vref_trim.value);
100017b8:	400807b7          	lui	a5,0x40080
100017bc:	1047a683          	lw	a3,260(a5) # 40080104 <__StackTop+0x2007c104>
100017c0:	fffc4637          	lui	a2,0xfffc4
100017c4:	167d                	addi	a2,a2,-1
100017c6:	8e75                	and	a2,a2,a3
100017c8:	20001737          	lui	a4,0x20001
100017cc:	c8c70713          	addi	a4,a4,-884 # 20000c8c <g_otp_cfg>
100017d0:	00275683          	lhu	a3,2(a4)
100017d4:	8abd                	andi	a3,a3,15
100017d6:	06ba                	slli	a3,a3,0xe
100017d8:	8ed1                	or	a3,a3,a2
100017da:	10d7a223          	sw	a3,260(a5)
    // aon_rco24m_cc
    REG_WRT_BITS(0x40080108, 15, 8, g_otp_cfg.aon_rco24m_cc.value);
100017de:	1087a683          	lw	a3,264(a5)
100017e2:	7641                	lui	a2,0xffff0
100017e4:	0ff60613          	addi	a2,a2,255 # ffff00ff <__StackTop+0xdffec0ff>
100017e8:	8e75                	and	a2,a2,a3
100017ea:	00474683          	lbu	a3,4(a4)
100017ee:	06a2                	slli	a3,a3,0x8
100017f0:	8ed1                	or	a3,a3,a2
100017f2:	10d7a423          	sw	a3,264(a5)
    // aon_rco32k_cc
    REG_WRT_BITS(0x4008010C, 14, 7, g_otp_cfg.aon_rco32k_cc.value);
100017f6:	10c7a683          	lw	a3,268(a5)
100017fa:	7661                	lui	a2,0xffff8
100017fc:	07f60613          	addi	a2,a2,127 # ffff807f <__StackTop+0xdfff407f>
10001800:	8e75                	and	a2,a2,a3
10001802:	00674683          	lbu	a3,6(a4)
10001806:	069e                	slli	a3,a3,0x7
10001808:	8ed1                	or	a3,a3,a2
1000180a:	10d7a623          	sw	a3,268(a5)
    // xo ctune
    REG_WRT_BITS(0x40080110, 23, 18, g_otp_cfg.crystal_cal.value);
1000180e:	1107a683          	lw	a3,272(a5)
10001812:	ff040637          	lui	a2,0xff040
10001816:	167d                	addi	a2,a2,-1
10001818:	8e75                	and	a2,a2,a3
1000181a:	5f14                	lw	a3,56(a4)
1000181c:	03f6f693          	andi	a3,a3,63
10001820:	06ca                	slli	a3,a3,0x12
10001822:	8ed1                	or	a3,a3,a2
10001824:	10d7a823          	sw	a3,272(a5)
    //-----------------------------------------------------
    // CORE
    //-----------------------------------------------------
    // rf_bg_ctrim
    REG_WRT_BITS(0x42002008, 30, 27, g_otp_cfg.rf_bg_vtrim.value);
10001828:	42002637          	lui	a2,0x42002
1000182c:	461c                	lw	a5,8(a2)
1000182e:	880006b7          	lui	a3,0x88000
10001832:	16fd                	addi	a3,a3,-1
10001834:	8efd                	and	a3,a3,a5
10001836:	431c                	lw	a5,0(a4)
10001838:	8bbd                	andi	a5,a5,15
1000183a:	07ee                	slli	a5,a5,0x1b
1000183c:	8fd5                	or	a5,a5,a3
1000183e:	c61c                	sw	a5,8(a2)
}
10001840:	8082                	ret

10001842 <gpio_init>:
    
    while(1);
    return 0;
}

void gpio_init(void){
10001842:	1131                	addi	sp,sp,-20
10001844:	c806                	sw	ra,16(sp)
   GPIO_InitTypeDef GPIO_InitStruct;
    // GPIO3 output
    GPIO_StructInit(&GPIO_InitStruct);
10001846:	850a                	mv	a0,sp
10001848:	3c09                	jal	1000125a <GPIO_StructInit>
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_3;
1000184a:	47a1                	li	a5,8
1000184c:	c03e                	sw	a5,0(sp)
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_OUT_PP;
1000184e:	47c1                	li	a5,16
10001850:	00f10223          	sb	a5,4(sp)
    GPIO_InitStruct.GPIO_DriveStrength = GPIO_DRIVE_STRENGTH_3; // highest drive strength
10001854:	478d                	li	a5,3
10001856:	00f10323          	sb	a5,6(sp)
    GPIO_Init(&GPIO_InitStruct);
1000185a:	850a                	mv	a0,sp
1000185c:	3c05                	jal	1000128c <GPIO_Init>
    GPIO_ResetBits(GPIO_PIN_3);
1000185e:	4521                	li	a0,8
10001860:	3465                	jal	10001308 <GPIO_ResetBits>
}
10001862:	40c2                	lw	ra,16(sp)
10001864:	0151                	addi	sp,sp,20
10001866:	8082                	ret

10001868 <adc_init>:

void adc_init(void){
10001868:	fd410113          	addi	sp,sp,-44
1000186c:	d406                	sw	ra,40(sp)
    GPADC_InitTypeDef GPADC_InitStruct;
    GPADC_StructInit(&GPADC_InitStruct);
1000186e:	850a                	mv	a0,sp
10001870:	e6dfe0ef          	jal	ra,100006dc <GPADC_StructInit>

    GPADC_InitStruct.GPADC_InputDivide = GPADC_INPUT_DIV3;
10001874:	4789                	li	a5,2
10001876:	00f10023          	sb	a5,0(sp)
    GPADC_InitStruct.GPADC_DiffEN = DISABLE;
1000187a:	c202                	sw	zero,4(sp)
    GPADC_InitStruct.GPADC_PositiveInputChannel = GPADC_CHANNEL_GPIO2;
1000187c:	000104a3          	sb	zero,9(sp)
    GPADC_InitStruct.GPADC_AverageWindow = GPADC_AVG_NUM_32;
10001880:	4795                	li	a5,5
10001882:	00f10523          	sb	a5,10(sp)
    GPADC_InitStruct.GPADC_ContinueMode = DISABLE;
10001886:	ca02                	sw	zero,20(sp)

    GPADC_Init(&GPADC_InitStruct);
10001888:	850a                	mv	a0,sp
1000188a:	d1dfe0ef          	jal	ra,100005a6 <GPADC_Init>
	GPADC_StartCalibration();
1000188e:	924ff0ef          	jal	ra,100009b2 <GPADC_StartCalibrationEx>

    GPADC_Cmd(ENABLE); // enable
10001892:	4505                	li	a0,1
10001894:	e7ffe0ef          	jal	ra,10000712 <GPADC_Cmd>
}
10001898:	50a2                	lw	ra,40(sp)
1000189a:	02c10113          	addi	sp,sp,44
1000189e:	8082                	ret

100018a0 <main>:
{
100018a0:	1131                	addi	sp,sp,-20
100018a2:	c806                	sw	ra,16(sp)
100018a4:	c622                	sw	s0,12(sp)
100018a6:	c426                	sw	s1,8(sp)
    omw_dbg_init();
100018a8:	8e3ff0ef          	jal	ra,1000118a <omw_dbg_init>
    adc_init();
100018ac:	3f75                	jal	10001868 <adc_init>
    gpio_init();
100018ae:	3f51                	jal	10001842 <gpio_init>
    printf("GPADC test ...\n");
100018b0:	10002537          	lui	a0,0x10002
100018b4:	4e050513          	addi	a0,a0,1248 # 100024e0 <gpio_res_tbl_vdd+0x80>
100018b8:	923ff0ef          	jal	ra,100011da <puts>
    div_bak = 0;
100018bc:	c202                	sw	zero,4(sp)
    cnt = 0;
100018be:	4481                	li	s1,0
100018c0:	a02d                	j	100018ea <main+0x4a>
            printf("    **  cnt: %4d, div: %2d, gpio: %4d mV, vbat: %4d mV, res: %d Ohm\n", cnt, div_cur, volt, g_gpadc_vbat, res);
100018c2:	87aa                	mv	a5,a0
100018c4:	20001737          	lui	a4,0x20001
100018c8:	c8275703          	lhu	a4,-894(a4) # 20000c82 <g_gpadc_vbat>
100018cc:	4682                	lw	a3,0(sp)
100018ce:	8622                	mv	a2,s0
100018d0:	85a6                	mv	a1,s1
100018d2:	10002537          	lui	a0,0x10002
100018d6:	4f050513          	addi	a0,a0,1264 # 100024f0 <gpio_res_tbl_vdd+0x90>
100018da:	933ff0ef          	jal	ra,1000120c <printf>
            div_bak = div_cur;
100018de:	c222                	sw	s0,4(sp)
        cnt ++;
100018e0:	0485                	addi	s1,s1,1
		DELAY_MS(300);
100018e2:	12c00513          	li	a0,300
100018e6:	88dfe0ef          	jal	ra,10000172 <delay_ms>
        GPIO_SetBits(GPIO_PIN_3);
100018ea:	4521                	li	a0,8
100018ec:	3c09                	jal	100012fe <GPIO_SetBits>
        GPIO_ResetBits(GPIO_PIN_3);
100018ee:	4521                	li	a0,8
100018f0:	3c21                	jal	10001308 <GPIO_ResetBits>
        GPIO_SetBits(GPIO_PIN_3);
100018f2:	4521                	li	a0,8
100018f4:	3429                	jal	100012fe <GPIO_SetBits>
        GPIO_ResetBits(GPIO_PIN_3);
100018f6:	4521                	li	a0,8
100018f8:	3c01                	jal	10001308 <GPIO_ResetBits>
        GPADC_BATUpdate();
100018fa:	ca0ff0ef          	jal	ra,10000d9a <GPADC_BATUpdate>
        GPIO_SetBits(GPIO_PIN_3);
100018fe:	4521                	li	a0,8
10001900:	3afd                	jal	100012fe <GPIO_SetBits>
        volt = GPADC_SampleVoltagePoll();
10001902:	fa5fe0ef          	jal	ra,100008a6 <GPADC_SampleVoltagePoll>
10001906:	c02a                	sw	a0,0(sp)
        GPIO_ResetBits(GPIO_PIN_3);
10001908:	4521                	li	a0,8
1000190a:	3afd                	jal	10001308 <GPIO_ResetBits>
        res = GPIO_GetIORes(GPIO_DRIVE_STRENGTH_0, g_gpadc_vbat, 1);
1000190c:	4605                	li	a2,1
1000190e:	200017b7          	lui	a5,0x20001
10001912:	c827d583          	lhu	a1,-894(a5) # 20000c82 <g_gpadc_vbat>
10001916:	4501                	li	a0,0
10001918:	3aed                	jal	10001312 <GPIO_GetIORes>
        div_cur = ((GPADC_ANA->GPADC_CTRL) >> 13) & 0x03;
1000191a:	40040737          	lui	a4,0x40040
1000191e:	00475403          	lhu	s0,4(a4) # 40040004 <__StackTop+0x2003c004>
10001922:	8035                	srli	s0,s0,0xd
10001924:	880d                	andi	s0,s0,3
        if(div_cur != div_bak){
10001926:	4612                	lw	a2,4(sp)
10001928:	f8861de3          	bne	a2,s0,100018c2 <main+0x22>
            printf("        cnt: %4d, div: %2d, gpio: %4d mV, vbat: %4d mV, res: %d Ohm\n", cnt, div_cur, volt, g_gpadc_vbat, res);
1000192c:	87aa                	mv	a5,a0
1000192e:	20001737          	lui	a4,0x20001
10001932:	c8275703          	lhu	a4,-894(a4) # 20000c82 <g_gpadc_vbat>
10001936:	4682                	lw	a3,0(sp)
10001938:	8622                	mv	a2,s0
1000193a:	85a6                	mv	a1,s1
1000193c:	10002537          	lui	a0,0x10002
10001940:	53850513          	addi	a0,a0,1336 # 10002538 <gpio_res_tbl_vdd+0xd8>
10001944:	8c9ff0ef          	jal	ra,1000120c <printf>
10001948:	bf61                	j	100018e0 <main+0x40>

1000194a <__divdi3>:
1000194a:	1151                	addi	sp,sp,-12
1000194c:	c422                	sw	s0,8(sp)
1000194e:	c226                	sw	s1,4(sp)
10001950:	872e                	mv	a4,a1
10001952:	4381                	li	t2,0
10001954:	0005da63          	bgez	a1,10001968 <__divdi3+0x1e>
10001958:	00a037b3          	snez	a5,a0
1000195c:	40b00733          	neg	a4,a1
10001960:	8f1d                	sub	a4,a4,a5
10001962:	40a00533          	neg	a0,a0
10001966:	53fd                	li	t2,-1
10001968:	0006db63          	bgez	a3,1000197e <__divdi3+0x34>
1000196c:	00c037b3          	snez	a5,a2
10001970:	40d006b3          	neg	a3,a3
10001974:	fff3c393          	not	t2,t2
10001978:	8e9d                	sub	a3,a3,a5
1000197a:	40c00633          	neg	a2,a2
1000197e:	82b2                	mv	t0,a2
10001980:	85b6                	mv	a1,a3
10001982:	842a                	mv	s0,a0
10001984:	833a                	mv	t1,a4
10001986:	22069163          	bnez	a3,10001ba8 <__divdi3+0x25e>
1000198a:	00001697          	auipc	a3,0x1
1000198e:	bf668693          	addi	a3,a3,-1034 # 10002580 <__clz_tab>
10001992:	0ac77e63          	bgeu	a4,a2,10001a4e <__divdi3+0x104>
10001996:	67c1                	lui	a5,0x10
10001998:	0af67463          	bgeu	a2,a5,10001a40 <__divdi3+0xf6>
1000199c:	0ff00793          	li	a5,255
100019a0:	00c7b7b3          	sltu	a5,a5,a2
100019a4:	078e                	slli	a5,a5,0x3
100019a6:	00f655b3          	srl	a1,a2,a5
100019aa:	96ae                	add	a3,a3,a1
100019ac:	0006c683          	lbu	a3,0(a3)
100019b0:	97b6                	add	a5,a5,a3
100019b2:	02000693          	li	a3,32
100019b6:	40f684b3          	sub	s1,a3,a5
100019ba:	00f68c63          	beq	a3,a5,100019d2 <__divdi3+0x88>
100019be:	00971733          	sll	a4,a4,s1
100019c2:	00f557b3          	srl	a5,a0,a5
100019c6:	009612b3          	sll	t0,a2,s1
100019ca:	00e7e333          	or	t1,a5,a4
100019ce:	00951433          	sll	s0,a0,s1
100019d2:	0102d593          	srli	a1,t0,0x10
100019d6:	02b377b3          	remu	a5,t1,a1
100019da:	01029613          	slli	a2,t0,0x10
100019de:	8241                	srli	a2,a2,0x10
100019e0:	01045713          	srli	a4,s0,0x10
100019e4:	02b35333          	divu	t1,t1,a1
100019e8:	07c2                	slli	a5,a5,0x10
100019ea:	8f5d                	or	a4,a4,a5
100019ec:	02660533          	mul	a0,a2,t1
100019f0:	879a                	mv	a5,t1
100019f2:	00a77c63          	bgeu	a4,a0,10001a0a <__divdi3+0xc0>
100019f6:	9716                	add	a4,a4,t0
100019f8:	fff30793          	addi	a5,t1,-1
100019fc:	00576763          	bltu	a4,t0,10001a0a <__divdi3+0xc0>
10001a00:	00a77563          	bgeu	a4,a0,10001a0a <__divdi3+0xc0>
10001a04:	ffe30793          	addi	a5,t1,-2
10001a08:	9716                	add	a4,a4,t0
10001a0a:	8f09                	sub	a4,a4,a0
10001a0c:	02b776b3          	remu	a3,a4,a1
10001a10:	0442                	slli	s0,s0,0x10
10001a12:	8041                	srli	s0,s0,0x10
10001a14:	02b75733          	divu	a4,a4,a1
10001a18:	06c2                	slli	a3,a3,0x10
10001a1a:	8c55                	or	s0,s0,a3
10001a1c:	02e60633          	mul	a2,a2,a4
10001a20:	853a                	mv	a0,a4
10001a22:	00c47b63          	bgeu	s0,a2,10001a38 <__divdi3+0xee>
10001a26:	9416                	add	s0,s0,t0
10001a28:	fff70513          	addi	a0,a4,-1
10001a2c:	00546663          	bltu	s0,t0,10001a38 <__divdi3+0xee>
10001a30:	00c47463          	bgeu	s0,a2,10001a38 <__divdi3+0xee>
10001a34:	ffe70513          	addi	a0,a4,-2
10001a38:	07c2                	slli	a5,a5,0x10
10001a3a:	8fc9                	or	a5,a5,a0
10001a3c:	4581                	li	a1,0
10001a3e:	a855                	j	10001af2 <__divdi3+0x1a8>
10001a40:	010005b7          	lui	a1,0x1000
10001a44:	47c1                	li	a5,16
10001a46:	f6b660e3          	bltu	a2,a1,100019a6 <__divdi3+0x5c>
10001a4a:	47e1                	li	a5,24
10001a4c:	bfa9                	j	100019a6 <__divdi3+0x5c>
10001a4e:	e601                	bnez	a2,10001a56 <__divdi3+0x10c>
10001a50:	4285                	li	t0,1
10001a52:	02b2d2b3          	divu	t0,t0,a1
10001a56:	67c1                	lui	a5,0x10
10001a58:	0af2fb63          	bgeu	t0,a5,10001b0e <__divdi3+0x1c4>
10001a5c:	0ff00793          	li	a5,255
10001a60:	0057f363          	bgeu	a5,t0,10001a66 <__divdi3+0x11c>
10001a64:	45a1                	li	a1,8
10001a66:	00b2d7b3          	srl	a5,t0,a1
10001a6a:	96be                	add	a3,a3,a5
10001a6c:	0006c783          	lbu	a5,0(a3)
10001a70:	02000693          	li	a3,32
10001a74:	97ae                	add	a5,a5,a1
10001a76:	40f68633          	sub	a2,a3,a5
10001a7a:	0af69163          	bne	a3,a5,10001b1c <__divdi3+0x1d2>
10001a7e:	40570733          	sub	a4,a4,t0
10001a82:	4585                	li	a1,1
10001a84:	0102d513          	srli	a0,t0,0x10
10001a88:	01029613          	slli	a2,t0,0x10
10001a8c:	8241                	srli	a2,a2,0x10
10001a8e:	02a776b3          	remu	a3,a4,a0
10001a92:	02a75733          	divu	a4,a4,a0
10001a96:	01069793          	slli	a5,a3,0x10
10001a9a:	01045693          	srli	a3,s0,0x10
10001a9e:	8edd                	or	a3,a3,a5
10001aa0:	02e60333          	mul	t1,a2,a4
10001aa4:	87ba                	mv	a5,a4
10001aa6:	0066fc63          	bgeu	a3,t1,10001abe <__divdi3+0x174>
10001aaa:	9696                	add	a3,a3,t0
10001aac:	fff70793          	addi	a5,a4,-1
10001ab0:	0056e763          	bltu	a3,t0,10001abe <__divdi3+0x174>
10001ab4:	0066f563          	bgeu	a3,t1,10001abe <__divdi3+0x174>
10001ab8:	ffe70793          	addi	a5,a4,-2
10001abc:	9696                	add	a3,a3,t0
10001abe:	406686b3          	sub	a3,a3,t1
10001ac2:	02a6f733          	remu	a4,a3,a0
10001ac6:	0442                	slli	s0,s0,0x10
10001ac8:	8041                	srli	s0,s0,0x10
10001aca:	02a6d6b3          	divu	a3,a3,a0
10001ace:	0742                	slli	a4,a4,0x10
10001ad0:	8c59                	or	s0,s0,a4
10001ad2:	02d60633          	mul	a2,a2,a3
10001ad6:	8536                	mv	a0,a3
10001ad8:	00c47b63          	bgeu	s0,a2,10001aee <__divdi3+0x1a4>
10001adc:	9416                	add	s0,s0,t0
10001ade:	fff68513          	addi	a0,a3,-1
10001ae2:	00546663          	bltu	s0,t0,10001aee <__divdi3+0x1a4>
10001ae6:	00c47463          	bgeu	s0,a2,10001aee <__divdi3+0x1a4>
10001aea:	ffe68513          	addi	a0,a3,-2
10001aee:	07c2                	slli	a5,a5,0x10
10001af0:	8fc9                	or	a5,a5,a0
10001af2:	853e                	mv	a0,a5
10001af4:	00038963          	beqz	t2,10001b06 <__divdi3+0x1bc>
10001af8:	00f037b3          	snez	a5,a5
10001afc:	40b005b3          	neg	a1,a1
10001b00:	8d9d                	sub	a1,a1,a5
10001b02:	40a00533          	neg	a0,a0
10001b06:	4422                	lw	s0,8(sp)
10001b08:	4492                	lw	s1,4(sp)
10001b0a:	0131                	addi	sp,sp,12
10001b0c:	8082                	ret
10001b0e:	010007b7          	lui	a5,0x1000
10001b12:	45c1                	li	a1,16
10001b14:	f4f2e9e3          	bltu	t0,a5,10001a66 <__divdi3+0x11c>
10001b18:	45e1                	li	a1,24
10001b1a:	b7b1                	j	10001a66 <__divdi3+0x11c>
10001b1c:	00c292b3          	sll	t0,t0,a2
10001b20:	00f75333          	srl	t1,a4,a5
10001b24:	00c51433          	sll	s0,a0,a2
10001b28:	00c71733          	sll	a4,a4,a2
10001b2c:	00f557b3          	srl	a5,a0,a5
10001b30:	0102d513          	srli	a0,t0,0x10
10001b34:	00e7e6b3          	or	a3,a5,a4
10001b38:	02a377b3          	remu	a5,t1,a0
10001b3c:	01029713          	slli	a4,t0,0x10
10001b40:	8341                	srli	a4,a4,0x10
10001b42:	0106d593          	srli	a1,a3,0x10
10001b46:	02a35333          	divu	t1,t1,a0
10001b4a:	07c2                	slli	a5,a5,0x10
10001b4c:	8fcd                	or	a5,a5,a1
10001b4e:	02670633          	mul	a2,a4,t1
10001b52:	859a                	mv	a1,t1
10001b54:	00c7fc63          	bgeu	a5,a2,10001b6c <__divdi3+0x222>
10001b58:	9796                	add	a5,a5,t0
10001b5a:	fff30593          	addi	a1,t1,-1
10001b5e:	0057e763          	bltu	a5,t0,10001b6c <__divdi3+0x222>
10001b62:	00c7f563          	bgeu	a5,a2,10001b6c <__divdi3+0x222>
10001b66:	ffe30593          	addi	a1,t1,-2
10001b6a:	9796                	add	a5,a5,t0
10001b6c:	40c78633          	sub	a2,a5,a2
10001b70:	02a677b3          	remu	a5,a2,a0
10001b74:	02a65633          	divu	a2,a2,a0
10001b78:	07c2                	slli	a5,a5,0x10
10001b7a:	02c70533          	mul	a0,a4,a2
10001b7e:	01069713          	slli	a4,a3,0x10
10001b82:	8341                	srli	a4,a4,0x10
10001b84:	8f5d                	or	a4,a4,a5
10001b86:	87b2                	mv	a5,a2
10001b88:	00a77c63          	bgeu	a4,a0,10001ba0 <__divdi3+0x256>
10001b8c:	9716                	add	a4,a4,t0
10001b8e:	fff60793          	addi	a5,a2,-1 # 42001fff <__StackTop+0x21ffdfff>
10001b92:	00576763          	bltu	a4,t0,10001ba0 <__divdi3+0x256>
10001b96:	00a77563          	bgeu	a4,a0,10001ba0 <__divdi3+0x256>
10001b9a:	ffe60793          	addi	a5,a2,-2
10001b9e:	9716                	add	a4,a4,t0
10001ba0:	05c2                	slli	a1,a1,0x10
10001ba2:	8f09                	sub	a4,a4,a0
10001ba4:	8ddd                	or	a1,a1,a5
10001ba6:	bdf9                	j	10001a84 <__divdi3+0x13a>
10001ba8:	14d76063          	bltu	a4,a3,10001ce8 <__divdi3+0x39e>
10001bac:	67c1                	lui	a5,0x10
10001bae:	02f6ff63          	bgeu	a3,a5,10001bec <__divdi3+0x2a2>
10001bb2:	0ff00793          	li	a5,255
10001bb6:	00d7b7b3          	sltu	a5,a5,a3
10001bba:	078e                	slli	a5,a5,0x3
10001bbc:	00f6d333          	srl	t1,a3,a5
10001bc0:	00001597          	auipc	a1,0x1
10001bc4:	9c058593          	addi	a1,a1,-1600 # 10002580 <__clz_tab>
10001bc8:	959a                	add	a1,a1,t1
10001bca:	0005c583          	lbu	a1,0(a1)
10001bce:	02000313          	li	t1,32
10001bd2:	97ae                	add	a5,a5,a1
10001bd4:	40f305b3          	sub	a1,t1,a5
10001bd8:	02f31163          	bne	t1,a5,10001bfa <__divdi3+0x2b0>
10001bdc:	4785                	li	a5,1
10001bde:	f0e6eae3          	bltu	a3,a4,10001af2 <__divdi3+0x1a8>
10001be2:	00c53533          	sltu	a0,a0,a2
10001be6:	00154793          	xori	a5,a0,1
10001bea:	b721                	j	10001af2 <__divdi3+0x1a8>
10001bec:	010005b7          	lui	a1,0x1000
10001bf0:	47c1                	li	a5,16
10001bf2:	fcb6e5e3          	bltu	a3,a1,10001bbc <__divdi3+0x272>
10001bf6:	47e1                	li	a5,24
10001bf8:	b7d1                	j	10001bbc <__divdi3+0x272>
10001bfa:	00f65333          	srl	t1,a2,a5
10001bfe:	00b696b3          	sll	a3,a3,a1
10001c02:	00d36333          	or	t1,t1,a3
10001c06:	00b616b3          	sll	a3,a2,a1
10001c0a:	00f752b3          	srl	t0,a4,a5
10001c0e:	01035413          	srli	s0,t1,0x10
10001c12:	00b71733          	sll	a4,a4,a1
10001c16:	c036                	sw	a3,0(sp)
10001c18:	00f556b3          	srl	a3,a0,a5
10001c1c:	8ed9                	or	a3,a3,a4
10001c1e:	0282f733          	remu	a4,t0,s0
10001c22:	01031613          	slli	a2,t1,0x10
10001c26:	8241                	srli	a2,a2,0x10
10001c28:	0282d2b3          	divu	t0,t0,s0
10001c2c:	01071793          	slli	a5,a4,0x10
10001c30:	0106d713          	srli	a4,a3,0x10
10001c34:	8f5d                	or	a4,a4,a5
10001c36:	025604b3          	mul	s1,a2,t0
10001c3a:	8796                	mv	a5,t0
10001c3c:	00977c63          	bgeu	a4,s1,10001c54 <__divdi3+0x30a>
10001c40:	971a                	add	a4,a4,t1
10001c42:	fff28793          	addi	a5,t0,-1
10001c46:	00676763          	bltu	a4,t1,10001c54 <__divdi3+0x30a>
10001c4a:	00977563          	bgeu	a4,s1,10001c54 <__divdi3+0x30a>
10001c4e:	ffe28793          	addi	a5,t0,-2
10001c52:	971a                	add	a4,a4,t1
10001c54:	8f05                	sub	a4,a4,s1
10001c56:	028772b3          	remu	t0,a4,s0
10001c5a:	06c2                	slli	a3,a3,0x10
10001c5c:	82c1                	srli	a3,a3,0x10
10001c5e:	02875433          	divu	s0,a4,s0
10001c62:	02c2                	slli	t0,t0,0x10
10001c64:	00d2e6b3          	or	a3,t0,a3
10001c68:	02860633          	mul	a2,a2,s0
10001c6c:	8722                	mv	a4,s0
10001c6e:	00c6fc63          	bgeu	a3,a2,10001c86 <__divdi3+0x33c>
10001c72:	969a                	add	a3,a3,t1
10001c74:	fff40713          	addi	a4,s0,-1
10001c78:	0066e763          	bltu	a3,t1,10001c86 <__divdi3+0x33c>
10001c7c:	00c6f563          	bgeu	a3,a2,10001c86 <__divdi3+0x33c>
10001c80:	ffe40713          	addi	a4,s0,-2
10001c84:	969a                	add	a3,a3,t1
10001c86:	8e91                	sub	a3,a3,a2
10001c88:	4602                	lw	a2,0(sp)
10001c8a:	07c2                	slli	a5,a5,0x10
10001c8c:	64c1                	lui	s1,0x10
10001c8e:	8fd9                	or	a5,a5,a4
10001c90:	fff48713          	addi	a4,s1,-1 # ffff <rom_func_end_check_val+0x639b>
10001c94:	00e7f2b3          	and	t0,a5,a4
10001c98:	0107d313          	srli	t1,a5,0x10
10001c9c:	8f71                	and	a4,a4,a2
10001c9e:	8241                	srli	a2,a2,0x10
10001ca0:	02e28433          	mul	s0,t0,a4
10001ca4:	02e30733          	mul	a4,t1,a4
10001ca8:	02c30333          	mul	t1,t1,a2
10001cac:	02c28633          	mul	a2,t0,a2
10001cb0:	00e602b3          	add	t0,a2,a4
10001cb4:	01045613          	srli	a2,s0,0x10
10001cb8:	9616                	add	a2,a2,t0
10001cba:	00e67363          	bgeu	a2,a4,10001cc0 <__divdi3+0x376>
10001cbe:	9326                	add	t1,t1,s1
10001cc0:	01065713          	srli	a4,a2,0x10
10001cc4:	933a                	add	t1,t1,a4
10001cc6:	0066ef63          	bltu	a3,t1,10001ce4 <__divdi3+0x39a>
10001cca:	d66699e3          	bne	a3,t1,10001a3c <__divdi3+0xf2>
10001cce:	6741                	lui	a4,0x10
10001cd0:	177d                	addi	a4,a4,-1
10001cd2:	8e79                	and	a2,a2,a4
10001cd4:	0642                	slli	a2,a2,0x10
10001cd6:	8c79                	and	s0,s0,a4
10001cd8:	00b51533          	sll	a0,a0,a1
10001cdc:	9432                	add	s0,s0,a2
10001cde:	4581                	li	a1,0
10001ce0:	e08579e3          	bgeu	a0,s0,10001af2 <__divdi3+0x1a8>
10001ce4:	17fd                	addi	a5,a5,-1
10001ce6:	bb99                	j	10001a3c <__divdi3+0xf2>
10001ce8:	4581                	li	a1,0
10001cea:	4781                	li	a5,0
10001cec:	b519                	j	10001af2 <__divdi3+0x1a8>
	...

10001cf0 <gpadc_batvoltoffset>:
10001cf0:	ff0b ff98 ffee 001b 0022 0035 0033 0029     ........".5.3.).
10001d00:	0018 fffd fff9 ffed ffd7 ffcd ffbc ffa5     ................

10001d10 <gpadc_div0_offset>:
10001d10:	ff88 ffb4 ffcc ffdb ffe4 ffeb ffef fff3     ................
10001d20:	fff6 fff8 fffa fffc fffc fffe ffff 0000     ................

10001d30 <gpadc_div1_offset>:
10001d30:	ff16 ff6e ffa1 ffbd ffcf ffdb ffe5 ffeb     ..n.............
10001d40:	fff1 fff5 fff9 fffb ffff 0001 0001 0003     ................
10001d50:	ff18 ff6f ffa0 ffbc ffce ffda ffe4 ffea     ..o.............
10001d60:	ffee fff2 fff6 fffa fffc fffe 0000 0000     ................
10001d70:	ff1f ff75 ffa4 ffc0 ffd0 ffdc ffe4 ffec     ..u.............
10001d80:	fff0 fff4 fff6 fffa fffc fffe 0000 0000     ................
10001d90:	ff2b ff7c ffa9 ffc3 ffd3 ffdf ffe7 ffed     +.|.............
10001da0:	fff1 fff5 fff7 fff9 fffb fffd ffff ffff     ................
10001db0:	ff3c ff8b ffb3 ffcb ffd9 ffe3 ffe9 ffef     <...............
10001dc0:	fff3 fff5 fff9 fffb fffb fffd ffff ffff     ................
10001dd0:	ff60 ffa0 ffc2 ffd6 ffe0 ffe8 ffee fff2     `...............
10001de0:	fff4 fff6 fff8 fffa fffc fffe fffe fffe     ................
10001df0:	ff9c ffc4 ffda ffe6 ffee fff2 fff4 fff6     ................
10001e00:	fff8 fffa fffa fffc fffc fffe fffe fffe     ................
10001e10:	ffec fff1 fff7 fff9 fffb fffd fffd fffd     ................
10001e20:	fffd ffff ffff ffff ffff ffff ffff ffff     ................
10001e30:	001b 0027 0019 0011 000b 0009 0007 0005     ..'.............
10001e40:	0003 0003 0003 0001 0001 0001 0001 0001     ................
10001e50:	ffef 003e 0042 002c 001e 0014 000e 000a     ..>.B.,.........
10001e60:	0008 0006 0004 0002 0002 0000 0000 0000     ................
10001e70:	ffba 001c 004e 004e 0038 0026 001a 0012     ....N.N.8.&.....
10001e80:	000e 000a 0006 0004 0004 0002 0000 0000     ................
10001e90:	ff9a fff9 0033 0051 0051 003d 002b 001d     ....3.Q.Q.=.+...
10001ea0:	0015 000f 0009 0007 0003 0001 ffff ffff     ................
10001eb0:	ff82 ffe1 0019 003d 0053 0055 0041 002f     ......=.S.U.A./.
10001ec0:	0021 0017 0011 000b 0007 0005 0003 0001     !...............
10001ed0:	ff70 ffce 0006 0028 0042 0052 0054 0044     p.....(.B.R.T.D.
10001ee0:	0030 001e 0018 0012 000c 0008 0004 0002     0...............
10001ef0:	ff61 ffbe fff6 0018 0030 0042 0050 0052     a.......0.B.P.R.
10001f00:	0044 0032 0024 0018 0012 000c 0006 0002     D.2.$...........
10001f10:	ff55 ffb1 ffe9 000b 0021 0033 0041 004b     U.......!.3.A.K.
10001f20:	004f 0043 0031 0023 0019 0011 000b 0005     O.C.1.#.........

10001f30 <gpadc_div2_offset>:
10001f30:	ff36 ffc4 001b 0048 0051 0042 0036 002d     6.....H.Q.B.6.-.
10001f40:	0027 0024 0021 001e 001b 001b 001b 001b     '.$.!...........
10001f50:	ff16 ffa3 fff8 0028 0049 004f 0043 0034     ......(.I.O.C.4.
10001f60:	0028 0022 001c 0019 0019 0016 0013 0013     (.".............
10001f70:	fefc ff86 ffdb 000b 002c 0044 004d 003e     ........,.D.M.>.
10001f80:	002f 0023 001d 0017 0011 000e 000e 000b     /.#.............
10001f90:	fee5 ff6f ffc1 fff4 0015 002d 003f 0048     ..o.......-.?.H.
10001fa0:	003c 002d 0021 0018 0012 000c 0009 0006     <.-.!...........
10001fb0:	fed1 ff5b ffad ffdd 0001 0019 002b 003a     ..[.........+.:.
10001fc0:	0040 0037 0028 0019 0010 000a 0004 0001     @.7.(...........
10001fd0:	febd ff47 ff99 ffc9 ffea 0002 0014 0023     ..G...........#.
10001fe0:	002f 0035 002f 0020 0014 0008 0002 fffc     /.5./. .........
10001ff0:	febd ff36 ff85 ffb8 ffd6 fff1 0003 0012     ..6.............
10002000:	001e 0027 002d 0027 0018 000c 0003 fffa     ..'.-.'.........
10002010:	febd ff22 ff70 ffa4 ffc5 ffdd ffef fffe     ..".p...........
10002020:	000a 0013 001c 0022 001f 0010 0004 fff8     ......".........
10002030:	febd ff11 ff62 ff93 ffb4 ffcc ffde ffed     ....b...........
10002040:	fff9 0005 000e 0014 001a 0017 000b fffc     ................
10002050:	febd feee ff4e ff82 ffa3 ffbb ffcd ffdc     ....N...........
10002060:	ffe8 fff1 fffa 0003 0009 000f 000c 0000     ................
10002070:	febd fe10 ff31 ff74 ff95 ffad ffbf ffce     ....1.t.........
10002080:	ffda ffe3 ffec fff5 fffb 0001 0004 0004     ................
10002090:	febd fbd8 fe59 ff53 ff84 ff9f ffb1 ffc0     ....Y.S.........
100020a0:	ffcc ffd5 ffde ffe4 ffed fff3 fff9 fffc     ................
100020b0:	febd f8e5 fc24 fe7f ff64 ff8b ff9d ffac     ....$...d.......
100020c0:	ffb8 ffc4 ffcd ffd3 ffdc ffe2 ffe5 ffeb     ................
100020d0:	febd f59d f946 fc52 fe95 ff6e ff8f ff9e     ....F.R...n.....
100020e0:	ffaa ffb6 ffbf ffc5 ffce ffd4 ffd7 ffdd     ................

100020f0 <gpadc_div3_offset>:
100020f0:	ffea ffea ffea ffea ffea ff8a ffa2 ffb6     ................
10002100:	ffc2 ffd2 ffda ffe6 ffee fff6 fffa fffa     ................
10002110:	fff1 fff1 fff1 fff1 fff1 fff1 ffa1 ffb5     ................
10002120:	ffc5 ffd1 ffdd ffe5 ffed fff5 fffd 0001     ................
10002130:	fff8 fff8 fff8 fff8 fff8 fff8 fff8 ffb4     ................
10002140:	ffc4 ffd0 ffdc ffe4 ffec fff4 fffc 0000     ................
	...
10002160:	ffc4 ffd0 ffdc ffe4 ffec fff4 fffc 0000     ................
10002170:	0007 0007 0007 0007 0007 0007 0007 0007     ................
10002180:	0007 ffcf ffdb ffe3 ffeb fff3 fffb ffff     ................
10002190:	000e 000e 000e 000e 000e 000e 000e 000e     ................
100021a0:	000e 000e ffda ffe2 ffea fff2 fffa fffe     ................
100021b0:	0016 0016 0016 0016 0016 0016 0016 0016     ................
100021c0:	0016 0016 0016 ffe2 ffea fff2 fffa fffe     ................
100021d0:	001d 001d 001d 001d 001d 001d 001d 001d     ................
100021e0:	001d 001d 001d 001d ffed fff5 fffd 0001     ................
100021f0:	0024 0024 0024 0024 0024 0024 0024 0024     $.$.$.$.$.$.$.$.
10002200:	0024 0024 0024 0024 0024 fff4 fff8 0000     $.$.$.$.$.......
10002210:	002c 002c 002c 002c 002c 002c 002c 002c     ,.,.,.,.,.,.,.,.
10002220:	002c 002c 002c 002c 002c 002c fff8 0000     ,.,.,.,.,.,.....
10002230:	0033 0033 0033 0033 0033 0033 0033 0033     3.3.3.3.3.3.3.3.
10002240:	0033 0033 0033 0033 0033 0033 0033 ffff     3.3.3.3.3.3.3...
10002250:	0020 0000 3130 3332 3534 3736 3938 6261      ...0123456789ab
10002260:	6463 6665 0000 0000 3130 3332 3534 3736     cdef....01234567
10002270:	3938 4241 4443 4645 0000 0000 5245 4f52     89ABCDEF....ERRO
10002280:	0052 0000 10ce 1000 10da 1000 10da 1000     R...............
10002290:	10da 1000 10da 1000 10da 1000 10da 1000     ................
100022a0:	10da 1000 10da 1000 10da 1000 10da 1000     ................
100022b0:	0ee0 1000 0ee0 1000 0ee0 1000 0ee0 1000     ................
100022c0:	0ee0 1000 0ee0 1000 0ee0 1000 0ee0 1000     ................
100022d0:	0ee0 1000 0ee0 1000 10da 1000 10da 1000     ................
100022e0:	10da 1000 10da 1000 10da 1000 10da 1000     ................
100022f0:	10da 1000 10da 1000 10da 1000 10da 1000     ................
10002300:	10da 1000 10da 1000 10da 1000 10da 1000     ................
10002310:	10da 1000 10da 1000 10da 1000 10da 1000     ................
10002320:	10da 1000 10da 1000 10da 1000 10da 1000     ................
10002330:	10da 1000 10da 1000 10da 1000 10da 1000     ................
10002340:	10da 1000 10da 1000 10da 1000 10da 1000     ................
10002350:	0fe6 1000 10da 1000 10da 1000 10da 1000     ................
10002360:	10da 1000 10da 1000 10da 1000 10da 1000     ................
10002370:	10da 1000 10da 1000 10da 1000 0efc 1000     ................
10002380:	0f16 1000 10da 1000 10da 1000 10da 1000     ................
10002390:	10da 1000 10da 1000 10da 1000 10da 1000     ................
100023a0:	0ef2 1000 10da 1000 10da 1000 10da 1000     ................
100023b0:	0ffa 1000 10da 1000 10da 1000 0f3a 1000     ............:...
100023c0:	10da 1000 0f9c 1000 10da 1000 10da 1000     ................
100023d0:	0ffa 1000 10da 1000 0f16 1000 000a 0000     ................

100023e0 <gpio_res_tbl_gnd>:
100023e0:	0574 01e2 0128 00dc 0529 01c9 011b 00d1     t...(...).......
100023f0:	04ea 01b6 010d 00c9 04b6 01a5 0105 00c2     ................
10002400:	048e 0196 00fd 00bc 0469 018c 00f5 00b8     ........i.......
10002410:	0448 0181 00f0 00b4 0430 017a 00eb 00b1     H.......0.z.....
10002420:	041a 0173 00e8 00af 0408 016e 00e5 00ad     ..s.......n.....
10002430:	03f8 0168 00e2 00ab 03ea 0164 00e0 00aa     ..h.......d.....
10002440:	03de 0160 00de 00a8 03d4 015d 00dd 00a7     ..`.......].....
10002450:	03cb 015a 00db 00a6 03c4 0158 00d9 00a5     ..Z.......X.....

10002460 <gpio_res_tbl_vdd>:
10002460:	066c 0232 0159 00fc 061f 0219 0149 00f1     l.2.Y.......I...
10002470:	05e1 0203 013b 00e7 05a7 01ed 0130 00df     ....;.......0...
10002480:	0575 01de 0126 00d7 0549 01cf 011d 00d1     u...&...I.......
10002490:	0523 01c0 0116 00cb 04ff 01b4 010e 00c5     #...............
100024a0:	04dd 01aa 0108 00c0 04c2 01a1 0100 00bc     ................
100024b0:	04a8 0198 00fa 00b9 0491 0190 00f6 00b5     ................
100024c0:	0479 0186 00f2 00b2 0463 017f 00ed 00ae     y.......c.......
100024d0:	0451 0178 00e8 00aa 043e 0173 00e2 00a5     Q.x.....>.s.....
100024e0:	5047 4441 2043 6574 7473 2e20 2e2e 0000     GPADC test .....
100024f0:	2020 2020 2a2a 2020 6e63 3a74 2520 6434         **  cnt: %4d
10002500:	202c 6964 3a76 2520 6432 202c 7067 6f69     , div: %2d, gpio
10002510:	203a 3425 2064 566d 202c 6276 7461 203a     : %4d mV, vbat: 
10002520:	3425 2064 566d 202c 6572 3a73 2520 2064     %4d mV, res: %d 
10002530:	684f 0a6d 0000 0000 2020 2020 2020 2020     Ohm.....        
10002540:	6e63 3a74 2520 6434 202c 6964 3a76 2520     cnt: %4d, div: %
10002550:	6432 202c 7067 6f69 203a 3425 2064 566d     2d, gpio: %4d mV
10002560:	202c 6276 7461 203a 3425 2064 566d 202c     , vbat: %4d mV, 
10002570:	6572 3a73 2520 2064 684f 0a6d 0000 0000     res: %d Ohm.....

10002580 <__clz_tab>:
10002580:	0100 0202 0303 0303 0404 0404 0404 0404     ................
10002590:	0505 0505 0505 0505 0505 0505 0505 0505     ................
100025a0:	0606 0606 0606 0606 0606 0606 0606 0606     ................
100025b0:	0606 0606 0606 0606 0606 0606 0606 0606     ................
100025c0:	0707 0707 0707 0707 0707 0707 0707 0707     ................
100025d0:	0707 0707 0707 0707 0707 0707 0707 0707     ................
100025e0:	0707 0707 0707 0707 0707 0707 0707 0707     ................
100025f0:	0707 0707 0707 0707 0707 0707 0707 0707     ................
10002600:	0808 0808 0808 0808 0808 0808 0808 0808     ................
10002610:	0808 0808 0808 0808 0808 0808 0808 0808     ................
10002620:	0808 0808 0808 0808 0808 0808 0808 0808     ................
10002630:	0808 0808 0808 0808 0808 0808 0808 0808     ................
10002640:	0808 0808 0808 0808 0808 0808 0808 0808     ................
10002650:	0808 0808 0808 0808 0808 0808 0808 0808     ................
10002660:	0808 0808 0808 0808 0808 0808 0808 0808     ................
10002670:	0808 0808 0808 0808 0808 0808 0808 0808     ................
10002680:	0010 0000 0000 0000 7a03 0052 7c01 0101     .........zR..|..
10002690:	0d1b 0002 0024 0000 0018 0000 f2ae ffff     ....$...........
100026a0:	03a4 0000 4200 0c0e 8844 8901 0302 01b8     .....B..D.......
100026b0:	c80a c942 0e42 4200 000b 0000 0010 0000     ..B.B..B........
100026c0:	0000 0000 7a03 0052 7c01 0101 0d1b 0002     .....zR..|......
100026d0:	0024 0000 0018 0000 0000 0000 0000 0000     $...............
100026e0:	4200 080e 8844 8901 0302 0000 c80a c942     .B..D.........B.
100026f0:	0e42 4200 000b 0000                         B..B....
