//------------------------------------------------------------------------------------
 //app_HS6220_test.c
//------------------------------------------------------------------------------------
// Copyright 2019, HunterSun Electronics Co., Ltd.
// crazy_code@yeah.net
// 2019-07-17

// Program Description:





#include ".\Sys\GF90F0320T.h"
#include "HS6220_RF.h"
#include "app_hs6220_test_ble.h"
#include "uti.h"
#include "com.h"
#include "intrins.h"

#include ".\Sys\GF90F0320T.h"
#include "intrins.h"
#include ".\Sys\register.h"
#include ".\Sys\gpio.h"
#include ".\Sys\flash.h"
#include ".\Sys\timer.h"
#include ".\Hdw\HS6200_RF.h"
#include "led.h"
#include "uti.h"
#include "uart.h"
#include "stdio.h"
#include <string.h>

#define AD_TYPE_MANUFACTURE_DATA     0xff
#define AD_TYPE_SHORT_LOCAL_NAME     0x08
#define AD_TYPE_COMPLETE_LOCAL_NAME  0x09
#define DEFAULT_MANUFACTURE_ID       0xFFF1

#define APP_GAP_APPEARANCE 961

static void hal_dump_rf_register(void);

static xdata unsigned char Tx_Payload[LONG_PACKET_TX_LEN];
static xdata unsigned char Rx_Payload[LONG_PACKET_RX_LEN];

volatile  unsigned char rx_offset = 0;
volatile  unsigned char rx_len = 0;

static const unsigned char channel_index[3] = {
	2,
	26,
	80
};

xdata unsigned char exe_gbuf_adv_ind[42] = {
  ///.header
  0x02, 37,
  ///.AdvA
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  ///Flags: BLE limited discoverable mode and BR/EDR not supported
  0x02, 0x01, 0x06,
  ///incomplete list of service class UUIDs: (0x1812, 0x180F)
  0x03, 0x02, 0x12, 0x18,
  ///Apperance
  0x03, 0x19, APP_GAP_APPEARANCE&0x0ff, (APP_GAP_APPEARANCE>>8)&0xff,
  ///Complete Local Name in 18 bytes always.
  19, 0x09,
  'H','S','Z','_','H','S','6','2','2','0',' ',' ',' ',' ',' ',' ',' ',' ',
  ///RFstar BLE Light's MANUFACTURER_ID
  //2, 1, 6, 3, 2, -80, -1, 9, -1, 83, -85, -38, 26, 31, -54, -25, -125,
  ///CRC24
  0, 0, 0,
};

xdata	unsigned char status=0x00;
void send_ble_packet_test(void)
{
	unsigned short i=0;
	unsigned char idx = 0,j=1;
	unsigned char status=0x00;

	hs6220_ble_init();   
	HS6220_write_byte(HS6220_BANK0_CONFIG, 0x8a); // power up

	//for(i = 0; i < 100; i ++)
	while(1)
	{
		HS6220_Flush_Tx();

		HS6220_Clear_All_Irq(); 	

		if(i % 16 == 0)
		printf("\r\n");
		printf("%4d ",i+1);
		
		Tx_Payload[0] = 3+j;         //AD_Element_length
		
		for(idx=0;idx<3;idx++)
		{
			HS6220_write_byte(HS6220_BANK0_RF_CH, channel_index[idx]);
			HS6220_wr_buffer(HS6220_BANK0_TX_HEADER, exe_gbuf_adv_ind, 2);
			HS6220_wr_buffer(HS6220_W_TX_PAYLOAD, exe_gbuf_adv_ind+8,  exe_gbuf_adv_ind[1]-6);

			HS6220_CE_High(); //ce pulse 20us
			Delay10us(40);
			HS6220_CE_Low();
			Delay1ms(2);
			/*wait data send finished*/
			while(1)	
			{
				status = HS6220_read_byte(HS6220_BANK0_STATUS);;
				if ((HS6220_STATUS_TX_DS & status) || (HS6220_STATUS_MAX_RT & status))
				{
					HS6220_write_byte(HS6220_BANK0_STATUS, status);	
					break; 
				}
			}
		}
		Delay1ms(30);
	}
}

void recv_ble_packet_test(void)
{
	unsigned char i = 0;
	unsigned char idx = 0;
	unsigned char len = 0;
	unsigned char status = 0x00;
	unsigned char ble_header_tbl[2] = {0x06,37}; // byte[0]7:rxadd,6:txadd,5~4:rfu,3~0:type; byte[1]length
	unsigned char ble_advaddr_tbl[6] = {0x00};
	
	hs6220_ble_init();

	printf("packet recv start!\n");
    
	HS6220_write_byte(HS6220_BANK0_CONFIG, 0xfb); // power up
	/* 7:event abort,6:md dsb,5:nesn sn dsb,4:infiniterx,
	3~0:3-ble broacast,5-ble connection,9-ble tx test,b-ble rx test */
	HS6220_write_byte(HS6220_BANK0_BLE_CTL, 0x1b);	
													
	idx = 1;
	HS6220_write_byte(HS6220_BANK0_RF_CH, channel_index[idx]); // channle map:37:2402,38:2426,39:2480
	
#if DUMP_INFO	
	hal_dump_rf_register();
#endif	
//	hs6220_irq_config();
	
	HS6220_CE_High();
	
	while(1)
	{
#if !LONG_PACKET_PRX
		status = HS6220_read_byte(HS6220_BANK0_STATUS);
		if (HS6220_STATUS_RX_DR & status)
		{
			HS6220_CE_Low();
			len = HS6220_read_payload_length();
			HS6220_read_buffer(HS6220_R_RX_PAYLOAD, Rx_Payload + rx_offset, len);

				printf("length = %x,", len);
				for(i = 0; i < len; i ++)
				{
					printf("%02x ", Rx_Payload[i]);
					Rx_Payload[i] = 0;
				}			
//			HS6220_read_buffer(HS6220_BANK0_RX_HEADER, ble_advaddr_tbl, 2);
//			printf("RX_HEADER ");
//			for(i = 0; i < 2; i ++)
//			{
//				printf("%02x ", ble_advaddr_tbl[1-i]);
//				ble_advaddr_tbl[1-i] = 0;
//			}
//			printf("\n");
//			
//			HS6220_read_buffer(HS6220_BANK0_RX_ADVA_ADDR, ble_advaddr_tbl, 6);
//			printf("RX_ADVA_ADDR ");
//			for(i = 0; i < 6; i ++)
//			{
//				printf("%02x ", ble_advaddr_tbl[i]);
//				ble_advaddr_tbl[i] = 0;
//			}
//			printf("\n");
//			
//			len = HS6220_read_payload_length();
//			HS6220_read_buffer(HS6220_R_RX_PAYLOAD, Rx_Payload , len);
//			printf("length = %x,", len);
//			for(i = 0; i < len; i ++)
//			{
//				printf("%02x ", Rx_Payload[i]);
//				Rx_Payload[i] = 0;
//			}
			printf("\n");
			
			HS6220_Flush_Rx();
			HS6220_Clear_All_Irq(); 
			HS6220_CE_High();
		}
#endif
	}
#if LONG_PACKET_PRX
	hs6220_irq_config();
#endif
}

void hs6220_ble_init(void)
{
	xdata unsigned char temp[6];
	xdata unsigned char i;
		xdata unsigned char data_tmp;
//	GPIO_InitTypeDef GPIO_InitStruct;  
	HS6220_SPI_Init();
	
reset_rf_int:
	HS6220_write_byte(HS6220_BANK0_FEATURE, SOFT_RST); // soft_reset
//	printf("hs6220_ble_init\n");
#if (HS6220_SPI_NWIRE == SPI_4_WIRE) 
	// Ĭ3SPI,Ҫʹ4SPI,ϵ֮Ҫһ
	HS6220_write_byte(HS6220_BANK0_DYNPD, 0x08);
#else
	HS6220_write_byte(HS6220_BANK0_DYNPD, 0x00);
#endif

	HS6220_CE_Low();	
	HS6220_write_byte(HS6220_BANK0_CONFIG, 0x03); // power up
	Delay1ms(4); // wait 3 ms
	HS6220_write_byte(HS6220_BANK0_PMU_CTL, 0x04); // RF_PWRDWN = 00 32K_en = 1
	Delay1ms(3); // wait 2 ms

	HS6220_write_byte(HS6220_BANK0_RF_CH, 0x28); 

	HS6220_Bank_Switch(HS6220_Bank1);
//	HS6220_wr_cmd(HS6220_ACTIVATE, HS6220_ACTIVATE_DATA);

	HS6220_write_byte(HS6220_BANK1_TEST_PKDET, 0x24); // pll_vdiv2_sel = 01

	temp[1] = 0x11; // vco_amp_mn=1, ֶģʽ
	temp[0] = 0xc3; // vco_amp_ctl= 0xcֵ
	HS6220_wr_buffer(HS6220_BANK1_FAGC_CTRL_1, temp, 2);

	HS6220_Bank_Switch(HS6220_Bank0);  
//	HS6220_wr_cmd(HS6220_ACTIVATE, HS6220_ACTIVATE_DATA);

	HS6220_CE_High();
	Delay10us(50);
	HS6220_CE_Low();

  data_tmp = 35; 
	while((HS6220_read_byte(HS6220_BANK0_RF_SETUP) & 0x20) == 0x00); // wait cal done
  {
      Delay1ms(1);
      data_tmp--;
      if(0 == data_tmp)
      {
        goto reset_rf_int;
      }
  }
	//    delay_ms(500);
	HS6220_write_byte(HS6220_BANK0_RF_SETUP, HS6220_read_byte(HS6220_BANK0_RF_SETUP)&(~BIT4)); // clear cal_en
//	HS6220_write_byte(HS6220_BANK0_RF_SETUP, 0x60); 
	HS6220_write_byte(HS6220_BANK0_FEATURE, 0x48); // BLE_EN = 1, bp_gau = 0
	HS6220_write_byte(HS6220_BANK0_DYNPD, 0x07);
	
	HS6220_write_byte(HS6220_BANK0_PRE_GURD, 0x67); // 1byte pramble
	
		
//	printf("cali done\r\n");
	HS6220_Bank_Switch(HS6220_Bank1);	
//	HS6220_wr_cmd(HS6220_ACTIVATE, HS6220_ACTIVATE_DATA);

	temp[3] = 0x28;
	temp[2] = 0x75; // bp_dac =1 bp_rc = 1
	temp[1] = 0x98; // bp_vco_amp = 1 bp_vco_ldo=1
	temp[0] = 0x20;
	HS6220_wr_buffer(HS6220_BANK1_CAL_CTL, temp, 4);

	temp[2] = 0x11;
	temp[1] = 0x04;  
	temp[0] = 0x1D;    
	HS6220_wr_buffer(HS6220_BANK1_RF_IVGEN, temp, 3); // xtal_cc = 0x1d

	HS6220_Bank_Switch(HS6220_Bank0);
	

//	HS6220_wr_cmd(HS6220_ACTIVATE, HS6220_ACTIVATE_DATA);

	HS6220_write_byte(HS6220_BANK0_CONFIG, 0x0a);
	HS6220_write_byte(HS6220_BANK0_EN_AA, 0x00);

	HS6220_write_byte(HS6220_BANK0_SETUP_VALUE, 0xff); // rx timeout 
	HS6220_write_byte(HS6220_BANK0_CONFIG_EXT, 0x24); // дtx fifo ߷, ʹhs6220ڲ

	HS6220_write_byte(HS6220_BANK0_RX_PW_P0, LONG_PACKET_RX_LEN);
	
	temp[0] = 0x46;
	temp[1] = 0x0b;
	temp[2] = 0xaf;
	temp[3] = 0x43;
	temp[4] = 0x98;
	temp[5] = 0x27;
	HS6220_wr_buffer(HS6220_BANK0_TX_ADVA_ADDR, temp, 6);

	temp[0] = 0x55;
	temp[1] = 0x55;
	temp[2] = 0x55;
	HS6220_wr_buffer(HS6220_BANK0_CRC_INIT, temp, 3);

	temp[0] = 0xd6;
	temp[1] = 0xbe;
	temp[2] = 0x89;
	temp[3] = 0x8e;
	HS6220_wr_buffer(HS6220_BANK0_ACCESS_ADDR, temp, 4); // 0x8E89BED6
}

#if LONG_PACKET_PRX
static void long_packet_half_interrupt_process(void)
{
	HS6220_read_buffer(HS6220_R_RX_PAYLOAD, Rx_Payload + rx_offset, 16);
	rx_len += 16;
	rx_offset += 16;
}

static void long_packet_rx_interrupt_process(void)
{
	unsigned char len = 0;
	int j;
	HS6220_CE_Low();
	len = HS6220_read_payload_length();
	HS6220_read_buffer(HS6220_R_RX_PAYLOAD, Rx_Payload + rx_offset, len);
	rx_len += len;
	rx_offset += len;			

//	printf("\nRlen=%d\n", rx_len);
//	for( j = 0; j < rx_len; j ++)
//		printf("%02x ", Rx_Payload[j]);

	rx_offset = 0;
	rx_len = 0;
	rwmemset(Rx_Payload, 0, LONG_PACKET_RX_LEN);
	HS6220_Flush_Rx();
	HS6220_Clear_All_Irq(); 
	HS6220_CE_High();
}

void HS6220_IRQ_Handler()  // long packet recieve isr
{
	unsigned char status = 0;
	unsigned char retry_count = 0;
	unsigned char tmp_buf[2] = {0x00};
	
//	if(EXTI_State(HS6220_IRQ_PORT,HS6220_IRQ_PIN))   
//	{
//		EXTI_Clear(HS6220_IRQ_PORT,HS6220_IRQ_PIN); 
//		
//		
//	//	printf("HS6220_IRQ_Handler\n");
//		while(1) 
//		{
//			status = HS6220_read_byte(HS6220_BANK0_STATUS_EXT);
//	//		printf("\status=%d\n", status);
//			if(status & RX_AFULL) // more than half of fifo
//			{
//				long_packet_half_interrupt_process();
//				retry_count = 0;
//			}
//			else if(status & HS6220_STATUS_RX_DR)
//			{
//				long_packet_rx_interrupt_process(); 
//				retry_count = 0;
//				break;
//			}
//			else if(status & RX_TIMER_OUT)
//			{
//				HS6220_CE_Low();
//				HS6220_Flush_Rx();
//				HS6220_Clear_All_Irq(); 
//				HS6220_CE_High();    
//				break;
//			}
//		}
//	}	
}
#endif

void hs6220_ble_test(void)
{				
		
			recv_ble_packet_test();
//			send_ble_packet_test();

}

static void hal_dump_rf_register(void)
{
#if DUMP_INFO
  unsigned char reg_value;
  unsigned char temp[6]; 
  signed char i;
  
  HS6220_Bank_Switch(HS6220_Bank0);
    
  HS6220_read_buffer(HS6220_BANK0_CONFIG, &reg_value, 1);
  printf("\r\n\r\n\r\nRF_BANK0_CONFIG(0x00): %02x\r\n", reg_value);  
  
  HS6220_read_buffer(HS6220_BANK0_EN_AA, &reg_value, 1);
  printf("RF_BANK0_EN_AA(0x01): %02x\r\n", reg_value); 

  HS6220_read_buffer(HS6220_BANK0_EN_RXADDR, &reg_value, 1);
  printf("RF_BANK0_EN_RXADDR(0x02): %02x\r\n", reg_value);  
  
  HS6220_read_buffer(HS6220_BANK0_PMU_CTL, &reg_value, 1);
  printf("RF_BANK0_PMU_CTL(0x03): %02x\r\n", reg_value); 
  
  HS6220_read_buffer(HS6220_BANK0_SETUP_RETR, &reg_value, 1);
  printf("RF_BANK0_SETUP_RETR(0x04): %02x\r\n", reg_value);	
	
  HS6220_read_buffer(HS6220_BANK0_RF_CH, &reg_value, 1);
  printf("RF_BANK0_HS6220_RF_CH(0x05): %02x\r\n", reg_value); 
  
  HS6220_read_buffer(HS6220_BANK0_RF_SETUP, &reg_value, 1);
  printf("RF_BANK0_HS6220_RF_SETUP(0x06): %02x\r\n", reg_value); 

  HS6220_read_buffer(HS6220_BANK0_STATUS, &reg_value, 1);
  printf("RF_BANK0_STATUS(0x07): %02x\r\n", reg_value); 
	
  HS6220_read_buffer(HS6220_BANK0_ACCESS_ADDR, temp, 4);
  printf("RF_BANK0_ACCESS_ADDR(0x0A): "); 
  for(i=3;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");
  
  HS6220_read_buffer(HS6220_BANK0_BLE_TIM_CNT, &reg_value, 1);
  printf("HS6220_BANK0_BLE_TIM(0x0B): %02x\r\n", reg_value); 
  
  HS6220_read_buffer(HS6220_BANK0_BLE_CTL, &reg_value, 1);
  printf("RF_BANK0_BLE_CTL(0x0C): %02x\r\n", reg_value); 
	
	HS6220_read_buffer(HS6220_BANK0_CLKN_SYNC_ADDR, temp, 4);
  printf("RF_BANK0_CLKN_SYNC_ADDR(0x0D): "); 
	for(i=3;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");

  HS6220_read_buffer(HS6220_BANK0_TX_ADVA_ADDR, temp, 6);
  printf("RF_BANK0_TX_ADVA(0x10): "); 
  for(i=5;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");
	
  HS6220_read_buffer(HS6220_BANK0_TX_HEADER, temp, 2);
  printf("RF_BANK0_TX_HEADER(0x11): "); 
  for(i=1;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");
  
  HS6220_read_buffer(HS6220_BANK0_CRC_INIT, temp, 3);
  printf("RF_BANK0_CRC_INIT(0x12): "); 
  for(i=2;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");
	
  HS6220_read_buffer(HS6220_BANK0_BLE_SETUP_DELAY, &reg_value, 1);
  printf("RF_BANK0_BLE_SETUP_DELAY(0x13): %02x\r\n", reg_value); 
		  
  HS6220_read_buffer(HS6220_BANK0_RX_HEADER, temp, 2);
  printf("RF_BANK0_RX_HEADER(0x14): "); 
  for(i=1;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");
  
  HS6220_read_buffer(HS6220_BANK0_RX_ADVA_ADDR, temp, 6);
  printf("RF_BANK0_RX_ADVA(0x15): "); 
  for(i=5;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");
	
	HS6220_read_buffer(HS6220_BANK0_STATUS_EXT, temp, 2);
  printf("RF_BANK0_STATUS_EXT(0x16): "); 
  for(i=1;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");
	
	HS6220_read_buffer(HS6220_BANK0_FIFO_STATUS, &reg_value, 1);
  printf("RF_BANK0_FIFO_STATUS(0x17): %02x\r\n", reg_value); 

	HS6220_read_buffer(HS6220_BANK0_CONFIG_EXT, &reg_value, 1);
  printf("RF_BANK0_CONFIG_EXT(0x18): %02x\r\n", reg_value);
  
  HS6220_read_buffer(HS6220_BANK0_DYNPD, &reg_value, 1);
  printf("RF_BANK0_DYNPD(0x1C): %02x\r\n", reg_value); 
  
  HS6220_read_buffer(HS6220_BANK0_FEATURE, &reg_value, 1);
  printf("RF_BANK0_FEATURE(0x1D): %02x\r\n", reg_value); 

  HS6220_read_buffer(HS6220_BANK0_SETUP_VALUE, temp, 3);
  printf("RF_BANK0_SETUP_VALUE(0x1E): ");
  for(i=2;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");
  
  HS6220_read_buffer(HS6220_BANK0_PRE_GURD, temp, 2);
  printf("RF_BANK0_PRE_GURD(0x1F): ");  
  for(i=1;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n\r\n");
  
  HS6220_Bank_Switch(HS6220_Bank1);

  HS6220_read_buffer(HS6220_BANK1_CHIP_ID, temp, 2);
  printf("RF_BANK1_CHIP_ID(0x00):");
  for(i=1;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n"); 
  
  HS6220_read_buffer(HS6220_BANK1_PLL_CTL0, temp, 4);
  printf("RF_BANK1_PLL_CTL0(0x01):");
  for(i=3;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");  

  HS6220_read_buffer(HS6220_BANK1_PLL_CTL1, temp, 3);
  printf("RF_BANK1_PLL_CTL1(0x02):");
  for(i=2;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");

  HS6220_read_buffer(HS6220_BANK1_CAL_CTL, temp, 4);
  printf("RF_BANK1_CAL_CTL(0x03):");
  for(i=3;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");

  HS6220_read_buffer(HS6220_BANK1_STATUS, &reg_value, 1);
  printf("RF_BANK1_STATUS(0x07):%02x\r\n", reg_value);   

  HS6220_read_buffer(HS6220_BANK1_STATE, temp, 2);
  printf("RF_BANK1_STATE(0x08):");
  for(i=1;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n"); 

  HS6220_read_buffer(HS6220_BANK1_CHAN, temp, 4);
  printf("RF_BANK1_CHAN(0x09):");
  for(i=3;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");    

  HS6220_read_buffer(HS6220_BANK1_FDEV, &reg_value, 1);
  printf("RF_BANK1_FDEV(0x0C):%02x\r\n", reg_value);  
	
  HS6220_read_buffer(HS6220_BANK1_DAC_RANGE, &reg_value, 1);
  printf("RF_BANK1_DAC_RANGE(0x0D):%02x\r\n", reg_value);  

  HS6220_read_buffer(HS6220_BANK1_CTUNING, temp, 2);
  printf("RF_BANK1_CTUNING(0x0F):");
  for(i=1;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n"); 
	
	HS6220_read_buffer(HS6220_BANK1_FTUNING, temp, 2);
  printf("RF_BANK1_FTUNING(0x10):");
  for(i=1;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n"); 
	
  HS6220_read_buffer(HS6220_BANK1_RX_CTRL, temp, 2);
  printf("RF_BANK1_RX_CTRL(0x11):");
  for(i=1;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");    

  HS6220_read_buffer(HS6220_BANK1_FAGC_CTRL_1, temp, 4);
  printf("RF_BANK1_FAGC_CTRL_1(0x13):");
  for(i=3;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n"); 
	
  HS6220_read_buffer(HS6220_BANK1_DOC_DACI, &reg_value, 1);
  printf("RF_BANK1_DOC_DACI(0x1A):%02x\r\n", reg_value);  
	
  HS6220_read_buffer(HS6220_BANK1_DOC_DACQ, &reg_value, 1);
  printf("RF_BANK1_DOC_DACQ(0x1B):%02x\r\n", reg_value);  

  HS6220_read_buffer(HS6220_BANK1_AGC_CTRL, temp, 3);
  printf("RF_BANK1_AGC_CTRL(0x1C):");
  for(i=2;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n"); 
	
  HS6220_read_buffer(HS6220_BANK1_AGC_GAIN, temp, 4);
  printf("RF_BANK1_AGC_GAIN(0x1D):");
  for(i=3;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n"); 

  HS6220_read_buffer(HS6220_BANK1_RF_IVGEN, temp, 3);
  printf("RF_BANK1_RF_IVGEN(0x1E):");
  for(i=2;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n"); 
	
  HS6220_read_buffer(HS6220_BANK1_TEST_PKDET, temp, 3);
  printf("RF_BANK1_TEST_PKDET(0x1F):");
  for(i=2;i>=0;i--)
    printf("%02x " , temp[i]);
  printf("\r\n");

  HS6220_Bank_Switch(HS6220_Bank0);	
#endif
}


