/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : hs6220.c
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-09-25
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */
#define TAG  "hs6220"
#include "trace.h"

#include "board.h"
#include "hs6220.h"
#include "hs6220_reg.h"

uint8_t rf_fifo_data[16] = {0};

//byte_flag_t rf_flag;

uint32_t HS6220_sleep_time = 0;
uint32_t HS6220_reset_time = 0;

static void HS6220_delay_us(uint32_t us)
{		
	delay_us(us);				 
}

void HS6220_delay_ms(uint32_t ms)
{		
	delay_ms(ms);					 
}

static void HS6220_Operation(uint8_t opt)
{	
	HS6220_CSN_LOW;
	spi_inout(opt);
	HS6220_CSN_HIGH;
}

static void HS6220_wr_buffer(uint8_t addr,const uint8_t* buf,uint8_t len)
{
	HS6220_CSN_LOW;
	spi_inout(HS6220_W_REGISTER | addr);
	while(len--)
	{
		spi_inout(*buf ++);
	}
	HS6220_CSN_HIGH;
}

// HS6220写一个寄存器一个值操作函数
static void HS6220_write_byte(uint8_t addr,uint8_t data)
{
	HS6220_wr_buffer(addr, &data, 1);
}

static void HS6220_read_buffer(uint8_t addr, uint8_t *buffer, uint8_t size)
{
	HS6220_CSN_LOW;
	spi_inout(HS6220_R_REGISTER|addr);
	
	for(uint8_t i = 0; i < size; i++ )
	{
		buffer[i] = spi_inout(0);
	}
	HS6220_CSN_HIGH;
}

static uint8_t HS6220_read_byte( uint8_t addr )
{
    uint8_t data;
    HS6220_read_buffer( addr, &data, 1 );
    return data;
}

static void HS6220_write_byte_cmd(uint8_t cmd,uint8_t data)
{
	HS6220_CSN_LOW;
	spi_inout(cmd);
	spi_inout(data);
	HS6220_CSN_HIGH;
}

// HS6220 CE拉高
void HS6220_CE_High(void)
{
	HS6220_Operation(HS6220_CMD_CE_HIGH);;
}

// HS6220 CE拉低
void HS6220_CE_Low(void)
{
	HS6220_Operation(HS6220_CMD_CE_LOW);
}

void HS6220_RF_CE_High_Pulse(void)
{
	HS6220_Operation(HS6220_CMD_CE_HIGH);
	HS6220_delay_us(300);
	HS6220_Operation(HS6220_CMD_CE_LOW);	
}
/*Clear All Irq*/
void HS6220_Clear_All_Irq(void)
{
	HS6220_write_byte(HS6220_BANK0_STATUS, 0x70);
}

/*Flush Rx*/
void HS6220_Flush_Rx(void)
{
	HS6220_Operation(HS6220_FLUSH_RX);
}

/*Flush Tx*/
void HS6220_Flush_Tx(void)
{
	HS6220_Operation(HS6220_FLUSH_TX);
}

void HS6220_Bank_Switch(hs6220_bank_t bank)
{
	uint8_t sta;
	
	sta = HS6220_read_byte(HS6220_BANK0_STATUS);
	
	if(bank != HS6220_BANK0)
	{
		if(!(sta & HS6220_STATUS_BANK))
		{
			HS6220_write_byte_cmd(HS6220_ACTIVATE, HS6220_ACTIVATE_DATA);
		}
	}
	else
	{
		if(sta & HS6220_STATUS_BANK)
		{
			HS6220_write_byte_cmd(HS6220_ACTIVATE, HS6220_ACTIVATE_DATA);
		}
	}
}

void HS6220_soft_rst(void)
{
	HS6220_write_byte(HS6220_BANK0_FEATURE, SOFT_RST); // soft_reset
    HS6220_write_byte(HS6220_BANK0_DYNPD,   0x08);  // 默认3线SPI,使能4线SPI
    
    HS6220_CE_Low();	
	HS6220_write_byte(HS6220_BANK0_CONFIG, 0x8b); // power up
	HS6220_delay_ms(3); // wait 3 ms
	HS6220_write_byte(HS6220_BANK0_PMU_CTL, 0xac); // HS6220_PWRDWN = 00
	HS6220_delay_ms(2);
    
    HS6220_write_byte(HS6220_BANK0_FEATURE, 0x10); // VCO_AMP_TX_MUX = b'0, A2 don't need config this bit
	HS6220_write_byte(HS6220_BANK0_RF_CH, 0x28); // VCO_AMP_TX_MUX = b'0, A2 don't need config this bit
}

static bool HS6220_calibration(void)
{
    uint8_t temp[5];
	unsigned char count;
    HS6220_Bank_Switch(HS6220_BANK1);

	HS6220_write_byte(HS6220_BANK1_TEST_PKDET, 0x20); // pll_vdiv2_sel = 01, A2 don't need config this bit

//	temp[2] = 0x05;
	//temp[1] = 0xa0;
	temp[0] = 0x01;
	HS6220_wr_buffer(HS6220_BANK1_FAGC_CTRL_1, temp, 1);
    
	temp[1] = 0xb2;
	temp[0] = 0xcf;  
	HS6220_wr_buffer(HS6220_BANK1_AGC_CTRL, temp, 2);
    
    HS6220_Bank_Switch(HS6220_BANK0);

	HS6220_CE_High();
	HS6220_delay_us(300);
	HS6220_CE_Low(); // 一定要注意，校准的时候CE是低的
//    uint32_t time = hal_get_tick();
//	while ((HS6220_read_byte(HS6220_BANK0_RF_SETUP) & 0x20) == 0x00) //wait cal done
//    {
////        if (hal_get_elapsed_time(time) > 50)
////        {
////            return false;
////        }
//    }

	count = 35;
	while(1)   //wait cal done
	{	
		if( (HS6220_read_byte(HS6220_BANK0_RF_SETUP) & 0x20) )
		{
			break;
		}
		
		delay_ms(1);
		count--;
		if(!count)
		{
			return false;
		}
	
	}
    
    HS6220_write_byte(HS6220_BANK0_RF_SETUP, 0x40);  // cal_en = 0

//	HS6220_write_byte(HS6220_BANK0_FEATURE, 0x48);	
//    
//	HS6220_write_byte(HS6220_BANK0_DYNPD, 0x0F);	
//	HS6220_write_byte(HS6220_BANK0_PRE_GURD, 0x67);
    return true;
}

/* 读取RF芯片的ID */
unsigned char HS6220_Get_Chip_ID(void)
{  
	unsigned int chip_id;
	
	HS6220_Bank_Switch(HS6220_BANK1);
	HS6220_read_buffer(HS6220_BANK1_CHIP_ID, (unsigned char *)&chip_id, 2);
	HS6220_Bank_Switch(HS6220_BANK0);
	return chip_id;  
}

static void HS6220_initialize(void)
{
    uint8_t temp[6];
    HS6220_Bank_Switch(HS6220_BANK1);	

	temp[2] = 0x75;   //bp_dac =1 bp_rc = 1
	temp[1] = 0x98;  // bp_vco_amp = 1 bp_vco_ldo=1
	temp[0] = 0x20;
	HS6220_wr_buffer(HS6220_BANK1_CAL_CTL, temp, 3);
	
//	temp[2] = 0x11;
//	temp[1] = 0x04;  
//	temp[0] = 0x1D;    
//	HS6220_wr_buffer(HS6220_BANK1_RF_IVGEN, temp, 3); // xtal_cc = 0x1d

	HS6220_Bank_Switch(HS6220_BANK0);	
	
//	HS6220_write_byte(HS6220_BANK0_PRE_GURD, 0x76);	
//	HS6220_write_byte(HS6220_BANK0_SETUP_VALUE, 0xff); // rx timeout 
//	HS6220_write_byte(HS6220_BANK0_CONFIG_EXT, 0x24); // 边写tx fifo 边发送, 使能hs6220内部计数器

	temp[0]=0x46;
	temp[1]=0x0B;
	temp[2]=0xAF;
	temp[3]=0x43;
	temp[4]=0x98;
	HS6220_wr_buffer(HS6220_BANK0_RX_ADDR_P0, temp, 5); // set address

	temp[0]=0x46;
	temp[1]=0x0B;
	temp[2]=0xAF;
	temp[3]=0x43;
	temp[4]=0x98;
	HS6220_wr_buffer(HS6220_BANK0_TX_ADDR, temp, 5);   //set address

	HS6220_write_byte(HS6220_BANK0_FEATURE, 0x0); 
	HS6220_write_byte(HS6220_BANK0_EN_AA, 0x00);
	HS6220_write_byte(HS6220_BANK0_CONFIG, 0xfA);
	HS6220_write_byte(HS6220_BANK0_RX_PW_P0, 32);      // 数据通道0中RX有效负载的字节数
	HS6220_write_byte(HS6220_BANK0_RF_CH, 45);         // 频点 2400 + 2 MHz
	HS6220_write_byte(HS6220_BANK0_EN_RXADDR, 0x03);   // scramble_en = 0	
	HS6220_write_byte(HS6220_BANK0_RF_SETUP, 0x47);   
	HS6220_write_byte(HS6220_BANK0_DYNPD, 0x0E);
	
//	temp[0] = HS6220_read_byte(HS6220_BANK0_RF_CH);
//	log_debug("HS6220_initialize", &temp[0], 1);
	
	HS6220_Flush_Rx();
	HS6220_Clear_All_Irq();	
	HS6220_CE_High();	
}

void HS6220_Init(void)
{
    do
    {
        HS6220_soft_rst();
    }while (HS6220_calibration() == false);
    
    HS6220_initialize();
    
    HS6220_sleep_time = HS6220_reset_time = hal_get_tick();
}

void HS6220_ModeSwitch(HS6220_ModeTypeDef mod)
{
	unsigned char sta;
	HS6220_CE_Low();
	sta = HS6220_read_byte(HS6220_BANK0_CONFIG);
	if(mod != Rf_PRX_Mode)
		sta &= 0xFE;
	else	
		sta |= 0x01;

	HS6220_write_byte(HS6220_BANK0_CONFIG,sta);
	if(mod == Rf_Carrier_Mode)
	{
		HS6220_write_byte(HS6220_BANK0_RF_SETUP,0xc7); /* 0xC7:5dbM for B3&B4,0x83:0dBm for b4,0xc0:0dBm for b3*/
		HS6220_CE_High();
                while(1);
	}
	HS6220_CE_High();
}
extern uint8_t  rf_buf[32];	
uint8_t hs6220_rx_check(void)
{
    uint8_t rx_buff_size = 0;
    uint8_t status = HS6220_read_byte(HS6220_BANK0_STATUS);
    if (HS6220_STATUS_RX_DR & status)
    {
        HS6220_Clear_All_Irq(); /*clear irq*/    
        HS6220_CE_Low();

        rx_buff_size = HS6220_read_byte(HS6220_R_RX_PL_WID);
        if (rx_buff_size <= 32)
            HS6220_read_buffer(HS6220_R_RX_PAYLOAD, rf_buf, rx_buff_size);
        
//        log_debug("rx", rf_fifo_data, rx_buff_size);

        HS6220_sleep_time = HS6220_reset_time = hal_get_tick();
        HS6220_Flush_Rx();        
				HS6220_CE_High();
    }
    else
    {
        if (hal_get_elapsed_time(HS6220_reset_time) > 300)
        {
            HS6220_CE_Low();
            HS6220_Init();
            HS6220_CE_High(); 
        }
        
        if (hal_get_elapsed_time(HS6220_sleep_time) > 20)
        {
            HS6220_CE_Low();
            HS6220_Flush_Rx();
            HS6220_Clear_All_Irq();
            
            HS6220_write_byte(HS6220_BANK0_PMU_CTL, 0xae);		
            HS6220_delay_ms(1);// 这里的1ms延时不可缺少，也不能小 
            HS6220_write_byte(HS6220_BANK0_PMU_CTL, 0xac);
            HS6220_delay_ms(1);// 这里的1ms延时不可缺少，也不能小
            HS6220_CE_High(); 
            HS6220_sleep_time = hal_get_tick();
        }
    }
    return rx_buff_size;
}

void hs6220_send(uint8_t *buff, uint16_t size)
{
    uint8_t status;
    uint32_t tx_timeout_time = 0;
    HS6220_CE_Low();

    for(uint8_t i = 0; i < HS6220_REQ_CNT;i++)
    {
        HS6220_wr_buffer(HS6220_W_TX_PAYLOAD_NOACK, buff, size);
        HS6220_CE_High();
        tx_timeout_time = hal_get_tick();
        do
        {
            status = HS6220_read_byte(HS6220_BANK0_STATUS);
            
            if ((status & HS6220_STATUS_TX_DS) || (status&HS6220_STATUS_MAX_RT))
            {
                break;
            }
        }while (hal_get_elapsed_time(tx_timeout_time)<2);
        HS6220_CE_Low();
        HS6220_Clear_All_Irq();
        HS6220_Flush_Tx();
    }
}
