 #include "HS6220.H"
#include "key.H"
#include "extern.H"

extern word point;
byte rf_data_buf[40];



//byte tx_id[2];
byte rf_buf,rf_write_data_cnt;
byte rf_reg,rf_data;
byte DelayCnt;

/*******************************************************************************
* : Delayus
* : ӳ
* β:       
* : 
* ˵: 
*******************************************************************************/
void Delay100US(void)
{
	byte cnt;
	do
	{
		cnt = 70;
		do
		{
		wdreset;
		}while(--cnt$0);
	}while(--DelayCnt$0);
}

//===============================================
//===============================================
void spi_Writeabyte(void)
{
//-------- SPI----------------------
/*
   byte k=8;
 //  PBC.2=1;
   .delay 10
   while(k)
   {     
	   spi_sck=0;               // _|~
	   if(rf_buf.7)
	     spi_mosi=1;
 	   else 
	     spi_mosi=0;
	  nop;
	   spi_sck=1;               // ~|_
 	   rf_buf<<=1;  	   
	   k--;
   }
   spi_sck=0;
   spi_mosi=0;
*/
//-------- SPI----------------------

   byte k=8;
   spi_mosi_c=1;

   .delay 10
   while(k)
   {     
	   spi_sck=0;               // _|~
	   if(rf_buf.7)
	     spi_mosi=1;
 	   else 
	     spi_mosi=0;
	   spi_sck=1;    
	   nop;
 	   rf_buf<<=1;  	   
	   k--;
   }
   spi_sck=0;
   spi_mosi=0;
   .delay 10
} 
//===============================================
//===============================================
void  spi_Readabyte(void)
{
//-------- SPI----------------------
/*
  byte k=8;
  // PAC.0=0;
 // paph.0 =1;
   .delay 10

  while(k)
  {
  	 rf_buf<<=1;
     spi_sck=1;
     if(spi_miso)
	    rf_buf.0=1; //   rf_buf |=0x01;
     else
	    rf_buf.0=0; // rf_buf &=0xfe;
     spi_sck=0;
	 k--;
  }
*/
//-------- SPI----------------------
  byte k=8;
   spi_mosi_c=0;
   spi_mosi_h=1;
   .delay 10

  while(k)
  {
  	 rf_buf<<=1;
     spi_sck=1;
     if(spi_mosi)
	    rf_buf.0=1; //   rf_buf |=0x01;
     else
	    rf_buf.0=0; // rf_buf &=0xfe;
     spi_sck=0;
	 k--;
  }

}
//===============================================
//write reg
//===============================================
void rf_write_onebyte(void)
{
	spi_csn=0;
	rf_buf=rf_reg;
	spi_Writeabyte();
	rf_buf=rf_data;
	spi_Writeabyte();
    spi_csn=1;
}
//===============================================
//write reg
//===============================================
void rf_read_onebyte(void)
{
	spi_csn=0;
	rf_buf=rf_reg;
	spi_Writeabyte();
	rf_buf=rf_data;
	spi_Readabyte();
    spi_csn=1;
		.delay 20	
}

//===============================================
//flush fifo
//===============================================
void flush_tx_fifo(void)
{
	spi_csn=0;
	rf_buf=HS6220_FLUSH_TX;
	spi_Writeabyte();
//	rf_buf=0;
//	spi_Writeabyte();
    spi_csn=1;
}
//===============================================
//flush fifo
//===============================================
void flush_rx_fifo(void)
{
	spi_csn=0;
	rf_buf=HS6220_FLUSH_RX;
	spi_Writeabyte();
//	rf_buf=0;
//	spi_Writeabyte();
    spi_csn=1;
}
//===============================================
//clear rf status flag
//===============================================
void clear_rf_status(void)
{
    spi_csn=0;
	rf_buf=0x27;  //HS6220_BANK0_STATUS
	spi_Writeabyte();
	rf_buf=0x70;
	spi_Writeabyte();
    spi_csn=1;

}
//===============================================
//get rf status flag
//===============================================
void get_rf_status_flag(void)
{
    spi_csn=0;
    rf_buf=0x07;
    spi_Writeabyte();
    spi_Readabyte();       //read rf status
    spi_csn=1;
}

//===============================================
//set_tx
//===============================================
void rf_tx_set(void)
{
    spi_csn=0;
	rf_buf=0x20;
	spi_Writeabyte();
	rf_buf=0xfa;
	spi_Writeabyte();
    spi_csn=1;
}
//===============================================
//set_rx
//===============================================
void rf_rx_set(void)
{
    spi_csn=0;
	rf_buf=0x20;
	spi_Writeabyte();
	rf_buf=0xfb;
	spi_Writeabyte();
    spi_csn=1;
}
//===============================================
//rf power up
//===============================================
void rf_power_up(void)
{
	rf_reg = HS6220_BANK0_CONFIG | HS6220_W_REGISTER;   rf_data =0Xfa;rf_write_onebyte();
	DelayCnt = 10;Delay100US();// 1msʱǱģȴRFоƬһϵж

	rf_reg = HS6220_BANK0_PMU_CTL | HS6220_R_REGISTER;   rf_data =0;rf_read_onebyte();
	rf_buf&=0xfc;
	rf_reg = HS6220_BANK0_PMU_CTL | HS6220_W_REGISTER;   rf_data =0xa8;rf_write_onebyte();

}
//===============================================
//rf power down
//===============================================
void rf_power_down(void)
{
	rf_reg = HS6220_BANK0_PMU_CTL | HS6220_R_REGISTER;   rf_data =0;rf_read_onebyte();
	rf_buf&=0xfc;
	rf_buf|=0x01;
	rf_reg = HS6220_BANK0_PMU_CTL | HS6220_W_REGISTER;   rf_data =rf_buf;rf_write_onebyte();
	DelayCnt = 10;Delay100US();// 1msʱǱҪģҪȴRFһϵж

	rf_reg = HS6220_BANK0_CONFIG | HS6220_W_REGISTER;   rf_data =0Xf8;rf_write_onebyte();
}

//===============================================
//ce low
//===============================================
void rf_ce_low(void)
{

    spi_csn=0;
	rf_buf=HS6220_CMD_CE_LOW;
	spi_Writeabyte();
    spi_csn=1;
}
//===============================================
//ce high
//===============================================
void rf_ce_high(void)
{
    spi_csn=0;
	rf_buf=HS6220_CMD_CE_HIGH;
	spi_Writeabyte();
    spi_csn=1;
}

//===============================================
//ce high
//===============================================
void rf_operation(void)
{
    spi_csn=0;
	spi_Writeabyte();
    spi_csn=1;
}

/* TX_FIFOãҪʹݰùܣҪдTX_FIFOǰд
** ȻCEһֱΪ߾ͻһֱⷢͬݣʱCE巽ʽһ
** һͬݣ
** Ҫעʱʹtx_fifoҲлŵtx_fifoݾûˡ*/
void rf_Reuse_TX_PL(void)
{  
    spi_csn=0;
	rf_buf=HS6220_REUSE_TX_PL;
	spi_Writeabyte();
    spi_csn=1;
}
//==============================================
//write rf_buf
//==============================================
void write_rf_data_buf(void)
{
     byte temp01_buf;

	 point=rf_data_buf;
	 temp01_buf=0;
	 while(temp01_buf<rf_write_data_cnt)
	 {
	     rf_buf=*point;  
         spi_Writeabyte();
	     point++;
	     temp01_buf++;
	 }
}
//==============================================
//write rf_buf
//==============================================
void read_rf_data_buf(void)
{
     byte temp01_buf;

	 point=rf_data_buf;
	 temp01_buf=0;
	 while(temp01_buf<rf_write_data_cnt)
	 {
	   //  rf_buf=;  
         spi_Readabyte();
		 *point=rf_buf;
	     point++;
	     temp01_buf++;
	 }
}

//==============================================
//write tx0_address
//==============================================
void write_tx0_address(void)
{
	 spi_csn=0;
	 rf_buf=0x30;       //write TX0 address
     spi_Writeabyte();
	 rf_write_data_cnt=5;
	 write_rf_data_buf();
     spi_csn=1;
}
//==============================================
//write rx0_address
//==============================================
void write_rx0_address(void)
{
	 spi_csn=0;
	 rf_buf=0x2a;     //write  rx address
     spi_Writeabyte();
	 rf_write_data_cnt=5;
	 write_rf_data_buf();
     spi_csn=1;
}

/*******************************************************************************
* : HS6200_Bank_Select
* : 
* β:       
* : 
* ˵: 
*******************************************************************************/
void rf_bank_Switch(void)
{
	byte bank = rf_buf;//ѡblank

	get_rf_status_flag();
	
	if(bank == Rf_Bank1)//ѡbank1
	{
		if(!(rf_buf.7)){
			rf_reg=HS6220_ACTIVATE; rf_data=HS6220_ACTIVATE_DATA; rf_write_onebyte();
		}
	}
	else
	{
		if(rf_buf.7){
			rf_reg=HS6220_ACTIVATE; rf_data=HS6220_ACTIVATE_DATA; rf_write_onebyte();
		}
	}
}


/* ȡRFоƬID */
void  OM6220_Get_Chip_ID(void)
{  
	byte chip_id;

	rf_buf=Rf_Bank1; rf_bank_Switch();//лbank1

	 spi_csn=0;
	 rf_buf=0x00;       //write TX0 address
     spi_Writeabyte();
 	 spi_Readabyte();
	 chip_id=rf_buf;
 	 spi_Readabyte();
     spi_csn=1;

	rf_buf=Rf_Bank0; rf_bank_Switch(); // ֮Ҫǵлbank0
	rf_buf=chip_id;
}

/* л帺صֵ */
void rf_Change_Xtalcc(void)
{
//	byte  temp[4] = {0x00};

	byte xtal_cc=rf_buf;	
	if(xtal_cc > 15)
		xtal_cc = 15;
	
	// лbank1,帺صֵ015,ֵԽСƵԽߣֵԽƵԽС
	rf_buf=Rf_Bank1; rf_bank_Switch();//лbank1
	spi_csn=0;
	 rf_buf=HS6220_BANK1_RF_IVGEN;
	 spi_Writeabyte();
	 rf_write_data_cnt=4;
	 read_rf_data_buf();
    spi_csn=1;

	rf_data_buf[0] &= ~0x1f;
	rf_data_buf[0] |= xtal_cc; // ֵ15

	spi_csn=0;
	rf_buf=HS6220_BANK1_RF_IVGEN+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_write_data_cnt=4;
	write_rf_data_buf();
    spi_csn=1;

	rf_buf=Rf_Bank0; rf_bank_Switch(); // ֮Ҫǵлbank0
}
//===============================================
//ʼRF
//===============================================
extern byte mode_cnt;
void init_rf(void)
{   
	byte temp00,tmp_data;

	rf_reg=HS6220_BANK0_FEATURE+HS6220_W_REGISTER; rf_data=SOFT_RST;rf_write_onebyte();// soft_reset

	rf_reg=HS6220_BANK0_DYNPD+HS6220_W_REGISTER; rf_data=0x00;rf_write_onebyte();//ͨ
//	rf_reg=HS6220_BANK0_DYNPD+HS6220_W_REGISTER; rf_data=0x08;rf_write_onebyte();//ͨ

	rf_ce_low();
	rf_reg=HS6220_BANK0_CONFIG+HS6220_W_REGISTER; rf_data=0x8b;rf_write_onebyte();// power up
	DelayCnt = 30;Delay100US();// wait 3 ms
	rf_reg=HS6220_BANK0_PMU_CTL+HS6220_W_REGISTER; rf_data=0xac;rf_write_onebyte();// HS6220_PWRDWN = 00
	DelayCnt = 20;Delay100US();// wait 2 ms
	rf_reg=HS6220_BANK0_FEATURE+HS6220_W_REGISTER; rf_data=0x10;rf_write_onebyte();// VCO_AMP_TX_MUX = b'0, A2 don't need config this bit

	rf_buf=Rf_Bank1; rf_bank_Switch();//лbank1

	rf_reg=HS6220_BANK1_TEST_PKDET+HS6220_W_REGISTER; rf_data=0x20;rf_write_onebyte();// pll_vdiv2_sel = 01, A2 don't need config this bit

	spi_csn=0;
	rf_buf=HS6220_BANK1_FAGC_CTRL_1+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[2]=0x05;
	rf_data_buf[1]=0xa0;
	rf_data_buf[0]=0x01;
	rf_write_data_cnt=3;
	write_rf_data_buf();
    spi_csn=1;

    spi_csn=0;
	rf_buf=HS6220_BANK1_AGC_CTRL+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[1]=0xb2;
	rf_data_buf[0]=0xcf;
	rf_write_data_cnt=2;
	write_rf_data_buf();
    spi_csn=1;

	rf_buf=Rf_Bank0; rf_bank_Switch();//лbank0
	rf_ce_high();
	DelayCnt = 2;Delay100US();// wait 100us
	rf_ce_low();// һҪע⣬У׼ʱCEǵ͵

	while(1)
	{
		rf_reg=HS6220_BANK0_RF_SETUP+HS6220_R_REGISTER; rf_data=0x40;rf_read_onebyte();
		if(rf_buf.5)  break;
	}
	rf_reg=HS6220_BANK0_RF_SETUP+HS6220_W_REGISTER; rf_data=0x40;rf_write_onebyte();

	rf_buf=Rf_Bank1; rf_bank_Switch();//лbank1
    spi_csn=0;
	rf_buf=HS6220_BANK1_CAL_CTL+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[2]=0x75;
	rf_data_buf[1]=0x98;
	rf_data_buf[0]=0x20;
	rf_write_data_cnt=3;
	write_rf_data_buf();
    spi_csn=1;
	/* increase fitler agc threshold start (A2 don't need config this bit)*/

	rf_buf=Rf_Bank0; rf_bank_Switch();//лbank0

    spi_csn=0;
	rf_buf=HS6220_BANK0_RX_ADDR_P0+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[0]=0x46;
	rf_data_buf[1]=0x0b;
	rf_data_buf[2]=0xaf;
	rf_data_buf[3]=0x43;
	rf_data_buf[4]=0x98;
	rf_write_data_cnt=5;
	write_rf_data_buf();
    spi_csn=1;

    spi_csn=0;
	rf_buf=HS6220_BANK0_TX_ADDR+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[0]=0x46;
	rf_data_buf[1]=0x0b;
	rf_data_buf[2]=0xaf;
	rf_data_buf[3]=0x43;
	rf_data_buf[4]=0x98;
	rf_write_data_cnt=5;
	write_rf_data_buf();
    spi_csn=1;

	rf_reg=HS6220_BANK0_FEATURE+HS6220_W_REGISTER; rf_data=0x10;rf_write_onebyte();
	rf_reg=HS6220_BANK0_EN_AA+HS6220_W_REGISTER; rf_data=0x00;rf_write_onebyte();
	rf_reg=HS6220_BANK0_CONFIG+HS6220_W_REGISTER; rf_data=0xfa;rf_write_onebyte();
	rf_reg=HS6220_BANK0_RX_PW_P0+HS6220_W_REGISTER; rf_data=rx_lenth;rf_write_onebyte();
	rf_reg=HS6220_BANK0_RF_CH+HS6220_W_REGISTER; rf_data=45;rf_write_onebyte();
	rf_reg=HS6220_BANK0_EN_RXADDR+HS6220_W_REGISTER; rf_data=0x03;rf_write_onebyte();//scramble_en = 0
	rf_reg=HS6220_BANK0_RF_SETUP+HS6220_W_REGISTER; rf_data=0x47;rf_write_onebyte();
	rf_reg=HS6220_BANK0_DYNPD+HS6220_W_REGISTER; rf_data=0x07;rf_write_onebyte();

	clear_rf_status();
	flush_rx_fifo();
	if(mode_cnt==rx_mode)
	{
	rf_rx_set();
	}
	else
	{
	rf_tx_set();
	}
	rf_ce_high();
}


void hs6220_ble_init(void)
{
	byte temp00,tmp_data;
	byte run_time;

hs6220_ble_init_loop:
	rf_reg=HS6220_BANK0_FEATURE+HS6220_W_REGISTER; rf_data=SOFT_RST;rf_write_onebyte();// soft_reset
	DelayCnt = 20;Delay100US();// wait 2 ms
	rf_reg=HS6220_BANK0_DYNPD+HS6220_W_REGISTER; rf_data=0x00;rf_write_onebyte();//ͨ
//	rf_reg=HS6220_BANK0_DYNPD+HS6220_W_REGISTER; rf_data=0x08;rf_write_onebyte();//ͨ

	rf_ce_low();
	rf_reg=HS6220_BANK0_CONFIG+HS6220_W_REGISTER; rf_data=0x8b;rf_write_onebyte();// power up
	DelayCnt = 30;Delay100US();// wait 3 ms
	rf_reg=HS6220_BANK0_PMU_CTL+HS6220_W_REGISTER; rf_data=0x8c;rf_write_onebyte();// RF_PWRDWN = 00 32K_en = 1
	DelayCnt = 20;Delay100US();// wait 2 ms

	rf_reg=HS6220_BANK0_RF_CH+HS6220_W_REGISTER; rf_data=0x28;rf_write_onebyte();

	rf_buf=Rf_Bank1; rf_bank_Switch();//лbank1

	rf_reg=HS6220_BANK1_TEST_PKDET+HS6220_W_REGISTER; rf_data=0x20;rf_write_onebyte();// pll_vdiv2_sel = 01, A2 don't need config this bit

	rf_reg=HS6220_BANK1_FAGC_CTRL_1+HS6220_W_REGISTER; rf_data=0x01;rf_write_onebyte();// 300mV
	/* У׼ǰд롣*/
	rf_reg=HS6220_BANK1_FDEV+HS6220_W_REGISTER; rf_data=0x25;rf_write_onebyte();// 0x20=250khz 0x25=290khz

	/*
	spi_csn=0;
	rf_buf=HS6220_BANK1_FAGC_CTRL_1+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[1]=0x11;
	rf_data_buf[0]=0xc3;
	rf_write_data_cnt=2;
	write_rf_data_buf();
    spi_csn=1;
*/
	rf_buf=Rf_Bank0; rf_bank_Switch();//лbank0

	rf_reg=HS6220_BANK0_FEATURE+HS6220_W_REGISTER; rf_data=0x10;rf_write_onebyte();

	rf_ce_high();
	DelayCnt = 5;Delay100US();// wait 300us
	rf_ce_low();

	run_time = 35;	
	while(1)
	{
		DelayCnt = 10;Delay100US();// wait 2 ms
		rf_reg=HS6220_BANK0_RF_SETUP+HS6220_R_REGISTER; rf_data=0x40;rf_read_onebyte();
		if(rf_buf.5)  break;
		if(run_time) 
		{ 
			run_time--;
		}
		else
		{
			GOTO hs6220_ble_init_loop  // ȴ35msûм⵽У׼ɱ־¸λʼRFSPI⵼RFʼ
		}
	}

	rf_reg=HS6220_BANK0_RF_SETUP+HS6220_W_REGISTER; rf_data=rf_buf&0xEF;rf_write_onebyte();

	rf_reg=HS6220_BANK0_FEATURE+HS6220_W_REGISTER; rf_data=0x48;rf_write_onebyte();// BLE_EN = 1, bp_gau = 0

	rf_reg=HS6220_BANK0_PRE_GURD+HS6220_W_REGISTER; rf_data=0x67;rf_write_onebyte();// 1byte pramble

	rf_buf=Rf_Bank1; rf_bank_Switch();//лbank1
    spi_csn=0;
	rf_buf=HS6220_BANK1_CAL_CTL+HS6220_W_REGISTER;
	spi_Writeabyte();
//	rf_data_buf[3]=0x28;
	rf_data_buf[2]=0x75;
	rf_data_buf[1]=0x98;
	rf_data_buf[0]=0x20;
	rf_write_data_cnt=3;
	write_rf_data_buf();
    spi_csn=1;

/*
    spi_csn=0;
	rf_buf=HS6220_BANK1_RF_IVGEN+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[2]=0x11;
	rf_data_buf[1]=0x04;
	rf_data_buf[0]=0x1d;
	rf_write_data_cnt=3;
	write_rf_data_buf();
    spi_csn=1;
*/
	rf_reg=HS6220_BANK1_RF_IVGEN+HS6220_W_REGISTER; rf_data=0x17;rf_write_onebyte();

	rf_buf=Rf_Bank0; rf_bank_Switch();//лbank0

	rf_reg=HS6220_BANK0_FEATURE+HS6220_W_REGISTER; rf_data=0x40;rf_write_onebyte();// BLE_EN=1, bp_gau=0(GFSK), vco_amp_tx_mux=0(small 

	rf_reg=HS6220_BANK0_PRE_GURD+HS6220_W_REGISTER; rf_data=0x76;rf_write_onebyte();// 15-bit preamble

	rf_reg=HS6220_BANK0_EN_AA+HS6220_W_REGISTER; rf_data=0x00;rf_write_onebyte();

	rf_reg=HS6220_BANK0_CONFIG_EXT+HS6220_W_REGISTER; rf_data=0x1d;rf_write_onebyte();

//	rf_reg=HS6220_BANK0_CONFIG_EXT+HS6220_W_REGISTER; rf_data=0x1d;rf_write_onebyte();

	rf_reg=OM6220_BANK0_BLE_SETUP_DELAY+HS6220_W_REGISTER; rf_data=0xf0;rf_write_onebyte();

    spi_csn=0;
	rf_buf=HS6220_BANK0_TX_ADVA_ADDR+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[0]=0x46;
	rf_data_buf[1]=0x0b;
	rf_data_buf[2]=0xaf;
	rf_data_buf[3]=0x43;
	rf_data_buf[4]=0x98;
	rf_data_buf[5]=0xaf;
	rf_write_data_cnt=6;
	write_rf_data_buf();
    spi_csn=1;

    spi_csn=0;
	rf_buf=HS6220_BANK0_CRC_INIT+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[0]=0x55;
	rf_data_buf[1]=0x55;
	rf_data_buf[2]=0x55;
	rf_write_data_cnt=3;
	write_rf_data_buf();
    spi_csn=1;

    spi_csn=0;
	rf_buf=HS6220_BANK0_ACCESS_ADDR+HS6220_W_REGISTER;
	spi_Writeabyte();
	rf_data_buf[0]=0xd6;
	rf_data_buf[1]=0xbe;
	rf_data_buf[2]=0x89;
	rf_data_buf[3]=0x8e;
	rf_write_data_cnt=4;
	write_rf_data_buf();
    spi_csn=1;

	rf_reg=HS6220_BANK0_BLE_CTL+HS6220_W_REGISTER; rf_data=0x03;rf_write_onebyte();// adv mode 

	rf_buf=0x01;
	rf_Change_Xtalcc();	
}
//===============================================
//tx_rf_data
//===============================================
void rf_tx_data(void)
{
	byte repeat_send_cnt=10;

	rf_ce_low();
	flush_tx_fifo();
	clear_rf_status();
	 spi_csn=0;
	 rf_buf=HS6220_W_TX_PAYLOAD_NOACK;
     spi_Writeabyte();
     rf_write_data_cnt=rx_lenth;
	 write_rf_data_buf();
	 spi_csn=1;
	 rf_ce_high();
	DelayCnt = 1;Delay100US();//
	rf_ce_low();
	DelayCnt = 10;Delay100US();//
/*
	 spi_csn=0;
	 rf_buf=HS6220_REUSE_TX_PL;
     spi_Writeabyte();
	 spi_csn=1;
	 rf_ce_high();
	.delay 200
	rf_ce_low();
	while(repeat_send_cnt)
	{
		rf_ce_high();
		.delay 200
		rf_ce_low();
		.delay 200	
		repeat_send_cnt--;
	}
*/
	clear_rf_status();
	flush_tx_fifo();
//	rf_ce_high();

}

//===============================================
//rf_RecivePack
//===============================================
extern word rf_reset_cnt;
void rf_RecivePack(void)
{
//	rf_ce_low();
//	rf_reg=HS6220_BANK0_RF_CH+HS6220_R_REGISTER; rf_data=0x00;rf_read_onebyte();
	get_rf_status_flag();
	if(rf_buf.6) //rx_dr
	{
		rf_reset_cnt=rf_reset_time;
		rf_sleep_cnt=10;
	 rf_reg = HS6220_R_RX_PL_WID | HS6220_R_REGISTER;   rf_data =0;rf_read_onebyte();
	 if(rf_buf==rx_lenth)  //16
	 {
		 rf_write_data_cnt=rf_buf;
		 spi_csn=0;
		 rf_buf=HS6220_R_RX_PAYLOAD;
		 spi_Writeabyte();
		 rf_write_data_cnt=rx_lenth;
		 read_rf_data_buf();
		 spi_csn=1;
	 }
	// յݲȡFIFO֮
	rf_ce_low();
	flush_rx_fifo();
	clear_rf_status();
	rf_ce_high(); // CEߵȴ´ݵ

	}

	if(!rf_reset_cnt) // 300msûյ1ݣλRF³ʼ
	{

		init_rf();
		rf_reset_cnt=rf_reset_time;

	}
	if(!rf_sleep_cnt)// 20msûյ1ݣRF˯߻һ
	{
		
		rf_ce_low();
		flush_rx_fifo();
		clear_rf_status();
		rf_reg = HS6220_BANK0_PMU_CTL | HS6220_W_REGISTER;   rf_data =0xae;rf_write_onebyte();
		DelayCnt = 10;Delay100US();// 1msʱȱ٣ҲС 
		rf_reg = HS6220_BANK0_PMU_CTL | HS6220_W_REGISTER;   rf_data =0xac;rf_write_onebyte();
		DelayCnt = 10;Delay100US();// 1msʱȱ٣ҲС
		rf_ce_high(); 
		rf_sleep_cnt=10;
	}


}
		/* ע⣺λΪزʹλزģʽ֮CEҪߣزŻ
		   ҪлƵ㣬ʵȣͲҪȥڲRFῴزźŵ*/
extern byte int_2ms;
extern byte test_mode_fg;
extern byte key_code;

void test_mode(void)
{
	byte key_temp;
	byte key_cnt=0;
	byte rc_ch;
		rf_ce_low();
		rf_tx_set();

		 spi_csn=0;
		 rf_buf=0x26;
	     spi_Writeabyte();
		 rf_buf=0xc7;
	     spi_Writeabyte();  
		 spi_csn=1;
		rf_ce_high();	
		test_mode_fg=1;
/*	rf_ce_low();

	if(test_mode_fg==1)//زģʽ
	{
		 spi_csn=0;
		 rf_buf=0x26;
	     spi_Writeabyte();
		 rf_buf=0xc7;
	     spi_Writeabyte();  
		 spi_csn=1;
	}
	else
	if(test_mode_fg==2)//ģʽ
	{
		 spi_csn=0;
		 rf_buf=0x26;
	     spi_Writeabyte();
		 rf_buf=0x47;
	     spi_Writeabyte();  
		 spi_csn=1;
	}
	else//ģʽ
	{
		 rf_rx_set();
	}
	rf_ce_high();

	io_led=1;
*/
	while(1)
	{

		io_led=1;

		if((key_temp!=key_code))//&&(key_code.0))
		{
			key_temp=key_code;
			if(key_code)
			{
			key_cnt++;
			if(key_cnt>9) key_cnt=1;
			}

			if(key_cnt==1)
			{
				init_rf();
				rf_ce_low();
				rf_tx_set();

				 spi_csn=0;
				 rf_buf=0x26;
			     spi_Writeabyte();
				 rf_buf=0xc7;
			     spi_Writeabyte();  
				 spi_csn=1;
				rf_ce_high();	
				test_mode_fg=1;

				rc_ch=0x05;
			}
			else
			if(key_cnt==2)
			{
				rc_ch=34;
			}
			else
			if(key_cnt==3)
			{
				rc_ch=75;
			}
			else
			if(key_cnt==4)
			{
				init_rf();
				rf_ce_low();
				rf_tx_set();

				 spi_csn=0;
				 rf_buf=0x26;
			     spi_Writeabyte();
				 rf_buf=0x47;
			     spi_Writeabyte();  
				 spi_csn=1;
				rf_ce_high();	
				test_mode_fg=2;

				rc_ch=0x05;
			}
			else
			if(key_cnt==5)
			{
				rc_ch=34;
			}
			else
			if(key_cnt==6)
			{
				rc_ch=75;
			}
			else
			if(key_cnt==7)
			{
				init_rf();
				rf_ce_low();
				rf_rx_set();
				rf_ce_high();	
				test_mode_fg=3;

				rc_ch=0x05;
			}
			else
			if(key_cnt==8)
			{
				rc_ch=34;
			}
			else
			if(key_cnt==9)
			{
				rc_ch=75;
			}


			 rf_ce_low();
			 spi_csn=0;
			 rf_buf=0x25;
		     spi_Writeabyte();
			 rf_buf=rc_ch;
		     spi_Writeabyte();  
			 spi_csn=1;
			 rf_ce_high();
		}

		if(!int_2ms )
		{
			int_2ms=2;
			key_deal();
			if(test_mode_fg==2)
			{
		 	 
			 rf_tx_data();

			}
		}
	}
}

void hs6200_carrier_mode(void)
{
	rf_ce_low();
/*	flush_tx_fifo();
	clear_rf_status();
	 spi_csn=0;
	 rf_buf=0x20;
     spi_Writeabyte();
	 rf_buf=0x0e;
     spi_Writeabyte();  
	 spi_csn=1;*/
//	 rf_ce_high();

	 spi_csn=0;
	 rf_buf=0x26;
     spi_Writeabyte();
	 rf_buf=0xc7;
     spi_Writeabyte();  
	 spi_csn=1;
	 spi_csn=0;
	 rf_buf=0x25;
     spi_Writeabyte();
	 rf_buf=45;
     spi_Writeabyte();  
	 spi_csn=1;
	 rf_ce_high();
	 while(1){

		 .delay 200
	 };


} 

void exe_gbuf_adv_ind(void)
{
	_pcadd
	{
 ///.header
	ret  0x02; 	ret  0x25;  
  ///.AdvA
	ret  0x00;	ret  0x00;	ret  0x00;	ret  0x00;	ret  0x00;	ret  0x00;
  ///Flags: BLE limited discoverable mode and BR/EDR not supported
	ret  0x02;	ret  0x01;	ret  0x06;
  ///incomplete list of service class UUIDs: (0x1812, 0x180F)
	ret  0x03;	ret  0x02;	ret  0x12;	ret  0x18;
  ///Apperance
	ret  0x03;	ret  0x19;	ret  0xC1;	ret  0x03;
  ///Complete Local Name in 18 bytes always.
	ret  0x13;	ret  0x09;
	ret  0x48; //'H'
	ret  0x53; //'S'
	ret  0x5A; //'Z'
	ret  0x5F; //'_'
	ret  0x48; //'H'
	ret  0x53; //'S'
	ret  0x36; //'6'
	ret  0x32; //'2'
	ret  0x32; //'2'
	ret  0x30; //'0'
	ret  0x20; //' '
	ret  0x20; //' '
	ret  0x20; //' '
	ret  0x20; //' '
	ret  0x20; //' '
	ret  0x20; //' '
	ret  0x20; //' '
	ret  0x20; //' '
	ret  0x00;	ret  0x00;	ret  0x00;
	ret  0x00;	ret  0x00;	ret  0x00;
	}
}


void  send_ble_packet_test(void)
{
	BYTE temp00;
	BYTE temp01;
	BYTE temp02;
	BYTE rf_chip_id;
	hs6220_ble_init();

	OM6220_Get_Chip_ID();// ȡоƬchip id ҪΪ¾оƬ
	rf_chip_id=rf_buf;
	rf_reg=HS6220_BANK0_CONFIG+HS6220_W_REGISTER; rf_data=0x8a;rf_write_onebyte();// CONFIGĴΪģʽʹCRC

	if(rf_chip_id>0x24)// °汾оƬ
	{
		rf_reg=HS6220_BANK0_BLE_CTL+HS6220_W_REGISTER; rf_data=0x06;rf_write_onebyte();// 7:event abort,6:md dsb,5:nesn sn dsb,4:infiniterx,

	}
	else // Ǿɰ汾оƬʹCE巽ʽ
	{
		rf_reg=HS6220_BANK0_BLE_CTL+HS6220_W_REGISTER; rf_data=0x0b;rf_write_onebyte();// ɰ汾оƬûаģʽ
	}

	// 帺صֵԵƵƫֵ0~15һ16
//	rf_buf=0x07;
//	rf_Change_Xtalcc();	


	while(1)
	{
		rf_ce_low();

		rf_reg=HS6220_BANK0_BLE_CTL+HS6220_W_REGISTER; rf_data=0x03;rf_write_onebyte();// Ϊ㲥ģʽ

		if(rf_chip_id>0x24)// °汾оƬ
		{
			rf_buf=0x8b;
			rf_operation();// λ״̬ɵоƬû
		}

		flush_tx_fifo();
		clear_rf_status();
//37ͨ
		rf_reg=HS6220_BANK0_RF_CH+HS6220_W_REGISTER; rf_data=chn_37;rf_write_onebyte();//ͨ
  ///.header
		spi_csn=0;
		rf_buf=HS6220_BANK0_TX_HEADER+HS6220_W_REGISTER;
		spi_Writeabyte();
		rf_data_buf[1]=37;
		rf_data_buf[0]=0x02;
		rf_write_data_cnt=2;
		write_rf_data_buf();
	    spi_csn=1;

		temp01=0;
		temp00=9;
		 point=rf_data_buf;  //ȡ
		while(temp01<32)
		{

		 A=temp00;
		 exe_gbuf_adv_ind();
		 temp02=A;
		 *point=temp02;
		 temp00++;
		 temp01++;
		 point++;	
		}
		 spi_csn=0;
		 rf_buf=HS6220_W_TX_PAYLOAD;
	     spi_Writeabyte();
	     rf_write_data_cnt=31;
		 write_rf_data_buf();
		 spi_csn=1;
		// εĲ		
		 rf_Reuse_TX_PL();	// ʹݰ
		 rf_ce_high();
		 DelayCnt = 20;Delay100US();// ʱʱĳ̣Ӱ췢Ĺؼ
		 clear_rf_status();// һҪ״̬Ĵ

		while(1)// ȴݷ	ȻһҪȴɱ־׳
		{
			get_rf_status_flag();// ȡ״̬ĴǷ
			if((rf_buf.4)||(rf_buf.5)) // 
			{
				clear_rf_status();// ״̬Ĵ
				break;
			}
		}
//38ͨ
		rf_ce_low();
		flush_tx_fifo();
		clear_rf_status();

		rf_reg=HS6220_BANK0_RF_CH+HS6220_W_REGISTER; rf_data=chn_38;rf_write_onebyte();//ͨ
  ///.header
		spi_csn=0;
		rf_buf=HS6220_BANK0_TX_HEADER+HS6220_W_REGISTER;
		spi_Writeabyte();
		rf_data_buf[1]=37;
		rf_data_buf[0]=0x02;
		rf_write_data_cnt=2;
		write_rf_data_buf();
	    spi_csn=1;

		temp01=0;
		temp00=9;
		 point=rf_data_buf;  //ȡ
		while(temp01<32)
		{

		 A=temp00;
		 exe_gbuf_adv_ind();
		 temp02=A;
		 *point=temp02;
		 temp00++;
		 temp01++;
		 point++;	
		}
		 spi_csn=0;
		 rf_buf=HS6220_W_TX_PAYLOAD;
	     spi_Writeabyte();
	     rf_write_data_cnt=31;
		 write_rf_data_buf();
		 spi_csn=1;

		// εĲ		
		 rf_Reuse_TX_PL();	// ʹݰ
		 rf_ce_high();
		 DelayCnt = 20;Delay100US();// ʱʱĳ̣Ӱ췢Ĺؼ
		 clear_rf_status();// һҪ״̬Ĵ

		while(1)// ȴݷ	ȻһҪȴɱ־׳
		{
			get_rf_status_flag();// ȡ״̬ĴǷ
			if((rf_buf.4)||(rf_buf.5)) // 
			{
				clear_rf_status();// ״̬Ĵ
				break;
			}
		}
//39ͨ
		rf_ce_low();
		flush_tx_fifo();
		clear_rf_status();

		rf_reg=HS6220_BANK0_RF_CH+HS6220_W_REGISTER; rf_data=chn_39;rf_write_onebyte();//ͨ
  ///.header
		spi_csn=0;
		rf_buf=HS6220_BANK0_TX_HEADER+HS6220_W_REGISTER;
		spi_Writeabyte();
		rf_data_buf[1]=37;
		rf_data_buf[0]=0x02;
		rf_write_data_cnt=2;
		write_rf_data_buf();
	    spi_csn=1;

		temp01=0;
		temp00=9;
		 point=rf_data_buf;  //ȡ
		while(temp01<32)
		{

		 A=temp00;
		 exe_gbuf_adv_ind();
		 temp02=A;
		 *point=temp02;
		 temp00++;
		 temp01++;
		 point++;	
		}
		 spi_csn=0;
		 rf_buf=HS6220_W_TX_PAYLOAD;
	     spi_Writeabyte();
	     rf_write_data_cnt=31;
		 write_rf_data_buf();
		 spi_csn=1;

		// εĲ		
		 rf_Reuse_TX_PL();	// ʹݰ
		 rf_ce_high();
		 DelayCnt = 20;Delay100US();// ʱʱĳ̣Ӱ췢Ĺؼ
		 clear_rf_status();// һҪ״̬Ĵ

		while(1)// ȴݷ	ȻһҪȴɱ־׳
		{
			get_rf_status_flag();// ȡ״̬ĴǷ
			if((rf_buf.4)||(rf_buf.5)) // 
			{
				clear_rf_status();// ״̬Ĵ
				break;
			}
		}
		// ʱ30msȻȥ͹㲥SIG涨Ĺ㲥Ҳᷢĺܿ죬Ҫע⡣
		DelayCnt = 100;Delay100US();// wait 10ms
		DelayCnt = 100;Delay100US();// wait 10ms
		DelayCnt = 100;Delay100US();// wait 10ms
	}
}


void  recv_ble_packet_test(void)
{
	BYTE rf_chip_id;
	byte status_ext1,status_ext2;
	byte len,temp01_buf;

	hs6220_ble_init();

	rf_ce_low();
	OM6220_Get_Chip_ID();// ȡоƬchip id ҪΪ¾оƬ
	rf_chip_id=rf_buf;


	rf_reg=HS6220_BANK0_CONFIG+HS6220_W_REGISTER; rf_data=0x8b;rf_write_onebyte();// power up

	rf_reg=HS6220_BANK0_RF_CH+HS6220_W_REGISTER; rf_data=chn_38;rf_write_onebyte();//ͨ
	if(rf_chip_id>0x24)// °汾оƬ
	{
		rf_reg=HS6220_BANK0_BLE_CTL+HS6220_W_REGISTER; rf_data=0x06;rf_write_onebyte();// 7:event abort,6:md dsb,5:nesn sn dsb,4:infiniterx,
/*													// 3~0:3-ble broacast,5-ble connection,9-ble tx test,b-ble rx test 
		rf_reg=HS6220_BANK0_BLE_CTL+HS6220_W_REGISTER; rf_data=0x07;rf_write_onebyte();// ʹðʱҪģʽfilter scan mode.
	    spi_csn=0;
		rf_buf=HS6220_BANK0_WHITE_LIST_RXADDR_1+HS6220_W_REGISTER;// ַ1
		spi_Writeabyte();
		rf_data_buf[0]=0xA9;
		rf_data_buf[1]=0xFF;
		rf_data_buf[2]=0xE8;
		rf_data_buf[3]=0xAB;
		rf_data_buf[4]=0x90;
		rf_data_buf[5]=0x3D;
		rf_write_data_cnt=6;
		write_rf_data_buf();
	    spi_csn=1;

	    spi_csn=0;
		rf_buf=HS6220_BANK0_WHITE_LIST_RXADDR_1+HS6220_W_REGISTER;// ַ2
		spi_Writeabyte();
		rf_data_buf[0]=0xCE;
		rf_data_buf[1]=0x83;
		rf_data_buf[2]=0xB5;
		rf_data_buf[3]=0xD1;
		rf_data_buf[4]=0xD8;
		rf_data_buf[5]=0xEA;
		rf_write_data_cnt=6;
		write_rf_data_buf();
	    spi_csn=1;
*/
	}
	else // Ǿɰ汾оƬʹCE巽ʽ
	{
		rf_reg=HS6220_BANK0_BLE_CTL+HS6220_W_REGISTER; rf_data=0x0b;rf_write_onebyte();// ɰ汾оƬûаģʽ
	}
/*
	if(rf_chip_id>0x24)// °汾оƬ
	{
		rf_buf=0x8b;
		rf_operation();// λ״̬ɵоƬû
	}
*/
	if(rf_chip_id>0x24)// °汾оƬ
	{
		rf_buf=0xd9;
		rf_operation();// CE°汾оƬеģоƬ״̬
	}
	else
	{
		rf_ce_high(); 
	}
	/* ֵעǣɨڼ䣬һҪһֱȥȡ״̬ǮǷݵݵҪʱȡ
	ǧҪʹü೤ʱȥȡһ״̬ĴȻȡݵķʽ׶ݡ
	Ѿпͻֹ⣬Ϊһֱȡ״̬ĴԶݣⲢɨ費ݡ */ 
	
	while(1)
	{

		if(rf_chip_id>0x24)// °汾оƬ
		{
			 spi_csn=0;
			 rf_buf=HS6220_BANK0_STATUS_EXT;       //write TX0 address
		     spi_Writeabyte();
		 	 spi_Readabyte();
			 status_ext1=rf_buf;
		 	 spi_Readabyte();
			 status_ext2=rf_buf;
		     spi_csn=1;
			 if(status_ext1&0x08)/*RX_TIME_OUT*/
			 {
				clear_rf_status();	
				rf_buf=0x8b;
				rf_operation();// λ״̬ɵоƬû
				rf_buf=0xd9;
				rf_operation();// CE°汾оƬеģоƬ״̬
			 }
			 else
			 if(status_ext2&0xe0)/*RX erros*/
			 {
				clear_rf_status();	
				rf_buf=0x8b;
				rf_operation();// λ״̬ɵоƬû
				rf_buf=0xd9;
				rf_operation();// CE°汾оƬеģоƬ״̬
			 }
			 else
			 if(status_ext1&0x40)/*RX_DR*/
			 {
				rf_reset_cnt=rf_reset_time;
				rf_sleep_cnt=10;

				clear_rf_status();				
				 spi_csn=0;
				 rf_buf=HS6220_BANK0_RX_HEADER;       // °汾оƬheader
			     spi_Writeabyte();
			 	 spi_Readabyte();
				 rf_data_buf[0]=rf_buf;
			 	 spi_Readabyte();
				 rf_data_buf[1]=rf_buf;
			     spi_csn=1;

				 len=rf_data_buf[1];
				 if(len>0)	
				 {

					 spi_csn=0;
					 rf_buf=HS6220_BANK0_RX_ADVA_ADDR;      // °汾оƬAdva
				     spi_Writeabyte();
				 	 spi_Readabyte();
					 rf_data_buf[2]=rf_buf;
				 	 spi_Readabyte();
					 rf_data_buf[3]=rf_buf;
				 	 spi_Readabyte();
					 rf_data_buf[4]=rf_buf;
				 	 spi_Readabyte();
					 rf_data_buf[5]=rf_buf;
				 	 spi_Readabyte();
					 rf_data_buf[6]=rf_buf;
				 	 spi_Readabyte();
					 rf_data_buf[7]=rf_buf;
				     spi_csn=1;

					 if(len>6)	// °汾оƬAdvData
					 {
						 spi_csn=0;
						 rf_buf=HS6220_R_RX_PAYLOAD;
						 spi_Writeabyte();
						 point=&rf_data_buf[8];
						 rf_write_data_cnt=len-6;
						 temp01_buf=0;
						 while(temp01_buf<rf_write_data_cnt)
						 {
						   //  rf_buf=;  
					         spi_Readabyte();
							 *point=rf_buf;
						     point++;
						     temp01_buf++;
						 }
						 spi_csn=1;
					 }

					flush_rx_fifo();
					clear_rf_status();
					rf_buf=0x8b;
					rf_operation();// λ״̬ɵоƬû
					rf_buf=0xd9;
					rf_operation();// CE°汾оƬеģоƬ״̬
				 }

			 }					
		}
		else
		{
			get_rf_status_flag();
			if((rf_buf.6)) //
			{
				rf_ce_low();
				 rf_reg = HS6220_R_RX_PL_WID | HS6220_R_REGISTER;   rf_data =0;rf_read_onebyte();
				 if(rf_buf<64)  //16
				 {
					 rf_write_data_cnt=rf_buf;
					 spi_csn=0;
					 rf_buf=HS6220_R_RX_PAYLOAD;
					 spi_Writeabyte();
					 rf_write_data_cnt=rf_buf;
					 read_rf_data_buf();
					 //===============ûй===rf_data_buf====		
					 spi_csn=1;
					flush_rx_fifo();
					clear_rf_status();
				 }


			}
		}


		if(!rf_reset_cnt) // 300msûյ1ݣλRF³ʼ
		{

			hs6220_ble_init();
			rf_ce_low();
			rf_reg=HS6220_BANK0_CONFIG+HS6220_W_REGISTER; rf_data=0x8b;rf_write_onebyte();// power up
			rf_reg=HS6220_BANK0_RF_CH+HS6220_W_REGISTER; rf_data=chn_38;rf_write_onebyte();//ͨ
			rf_reg=HS6220_BANK0_BLE_CTL+HS6220_W_REGISTER; rf_data=0x06;rf_write_onebyte();
			rf_buf=0xd9;
			rf_operation();

			rf_reset_cnt=rf_reset_time;

		}
		if(!rf_sleep_cnt)// 20msûյ1ݣRF˯߻һ
		{
			
			rf_ce_low();
			flush_rx_fifo();
			clear_rf_status();
			rf_reg = HS6220_BANK0_PMU_CTL | HS6220_W_REGISTER;   rf_data =0xae;rf_write_onebyte();
			DelayCnt = 10;Delay100US();// 1msʱȱ٣ҲС 
			rf_reg = HS6220_BANK0_PMU_CTL | HS6220_W_REGISTER;   rf_data =0xac;rf_write_onebyte();
			DelayCnt = 10;Delay100US();// 1msʱȱ٣ҲС
			rf_ce_high(); 
			rf_sleep_cnt=10;
		}
	}
}









